/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDFractionDigitsFacet;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxFacet;
import org.eclipse.xsd.XSDMaxLengthFacet;
import org.eclipse.xsd.XSDMinFacet;
import org.eclipse.xsd.XSDMinLengthFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDRepeatableFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTotalDigitsFacet;
import org.eclipse.xsd.XSDWhiteSpaceFacet;
import org.eclipse.xsd.impl.XSDConstrainingFacetImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelEditorImpl;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.editor.FacetValue;
import org.teiid.designer.xsd.ui.editor.InclusiveInteger;

public class FacetHelper {
    private static final String ERROR_KEY_UNUSABLE_FACET = "FacetHelper.unusableFacet.error";
    public static final String FAKE_FACET_MAXIMUM = "maximum";
    public static final String FAKE_FACET_MINIMUM = "minimum";
    public static final String FACET_FRACTIONDIGITS = "fractionDigits";
    public static final String FACET_TOTALDIGITS = "totalDigits";
    public static final String FACET_MAX_INCLUSIVE = "maxInclusive";
    public static final String FACET_MIN_INCLUSIVE = "minInclusive";
    public static final String FACET_MAX_EXCLUSIVE = "maxExclusive";
    public static final String FACET_MIN_EXCLUSIVE = "minExclusive";
    public static final String FACET_MAXLENGTH = "maxLength";
    public static final String FACET_MINLENGTH = "minLength";
    public static final String FACET_LENGTH = "length";
    public static final String FACET_WHITESPACE = "whitespace";
    public static final String FACET_ENUMERATION = "enumeration";
    public static final String FACET_PATTERN = "pattern";
    private static final String[] NUMERIC_TYPES = new String[]{"integer", "positiveInteger", "negativeInteger", "nonNegativeInteger", "nonPositiveInteger", "long", "unsignedLong", "int", "unsignedInt", "byte", "unsignedByte", "decimal"};
    private static final String[] BOUNDS_TYPES = new String[]{"float", "double", "boolean", "duration", "dateTime", "date", "time", "gYear", "gYearMonth", "gMonth", "gMonthDay", "gDay"};
    public static final int DEFAULT_MAX_BOUNDS = 999999;
    public static final int DEFAULT_MIN_BOUNDS = -999999;
    private static Map facetNametoEClass = new HashMap();
    private static Map defaults = new HashMap();

    static {
        facetNametoEClass.put(FACET_ENUMERATION, XSDPackage.eINSTANCE.getXSDEnumerationFacet());
        facetNametoEClass.put(FACET_FRACTIONDIGITS, XSDPackage.eINSTANCE.getXSDFractionDigitsFacet());
        facetNametoEClass.put(FACET_LENGTH, XSDPackage.eINSTANCE.getXSDLengthFacet());
        facetNametoEClass.put(FACET_MAXLENGTH, XSDPackage.eINSTANCE.getXSDMaxLengthFacet());
        facetNametoEClass.put(FACET_MINLENGTH, XSDPackage.eINSTANCE.getXSDMinLengthFacet());
        facetNametoEClass.put(FACET_MAX_INCLUSIVE, XSDPackage.eINSTANCE.getXSDMaxInclusiveFacet());
        facetNametoEClass.put(FACET_MAX_EXCLUSIVE, XSDPackage.eINSTANCE.getXSDMaxExclusiveFacet());
        facetNametoEClass.put(FACET_MIN_INCLUSIVE, XSDPackage.eINSTANCE.getXSDMinInclusiveFacet());
        facetNametoEClass.put(FACET_MIN_EXCLUSIVE, XSDPackage.eINSTANCE.getXSDMinExclusiveFacet());
        facetNametoEClass.put(FACET_PATTERN, XSDPackage.eINSTANCE.getXSDPatternFacet());
        facetNametoEClass.put(FACET_TOTALDIGITS, XSDPackage.eINSTANCE.getXSDTotalDigitsFacet());
        facetNametoEClass.put(FACET_WHITESPACE, XSDPackage.eINSTANCE.getXSDWhiteSpaceFacet());
    }

    public static void setEnterpriseFacetValue(XSDSimpleTypeDefinition type, FacetValue newValue) {
        if (newValue.value != null) {
            EnterpriseDatatypeInfo edi = ModelerCore.getWorkspaceDatatypeManager().getEnterpriseDatatypeInfo(type);
            if (edi == null) {
                edi = new EnterpriseDatatypeInfo();
            }
            edi.setRuntimeTypeFixed(new Boolean(newValue.isFixedLocal));
            edi.setRuntimeType((String)newValue.value);
            ModelEditorImpl.fillWithDefaultValues((EnterpriseDatatypeInfo)edi, (XSDSimpleTypeDefinition)type);
            ModelerCore.getModelEditor().setEnterpriseDatatypePropertyValue((EObject)type, (Object)edi);
        } else {
            ModelerCore.getModelEditor().unsetEnterpriseDatatypePropertyValue((EObject)type);
        }
    }

    public static FacetValue getEnterpriseFacetValue(XSDSimpleTypeDefinition startingType) {
        FacetValue fv = new FacetValue();
        final XSDSimpleTypeDefinition definingEnterpriseType = FacetHelper.getDefiningEnterpriseType(startingType);
        fv.type = startingType;
        EnterpriseDatatypeInfo edi = ModelerCore.getWorkspaceDatatypeManager().getEnterpriseDatatypeInfo(definingEnterpriseType);
        fv.value = edi.getRuntimeType();
        if (startingType == definingEnterpriseType) {
            final XSDSimpleTypeDefinition dftDefiner = FacetHelper.getDefiningEnterpriseType(definingEnterpriseType.getBaseTypeDefinition());
            EnterpriseDatatypeInfo ediDft = ModelerCore.getWorkspaceDatatypeManager().getEnterpriseDatatypeInfo(dftDefiner);
            fv.defaultValue = ediDft.getRuntimeType();
            fv.facet = new XSDConstrainingFacetImpl(){

                public String getFacetName() {
                    return "This is not a real facet!";
                }

                public XSDConcreteComponent getContainer() {
                    return dftDefiner;
                }
            };
        } else {
            fv.defaultValue = fv.value;
            fv.facet = new XSDConstrainingFacetImpl(){

                public String getFacetName() {
                    return "This is not a real facet!";
                }

                public XSDConcreteComponent getContainer() {
                    return definingEnterpriseType;
                }
            };
        }
        Boolean rtFixed = edi.getRuntimeTypeFixed();
        if (rtFixed != null) {
            fv.isFixedLocal = rtFixed;
        }
        return fv;
    }

    public static FacetValue getFacetValue(XSDSimpleTypeDefinition type, XSDConstrainingFacet facet) {
        FacetValue fv = new FacetValue();
        fv.description = ModelObjectUtilities.getDescription((EObject)facet);
        fv.type = type;
        fv.facet = facet;
        Object mainVal = FacetHelper.getMainFacetValue(facet);
        fv.value = mainVal != null ? mainVal : FacetHelper.getDefaultMainFacetValue(facet.getFacetName());
        fv.defaultValue = type == facet.getContainer() ? null : fv.value;
        fv.isFixedLocal = FacetHelper.isFixed(facet);
        return fv;
    }

    private static void removeFacet(XSDSimpleTypeDefinition type, String facetName) {
        String nameEx = FacetHelper.getRealFacetName(facetName, false);
        String nameIn = FacetHelper.getRealFacetName(facetName, true);
        Iterator itor = type.getFacetContents().iterator();
        while (itor.hasNext()) {
            XSDConstrainingFacet facet = (XSDConstrainingFacet)itor.next();
            String thisName = facet.getFacetName();
            if (!nameEx.equals(thisName) && !nameIn.equals(thisName)) continue;
            itor.remove();
        }
    }

    private static String getRealFacetName(String facetName, boolean inclusive) {
        if (facetName == FAKE_FACET_MAXIMUM) {
            facetName = inclusive ? FACET_MAX_INCLUSIVE : FACET_MAX_EXCLUSIVE;
        } else if (facetName == FAKE_FACET_MINIMUM) {
            facetName = inclusive ? FACET_MIN_INCLUSIVE : FACET_MIN_EXCLUSIVE;
        }
        return facetName;
    }

    public static void removeFacet(XSDSimpleTypeDefinition type, XSDConstrainingFacet facet) {
        try {
            ModelerCore.getModelEditor().removeValue((Object)type, (Object)facet, type.getFacetContents());
        }
        catch (ModelerCoreException err) {
            ModelerXsdUiConstants.Util.log((Throwable)err);
        }
    }

    public static XSDConstrainingFacet addOrSetFacetValue(XSDSimpleTypeDefinition type, String facetName, FacetValue fv) {
        XSDConstrainingFacet workFacet = fv.facet;
        if (fv.facet == null || fv.facet.getContainer() != type) {
            boolean inclusiveness = false;
            if (fv.value instanceof InclusiveInteger) {
                inclusiveness = ((InclusiveInteger)fv.value).isInclusive;
            }
            if (facetName == FAKE_FACET_MAXIMUM || facetName == FAKE_FACET_MINIMUM) {
                FacetHelper.removeFacet(type, facetName);
            }
            workFacet = FacetHelper.createFacet(facetName, inclusiveness);
            try {
                ModelerCore.getModelEditor().addValue((Object)type, (Object)workFacet, type.getFacetContents());
            }
            catch (ModelerCoreException err) {
                ModelerXsdUiConstants.Util.log((Throwable)err);
            }
        }
        if (!FormUtil.safeEquals((Object)fv.value, (Object)FacetHelper.getMainFacetValue(workFacet))) {
            fv.facet = workFacet = FacetHelper.setMainFacetValue(type, workFacet, fv.value);
        }
        String existingDesc = ModelObjectUtilities.getDescription((EObject)workFacet);
        if (fv.description != null) {
            if (!fv.description.equals(existingDesc)) {
                ModelObjectUtilities.setDescription((EObject)workFacet, (String)fv.description, (Object)type);
            }
        } else if (existingDesc != null && existingDesc.length() > 0) {
            ModelObjectUtilities.setDescription((EObject)workFacet, (String)" ", (Object)type);
        }
        FacetHelper.setFixed(workFacet, fv.isFixedLocal);
        return workFacet;
    }

    private static void setFixed(XSDConstrainingFacet workFacet, boolean isFixed) {
        if (workFacet instanceof XSDFixedFacet) {
            XSDFixedFacet ff = (XSDFixedFacet)workFacet;
            ff.setFixed(isFixed);
        }
    }

    private static XSDConstrainingFacet setMainFacetValue(XSDSimpleTypeDefinition type, XSDConstrainingFacet facet, Object value) {
        int facetClassifierID = facet.eClass().getClassifierID();
        switch (facetClassifierID) {
            case 23: {
                XSDLengthFacet lf = (XSDLengthFacet)facet;
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    lf.setLexicalValue(i.toString());
                    break;
                }
                if (!(value instanceof InclusiveInteger)) break;
                InclusiveInteger ii = (InclusiveInteger)value;
                lf.setLexicalValue(Integer.toString(ii.value));
                break;
            }
            case 27: {
                XSDMaxLengthFacet mf = (XSDMaxLengthFacet)facet;
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    mf.setLexicalValue(i.toString());
                    break;
                }
                if (!(value instanceof InclusiveInteger)) break;
                InclusiveInteger ii = (InclusiveInteger)value;
                mf.setLexicalValue(Integer.toString(ii.value));
                break;
            }
            case 31: {
                XSDMinLengthFacet mf = (XSDMinLengthFacet)facet;
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    mf.setLexicalValue(i.toString());
                    break;
                }
                if (!(value instanceof InclusiveInteger)) break;
                InclusiveInteger ii = (InclusiveInteger)value;
                mf.setLexicalValue(Integer.toString(ii.value));
                break;
            }
            case 40: {
                XSDPatternFacet pf = (XSDPatternFacet)facet;
                pf.setLexicalValue((String)value);
                break;
            }
            case 14: {
                XSDEnumerationFacet ef = (XSDEnumerationFacet)facet;
                ef.setLexicalValue((String)value);
                break;
            }
            case 54: {
                XSDWhiteSpaceFacet wf = (XSDWhiteSpaceFacet)facet;
                if (!(value instanceof String)) break;
                String white = (String)value;
                wf.setLexicalValue(white);
                break;
            }
            case 28: 
            case 30: {
                XSDMinFacet mf = (XSDMinFacet)facet;
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    mf.setLexicalValue(i.toString());
                    break;
                }
                if (!(value instanceof InclusiveInteger)) break;
                InclusiveInteger ii = (InclusiveInteger)value;
                if (ii.isInclusive == mf.isInclusive()) {
                    mf.setLexicalValue(Integer.toString(ii.value));
                    break;
                }
                Object mf2 = ii.isInclusive ? XSDFactory.eINSTANCE.createXSDMinInclusiveFacet() : XSDFactory.eINSTANCE.createXSDMinExclusiveFacet();
                mf2.setLexicalValue(Integer.toString(ii.value));
                try {
                    ModelerCore.getModelEditor().removeValue((Object)type, (Object)mf, type.getFacetContents());
                    ModelerCore.getModelEditor().addValue((Object)type, mf2, type.getFacetContents());
                    facet = mf2;
                }
                catch (ModelerCoreException err) {
                    ModelerXsdUiConstants.Util.log((Throwable)err);
                }
                return mf2;
            }
            case 24: 
            case 26: {
                XSDMaxFacet mf = (XSDMaxFacet)facet;
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    mf.setLexicalValue(i.toString());
                    break;
                }
                if (!(value instanceof InclusiveInteger)) break;
                InclusiveInteger ii = (InclusiveInteger)value;
                if (ii.isInclusive == mf.isInclusive()) {
                    mf.setLexicalValue(Integer.toString(ii.value));
                    break;
                }
                Object mf2 = ii.isInclusive ? XSDFactory.eINSTANCE.createXSDMaxInclusiveFacet() : XSDFactory.eINSTANCE.createXSDMaxExclusiveFacet();
                mf2.setLexicalValue(Integer.toString(ii.value));
                try {
                    ModelerCore.getModelEditor().removeValue((Object)type, (Object)mf, type.getFacetContents());
                    ModelerCore.getModelEditor().addValue((Object)type, mf2, type.getFacetContents());
                    facet = mf2;
                }
                catch (ModelerCoreException err) {
                    ModelerXsdUiConstants.Util.log((Throwable)err);
                }
                return mf2;
            }
            case 18: {
                XSDFractionDigitsFacet ff = (XSDFractionDigitsFacet)facet;
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    ff.setLexicalValue(i.toString());
                    break;
                }
                if (!(value instanceof InclusiveInteger)) break;
                InclusiveInteger ii = (InclusiveInteger)value;
                ff.setLexicalValue(Integer.toString(ii.value));
                break;
            }
            case 52: {
                XSDTotalDigitsFacet tf = (XSDTotalDigitsFacet)facet;
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    tf.setLexicalValue(i.toString());
                    break;
                }
                if (!(value instanceof InclusiveInteger)) break;
                InclusiveInteger ii = (InclusiveInteger)value;
                tf.setLexicalValue(Integer.toString(ii.value));
                break;
            }
            default: {
                ModelerXsdUiConstants.Util.log((Object)ModelerXsdUiConstants.Util.getString(ERROR_KEY_UNUSABLE_FACET, (Object)facet));
            }
        }
        return facet;
    }

    private static Object getDefaultMainFacetValue(String facetName) {
        Object dft = defaults.get(facetName);
        if (dft == null) {
            XSDConstrainingFacet dftFacet = FacetHelper.createFacet(facetName);
            dft = FacetHelper.getMainFacetValue(dftFacet);
            defaults.put(facetName, dft);
        }
        return dft;
    }

    public static Object getMainFacetValue(XSDConstrainingFacet facet) {
        Object rv = null;
        int facetClassifierID = facet.eClass().getClassifierID();
        switch (facetClassifierID) {
            case 23: {
                XSDLengthFacet lf = (XSDLengthFacet)facet;
                rv = new Integer(lf.getValue());
                break;
            }
            case 27: {
                XSDMaxLengthFacet mf = (XSDMaxLengthFacet)facet;
                rv = new Integer(mf.getValue());
                break;
            }
            case 31: {
                XSDMinLengthFacet mf = (XSDMinLengthFacet)facet;
                rv = new Integer(mf.getValue());
                break;
            }
            case 40: {
                XSDPatternFacet pf = (XSDPatternFacet)facet;
                EList value = pf.getValue();
                if (value.size() > 1) {
                    rv = value;
                    break;
                }
                if (value.size() == 1) {
                    rv = value.get(0);
                    break;
                }
                rv = pf.getLexicalValue();
                break;
            }
            case 14: {
                XSDEnumerationFacet ef = (XSDEnumerationFacet)facet;
                EList value = ef.getValue();
                if (value.size() > 1) {
                    rv = value;
                    break;
                }
                if (value.size() == 1) {
                    rv = value.get(0);
                    break;
                }
                rv = ef.getLexicalValue();
                break;
            }
            case 54: {
                XSDWhiteSpaceFacet wf = (XSDWhiteSpaceFacet)facet;
                rv = wf.getValue().getName();
                break;
            }
            case 28: 
            case 30: {
                int value;
                XSDMinFacet mf = (XSDMinFacet)facet;
                try {
                    String lexicalValue = mf.getLexicalValue();
                    value = lexicalValue != null ? Integer.parseInt(lexicalValue) : -2147483647;
                }
                catch (NumberFormatException numberFormatException) {
                    value = -999999;
                }
                rv = new InclusiveInteger(value, mf.isInclusive());
                break;
            }
            case 24: 
            case 26: {
                int value;
                XSDMaxFacet mf = (XSDMaxFacet)facet;
                try {
                    String lexicalValue = mf.getLexicalValue();
                    value = lexicalValue != null ? Integer.parseInt(lexicalValue) : -2147483647;
                }
                catch (NumberFormatException numberFormatException) {
                    value = 999999;
                }
                rv = new InclusiveInteger(value, mf.isInclusive());
                break;
            }
            case 18: {
                XSDFractionDigitsFacet ff = (XSDFractionDigitsFacet)facet;
                rv = new Integer(ff.getValue());
                break;
            }
            case 52: {
                XSDTotalDigitsFacet tf = (XSDTotalDigitsFacet)facet;
                rv = new Integer(tf.getValue());
                break;
            }
            default: {
                ModelerXsdUiConstants.Util.log((Object)ModelerXsdUiConstants.Util.getString(ERROR_KEY_UNUSABLE_FACET, (Object)facet));
            }
        }
        return rv;
    }

    public static boolean isFixed(XSDConstrainingFacet facet) {
        return facet instanceof XSDFixedFacet && ((XSDFixedFacet)facet).isFixed();
    }

    public static Set getUsefulFacets(XSDSimpleTypeDefinition type) {
        HashSet<XSDConstrainingFacet> rv = new HashSet<XSDConstrainingFacet>();
        for (XSDConstrainingFacet facet : type.getFacets()) {
            if (facet instanceof XSDRepeatableFacet && facet.getElement() == null) {
                XSDEnumerationFacet ef;
                XSDSimpleTypeDefinition realParent;
                if (facet instanceof XSDPatternFacet) {
                    XSDPatternFacet pf = (XSDPatternFacet)facet;
                    realParent = (XSDSimpleTypeDefinition)pf.getContainer();
                    if (realParent != type) continue;
                    rv.addAll((Collection<XSDConstrainingFacet>)realParent.getPatternFacets());
                    continue;
                }
                if (!(facet instanceof XSDEnumerationFacet) || (realParent = (XSDSimpleTypeDefinition)(ef = (XSDEnumerationFacet)facet).getContainer()) != type) continue;
                rv.addAll((Collection<XSDConstrainingFacet>)realParent.getEnumerationFacets());
                continue;
            }
            rv.add(facet);
        }
        return rv;
    }

    public static XSDConstrainingFacet createFacet(String name) {
        return FacetHelper.createFacet(name, false);
    }

    public static XSDConstrainingFacet createFacet(String name, boolean inclusive) {
        name = FacetHelper.getRealFacetName(name, inclusive);
        return (XSDConstrainingFacet)XSDFactory.eINSTANCE.create((EClass)facetNametoEClass.get(name));
    }

    public static boolean needsNumeric(XSDSimpleTypeDefinition simpleType) {
        if (ModelerCore.getWorkspaceDatatypeManager().isNumeric((EObject)simpleType)) {
            return true;
        }
        XSDSimpleTypeDefinition base = simpleType.getBaseTypeDefinition();
        if (base != null) {
            String basename = base.getName();
            int i = 0;
            while (i < NUMERIC_TYPES.length) {
                String numericTypeName = NUMERIC_TYPES[i];
                if (numericTypeName.equalsIgnoreCase(basename)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean needsBounds(XSDSimpleTypeDefinition simpleType) {
        if (ModelerCore.getWorkspaceDatatypeManager().isBounded((EObject)simpleType)) {
            return true;
        }
        if (FacetHelper.needsNumeric(simpleType)) {
            return true;
        }
        XSDSimpleTypeDefinition base = simpleType.getBaseTypeDefinition();
        if (base != null) {
            String basename = base.getName();
            int i = 0;
            while (i < BOUNDS_TYPES.length) {
                String boundsTypeName = BOUNDS_TYPES[i];
                if (boundsTypeName.equalsIgnoreCase(basename)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static XSDSimpleTypeDefinition getDefiningEnterpriseType(XSDSimpleTypeDefinition simpleType) {
        XSDSimpleTypeDefinition root;
        XSDSimpleTypeDefinition rv = root = simpleType.getRootTypeDefinition();
        while (simpleType != root) {
            if (ModelerCore.getWorkspaceDatatypeManager().isEnterpriseDatatype((EObject)simpleType)) {
                rv = simpleType;
                break;
            }
            simpleType = simpleType.getBaseTypeDefinition();
        }
        return rv;
    }

    public static XSDSimpleTypeDefinition createAtomicSimpleTypeDefinintion(XSDSchema location, String typeName, XSDSimpleTypeDefinition baseType) {
        XSDSimpleTypeDefinition std = (XSDSimpleTypeDefinition)XSDFactory.eINSTANCE.create(XSDPackage.eINSTANCE.getXSDSimpleTypeDefinition());
        std.setName(typeName);
        try {
            ModelerCore.getModelEditor().addValue((Object)location, (Object)std, location.getContents());
            if (baseType != null) {
                ModelerCore.getDatatypeManager((EObject)std).setBasetypeDefinition(std, baseType);
            } else {
                XSDSimpleTypeDefinition defaultBaseType = FacetHelper.getDefaultBaseType();
                ModelerCore.getDatatypeManager((EObject)std).setBasetypeDefinition(std, defaultBaseType);
            }
        }
        catch (ModelerCoreException ex) {
            ModelerXsdUiConstants.Util.log((Throwable)ex);
        }
        return std;
    }

    private static XSDSimpleTypeDefinition getDefaultBaseType() throws ModelerCoreException {
        return (XSDSimpleTypeDefinition)ModelerCore.getBuiltInTypesManager().findDatatype("string");
    }

    public static String getFacetName(XSDConstrainingFacet facet) {
        String facetName = facet.getFacetName();
        if (FACET_MAX_INCLUSIVE.equals(facetName) || FACET_MAX_EXCLUSIVE.equals(facetName)) {
            facetName = FAKE_FACET_MAXIMUM;
        } else if (FACET_MIN_INCLUSIVE.equals(facetName) || FACET_MIN_EXCLUSIVE.equals(facetName)) {
            facetName = FAKE_FACET_MINIMUM;
        }
        return facetName;
    }

    public static boolean isSubtypeOf(XSDSimpleTypeDefinition startFrom, XSDSimpleTypeDefinition lookFor) {
        XSDSimpleTypeDefinition current = startFrom;
        XSDSimpleTypeDefinition root = startFrom.getRootTypeDefinition();
        while (current != root) {
            if (current == lookFor) {
                return true;
            }
            current = current.getBaseTypeDefinition();
        }
        return false;
    }
}

