/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlConstants;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ddl.DdlImporterManager;
import org.teiid.designer.ddl.importer.DdlImporterI18n;
import org.teiid.designer.ddl.importer.node.AbstractImporter;
import org.teiid.designer.ddl.importer.node.StandardImporter;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.relational.model.RelationalAccessPattern;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalSchema;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalViewTable;

public class TeiidDdlImporter
extends StandardImporter {
    private static final String NS_TEIID_ODATA = "teiid_odata";
    private static final String NS_TEIID_WEBSERVICE = "teiid_ws";
    private static final String NS_TEIID_MONGO = "teiid_mongo";
    private static final String NS_TEIID_SALESFORCE = "teiid_sf";
    private static final String NS_TEIID_RELATIONAL = "teiid_rel";
    private static final String NS_TEIID_ACCUMULO = "teiid_accumulo";
    private static final String NS_TEIID_EXCEL = "teiid_excel";
    private static final String NS_TEIID_JPA = "teiid_jpa";
    private static final String NS_DESIGNER_ODATA = "odata";
    private static final String NS_DESIGNER_WEBSERVICE = "ws";
    private static final String NS_DESIGNER_MONGO = "mongo";
    private static final String NS_DESIGNER_SALESFORCE = "salesforce";
    private static final String NS_DESIGNER_RELATIONAL = "relational";
    private static final String NS_DESIGNER_ACCUMULO = "accumulo";
    private static final String NS_DESIGNER_EXCEL = "excel";
    private static final String NS_DESIGNER_JPA = "jpa2";
    static int DEFAULT_NULL_VALUE_COUNT = -1;

    @Override
    protected TeiidInfo createInfo(AstNode node, RelationalModel model) throws Exception {
        return new TeiidInfo(node, model);
    }

    @Override
    protected String getTeiidDataTypeName(String datatype) throws Exception {
        String resultTypeName = null;
        EObject[] builtInTypes = ModelerCore.getWorkspaceDatatypeManager().getAllDatatypes();
        String dtName = null;
        int i = 0;
        while (i < builtInTypes.length) {
            dtName = ModelerCore.getWorkspaceDatatypeManager().getName(builtInTypes[i]);
            if (dtName != null && dtName.equalsIgnoreCase(datatype)) {
                resultTypeName = dtName;
                break;
            }
            ++i;
        }
        if (resultTypeName == null) {
            resultTypeName = super.getTeiidDataTypeName(datatype);
        }
        return resultTypeName;
    }

    private void createConstraint(AstNode constraintNode, RelationalTable table, RelationalModel model, Collection<RelationalReference> allRefs) throws CoreException {
        String type = constraintNode.getProperty("teiidddl:constraintType").toString();
        boolean primaryKeyConstraint = false;
        boolean uniqueConstraint = false;
        boolean accessPatternConstraint = false;
        boolean foreignKeyConstraint = false;
        boolean indexConstraint = false;
        RelationalPrimaryKey key = null;
        if ("PRIMARY KEY".equals(type)) {
            key = this.getFactory().createPrimaryKey();
            this.initialize((RelationalReference)key, constraintNode);
            table.setPrimaryKey(key);
            primaryKeyConstraint = true;
        } else if ("INDEX".equals(type)) {
            key = this.getFactory().createIndex();
            this.initialize((RelationalReference)key, constraintNode);
            model.addChild((RelationalReference)key);
            indexConstraint = true;
        } else if ("UNIQUE".equals(type)) {
            key = this.getFactory().createUniqueConstraint();
            this.initialize((RelationalReference)key, constraintNode);
            table.getUniqueConstraints().add((RelationalUniqueConstraint)key);
            uniqueConstraint = true;
        } else if (TeiidDdlConstants.TeiidNonReservedWord.ACCESSPATTERN.toDdl().equals(type)) {
            key = this.getFactory().createAccessPattern();
            this.initialize((RelationalReference)key, constraintNode);
            table.getAccessPatterns().add((RelationalAccessPattern)key);
            accessPatternConstraint = true;
        } else if ("FOREIGN KEY".equals(type)) {
            key = this.getFactory().createForeignKey();
            this.initializeFK(table.getForeignKeys(), (RelationalForeignKey)key, constraintNode);
            table.getForeignKeys().add((RelationalForeignKey)key);
            foreignKeyConstraint = true;
        } else assert (false) : "Unexpected constraint type of '" + type + "'";
        Object temp = constraintNode.getProperty("teiidddl:tableElementRefs");
        List references = (List)temp;
        for (AstNode ref : references) {
            try {
                RelationalColumn col = this.find(RelationalColumn.class, ref, (RelationalReference)table, allRefs);
                if (col == null) continue;
                if (primaryKeyConstraint) {
                    key.getColumns().add(col);
                    continue;
                }
                if (uniqueConstraint) {
                    ((RelationalUniqueConstraint)key).getColumns().add(col);
                    continue;
                }
                if (accessPatternConstraint) {
                    ((RelationalAccessPattern)key).getColumns().add(col);
                    continue;
                }
                if (foreignKeyConstraint) {
                    ((RelationalForeignKey)key).getColumns().add(col);
                    continue;
                }
                if (indexConstraint) {
                    ((RelationalIndex)key).getColumns().add(col);
                    continue;
                }
                assert (false) : "Unexpected constraint type of '" + type + "'";
            }
            catch (AbstractImporter.EntityNotFoundException error) {
                this.addProgressMessage(error.getMessage());
            }
        }
        if (foreignKeyConstraint) {
            RelationalForeignKey foreignKey = (RelationalForeignKey)key;
            AstNode tableRefNode = (AstNode)constraintNode.getProperty("teiidddl:tableRef");
            if (tableRefNode == null) {
                this.addProgressMessage(String.valueOf(DdlImporterI18n.FK_TABLE_REF_NOT_FOUND_MSG) + " '" + foreignKey.getName() + "'");
                return;
            }
            try {
                RelationalTable tableRef = this.find(RelationalTable.class, tableRefNode, null, allRefs);
                RelationalPrimaryKey tableRefPrimaryKey = tableRef.getPrimaryKey();
                List primaryKeyColumns = tableRef.getColumns();
                Object tempRefColumns = constraintNode.getProperty("teiidddl:tableRefElementRefs");
                List foreignTableColumnNodes = tempRefColumns == null ? Collections.emptyList() : (List)tempRefColumns;
                int numPKColumns = primaryKeyColumns.size();
                int numFKColumns = foreignTableColumnNodes.size();
                if (foreignTableColumnNodes.isEmpty()) {
                    if (tableRefPrimaryKey != null) {
                        foreignKey.setUniqueKeyName(tableRefPrimaryKey.getName());
                        foreignKey.setUniqueKeyTableName(tableRef.getName());
                    }
                } else if (numPKColumns == numFKColumns) {
                    for (AstNode fTableColumn : foreignTableColumnNodes) {
                        this.find(RelationalColumn.class, fTableColumn, (RelationalReference)tableRef, allRefs);
                    }
                    foreignKey.setUniqueKeyName(tableRefPrimaryKey.getName());
                    foreignKey.setUniqueKeyTableName(tableRef.getName());
                } else {
                    foreignKey.setUniqueKeyName(tableRefPrimaryKey.getName());
                    foreignKey.setUniqueKeyTableName(tableRef.getName());
                }
            }
            catch (AbstractImporter.EntityNotFoundException error) {
                this.addProgressMessage(error.getMessage());
            }
        }
        ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
        List children = constraintNode.getChildren();
        for (AstNode child : children) {
            if (!this.is(child, "ddl:statementOption")) continue;
            optionNodes.add(child);
        }
        this.processOptions(optionNodes, (RelationalReference)key);
    }

    @Override
    protected RelationalColumn createColumn(AstNode node, RelationalTable table) throws Exception {
        RelationalColumn column = super.createColumn(node, table);
        Object prop = node.getProperty("teiidddl:autoIncrement");
        if (prop != null) {
            column.setAutoIncremented(((Boolean)prop).booleanValue());
        }
        ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
        List children = node.getChildren();
        for (AstNode child : children) {
            if (!this.is(child, "ddl:statementOption")) continue;
            optionNodes.add(child);
        }
        this.processOptions(optionNodes, (RelationalReference)column);
        return column;
    }

    @Override
    protected RelationalProcedure createProcedure(AstNode procedureNode, RelationalModel model) throws Exception {
        RelationalProcedure procedure = super.createProcedure(procedureNode, model);
        ArrayList<AstNode> procOptionNodes = new ArrayList<AstNode>();
        for (AstNode child : procedureNode) {
            RelationalProcedureResultSet result;
            if (this.is(child, "teiidddl:procedureParameter")) {
                this.createProcedureParameter(child, procedure);
                continue;
            }
            if (this.is(child, "teiidddl:resultColumns")) {
                result = this.getFactory().createProcedureResultSet();
                procedure.setResultSet(result);
                this.initialize((RelationalReference)result, procedureNode);
                for (AstNode resultCol : child) {
                    if (!resultCol.hasMixin("teiidddl:resultColumn")) continue;
                    this.createColumn(resultCol, (RelationalTable)result);
                }
                continue;
            }
            if (this.is(child, "teiidddl:resultDataType")) {
                result = this.getFactory().createProcedureResultSet();
                procedure.setResultSet(result);
                this.initialize((RelationalReference)result, procedureNode);
                this.createColumn(child, (RelationalTable)result);
                continue;
            }
            if (!this.is(child, "ddl:statementOption")) continue;
            procOptionNodes.add(child);
        }
        this.processOptions(procOptionNodes, (RelationalReference)procedure);
        return procedure;
    }

    @Override
    protected RelationalParameter createProcedureParameter(AstNode node, RelationalProcedure procedure) throws Exception {
        RelationalParameter prm = super.createProcedureParameter(node, procedure);
        Object prop = node.getProperty("teiidddl:parameterType");
        if (prop != null) {
            String direction = prop.toString();
            prm.setDirection(direction);
        }
        ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
        List children = node.getChildren();
        for (AstNode child : children) {
            if (!this.is(child, "ddl:statementOption")) continue;
            optionNodes.add(child);
        }
        this.processOptions(optionNodes, (RelationalReference)prm);
        return prm;
    }

    @Override
    public RelationalModel importNode(AstNode rootNode, DdlImporterManager importManager) throws Exception {
        this.setImporterManager(importManager);
        RelationalModel model = this.getFactory().createModel("ddlImportedModel");
        HashMap<AstNode, RelationalReference> deferredCreateMap = new HashMap<AstNode, RelationalReference>();
        for (AstNode node : rootNode) {
            Map<AstNode, RelationalReference> deferredMap;
            if (this.is(node, "ddl:createSchemaStatement")) {
                RelationalSchema schema = this.getFactory().createSchema();
                model.addChild((RelationalReference)schema);
                this.initialize((RelationalReference)schema, node);
                for (AstNode node1 : node) {
                    Map<AstNode, RelationalReference> deferredMap2 = this.createObject(node1, model, schema);
                    if (deferredMap2.isEmpty()) continue;
                    deferredCreateMap.putAll(deferredMap2);
                }
                continue;
            }
            if (this.is(node, "teiidddl:optionNamespace") || (deferredMap = this.createObject(node, model, null)).isEmpty()) continue;
            deferredCreateMap.putAll(deferredMap);
        }
        this.createDeferredObjects(deferredCreateMap, model);
        return model;
    }

    @Override
    protected Map<AstNode, RelationalReference> createObject(AstNode node, RelationalModel model, RelationalSchema schema) throws Exception {
        HashMap<AstNode, RelationalReference> deferredMap = new HashMap<AstNode, RelationalReference>();
        if (this.is(node, "teiidddl:createTable")) {
            RelationalTable baseTable = this.getFactory().createBaseTable();
            this.initializeTable(baseTable, node, model);
            ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
            for (AstNode child : node) {
                if (this.is(child, "teiidddl:tableElement")) {
                    this.createColumn(child, baseTable);
                    continue;
                }
                if (this.is(child, "ddl:statementOption")) {
                    optionNodes.add(child);
                    continue;
                }
                if (!this.is(child, "teiidddl:tableElementConstraint") && !this.is(child, "teiidddl:foreignKeyConstraint") && !this.is(child, "teiidddl:indexConstraint")) continue;
                deferredMap.put(child, (RelationalReference)baseTable);
            }
            if (!optionNodes.isEmpty()) {
                this.processOptions(optionNodes, (RelationalReference)baseTable);
            }
        } else if (this.is(node, "teiidddl:createView")) {
            String queryExpression;
            RelationalViewTable viewTable = this.getFactory().createViewTable();
            this.initializeTable(viewTable, node, model);
            ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
            for (AstNode child : node) {
                if (this.is(child, "teiidddl:tableElement")) {
                    this.createColumn(child, (RelationalTable)viewTable);
                    continue;
                }
                if (this.is(child, "ddl:statementOption")) {
                    optionNodes.add(child);
                    continue;
                }
                if (!this.is(child, "teiidddl:tableElementConstraint") && !this.is(child, "teiidddl:foreignKeyConstraint") && !this.is(child, "teiidddl:indexConstraint")) continue;
                deferredMap.put(child, (RelationalReference)viewTable);
            }
            if (!optionNodes.isEmpty()) {
                this.processOptions(optionNodes, (RelationalReference)viewTable);
            }
            if (!StringUtilities.isEmpty((String)(queryExpression = (String)node.getProperty("teiidddl:queryExpression")))) {
                viewTable.setTransformationSQL(queryExpression);
            }
        } else if (this.is(node, "teiidddl:createProcedure") || this.is(node, "teiidddl:createFunction")) {
            this.createProcedure(node, model);
        } else if (this.is(node, "teiidddl:alterTable")) {
            deferredMap.put(node, null);
        } else if (!this.is(node, "teiidddl:alterView") && !this.is(node, "teiidddl:alterProcedure")) {
            return super.createObject(node, model, schema);
        }
        return deferredMap;
    }

    @Override
    protected void createDeferredObjects(Map<AstNode, RelationalReference> deferredNodes, RelationalModel model) throws Exception {
        RelationalTable table;
        Collection allRefs = model.getAllReferences();
        Set<AstNode> astNodes = deferredNodes.keySet();
        for (AstNode node : astNodes) {
            if (!this.is(node, "teiidddl:tableElementConstraint")) continue;
            table = (RelationalTable)deferredNodes.get(node);
            this.createConstraint(node, table, model, allRefs);
        }
        for (AstNode node : astNodes) {
            if (this.is(node, "teiidddl:foreignKeyConstraint") || this.is(node, "teiidddl:indexConstraint")) {
                table = (RelationalTable)deferredNodes.get(node);
                this.createConstraint(node, table, model, allRefs);
                continue;
            }
            if (!this.is(node, "teiidddl:alterTable")) continue;
            table = this.find(RelationalTable.class, node, null, allRefs);
            ArrayList<AstNode> optionNodes = new ArrayList<AstNode>();
            if (table != null) {
                for (AstNode child : node) {
                    if (!this.is(child, "teiidddl:alterOptionsList")) continue;
                    List nodeList = child.getChildren();
                    for (AstNode listItem : nodeList) {
                        if (!listItem.hasMixin("ddl:statementOption")) continue;
                        optionNodes.add(listItem);
                    }
                }
            }
            if (optionNodes.isEmpty()) continue;
            this.processOptions(optionNodes, (RelationalReference)table);
        }
    }

    private void processOptions(List<AstNode> optionNodes, RelationalReference relationalReference) {
        this.processTeiidStandardOptions(optionNodes, relationalReference);
        this.processTeiidExtensionOptions(optionNodes, relationalReference);
    }

    private void processTeiidStandardOptions(List<AstNode> optionNodes, RelationalReference relationalReference) {
        this.processTeiidCommonOptions(optionNodes, relationalReference);
        if (relationalReference instanceof RelationalTable) {
            this.processTeiidTableOptions(optionNodes, (RelationalTable)relationalReference);
        } else if (relationalReference instanceof RelationalColumn) {
            this.processTeiidColumnOptions(optionNodes, (RelationalColumn)relationalReference);
        } else if (relationalReference instanceof RelationalProcedure) {
            this.processTeiidProcedureOptions(optionNodes, (RelationalProcedure)relationalReference);
        }
    }

    private void processTeiidCommonOptions(List<AstNode> optionNodes, RelationalReference entity) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            String optionValueStr;
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (CoreStringUtil.isEmpty((String)optionName) || CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) continue;
            if (optionName.equalsIgnoreCase("ANNOTATION")) {
                entity.setDescription(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("UUID")) {
                nodeIter.remove();
                continue;
            }
            if (!optionName.equalsIgnoreCase("NAMEINSOURCE")) continue;
            entity.setNameInSource(optionValueStr);
            nodeIter.remove();
        }
    }

    private void processTeiidTableOptions(List<AstNode> optionNodes, RelationalTable table) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            String optionValueStr;
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (CoreStringUtil.isEmpty((String)optionName) || CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) continue;
            if (optionName.equalsIgnoreCase("CARDINALITY")) {
                table.setCardinality(Integer.parseInt(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("MATERIALIZED")) {
                table.setMaterialized(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("MATERIALIZED_TABLE")) {
                nodeIter.remove();
                continue;
            }
            if (!optionName.equalsIgnoreCase("UPDATABLE")) continue;
            table.setSupportsUpdate(this.isTrue(optionValueStr));
            nodeIter.remove();
        }
    }

    private void processTeiidProcedureOptions(List<AstNode> optionNodes, RelationalProcedure procedure) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            String optionValueStr;
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (CoreStringUtil.isEmpty((String)optionName) || CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) continue;
            if (optionName.equalsIgnoreCase("UPDATECOUNT")) {
                procedure.setUpdateCount(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("CATEGORY")) {
                procedure.setFunctionCategory(optionValueStr);
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("AGGREGATE")) {
                procedure.setAggregate(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("ALLOWS-DISTINCT")) {
                procedure.setAllowsDistinct(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("ALLOWS-ORDERBY")) {
                procedure.setAllowsOrderBy(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("ANALYTIC")) {
                procedure.setAnalytic(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("DECOMPOSABLE")) {
                procedure.setDecomposable(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("NON-PREPARED")) {
                procedure.setNonPrepared(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("NULL-ON-NULL")) {
                procedure.setReturnsNullOnNull(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("USES-DISTINCT-ROWS")) {
                procedure.setUseDistinctRows(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("VARARGS")) {
                procedure.setVariableArguments(this.isTrue(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("DETERMINISM")) {
                procedure.setDeterministic(this.isDeterministic(optionValueStr));
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("NATIVE-QUERY")) {
                procedure.setNativeQuery(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("FUNCTION-CATEGORY")) {
                procedure.setFunctionCategory(optionValueStr);
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("JAVA_CLASS")) {
                procedure.setJavaClassName(optionValueStr);
                procedure.setFunction(true);
                nodeIter.remove();
                continue;
            }
            if (!optionName.equalsIgnoreCase("JAVA_METHOD")) continue;
            procedure.setJavaMethodName(optionValueStr);
            procedure.setFunction(true);
            nodeIter.remove();
        }
    }

    private void processTeiidColumnOptions(List<AstNode> optionNodes, RelationalColumn column) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            String optionValueStr;
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (CoreStringUtil.isEmpty((String)optionName) || CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) continue;
            if (optionName.equalsIgnoreCase("SELECTABLE")) {
                column.setSelectable(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("UPDATABLE")) {
                column.setUpdateable(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("CURRENCY")) {
                column.setCurrency(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("CASE_SENSITIVE")) {
                column.setCaseSensitive(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("SIGNED")) {
                column.setSigned(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("FIXED_LENGTH")) {
                column.setLengthFixed(this.isTrue(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("SEARCHABLE")) {
                column.setSearchability(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("MIN_VALUE")) {
                column.setMinimumValue(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("MAX_VALUE")) {
                column.setMaximumValue(optionValueStr);
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("NATIVE_TYPE")) {
                column.setNativeType(optionValueStr);
                nodeIter.remove();
                this.resolveColumnDatatype(column, optionValueStr);
                continue;
            }
            if (optionName.equalsIgnoreCase("NULL_VALUE_COUNT")) {
                column.setNullValueCount(Integer.parseInt(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (optionName.equalsIgnoreCase("RADIX")) {
                column.setRadix(Integer.parseInt(optionValueStr));
                nodeIter.remove();
                continue;
            }
            if (!optionName.equalsIgnoreCase("CHAR_OCTET_LENGTH")) continue;
            column.setCharacterOctetLength(Integer.parseInt(optionValueStr));
            nodeIter.remove();
        }
    }

    private void resolveColumnDatatype(RelationalColumn column, String nativeType) {
        if (column.getDatatype().equalsIgnoreCase("INTEGER") && nativeType.equalsIgnoreCase("INT")) {
            column.setDatatype(nativeType);
        } else if (column.getDatatype().equalsIgnoreCase("STRING") && nativeType.equalsIgnoreCase("CHAR")) {
            if (column.getLength() > 1) {
                column.setDatatype("STRING");
            } else {
                column.setDatatype(nativeType);
            }
        } else if (column.getDatatype().equalsIgnoreCase("VARBINARY") && nativeType.equalsIgnoreCase("BINARY")) {
            column.setDatatype("OBJECT".toLowerCase());
        } else if (!column.getDatatype().equalsIgnoreCase("TIMESTAMP") || !nativeType.equalsIgnoreCase("DATETIME")) {
            if (column.getDatatype().equalsIgnoreCase("DOUBLE") && nativeType.equalsIgnoreCase("FLOAT")) {
                column.setDatatype(nativeType);
                if (column.getPrecision() == 0) {
                    column.setPrecision(53);
                }
            } else if (column.getDatatype().equalsIgnoreCase("BIGDECIMAL") && nativeType.equalsIgnoreCase("DECIMAL")) {
                column.setDatatype(nativeType);
            } else if (column.getDatatype().equalsIgnoreCase("SHORT") && nativeType.equalsIgnoreCase("TINYINT")) {
                column.setDatatype("BYTE".toLowerCase());
            } else if (column.getDatatype().equalsIgnoreCase("FLOAT") && nativeType.equalsIgnoreCase("REAL") && column.getPrecision() == 0) {
                column.setPrecision(24);
            }
        }
        column.setLengthFixed(this.isFixedLength(column.getNativeType()));
        if (column.getSearchability().equalsIgnoreCase("ALL_EXCEPT_LIKE")) {
            column.setCaseSensitive(false);
        } else if (column.getSearchability().equalsIgnoreCase("SEARCHABLE")) {
            column.setCaseSensitive(true);
        } else {
            column.setCaseSensitive(false);
        }
    }

    protected boolean isFixedLength(String typeName) {
        return !"LONGVARBINARY".equalsIgnoreCase(typeName) && !"LONGVARCHAR".equalsIgnoreCase(typeName) && !"VARBINARY".equalsIgnoreCase(typeName) && !"VARCHAR".equalsIgnoreCase(typeName) && !"ARRAY".equalsIgnoreCase(typeName) && !"BLOB".equalsIgnoreCase(typeName) && !"CLOB".equalsIgnoreCase(typeName);
    }

    private boolean isDeterministic(String determinismStr) {
        if ("NONDETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        if ("COMMAND_DETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        if ("SESSION_DETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        if ("USER_DETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        if ("VDB_DETERMINISTIC".equalsIgnoreCase(determinismStr)) {
            return false;
        }
        return "DETERMINISTIC".equalsIgnoreCase(determinismStr);
    }

    private void processTeiidExtensionOptions(List<AstNode> optionNodes, RelationalReference relationalEntity) {
        Iterator<AstNode> nodeIter = optionNodes.iterator();
        while (nodeIter.hasNext()) {
            AstNode optionNode = nodeIter.next();
            String optionName = optionNode.getName();
            Object optionValue = optionNode.getProperty("ddl:value");
            if (!CoreStringUtil.isEmpty((String)optionName)) {
                String optionValueStr;
                if (this.isUriNamespaced(optionName) || this.isPrefixNamespaced(optionName)) {
                    optionName = this.translateNamespacedOptionName(optionName);
                }
                if (!CoreStringUtil.isEmpty((String)(optionValueStr = (String)optionValue))) {
                    relationalEntity.addExtensionProperty(optionName, optionValueStr);
                }
            }
            nodeIter.remove();
        }
    }

    private String translateNamespacedOptionName(String namespacedPropName) {
        if (this.isUriNamespaced(namespacedPropName)) {
            String propNsUri = this.getExtensionPropertyNsUri(namespacedPropName);
            String designerNs = this.translateTeiidNsUriToDesignerNSPrefix(propNsUri);
            String propName = this.getExtensionPropertyName(namespacedPropName);
            return String.valueOf(designerNs) + ':' + propName;
        }
        if (this.isPrefixNamespaced(namespacedPropName)) {
            String propNsPrefix = this.getExtensionPropertyNsPrefix(namespacedPropName);
            String designerNs = this.translateTeiidNSPrefixToDesignerNSPrefix(propNsPrefix);
            String propName = this.getExtensionPropertyName(namespacedPropName);
            return String.valueOf(designerNs) + ':' + propName;
        }
        return namespacedPropName;
    }

    private String getExtensionPropertyNsPrefix(String propName) {
        int index;
        String namespace = null;
        if (!CoreStringUtil.isEmpty((String)propName) && this.isPrefixNamespaced(propName) && (index = propName.indexOf(58)) != -1) {
            namespace = propName.substring(0, index);
        }
        return namespace;
    }

    private String getExtensionPropertyNsUri(String propName) {
        String name = null;
        if (propName != null) {
            propName.trim();
            if (this.isUriNamespaced(propName)) {
                int index1 = propName.indexOf(123);
                int index2 = propName.indexOf(125);
                name = propName.substring(index1 + 1, index2);
            }
        }
        return name;
    }

    private String getExtensionPropertyName(String namespacedPropName) {
        String name = namespacedPropName;
        if (this.isPrefixNamespaced(namespacedPropName)) {
            int index = namespacedPropName.indexOf(58);
            name = namespacedPropName.substring(index + 1);
        } else if (this.isUriNamespaced(namespacedPropName)) {
            int index = namespacedPropName.indexOf(125);
            name = namespacedPropName.substring(index + 1);
        }
        return name;
    }

    private boolean isPrefixNamespaced(String propName) {
        boolean isPrefixNamespaced = false;
        if (!CoreStringUtil.isEmpty((String)propName) && !this.hasOpenCloseBraces(propName) && propName.indexOf(58) != -1) {
            isPrefixNamespaced = true;
        }
        return isPrefixNamespaced;
    }

    private boolean isUriNamespaced(String propName) {
        boolean isUriNamespaced = false;
        if (!CoreStringUtil.isEmpty((String)propName) && this.hasOpenCloseBraces(propName)) {
            isUriNamespaced = true;
        }
        return isUriNamespaced;
    }

    private boolean hasOpenCloseBraces(String propName) {
        boolean hasBoth = false;
        if (!CoreStringUtil.isEmpty((String)propName) && propName.indexOf(123) != -1 && propName.indexOf(125) != -1) {
            hasBoth = true;
        }
        return hasBoth;
    }

    private String translateTeiidNSPrefixToDesignerNSPrefix(String teiidNamespace) {
        String designerNS = teiidNamespace;
        if (NS_TEIID_ODATA.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_ODATA;
        } else if (NS_TEIID_RELATIONAL.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_RELATIONAL;
        } else if (NS_TEIID_WEBSERVICE.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_WEBSERVICE;
        } else if (NS_TEIID_SALESFORCE.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_SALESFORCE;
        } else if (NS_TEIID_MONGO.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_MONGO;
        } else if (NS_TEIID_ACCUMULO.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_ACCUMULO;
        } else if (NS_TEIID_EXCEL.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_EXCEL;
        } else if (NS_TEIID_JPA.equals(teiidNamespace)) {
            designerNS = NS_DESIGNER_JPA;
        }
        return designerNS;
    }

    private String translateTeiidNsUriToDesignerNSPrefix(String teiidNsUri) {
        String designerNsPrefix = null;
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        Collection meds = registry.getAllDefinitions();
        for (ModelExtensionDefinition med : meds) {
            String designerMedNsUri = med.getNamespaceUri();
            String designerMedNsPrefix = med.getNamespacePrefix();
            if (CoreStringUtil.isEmpty((String)designerMedNsUri) || !designerMedNsUri.equals(teiidNsUri)) continue;
            designerNsPrefix = designerMedNsPrefix;
            break;
        }
        return designerNsPrefix;
    }

    static interface TYPES_UPPER {
        public static final String ARRAY = "ARRAY";
        public static final String BIGDECIMAL = "BIGDECIMAL";
        public static final String BINARY = "BINARY";
        public static final String BIT = "BIT";
        public static final String BLOB = "BLOB";
        public static final String BYTE = "BYTE";
        public static final String CHAR = "CHAR";
        public static final String CLOB = "CLOB";
        public static final String DATE = "DATE";
        public static final String DATETIME = "DATETIME";
        public static final String DECIMAL = "DECIMAL";
        public static final String DOUBLE = "DOUBLE";
        public static final String FLOAT = "FLOAT";
        public static final String INT = "INT";
        public static final String INTEGER = "INTEGER";
        public static final String LONGVARBINARY = "LONGVARBINARY";
        public static final String LONGVARCHAR = "LONGVARCHAR";
        public static final String NCHAR = "NCHAR";
        public static final String NUMERIC = "NUMERIC";
        public static final String OBJECT = "OBJECT";
        public static final String REAL = "REAL";
        public static final String REF = "REF";
        public static final String SHORT = "SHORT";
        public static final String STRING = "STRING";
        public static final String SMALLINT = "SMALLINT";
        public static final String TIMES = "TIME";
        public static final String TIMESTAMP = "TIMESTAMP";
        public static final String TINYINT = "TINYINT";
        public static final String VARBINARY = "VARBINARY";
        public static final String VARCHAR = "VARCHAR";
    }

    private class TeiidInfo
    extends StandardImporter.Info {
        public TeiidInfo(AstNode node, RelationalModel model) throws Exception {
            super(node, model);
        }

        @Override
        protected void init(AstNode node, RelationalModel model) throws Exception {
            String name = node.getName();
            int ndx = name.lastIndexOf(46);
            if (ndx >= 0) {
                this.schema = null;
                this.name = this.removeLeadingTrailingTicks(name.substring(ndx + 1));
            } else {
                super.init(node, model);
            }
        }
    }
}

