/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl.importer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.extension.AbstractMetaclassNameProvider;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionAssistant;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.registry.ModelExtensionRegistry;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.relational.AccessPattern;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Catalog;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.ColumnSet;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.MultiplicityKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.ProcedureUpdateCount;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.Schema;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.metamodels.relational.UniqueConstraint;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.metamodels.relational.View;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionAssistant;
import org.teiid.designer.metamodels.relational.extension.RelationalModelExtensionConstants;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.RelationalPlugin;
import org.teiid.designer.relational.compare.DifferenceReport;
import org.teiid.designer.relational.model.DatatypeProcessor;
import org.teiid.designer.relational.model.RelationalAccessPattern;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalParameter;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalProcedureResultSet;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalView;
import org.teiid.designer.relational.model.RelationalViewTable;
import org.teiid.designer.transformation.model.RelationalViewModelFactory;

public class EmfModelGenerator {
    public static final RelationalFactory FACTORY = RelationalFactory.eINSTANCE;
    public static EmfModelGenerator INSTANCE = new EmfModelGenerator();
    public static RelationalViewModelFactory VIEW_MODEL_FACTORY = new RelationalViewModelFactory();
    private DatatypeProcessor datatypeProcessor = new DatatypeProcessor();
    private ModelEditor modelEditor = ModelerCore.getModelEditor();
    private List<DeferredPair> pkList = new ArrayList<DeferredPair>();
    private List<DeferredPair> fkList = new ArrayList<DeferredPair>();
    private List<DeferredPair> apList = new ArrayList<DeferredPair>();
    private List<DeferredPair> ucList = new ArrayList<DeferredPair>();
    private List<RelationalIndex> indexList = new ArrayList<RelationalIndex>();
    private List<DeferredPair> deferredProcessingList = new ArrayList<DeferredPair>();
    private Map<String, Collection<ModelObjectExtensionAssistant>> classNameToMedAssistantsMap = new HashMap<String, Collection<ModelObjectExtensionAssistant>>();
    private Set<String> propsWithNoAssistant = new HashSet<String>();
    private Set<String> metaclassesWithNoAssistant = new HashSet<String>();

    public IStatus execute(DifferenceReport diffReport, ModelResource targetModelResource, IProgressMonitor progressMonitor, int totalWork) throws ModelerCoreException {
        String prop;
        Iterator<String> iter;
        StringBuffer sb;
        BaseTable table;
        this.clearLists();
        int workUnit = totalWork / 5;
        this.addRelationalExtensionAssistant(targetModelResource);
        progressMonitor.setTaskName(Messages.emfModelGenerator_generatingModel);
        progressMonitor.subTask(Messages.emfModelGenerator_deletingPrimaryObjects);
        List objsToDelete = diffReport.getObjectsToDelete().getList();
        for (RelationalReference child : objsToDelete) {
            if (!child.isChecked()) continue;
            this.deleteMatchingChild(targetModelResource, child);
        }
        progressMonitor.worked(workUnit);
        progressMonitor.subTask(Messages.emfModelGenerator_creatingPrimaryObjects);
        List objsToCreate = diffReport.getObjectsToCreate().getList();
        for (RelationalReference child : objsToCreate) {
            if (!child.isChecked()) continue;
            this.createObject(child, targetModelResource);
        }
        progressMonitor.worked(workUnit);
        progressMonitor.subTask(Messages.emfModelGenerator_updatingPrimaryObjects);
        List objsToUpdate = diffReport.getObjectsToUpdate().getList();
        for (RelationalReference child : objsToUpdate) {
            if (!child.isChecked()) continue;
            this.deleteMatchingChild(targetModelResource, child);
            this.createObject(child, targetModelResource);
        }
        progressMonitor.worked(workUnit);
        progressMonitor.subTask(Messages.emfModelGenerator_creatingSecondaryObjects);
        if (!this.pkList.isEmpty()) {
            for (DeferredPair item : this.pkList) {
                RelationalPrimaryKey pk = (RelationalPrimaryKey)item.getRelationalReference();
                table = (BaseTable)item.getEObject();
                this.createPrimaryKey((RelationalReference)pk, table, targetModelResource);
            }
        }
        if (!this.fkList.isEmpty()) {
            for (DeferredPair item : this.fkList) {
                RelationalForeignKey fk = (RelationalForeignKey)item.getRelationalReference();
                table = (BaseTable)item.getEObject();
                this.createForeignKey((RelationalReference)fk, table, targetModelResource);
            }
        }
        if (!this.apList.isEmpty()) {
            for (DeferredPair item : this.apList) {
                RelationalAccessPattern ap = (RelationalAccessPattern)item.getRelationalReference();
                table = (Table)item.getEObject();
                this.createAccessPattern((RelationalReference)ap, (Table)table, targetModelResource);
            }
        }
        if (!this.ucList.isEmpty()) {
            for (DeferredPair item : this.ucList) {
                RelationalUniqueConstraint uc = (RelationalUniqueConstraint)item.getRelationalReference();
                table = (BaseTable)item.getEObject();
                this.createUniqueConstraint((RelationalReference)uc, table, targetModelResource);
            }
        }
        if (!this.indexList.isEmpty()) {
            for (RelationalIndex index : this.indexList) {
                this.createIndex((RelationalReference)index, targetModelResource);
            }
        }
        progressMonitor.worked(workUnit);
        progressMonitor.subTask(Messages.emfModelGenerator_settingExtensionProps);
        if (!this.deferredProcessingList.isEmpty()) {
            for (DeferredPair item : this.deferredProcessingList) {
                RelationalReference relRef = item.getRelationalReference();
                EObject eObj = item.getEObject();
                this.processExtensionProperties(targetModelResource, relRef, eObj);
                this.setDescription(eObj, relRef.getDescription(), targetModelResource);
            }
        }
        progressMonitor.worked(workUnit);
        MultiStatus multiStatus = new MultiStatus("org.teiid.designer.relational", 0, Messages.emfModelGenerator_modelGenerationSuccess, null);
        if (!this.propsWithNoAssistant.isEmpty()) {
            sb = new StringBuffer();
            iter = this.propsWithNoAssistant.iterator();
            while (iter.hasNext()) {
                prop = iter.next();
                sb.append(prop);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            multiStatus.add((IStatus)new Status(2, "org.teiid.designer.relational", 0, NLS.bind((String)Messages.emfModelGenerator_warningAssistantForPropertyNotFound, (Object)sb.toString()), null));
        } else if (!this.metaclassesWithNoAssistant.isEmpty()) {
            sb = new StringBuffer();
            iter = this.metaclassesWithNoAssistant.iterator();
            while (iter.hasNext()) {
                prop = iter.next();
                sb.append(prop);
                if (!iter.hasNext()) continue;
                sb.append(",");
            }
            multiStatus.add((IStatus)new Status(2, "org.teiid.designer.relational", 0, NLS.bind((String)Messages.emfModelGenerator_warningAssistantForMetaclassNotFound, (Object)sb.toString()), null));
        }
        this.clearLists();
        return multiStatus;
    }

    private void clearLists() {
        this.pkList.clear();
        this.fkList.clear();
        this.apList.clear();
        this.ucList.clear();
        this.indexList.clear();
        this.deferredProcessingList.clear();
        this.propsWithNoAssistant.clear();
        this.metaclassesWithNoAssistant.clear();
    }

    public EObject createObject(RelationalReference relationalRef, ModelResource modelResource) throws ModelWorkspaceException {
        EObject newEObject = null;
        switch (relationalRef.getType()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (relationalRef instanceof RelationalViewTable) {
                    newEObject = VIEW_MODEL_FACTORY.buildObject(relationalRef, modelResource, (IProgressMonitor)new NullProgressMonitor());
                    break;
                }
                newEObject = this.createBaseTable(relationalRef, modelResource);
                modelResource.getEmfResource().getContents().add((Object)newEObject);
                break;
            }
            case 4: {
                newEObject = this.createView(relationalRef, modelResource);
                modelResource.getEmfResource().getContents().add((Object)newEObject);
                break;
            }
            case 5: {
                newEObject = this.createProcedure(relationalRef, modelResource);
                modelResource.getEmfResource().getContents().add((Object)newEObject);
                break;
            }
            case 13: {
                newEObject = this.createIndex(relationalRef, modelResource);
                modelResource.getEmfResource().getContents().add((Object)newEObject);
                break;
            }
            default: {
                RelationalPlugin.Util.log(2, NLS.bind((String)Messages.emfModelGenerator_unknown_object_type_0_cannot_be_processed, (Object)relationalRef.getName()));
            }
        }
        return newEObject;
    }

    private void deleteMatchingChild(ModelResource targetResource, RelationalReference ref) throws ModelerCoreException {
        int refType = ref.getType();
        EList existingChildren = targetResource.getEmfResource().getContents();
        EObject childToDelete = null;
        for (EObject child : existingChildren) {
            String eObjName = this.modelEditor.getName(child);
            if (refType == 3 && child instanceof BaseTable) {
                if (!CoreStringUtil.equals((String)eObjName, (String)ref.getName())) continue;
                childToDelete = child;
                break;
            }
            if (refType == 4 && child instanceof View) {
                if (!CoreStringUtil.equals((String)eObjName, (String)ref.getName())) continue;
                childToDelete = child;
                break;
            }
            if (refType == 5 && child instanceof Procedure) {
                if (!CoreStringUtil.equals((String)eObjName, (String)ref.getName())) continue;
                childToDelete = child;
                break;
            }
            if (refType == 13 && child instanceof Index) {
                if (!CoreStringUtil.equals((String)eObjName, (String)ref.getName())) continue;
                childToDelete = child;
                break;
            }
            if (refType == 1 && child instanceof Schema) {
                if (!CoreStringUtil.equals((String)eObjName, (String)ref.getName())) continue;
                childToDelete = child;
                break;
            }
            if (refType != 2 || !(child instanceof Catalog) || !CoreStringUtil.equals((String)eObjName, (String)ref.getName())) continue;
            childToDelete = child;
            break;
        }
        if (childToDelete != null) {
            this.modelEditor.delete(childToDelete);
        }
    }

    public EObject createBaseTable(RelationalReference ref, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalTable.class, (Object)ref);
        RelationalTable tableRef = (RelationalTable)ref;
        BaseTable baseTable = FACTORY.createBaseTable();
        baseTable.setName(tableRef.getName());
        baseTable.setSupportsUpdate(tableRef.getSupportsUpdate());
        baseTable.setMaterialized(tableRef.isMaterialized());
        baseTable.setNameInSource(tableRef.getNameInSource());
        baseTable.setSystem(tableRef.isSystem());
        baseTable.setCardinality(tableRef.getCardinality());
        for (RelationalColumn column : tableRef.getColumns()) {
            this.createColumn((RelationalReference)column, (Table)baseTable, modelResource);
        }
        RelationalPrimaryKey pk = tableRef.getPrimaryKey();
        if (pk != null) {
            this.pkList.add(new DeferredPair((RelationalReference)pk, (EObject)baseTable));
        }
        Collection ucs = tableRef.getUniqueConstraints();
        for (RelationalUniqueConstraint uc : ucs) {
            this.ucList.add(new DeferredPair((RelationalReference)uc, (EObject)baseTable));
        }
        for (RelationalAccessPattern ap : tableRef.getAccessPatterns()) {
            this.apList.add(new DeferredPair((RelationalReference)ap, (EObject)baseTable));
        }
        for (RelationalForeignKey fk : tableRef.getForeignKeys()) {
            this.fkList.add(new DeferredPair((RelationalReference)fk, (EObject)baseTable));
        }
        for (RelationalIndex index : tableRef.getIndexes()) {
            this.indexList.add(index);
        }
        if (!tableRef.getExtensionProperties().isEmpty() || !CoreStringUtil.isEmpty((String)tableRef.getDescription())) {
            this.deferredProcessingList.add(new DeferredPair((RelationalReference)tableRef, (EObject)baseTable));
        }
        return baseTable;
    }

    public EObject createView(RelationalReference ref, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalView.class, (Object)ref);
        RelationalView viewRef = (RelationalView)ref;
        View view = FACTORY.createView();
        view.setName(viewRef.getName());
        view.setSupportsUpdate(viewRef.getSupportsUpdate());
        view.setMaterialized(viewRef.isMaterialized());
        view.setNameInSource(viewRef.getNameInSource());
        view.setSystem(viewRef.isSystem());
        for (RelationalColumn column : viewRef.getColumns()) {
            this.createColumn((RelationalReference)column, (Table)view, modelResource);
        }
        for (RelationalAccessPattern ap : viewRef.getAccessPatterns()) {
            this.apList.add(new DeferredPair((RelationalReference)ap, (EObject)view));
        }
        this.updateDeferredList((RelationalReference)viewRef, (EObject)view);
        return view;
    }

    public EObject createColumn(RelationalReference ref, Table baseTable, ModelResource modelResource) {
        EObject datatype;
        CoreArgCheck.isInstanceOf(RelationalColumn.class, (Object)ref);
        RelationalColumn columnRef = (RelationalColumn)ref;
        Column column = FACTORY.createColumn();
        column.setOwner((ColumnSet)baseTable);
        column.setName(columnRef.getName());
        column.setNameInSource(columnRef.getNameInSource());
        column.setAutoIncremented(columnRef.isAutoIncremented());
        column.setCaseSensitive(columnRef.isCaseSensitive());
        column.setCharacterSetName(columnRef.getCharacterSetName());
        column.setCollationName(columnRef.getCollationName());
        column.setCurrency(columnRef.isCurrency());
        column.setDefaultValue(columnRef.getDefaultValue());
        column.setDistinctValueCount(columnRef.getDistinctValueCount());
        column.setFixedLength(columnRef.isLengthFixed());
        column.setFormat(columnRef.getFormat());
        column.setMaximumValue(columnRef.getMaximumValue());
        column.setMinimumValue(columnRef.getMinimumValue());
        column.setNativeType(columnRef.getNativeType());
        column.setNullable(this.getNullableType(columnRef.getNullable()));
        column.setNullValueCount(columnRef.getNullValueCount());
        column.setPrecision(columnRef.getPrecision());
        column.setRadix(columnRef.getRadix());
        column.setScale(columnRef.getScale());
        column.setSearchability(this.getSearchabilityType(columnRef.getSearchability()));
        column.setSelectable(columnRef.isSelectable());
        column.setSigned(columnRef.isSigned());
        column.setUpdateable(columnRef.isUpdateable());
        String dType = columnRef.getDatatype();
        if (dType == null || dType.length() == 0) {
            dType = "string";
        }
        if ((datatype = this.datatypeProcessor.findDatatype(dType)) != null) {
            column.setType(datatype);
            String dTypeName = this.modelEditor.getName(datatype);
            int datatypeLength = columnRef.getLength();
            if (datatypeLength == 0 && "string".equalsIgnoreCase(dTypeName)) {
                columnRef.setLength(255);
            } else {
                columnRef.setLength(datatypeLength);
            }
        }
        column.setLength(columnRef.getLength());
        this.updateDeferredList((RelationalReference)columnRef, (EObject)column);
        return column;
    }

    public EObject createColumn(RelationalReference ref, ProcedureResult procedureResult, ModelResource modelResource) {
        EObject datatype;
        CoreArgCheck.isInstanceOf(RelationalColumn.class, (Object)ref);
        RelationalColumn columnRef = (RelationalColumn)ref;
        Column column = FACTORY.createColumn();
        column.setOwner((ColumnSet)procedureResult);
        column.setName(columnRef.getName());
        column.setNameInSource(columnRef.getNameInSource());
        column.setAutoIncremented(columnRef.isAutoIncremented());
        column.setCaseSensitive(columnRef.isCaseSensitive());
        column.setCharacterSetName(columnRef.getCharacterSetName());
        column.setCollationName(columnRef.getCollationName());
        column.setCurrency(columnRef.isCurrency());
        column.setDefaultValue(columnRef.getDefaultValue());
        column.setDistinctValueCount(columnRef.getDistinctValueCount());
        column.setFixedLength(columnRef.isLengthFixed());
        column.setFormat(columnRef.getFormat());
        column.setLength(columnRef.getLength());
        column.setMaximumValue(columnRef.getMaximumValue());
        column.setMinimumValue(columnRef.getMinimumValue());
        column.setNativeType(columnRef.getNativeType());
        String nullableStr = columnRef.getNullable();
        column.setNullable(this.getNullableType(nullableStr));
        column.setNullValueCount(columnRef.getNullValueCount());
        column.setPrecision(columnRef.getPrecision());
        column.setRadix(columnRef.getRadix());
        column.setScale(columnRef.getScale());
        column.setSearchability(this.getSearchabilityType(columnRef.getSearchability()));
        column.setSelectable(columnRef.isSelectable());
        column.setSigned(columnRef.isSigned());
        column.setUpdateable(columnRef.isUpdateable());
        String dType = columnRef.getDatatype();
        if (dType == null || dType.length() == 0) {
            dType = "string";
        }
        if ((datatype = this.datatypeProcessor.findDatatype(dType)) != null) {
            column.setType(datatype);
            String dTypeName = this.modelEditor.getName(datatype);
            int datatypeLength = columnRef.getLength();
            if (datatypeLength == 0 && "string".equalsIgnoreCase(dTypeName)) {
                columnRef.setLength(255);
            } else {
                columnRef.setLength(datatypeLength);
            }
        }
        this.updateDeferredList((RelationalReference)columnRef, (EObject)column);
        return column;
    }

    private DirectionKind getDirectionKind(String dirKindStr) {
        if ("IN".equalsIgnoreCase(dirKindStr)) {
            return DirectionKind.IN_LITERAL;
        }
        if ("IN_OUT".equalsIgnoreCase(dirKindStr)) {
            return DirectionKind.INOUT_LITERAL;
        }
        if ("OUT".equalsIgnoreCase(dirKindStr)) {
            return DirectionKind.OUT_LITERAL;
        }
        if ("RETURN".equalsIgnoreCase(dirKindStr)) {
            return DirectionKind.RETURN_LITERAL;
        }
        return DirectionKind.UNKNOWN_LITERAL;
    }

    private ProcedureUpdateCount getUpdateCount(String updCountStr) {
        if (ProcedureUpdateCount.AUTO_LITERAL.getName().equalsIgnoreCase(updCountStr)) {
            return ProcedureUpdateCount.AUTO_LITERAL;
        }
        if (ProcedureUpdateCount.ONE_LITERAL.getName().equalsIgnoreCase(updCountStr)) {
            return ProcedureUpdateCount.ONE_LITERAL;
        }
        if (ProcedureUpdateCount.MULTIPLE_LITERAL.getName().equalsIgnoreCase(updCountStr)) {
            return ProcedureUpdateCount.MULTIPLE_LITERAL;
        }
        if (ProcedureUpdateCount.ZERO_LITERAL.getName().equalsIgnoreCase(updCountStr)) {
            return ProcedureUpdateCount.ZERO_LITERAL;
        }
        return ProcedureUpdateCount.AUTO_LITERAL;
    }

    private MultiplicityKind getMultiplictyKind(String multKindStr) {
        if (MultiplicityKind.MANY_LITERAL.getName().equalsIgnoreCase(multKindStr)) {
            return MultiplicityKind.MANY_LITERAL;
        }
        if (MultiplicityKind.ONE_LITERAL.getName().equalsIgnoreCase(multKindStr)) {
            return MultiplicityKind.ONE_LITERAL;
        }
        if (MultiplicityKind.ZERO_TO_ONE_LITERAL.getName().equalsIgnoreCase(multKindStr)) {
            return MultiplicityKind.ZERO_TO_ONE_LITERAL;
        }
        if (MultiplicityKind.ZERO_TO_MANY_LITERAL.getName().equalsIgnoreCase(multKindStr)) {
            return MultiplicityKind.ZERO_TO_MANY_LITERAL;
        }
        return MultiplicityKind.UNSPECIFIED_LITERAL;
    }

    private NullableType getNullableType(String nullableStr) {
        if ("NULLABLE".equalsIgnoreCase(nullableStr)) {
            return NullableType.NULLABLE_LITERAL;
        }
        if ("NO_NULLS".equalsIgnoreCase(nullableStr)) {
            return NullableType.NO_NULLS_LITERAL;
        }
        return NullableType.NULLABLE_UNKNOWN_LITERAL;
    }

    private SearchabilityType getSearchabilityType(String searchableStr) {
        if ("UNSEARCHABLE".equalsIgnoreCase(searchableStr)) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        if ("ALL_EXCEPT_LIKE".equalsIgnoreCase(searchableStr)) {
            return SearchabilityType.ALL_EXCEPT_LIKE_LITERAL;
        }
        if ("LIKE_ONLY".equalsIgnoreCase(searchableStr)) {
            return SearchabilityType.LIKE_ONLY_LITERAL;
        }
        return SearchabilityType.SEARCHABLE_LITERAL;
    }

    public EObject createIndex(RelationalReference ref, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalIndex.class, (Object)ref);
        RelationalIndex indexRef = (RelationalIndex)ref;
        Index index = FACTORY.createIndex();
        index.setName(indexRef.getName());
        index.setNameInSource(index.getNameInSource());
        index.setFilterCondition(indexRef.getFilterCondition());
        index.setAutoUpdate(indexRef.isAutoUpdate());
        index.setNullable(indexRef.isNullable());
        index.setUnique(indexRef.isUnique());
        EList indexColumns = index.getColumns();
        for (RelationalColumn relColumn : indexRef.getColumns()) {
            BaseTable baseTable = this.getTable(relColumn.getParent().getName(), modelResource);
            Column column = this.getColumn(relColumn.getName(), (Table)baseTable);
            if (column == null) continue;
            indexColumns.add(column);
        }
        this.updateDeferredList((RelationalReference)indexRef, (EObject)index);
        return index;
    }

    private EObject createPrimaryKey(RelationalReference ref, BaseTable baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalPrimaryKey.class, (Object)ref);
        RelationalPrimaryKey pkRef = (RelationalPrimaryKey)ref;
        PrimaryKey primaryKey = FACTORY.createPrimaryKey();
        primaryKey.setTable(baseTable);
        primaryKey.setName(pkRef.getName());
        primaryKey.setNameInSource(pkRef.getNameInSource());
        EList keyColumns = primaryKey.getColumns();
        for (RelationalColumn relColumn : pkRef.getColumns()) {
            Column column = this.getColumn(relColumn.getName(), (Table)baseTable);
            if (column == null) continue;
            keyColumns.add(column);
        }
        this.updateDeferredList((RelationalReference)pkRef, (EObject)primaryKey);
        return primaryKey;
    }

    public EObject createForeignKey(RelationalReference ref, BaseTable baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalForeignKey.class, (Object)ref);
        RelationalForeignKey fkRef = (RelationalForeignKey)ref;
        ForeignKey foreignKey = FACTORY.createForeignKey();
        foreignKey.setTable(baseTable);
        foreignKey.setName(fkRef.getName());
        foreignKey.setNameInSource(fkRef.getNameInSource());
        foreignKey.setForeignKeyMultiplicity(this.getMultiplictyKind(fkRef.getForeignKeyMultiplicity()));
        foreignKey.setPrimaryKeyMultiplicity(this.getMultiplictyKind(fkRef.getPrimaryKeyMultiplicity()));
        EList keyColumns = foreignKey.getColumns();
        for (RelationalColumn relColumn : fkRef.getColumns()) {
            Column column = this.getColumn(relColumn.getName(), (Table)baseTable);
            if (column == null) continue;
            keyColumns.add(column);
        }
        BaseTable fkTable = this.getTable(fkRef.getUniqueKeyTableName(), modelResource);
        String ukRefName = fkRef.getUniqueKeyName();
        if (fkTable != null && ukRefName != null) {
            if (fkTable.getPrimaryKey() != null && fkTable.getPrimaryKey().getName().equalsIgnoreCase(ukRefName)) {
                foreignKey.setUniqueKey((UniqueKey)fkTable.getPrimaryKey());
            } else if (fkTable.getUniqueConstraints().isEmpty()) {
                for (Object key : fkTable.getUniqueConstraints()) {
                    String keyName = this.modelEditor.getName((EObject)((UniqueKey)key));
                    if (!keyName.equalsIgnoreCase(ukRefName)) continue;
                    foreignKey.setUniqueKey((UniqueKey)key);
                }
            }
        }
        this.updateDeferredList((RelationalReference)fkRef, (EObject)foreignKey);
        return foreignKey;
    }

    private EObject createAccessPattern(RelationalReference ref, Table baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalAccessPattern.class, (Object)ref);
        RelationalAccessPattern apRef = (RelationalAccessPattern)ref;
        AccessPattern accessPattern = FACTORY.createAccessPattern();
        accessPattern.setTable(baseTable);
        accessPattern.setName(apRef.getName());
        accessPattern.setNameInSource(apRef.getNameInSource());
        EList keyColumns = accessPattern.getColumns();
        for (RelationalColumn relColumn : apRef.getColumns()) {
            Column column = this.getColumn(relColumn.getName(), baseTable);
            if (column == null) continue;
            keyColumns.add(column);
        }
        this.updateDeferredList((RelationalReference)apRef, (EObject)accessPattern);
        return accessPattern;
    }

    private EObject createUniqueConstraint(RelationalReference ref, BaseTable baseTable, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalUniqueConstraint.class, (Object)ref);
        RelationalUniqueConstraint ucRef = (RelationalUniqueConstraint)ref;
        UniqueConstraint uniqueConstraint = FACTORY.createUniqueConstraint();
        uniqueConstraint.setTable(baseTable);
        uniqueConstraint.setName(ucRef.getName());
        uniqueConstraint.setNameInSource(ucRef.getNameInSource());
        EList keyColumns = uniqueConstraint.getColumns();
        for (RelationalColumn relColumn : ucRef.getColumns()) {
            Column column = this.getColumn(relColumn.getName(), (Table)baseTable);
            if (column == null) continue;
            keyColumns.add(column);
        }
        this.updateDeferredList((RelationalReference)ucRef, (EObject)uniqueConstraint);
        return uniqueConstraint;
    }

    private Column getColumn(String name, Table baseTable) {
        for (Object column : baseTable.getColumns()) {
            if (!(column instanceof Column) || !((Column)column).getName().equalsIgnoreCase(name)) continue;
            return (Column)column;
        }
        return null;
    }

    private BaseTable getTable(String tableName, ModelResource modelResource) {
        try {
            for (EObject eObj : modelResource.getEmfResource().getContents()) {
                String eObjName = this.modelEditor.getName(eObj);
                if (!(eObj instanceof BaseTable) || eObjName == null || !eObjName.equalsIgnoreCase(tableName)) continue;
                return (BaseTable)eObj;
            }
        }
        catch (ModelWorkspaceException modelWorkspaceException) {
            RelationalPlugin.Util.log(4, NLS.bind((String)Messages.emfModelGenerator_error_finding_table_named, (Object)tableName));
        }
        return null;
    }

    public EObject createProcedure(RelationalReference ref, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalProcedure.class, (Object)ref);
        RelationalProcedure procedureRef = (RelationalProcedure)ref;
        Procedure procedure = FACTORY.createProcedure();
        procedure.setName(procedureRef.getName());
        procedure.setNameInSource(procedureRef.getNameInSource());
        procedure.setFunction(procedureRef.isFunction());
        procedure.setUpdateCount(this.getUpdateCount(procedureRef.getUpdateCount()));
        for (RelationalParameter paramRef : procedureRef.getParameters()) {
            this.createParameter((RelationalReference)paramRef, procedure, modelResource);
        }
        if (procedureRef.getResultSet() != null) {
            this.createResultSet((RelationalReference)procedureRef.getResultSet(), procedure, modelResource);
        }
        this.updateDeferredList((RelationalReference)procedureRef, (EObject)procedure);
        return procedure;
    }

    public EObject createParameter(RelationalReference ref, Procedure procedure, ModelResource modelResource) {
        EObject datatype;
        CoreArgCheck.isInstanceOf(RelationalParameter.class, (Object)ref);
        RelationalParameter parameterRef = (RelationalParameter)ref;
        ProcedureParameter parameter = FACTORY.createProcedureParameter();
        parameter.setProcedure(procedure);
        parameter.setName(parameterRef.getName());
        parameter.setNameInSource(parameterRef.getNameInSource());
        parameter.setDefaultValue(parameterRef.getDefaultValue());
        parameter.setDirection(this.getDirectionKind(parameterRef.getDirection()));
        parameter.setNativeType(parameterRef.getNativeType());
        parameter.setNullable(this.getNullableType(parameterRef.getNullable()));
        parameter.setPrecision(parameterRef.getPrecision());
        parameter.setRadix(parameterRef.getRadix());
        parameter.setScale(parameterRef.getScale());
        String dType = parameterRef.getDatatype();
        if (dType == null || dType.length() == 0) {
            dType = "string";
        }
        if ((datatype = this.datatypeProcessor.findDatatype(dType)) != null) {
            parameter.setType(datatype);
            String dTypeName = this.modelEditor.getName(datatype);
            int datatypeLength = parameterRef.getLength();
            if (datatypeLength == 0 && "string".equalsIgnoreCase(dTypeName)) {
                parameter.setLength(255);
            } else {
                parameter.setLength(datatypeLength);
            }
        }
        this.updateDeferredList((RelationalReference)parameterRef, (EObject)parameter);
        return parameter;
    }

    public EObject createResultSet(RelationalReference ref, Procedure procedure, ModelResource modelResource) {
        CoreArgCheck.isInstanceOf(RelationalProcedureResultSet.class, (Object)ref);
        RelationalProcedureResultSet resultSetRef = (RelationalProcedureResultSet)ref;
        ProcedureResult result = FACTORY.createProcedureResult();
        result.setProcedure(procedure);
        result.setName(resultSetRef.getName());
        result.setNameInSource(resultSetRef.getNameInSource());
        for (RelationalColumn colRef : resultSetRef.getColumns()) {
            this.createColumn((RelationalReference)colRef, result, modelResource);
        }
        this.updateDeferredList((RelationalReference)resultSetRef, (EObject)result);
        return result;
    }

    private void updateDeferredList(RelationalReference relRef, EObject eObj) {
        if (!relRef.getExtensionProperties().isEmpty() || !CoreStringUtil.isEmpty((String)relRef.getDescription()) || relRef instanceof RelationalProcedure) {
            this.deferredProcessingList.add(new DeferredPair(relRef, eObj));
        }
    }

    public void setDescription(EObject eObject, String description, ModelResource modelResource) {
        if (description != null && description.trim().length() > 0) {
            try {
                Annotation annotation;
                AnnotationContainer annotations = null;
                for (Object next : modelResource.getEmfResource().getContents()) {
                    if (!(next instanceof AnnotationContainer)) continue;
                    annotations = (AnnotationContainer)next;
                    break;
                }
                if (annotations == null) {
                    annotations = CoreFactory.eINSTANCE.createAnnotationContainer();
                    modelResource.getEmfResource().getContents().add((Object)annotations);
                }
                if ((annotation = annotations.findAnnotation(eObject)) == null) {
                    annotation = CoreFactory.eINSTANCE.createAnnotation();
                    annotations.getAnnotations().add((Object)annotation);
                    annotation.setAnnotatedObject(eObject);
                }
                annotation.setDescription(description);
            }
            catch (ModelWorkspaceException modelWorkspaceException) {
                RelationalPlugin.Util.log(4, NLS.bind((String)Messages.emfModelGenerator_error_adding_desciption_to_0, (Object)eObject));
            }
        }
    }

    private void processExtensionProperties(ModelResource modelResource, RelationalReference relationalEntity, EObject eObject) {
        if (relationalEntity.getType() == 5) {
            this.processProcedureExtensionProperties(modelResource, (RelationalProcedure)relationalEntity, eObject);
        }
        Properties extensionProperties = relationalEntity.getExtensionProperties();
        for (String string : extensionProperties.keySet()) {
            String propValue = extensionProperties.getProperty(string);
            ModelObjectExtensionAssistant assistant = this.getModelExtensionAssistant(eObject.getClass().getName(), string);
            if (assistant == null) continue;
            this.applyMedIfNecessary(modelResource, assistant);
            this.setPropertyValue(assistant, eObject, string, propValue);
        }
    }

    private void processProcedureExtensionProperties(ModelResource modelResource, RelationalProcedure relationalProcedure, EObject eObject) {
        RelationalModelExtensionAssistant relationalExtensionAssistant = this.getRelationalExtensionAssistant();
        String nativeQuery = relationalProcedure.getNativeQuery();
        if (!CoreStringUtil.isEmpty((String)nativeQuery)) {
            this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:native-query", nativeQuery);
        }
        boolean isNonPrepared = relationalProcedure.isNonPrepared();
        this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:non-prepared", String.valueOf(isNonPrepared));
        boolean isFunction = relationalProcedure.isFunction();
        if (isFunction) {
            String javaMethod;
            String javaClass;
            String functionCategory = relationalProcedure.getFunctionCategory();
            if (!CoreStringUtil.isEmpty((String)functionCategory)) {
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:function-category", functionCategory);
            }
            if (!CoreStringUtil.isEmpty((String)(javaClass = relationalProcedure.getJavaClassName()))) {
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:java-class", javaClass);
            }
            if (!CoreStringUtil.isEmpty((String)(javaMethod = relationalProcedure.getJavaMethodName()))) {
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:java-method", javaMethod);
            }
            boolean isVariableArgs = relationalProcedure.isVariableArguments();
            this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:varargs", String.valueOf(isVariableArgs));
            boolean isNullOnNull = relationalProcedure.isReturnsNullOnNull();
            this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:null-on-null", String.valueOf(isNullOnNull));
            boolean isDeterministic = relationalProcedure.isDeterministic();
            this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:deterministic", String.valueOf(isDeterministic));
            boolean isAggregate = relationalProcedure.isAggregate();
            if (isAggregate) {
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:aggregate", String.valueOf(isAggregate));
                boolean isAnalytic = relationalProcedure.isAnalytic();
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:analytic", String.valueOf(isAnalytic));
                boolean isAllowsOrderBy = relationalProcedure.isAllowsOrderBy();
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:allows-orderby", String.valueOf(isAllowsOrderBy));
                boolean isUseDistinctRows = relationalProcedure.isUseDistinctRows();
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:uses-distinct-rows", String.valueOf(isUseDistinctRows));
                boolean isAllowsDistinct = relationalProcedure.isAllowsDistinct();
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:allows-distinct", String.valueOf(isAllowsDistinct));
                boolean isDecomposable = relationalProcedure.isDecomposable();
                this.setPropertyValue((ModelObjectExtensionAssistant)relationalExtensionAssistant, eObject, "relational:decomposable", String.valueOf(isDecomposable));
            }
        }
    }

    private void setPropertyValue(ModelObjectExtensionAssistant assistant, EObject eObject, String propId, String propValue) {
        String namespacedId = null;
        namespacedId = propId.indexOf(58) != -1 ? propId : String.valueOf(assistant.getNamespacePrefix()) + ':' + propId;
        try {
            assistant.setPropertyValue((Object)eObject, namespacedId, propValue);
        }
        catch (Exception ex) {
            RelationalPlugin.Util.log(4, (Throwable)ex, NLS.bind((String)Messages.emfModelGenerator_errorSettingPropertyValue, (Object)namespacedId));
        }
    }

    private void applyMedIfNecessary(ModelResource modelResource, ModelObjectExtensionAssistant assistant) {
        if (modelResource != null && !modelResource.isReadOnly()) {
            try {
                if (!assistant.supportsMyNamespace((Object)modelResource)) {
                    assistant.saveModelExtensionDefinition((Object)modelResource);
                }
            }
            catch (Exception exception) {
                RelationalPlugin.Util.log(4, Messages.emfModelGenerator_errorApplyingMedToModel);
            }
        }
    }

    private ModelObjectExtensionAssistant getModelExtensionAssistant(String eObjectClassName, String propId) {
        Collection<ModelObjectExtensionAssistant> assistants = null;
        if (this.classNameToMedAssistantsMap.containsKey(eObjectClassName)) {
            assistants = this.classNameToMedAssistantsMap.get(eObjectClassName);
        } else {
            Collection collection = ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistants(eObjectClassName);
            assistants = new ArrayList<ModelObjectExtensionAssistant>();
            for (ModelExtensionAssistant medAssistant : collection) {
                if (!(medAssistant instanceof ModelObjectExtensionAssistant)) continue;
                assistants.add((ModelObjectExtensionAssistant)medAssistant);
            }
            this.classNameToMedAssistantsMap.put(eObjectClassName, assistants);
        }
        if (assistants.isEmpty()) {
            String string = this.getMetaclassShortName(eObjectClassName);
            this.metaclassesWithNoAssistant.add(string);
            return null;
        }
        if (this.isNamespaced(propId)) {
            ModelObjectExtensionAssistant modelObjectExtensionAssistant = this.getAssistantWithNamespace(this.getExtensionPropertyNamespace(propId), assistants);
            if (modelObjectExtensionAssistant != null) {
                return modelObjectExtensionAssistant;
            }
        } else {
            for (ModelExtensionAssistant modelExtensionAssistant : assistants) {
                String namespacedId = String.valueOf(modelExtensionAssistant.getNamespacePrefix()) + ':' + propId;
                if (!this.hasMatchingPropertyName(modelExtensionAssistant.getModelExtensionDefinition(), eObjectClassName, namespacedId)) continue;
                return modelExtensionAssistant instanceof ModelObjectExtensionAssistant ? (ModelObjectExtensionAssistant)modelExtensionAssistant : null;
            }
        }
        this.propsWithNoAssistant.add(propId);
        return null;
    }

    private ModelObjectExtensionAssistant getAssistantWithNamespace(String namespace, Collection<ModelObjectExtensionAssistant> assistants) {
        ModelObjectExtensionAssistant result = null;
        for (ModelObjectExtensionAssistant assistant : assistants) {
            if (!assistant.getNamespacePrefix().equalsIgnoreCase(namespace)) continue;
            result = assistant;
            break;
        }
        return result;
    }

    private String getExtensionPropertyNamespace(String propName) {
        int index;
        String namespace = null;
        if (!CoreStringUtil.isEmpty((String)propName) && (index = propName.indexOf(58)) != -1) {
            namespace = propName.substring(0, index);
        }
        return namespace;
    }

    private boolean isNamespaced(String propName) {
        boolean isNamespaced = false;
        if (!CoreStringUtil.isEmpty((String)propName)) {
            isNamespaced = propName.indexOf(58) != -1;
        }
        return isNamespaced;
    }

    private String getMetaclassShortName(String metaclass) {
        return AbstractMetaclassNameProvider.getLabel((String)metaclass);
    }

    private boolean hasMatchingPropertyName(ModelExtensionDefinition med, String metaclassName, String propId) {
        ModelExtensionPropertyDefinition propDefn = med.getPropertyDefinition(metaclassName, propId);
        return propDefn != null;
    }

    private void addRelationalExtensionAssistant(ModelResource modelResource) {
        RelationalModelExtensionAssistant assistant = this.getRelationalExtensionAssistant();
        try {
            assistant.applyMedIfNecessary(modelResource.getUnderlyingResource());
        }
        catch (Exception e) {
            RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
    }

    private RelationalModelExtensionAssistant getRelationalExtensionAssistant() {
        ModelExtensionRegistry registry = ExtensionPlugin.getInstance().getRegistry();
        String prefix = RelationalModelExtensionConstants.NAMESPACE_PROVIDER.getNamespacePrefix();
        RelationalModelExtensionAssistant assistant = (RelationalModelExtensionAssistant)registry.getModelExtensionAssistant(prefix);
        return assistant;
    }

    class DeferredPair {
        private RelationalReference relationalRef;
        private EObject eObj;

        public DeferredPair(RelationalReference relRef, EObject eObj) {
            this.relationalRef = relRef;
            this.eObj = eObj;
        }

        RelationalReference getRelationalReference() {
            return this.relationalRef;
        }

        EObject getEObject() {
            return this.eObj;
        }
    }
}

