/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.impl;

import com.ibm.icu.util.ULocale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.hibernate.Session;
import org.jboss.tools.birt.oda.IOdaFactory;
import org.jboss.tools.birt.oda.Messages;
import org.jboss.tools.birt.oda.impl.ConsoleConfigurationOdaFactory;
import org.jboss.tools.birt.oda.impl.HibernateDataSetMetaData;
import org.jboss.tools.birt.oda.impl.HibernateOdaQuery;
import org.jboss.tools.birt.oda.impl.ServerOdaFactory;
import org.osgi.framework.Bundle;

public class HibernateConnection
implements IConnection {
    private IOdaFactory odaSessionFactory;
    private Session session;

    public void open(Properties connProperties) throws OdaException {
        Bundle bundle = Platform.getBundle((String)"org.hibernate.eclipse");
        this.odaSessionFactory = bundle != null ? new ConsoleConfigurationOdaFactory(connProperties) : new ServerOdaFactory(connProperties);
        this.session = this.odaSessionFactory.getSessionFactory().openSession();
    }

    public void setAppContext(Object context) throws OdaException {
        if (!(context instanceof Map)) {
            throw new OdaException(Messages.HibernateConnection_Invalid_AppContext);
        }
    }

    public void close() throws OdaException {
        if (this.odaSessionFactory != null) {
            this.odaSessionFactory.close();
            this.odaSessionFactory = null;
        }
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    public boolean isOpen() throws OdaException {
        return this.session != null && this.session.isOpen();
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new HibernateDataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        return new HibernateOdaQuery(this);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public IOdaFactory getOdaSessionFactory() {
        return this.odaSessionFactory;
    }

    public Session getSession() {
        return this.session;
    }

    public void setLocale(ULocale uLocale) throws OdaException {
        throw new UnsupportedOperationException();
    }
}

