/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.birt.oda.impl;

import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.jboss.tools.birt.oda.Activator;
import org.jboss.tools.birt.oda.Messages;
import org.jboss.tools.birt.oda.impl.AbstractOdaFactory;
import org.jboss.tools.hibernate.spi.ISessionFactory;

public class ConsoleConfigurationOdaFactory
extends AbstractOdaFactory {
    ConsoleConfiguration consoleConfiguration;

    public ConsoleConfigurationOdaFactory(Properties properties) throws OdaException {
        this.getSessionFactory(properties);
        String maxRowString = properties.getProperty("maxRows");
        try {
            this.setMaxRows(new Integer(maxRowString));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public SessionFactory getSessionFactory(Properties properties) throws OdaException {
        String configurationName = properties.getProperty("configuration");
        ConsoleConfiguration[] configurations = KnownConfigurations.getInstance().getConfigurations();
        int i = 0;
        while (i < configurations.length) {
            if (configurations[i].getName().equals(configurationName)) {
                this.consoleConfiguration = configurations[i];
                break;
            }
            ++i;
        }
        if (!this.isOpen()) {
            try {
                ISessionFactory isf = this.consoleConfiguration.getSessionFactory();
                if (isf == null) {
                    this.consoleConfiguration.build();
                    this.consoleConfiguration.buildSessionFactory();
                    isf = this.consoleConfiguration.getSessionFactory();
                }
                this.sessionFactory = Activator.getSessionFactory(isf);
            }
            catch (HibernateException e) {
                throw new OdaException(e.getLocalizedMessage());
            }
        } else {
            throw new OdaException(NLS.bind((String)Messages.ConsoleConfigurationOdaFactory_Invalid_configuration, (Object)configurationName));
        }
        return this.sessionFactory;
    }
}

