/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.validator.wizards;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.switchyard.ValidateType;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.AbstractSwitchyardComposite;
import org.switchyard.tools.ui.editor.diagram.shared.ModelOperation;
import org.switchyard.tools.ui.editor.util.ValidatorTypesUtil;
import org.switchyard.tools.ui.editor.validator.wizards.AddValidatorWizard;

public class BaseValidatorComposite
extends AbstractSwitchyardComposite {
    private Composite _panel;
    private ValidateType _validator;
    private Combo _nameText;
    private ValidatorTypesUtil _typesUtil = null;
    private String _warningMessage = null;
    private WizardPage _wizPage = null;

    public BaseValidatorComposite(FormToolkit toolkit) {
        super(toolkit);
        if (this._typesUtil == null) {
            this._typesUtil = new ValidatorTypesUtil();
        }
    }

    @Override
    protected boolean validate() {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        if (this._nameText != null && !this._nameText.isDisposed()) {
            String text = this._nameText.getText().trim();
            if (text.isEmpty()) {
                this.setErrorMessage(Messages.error_emptyName);
            } else {
                try {
                    QName.valueOf(text);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.setErrorMessage(Messages.error_invalidQname);
                }
            }
            if (!text.isEmpty()) {
                boolean inEdit = false;
                if (this._wizPage != null && this._wizPage.getWizard() instanceof AddValidatorWizard && ((AddValidatorWizard)this._wizPage.getWizard()).getValidator() != null) {
                    inEdit = true;
                }
                if (this._typesUtil.validatorExists(text) && !inEdit) {
                    this.setWarningMessage(Messages.error_validatorNameExists);
                }
            }
        }
        return this.getErrorMessage() == null;
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this.setPanel(this.getToolkit().createComposite(parent, 0));
        GridLayout gl = new GridLayout(2, false);
        this.getPanel().setLayout((Layout)gl);
        if (this.getRootGridData() != null) {
            this.getPanel().setLayoutData((Object)this.getRootGridData());
        }
        this._nameText = this.createLabelAndCombo(this._panel, Messages.label_name);
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    protected void setPanel(Composite parent) {
        this._panel = parent;
    }

    public void setValidator(ValidateType transform) {
        this.setInUpdate(true);
        this._validator = transform;
        try {
            String[] types = this._typesUtil.getTypesAsStringsForConfig();
            this.updateList(this._nameText, types);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        if (transform != null) {
            this.setTextValue(this._nameText, transform.getName());
        }
        this.setInUpdate(false);
    }

    public ValidateType getValidator() {
        return this._validator;
    }

    @Override
    protected void handleModify(Control control) {
        if (control.equals(this._nameText) && control.getParent().isVisible()) {
            this.updateFeature((EObject)this._validator, "name", this._nameText.getText().trim());
        }
        this.validate();
    }

    @Override
    protected void handleUndo(Control control) {
        this.setInUpdate(true);
        if (this._validator != null && control.equals(this._nameText)) {
            this._nameText.setText(this._validator.getName());
        }
        this.setInUpdate(false);
    }

    protected void wrapOperation(List<ModelOperation> ops) {
        this.wrapOperation((EObject)this._validator, ops);
    }

    @Override
    protected void updateFeature(EObject eObject, String featureId, Object value) {
        ArrayList<ModelOperation> ops = new ArrayList<ModelOperation>();
        ops.add(new AbstractSwitchyardComposite.BasicEObjectOperation(this, eObject, featureId, value));
        this.wrapOperation(ops);
    }

    private void updateList(Combo list, String[] types) {
        if (list != null) {
            list.removeAll();
            int i = 0;
            while (i < types.length) {
                list.add(types[i]);
                ++i;
            }
        }
        this.addObservableListeners(true);
    }

    protected void setWarningMessage(String warningMessage) {
        this._warningMessage = warningMessage;
    }

    protected String getWarningMessage() {
        return this._warningMessage;
    }

    public void setWizardPage(WizardPage page) {
        this._wizPage = page;
    }
}

