/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.corext.refactoring.changes.CopyResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyParticipant;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.switchyard.tools.ui.editor.refactoring.CreateFolderChange;
import org.switchyard.tools.ui.editor.refactoring.UpdateReferencedModelURIChange;

public class SwitchYardCopyParticipant
extends CopyParticipant {
    private IFile _diagramFile;
    private IFile _modelFile;
    private IFolder _destination;

    protected boolean initialize(Object element) {
        if (!(element instanceof IFile)) {
            return false;
        }
        IFile modelFile = (IFile)element;
        IPath diagramPath = modelFile.getProject().getFullPath().append(".xml").append(modelFile.getProjectRelativePath()).addFileExtension("diagram");
        this._diagramFile = modelFile.getWorkspace().getRoot().getFile(diagramPath);
        IContainer destinationFolder = (IContainer)this.getArguments().getDestination();
        IPath destinationPath = destinationFolder.getProject().getFullPath().append(".xml").append(destinationFolder.getProjectRelativePath());
        this._destination = modelFile.getWorkspace().getRoot().getFolder(destinationPath);
        return this._diagramFile.exists();
    }

    public String getName() {
        return "SwitchYard Diagram File Copy";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getName());
        if (!this._destination.exists()) {
            change.add((Change)new CreateFolderChange(this._destination));
        }
        final INewNameQuery nameQuery = new INewNameQuery(){

            public String getNewName() throws OperationCanceledException {
                ReorgExecutionLog log = SwitchYardCopyParticipant.this.getArguments().getExecutionLog();
                if (log.isRenamed((Object)SwitchYardCopyParticipant.this._modelFile)) {
                    return String.valueOf(log.getNewName((Object)SwitchYardCopyParticipant.this._modelFile)) + ".diagram";
                }
                return null;
            }
        };
        change.add((Change)new CopyResourceChange((IResource)this._diagramFile, (IContainer)this._destination, nameQuery));
        change.add((Change)new UpdateReferencedModelURIChange(this._diagramFile){

            @Override
            protected IFile getDestination() {
                String newName = nameQuery.getNewName();
                if (newName == null) {
                    return SwitchYardCopyParticipant.this._destination.getFile(SwitchYardCopyParticipant.this._diagramFile.getName());
                }
                return SwitchYardCopyParticipant.this._destination.getFile(newName);
            }
        });
        return change;
    }
}

