/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.property.contract;

import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.switchyard.tools.ui.PlatformResourceAdapterFactory;
import org.switchyard.tools.ui.common.ContractControl;
import org.switchyard.tools.ui.common.InterfaceControl;
import org.switchyard.tools.ui.editor.ComponentTypeExtensionManager;
import org.switchyard.tools.ui.editor.property.AbstractModelComposite;
import org.switchyard.tools.ui.editor.property.ICompositeContainer;

public class ContractControlComposite
extends AbstractModelComposite<Contract> {
    private ContractControl _serviceControl = new ContractControl(ScaPackage.eINSTANCE.getService(), null, EnumSet.of(InterfaceControl.InterfaceType.Java, InterfaceControl.InterfaceType.WSDL, InterfaceControl.InterfaceType.ESB));
    private boolean _inUpdate = false;

    public ContractControlComposite(ICompositeContainer container, Composite parent, int style) {
        super(Contract.class, container, parent, style);
        int numColumns = 3;
        this.setLayout((Layout)new GridLayout(numColumns, false));
        this._serviceControl.createControl((Composite)this, numColumns);
        this._serviceControl.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!ContractControlComposite.this._inUpdate) {
                    ContractControlComposite.this.getContainer().validated(ContractControlComposite.this._serviceControl.getStatus());
                }
            }
        });
        this.adaptChildren((Control)this);
    }

    @Override
    public void refresh() {
        this._inUpdate = true;
        Contract contract = (Contract)this.getTargetObject();
        if (contract != null) {
            this._serviceControl.setProject(JavaCore.create((IProject)PlatformResourceAdapterFactory.getContainingProject((Object)contract)));
            this._serviceControl.setSelection((ISelection)new StructuredSelection((Object)contract));
            if (contract.eContainer() instanceof Component) {
                this._serviceControl.setSupportedInterfaceTypes(ComponentTypeExtensionManager.getSupportedInterfaceTypes((Component)contract.eContainer()));
            } else {
                this._serviceControl.setSupportedInterfaceTypes(EnumSet.allOf(InterfaceControl.InterfaceType.class));
            }
        }
        this._inUpdate = false;
    }
}

