/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.shared;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.SwitchYardModelUtils;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class PropertiesFileLoadDialog
extends TitleAreaDialog {
    private String _propertiesFileValue = null;
    private Button _classpathOption;
    private Text _classpathText;
    private Button _classpathBrowseBtn;
    private Button _urlOption;
    private Text _urlText;

    public PropertiesFileLoadDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Domain Properties File Details");
        this.setMessage("Specify the location of the domain properties file as a file in the project classpath or publicly available URL.");
        this.getShell().setText("Domain Properties File");
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        Group optionGroup = new Group(area, 0);
        optionGroup.setLayout((Layout)new GridLayout(2, false));
        optionGroup.setText("Location Options");
        optionGroup.setLayoutData((Object)new GridData(4, 1, true, true, 2, 3));
        this._classpathOption = new Button((Composite)optionGroup, 16);
        this._classpathOption.setText("Project Classpath");
        this._classpathOption.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._classpathOption.setSelection(true);
        this._classpathText = new Text((Composite)optionGroup, 2048);
        this._classpathText.setLayoutData((Object)new GridData(4, 1, true, false));
        this._classpathText.addModifyListener((ModifyListener)new TextModifyListener());
        this._classpathBrowseBtn = new Button((Composite)optionGroup, 8);
        this._classpathBrowseBtn.setText("...");
        this._classpathBrowseBtn.setLayoutData((Object)new GridData(4, 1, false, false));
        this._classpathBrowseBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String result;
                IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
                IJavaProject javaProject = null;
                if (modelFile != null && modelFile.getProject() != null) {
                    javaProject = JavaCore.create((IProject)modelFile.getProject());
                }
                if ((result = PropertiesFileLoadDialog.this.browseForClasspathResource(PropertiesFileLoadDialog.this._classpathBrowseBtn.getShell(), javaProject, "*.*")) != null) {
                    PropertiesFileLoadDialog.this._classpathText.setText(result);
                    PropertiesFileLoadDialog.this._classpathText.notifyListeners(24, null);
                    PropertiesFileLoadDialog.this._classpathText.setFocus();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._urlOption = new Button((Composite)optionGroup, 16);
        this._urlOption.setText("Public URL");
        this._urlOption.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._urlText = new Text((Composite)optionGroup, 2048);
        this._urlText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._urlText.addModifyListener((ModifyListener)new TextModifyListener());
        this._classpathOption.addSelectionListener((SelectionListener)new RadioSelectionListener());
        this._urlOption.addSelectionListener((SelectionListener)new RadioSelectionListener());
        this.setupBasedOnInitialValue();
        return area;
    }

    private void setupBasedOnInitialValue() {
        if (this._propertiesFileValue != null) {
            if (this._propertiesFileValue.contains("://")) {
                this.updateRadioButtonSelection(this._urlOption);
                this._urlText.setText(this._propertiesFileValue);
            } else {
                this.updateRadioButtonSelection(this._classpathOption);
                this._classpathText.setText(this._propertiesFileValue);
            }
        } else {
            this.updateRadioButtonSelection(this._classpathOption);
        }
        this.validate();
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.validate());
        }
    }

    private void updateRadioButtonSelection(Button radio) {
        if (radio != null && radio.equals(this._classpathOption)) {
            this._classpathText.setEnabled(true);
            this._classpathBrowseBtn.setEnabled(true);
            this._classpathOption.setSelection(true);
            this._urlOption.setSelection(false);
            this._urlText.setEnabled(false);
        } else {
            this._classpathText.setEnabled(false);
            this._classpathBrowseBtn.setEnabled(false);
            this._classpathOption.setSelection(false);
            this._urlOption.setSelection(true);
            this._urlText.setEnabled(true);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control rtnControl = super.createButtonBar(parent);
        this.getButton(0).setEnabled(this.validate());
        this.setErrorMessage(null);
        return rtnControl;
    }

    protected Text createLabelAndText(Composite parent, String label) {
        new Label(parent, 0).setText(label);
        Text newText = new Text(parent, 2048);
        newText.setLayoutData((Object)new GridData(4, 0, true, false));
        newText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                PropertiesFileLoadDialog.this.getButton(0).setEnabled(PropertiesFileLoadDialog.this.validate());
            }
        });
        newText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                PropertiesFileLoadDialog.this.getButton(0).setEnabled(PropertiesFileLoadDialog.this.validate());
            }
        });
        return newText;
    }

    private String browseForClasspathResource(Shell shell, IJavaProject project, String initialPattern) {
        Object[] result;
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1){

            protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
                return new FilteredResourcesSelectionDialog.ResourceFilter(this){

                    public boolean matchItem(Object item) {
                        IResource resource = (IResource)item;
                        return super.matchItem(item) && ("properties".equals(resource.getFileExtension()) || "xml".equals(resource.getFileExtension()));
                    }
                };
            }
        };
        dialog.setInitialPattern(initialPattern);
        if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IFile) {
            IFile file = (IFile)result[0];
            String filePath = JavaUtil.getJavaPathForResource((IResource)file).toString();
            return filePath.toString();
        }
        return null;
    }

    protected boolean validate() {
        this.setErrorMessage(null);
        IStatus validStatus = PropertiesFileLoadDialog.validatePropertiesLoadValue(this._propertiesFileValue);
        if (validStatus != Status.OK_STATUS) {
            this.setErrorMessage(validStatus.getMessage());
        }
        return this.getErrorMessage() == null;
    }

    public String getPropertiesFileValue() {
        return this._propertiesFileValue;
    }

    public void setPropertiesFileValue(String value) {
        this._propertiesFileValue = value;
    }

    public static IStatus validatePropertiesLoadValue(String value) {
        if (value != null) {
            String loadPath = value;
            boolean foundInClassloader = false;
            try {
                IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
                IResource propertiesFile = SwitchYardModelUtils.getJavaResource((IProject)modelFile.getProject(), (String)loadPath);
                if (propertiesFile != null) {
                    foundInClassloader = true;
                }
            }
            catch (Exception exception) {
                foundInClassloader = false;
            }
            boolean urlIsValid = false;
            boolean isUrl = false;
            if (loadPath.startsWith("http:") || loadPath.startsWith("file:")) {
                isUrl = true;
            }
            if (isUrl) {
                URL resourceURL = null;
                try {
                    resourceURL = new URL(loadPath);
                }
                catch (MalformedURLException malformedURLException) {
                    urlIsValid = false;
                }
                if (resourceURL != null) {
                    try {
                        resourceURL.toURI();
                        urlIsValid = true;
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        urlIsValid = false;
                    }
                }
            }
            if (!urlIsValid && isUrl) {
                return new Status(2, "org.switchyard.tools.ui.editor", "The properties file URL must be well-formed and public http or file URL.");
            }
            if (urlIsValid && isUrl) {
                return Status.OK_STATUS;
            }
            if (!foundInClassloader) {
                return new Status(4, "org.switchyard.tools.ui.editor", "The properties file must be specified as a file in the project classpath or publicly available http or file URL.");
            }
        }
        return Status.OK_STATUS;
    }

    private class RadioSelectionListener
    implements SelectionListener {
        private RadioSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            PropertiesFileLoadDialog.this.updateRadioButtonSelection((Button)e.widget);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            Text control = (Text)e.widget;
            PropertiesFileLoadDialog.this._propertiesFileValue = control.getText();
            PropertiesFileLoadDialog.this.validate();
            if (PropertiesFileLoadDialog.this.getButton(0) != null) {
                PropertiesFileLoadDialog.this.getButton(0).setEnabled(PropertiesFileLoadDialog.this.validate());
            }
        }
    }
}

