/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.diagram.component;

import java.util.List;
import org.eclipse.soa.sca.sca1_1.model.sca.Component;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Composite;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaFactory;
import org.eclipse.swt.widgets.Shell;
import org.switchyard.tools.ui.editor.diagram.component.BaseComponentFactory;
import org.switchyard.tools.ui.editor.diagram.component.IComponentWizard;
import org.switchyard.tools.ui.editor.diagram.implementation.IImplementationTypeFactory;

public class ComponentWithImplementationFactory
extends BaseComponentFactory {
    private IImplementationTypeFactory _delegate;

    public ComponentWithImplementationFactory(IImplementationTypeFactory delegate) {
        this._delegate = delegate;
    }

    @Override
    public Component createType(Shell shell, Composite container) {
        List<ComponentReference> references;
        Implementation implementation = (Implementation)this._delegate.createType(shell, null);
        if (implementation == null) {
            return null;
        }
        Component component = ScaFactory.eINSTANCE.createComponent();
        component.setName(this.getComponentName(implementation, container));
        component.setImplementation(implementation);
        ComponentService service = this._delegate.getImplementedService();
        if (service != null) {
            component.getService().add((Object)service);
        }
        if ((references = this._delegate.getImplementationReferences()) != null) {
            for (ComponentReference reference : references) {
                component.getReference().add((Object)reference);
            }
        }
        return component;
    }

    @Override
    protected IComponentWizard createTypeWizard() {
        return null;
    }
}

