/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.soap;

import java.math.BigInteger;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.wsdl.Port;
import org.switchyard.tools.models.switchyard1_0.camel.file.CamelFileBindingType;
import org.switchyard.tools.models.switchyard1_0.soap.ContextMapperType;
import org.switchyard.tools.models.switchyard1_0.soap.MessageComposerType;
import org.switchyard.tools.models.switchyard1_0.soap.MtomType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPBindingType;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPFactory;
import org.switchyard.tools.models.switchyard1_0.soap.SOAPPackage;
import org.switchyard.tools.models.switchyard1_0.soap.SoapHeadersType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.EscapedPropertyIntegerValidator;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.shared.WSDLPortSelectionDialog;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;
import org.switchyard.tools.ui.editor.util.OpenFileUtil;
import org.switchyard.tools.ui.wizards.NewWSDLFileWizard;

public class SOAPBindingReferenceComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private Text _nameText;
    private Text _mWSDLURIText;
    private SOAPBindingType _binding = null;
    private ComboViewer _soapHeadersTypeCombo = null;
    private Button _unwrappedPayloadCheckbox = null;
    private Text _portNameText = null;
    private Button _browseBtnWorkspace;
    private Link _newWSDLLink;
    private Text _endpointAddressText;
    private Button _enableMtomCheckbox = null;
    private Button _enableXopExpandCheckbox = null;
    private Button _disableMtomCheckbox = null;
    private Text _requestTimeoutText = null;
    private Text _mtomThresholdText = null;
    private WritableValue _bindingValue;

    public SOAPBindingReferenceComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_soapBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_soapBindingDetails;
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = new Composite(parent, style);
        this._panel.setLayout((Layout)new FillLayout());
        this.getSOAPTabControl(this._panel);
        this.bindControls(context);
    }

    private Control getSOAPTabControl(Composite tabFolder) {
        Composite composite = new Composite(tabFolder, 0);
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        this._nameText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this._newWSDLLink = new Link(composite, 0);
        String message = Messages.link_wsdlUri;
        this._newWSDLLink.setText(message);
        this._newWSDLLink.setEnabled(this.canEdit());
        this._newWSDLLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String oldResult = SOAPBindingReferenceComposite.this._mWSDLURIText.getText().trim();
                IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
                IPath wsdlPath = modelFile.getParent().getParent().getProjectRelativePath();
                wsdlPath = wsdlPath.append(oldResult);
                IProject project = SwitchyardSCAEditor.getActiveEditor().getModelFile().getProject();
                if (project.exists(wsdlPath)) {
                    IResource wsdlFile = project.findMember(wsdlPath);
                    OpenFileUtil.openFile(wsdlFile);
                } else {
                    String result = SOAPBindingReferenceComposite.getPathToNewWSDL(SOAPBindingReferenceComposite.this._panel.getShell(), wsdlPath, SOAPBindingReferenceComposite.this.openOnCreate());
                    if (result != null) {
                        SOAPBindingReferenceComposite.this.setTextValueAndNotify(SOAPBindingReferenceComposite.this._mWSDLURIText, result, false);
                    }
                }
            }
        });
        this._mWSDLURIText = this.createLabelAndText(composite, null);
        this._mWSDLURIText.setEnabled(this.canEdit());
        GridData uriGD = new GridData(768);
        this._mWSDLURIText.setLayoutData((Object)uriGD);
        this._browseBtnWorkspace = new Button(composite, 8);
        this._browseBtnWorkspace.setText(Messages.button_browse);
        this._browseBtnWorkspace.setEnabled(this.canEdit());
        GridData btnGD = new GridData();
        this._browseBtnWorkspace.setLayoutData((Object)btnGD);
        this._browseBtnWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result = SOAPBindingReferenceComposite.this.selectResourceFromWorkspace(SOAPBindingReferenceComposite.this._panel.getShell(), "*.wsdl");
                if (result != null) {
                    SOAPBindingReferenceComposite.this.setTextValueAndNotify(SOAPBindingReferenceComposite.this._mWSDLURIText, result, false);
                }
            }
        });
        this._portNameText = this.createLabelAndText(composite, Messages.label_wsdlPort);
        this._portNameText.setEnabled(this.canEdit());
        GridData pnGD = new GridData(768);
        pnGD.horizontalSpan = 2;
        this._portNameText.setLayoutData((Object)pnGD);
        this._unwrappedPayloadCheckbox = this.createCheckbox(composite, Messages.label_unwrappedPayload);
        GridData upChxGD = new GridData(768);
        upChxGD.horizontalSpan = 3;
        this._unwrappedPayloadCheckbox.setLayoutData((Object)upChxGD);
        this._soapHeadersTypeCombo = this.createLabelAndComboViewer(composite, Messages.label_soapHeadersType, true);
        GridData cmcGD = new GridData(768);
        cmcGD.horizontalSpan = 2;
        this._soapHeadersTypeCombo.getCombo().setLayoutData((Object)cmcGD);
        this._soapHeadersTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._soapHeadersTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this._soapHeadersTypeCombo.setInput((Object)SoapHeadersType.values());
        this._endpointAddressText = this.createLabelAndText(composite, Messages.label_endpointAddress);
        this._endpointAddressText.setEnabled(this.canEdit());
        GridData epAddrGD = new GridData(768);
        epAddrGD.horizontalSpan = 2;
        this._endpointAddressText.setLayoutData((Object)epAddrGD);
        this._requestTimeoutText = this.createLabelAndText(composite, Messages.label_requestTimeout);
        this._requestTimeoutText.setEnabled(this.canEdit());
        GridData rtAddrGD = new GridData(768);
        rtAddrGD.horizontalSpan = 2;
        this._requestTimeoutText.setLayoutData((Object)rtAddrGD);
        Group mtomGroup = new Group(composite, 0);
        mtomGroup.setText(Messages.label_mtom);
        mtomGroup.setLayout((Layout)new GridLayout(4, false));
        GridData epConfigGroupGD = new GridData(768);
        epConfigGroupGD.horizontalSpan = 3;
        epConfigGroupGD.horizontalIndent = -5;
        mtomGroup.setLayoutData((Object)epConfigGroupGD);
        this._enableMtomCheckbox = this.createCheckbox((Composite)mtomGroup, Messages.label_enable);
        GridData enableMtomChxGD = new GridData();
        enableMtomChxGD.horizontalSpan = 4;
        this._enableMtomCheckbox.setLayoutData((Object)enableMtomChxGD);
        this._disableMtomCheckbox = this.createCheckbox((Composite)mtomGroup, Messages.label_temporarilyDisable);
        GridData disableMtomChxGD = new GridData();
        disableMtomChxGD.horizontalIndent = 10;
        this._disableMtomCheckbox.setLayoutData((Object)disableMtomChxGD);
        this._enableXopExpandCheckbox = this.createCheckbox((Composite)mtomGroup, Messages.label_xopExpand);
        GridData enableXopExpandChxGD = new GridData();
        this._enableXopExpandCheckbox.setLayoutData((Object)enableXopExpandChxGD);
        this._mtomThresholdText = this.createLabelAndText((Composite)mtomGroup, Messages.label_threshold);
        GridData mtomThresholdGD = new GridData(768);
        this._mtomThresholdText.setLayoutData((Object)mtomThresholdGD);
        return composite;
    }

    @Override
    protected void handleModify(Control control) {
        this.setHasChanged(false);
        this.setDidSomething(true);
    }

    @Override
    protected void handleUndo(Control control) {
        if (this._binding != null) {
            super.handleUndo(control);
        }
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    @Override
    public void setBinding(Binding switchYardBindingType) {
        super.setBinding(switchYardBindingType);
        if (switchYardBindingType instanceof SOAPBindingType) {
            this.setTargetObject(switchYardBindingType.eContainer());
            this._binding = (SOAPBindingType)switchYardBindingType;
            this._bindingValue.setValue((Object)this._binding);
        } else {
            this._bindingValue.setValue(null);
        }
    }

    public Port browse(Shell shell, IJavaProject project, String initialPattern) {
        Port result;
        WSDLPortSelectionDialog dialog = new WSDLPortSelectionDialog(shell, (IContainer)(project == null ? ResourcesPlugin.getWorkspace().getRoot() : project.getProject()));
        dialog.setInitialPattern(initialPattern);
        if (dialog.open() == 0 && (result = dialog.getSelectedPort()) != null) {
            return result;
        }
        return null;
    }

    private String selectResourceFromWorkspace(Shell shell, String extension) {
        Port port;
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        IJavaProject javaProject = null;
        if (modelFile != null && modelFile.getProject() != null) {
            javaProject = JavaCore.create((IProject)modelFile.getProject());
        }
        if ((port = this.browse(shell, javaProject, extension)) != null) {
            this._portNameText.setText(port.getName());
            Path filePath = new Path(port.eResource().getURI().toPlatformString(true));
            IFile resource = javaProject.getProject().getWorkspace().getRoot().getFile((IPath)filePath);
            filePath = JavaUtil.getJavaPathForResource((IResource)resource);
            return filePath.toString();
        }
        return null;
    }

    private static String getPathToNewWSDL(Shell shell, IPath path, boolean _openWhenFinish) {
        NewWSDLFileWizard newWizard = new NewWSDLFileWizard();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        IFile modelFile = SwitchyardSCAEditor.getActiveEditor().getModelFile();
        if (modelFile != null && modelFile.getProject() != null) {
            IJavaProject javaProject = JavaCore.create((IProject)modelFile.getProject());
            IPackageFragmentRoot folder = javaProject.getPackageFragmentRoot((IResource)modelFile);
            selectionToPass = new StructuredSelection((Object)folder);
        }
        if (path != null) {
            newWizard.setStartingFileName(path.lastSegment());
        }
        newWizard.setOpenOnFinish(_openWhenFinish);
        newWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selectionToPass);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)newWizard);
        if (dialog.open() == 0) {
            return newWizard.getCreatedFilePath();
        }
        return null;
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, CamelFileBindingType.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("SOAP binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("SOAP binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._mWSDLURIText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__WSDL), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator(Messages.error_noUri)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._portNameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__WSDL_PORT), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._requestTimeoutText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__TIMEOUT), new EMFUpdateValueStrategyNullForEmptyString("", UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new EscapedPropertyIntegerValidator("Request Timeout must be a valid numeric value or follow the pattern for escaped properties (i.e. '${propName}').")), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._endpointAddressText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__ENDPOINT_ADDRESS), (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        WritableValue msgComposerUnwrappedValue = new WritableValue(realm, null, Boolean.class);
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._unwrappedPayloadCheckbox), (IObservableValue)msgComposerUnwrappedValue, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        ComputedValue computedMessageComposer = new ComputedValue((IObservableValue)msgComposerUnwrappedValue){
            private final /* synthetic */ IObservableValue val$msgComposerUnwrappedValue;
            {
                this.val$msgComposerUnwrappedValue = iObservableValue;
            }

            protected Object calculate() {
                Boolean unwrapped = (Boolean)this.val$msgComposerUnwrappedValue.getValue();
                if (unwrapped != null) {
                    MessageComposerType msgComposer = SOAPFactory.eINSTANCE.createMessageComposerType();
                    msgComposer.setUnwrapped(unwrapped.booleanValue());
                    return msgComposer;
                }
                return null;
            }

            protected void doSetValue(Object value) {
                if (value instanceof MessageComposerType) {
                    MessageComposerType msgComposer = (MessageComposerType)value;
                    this.val$msgComposerUnwrappedValue.setValue((Object)new Boolean(msgComposer.isUnwrapped()));
                } else {
                    this.val$msgComposerUnwrappedValue.setValue(null);
                }
                this.getValue();
            }
        };
        binding = context.bindValue((IObservableValue)computedMessageComposer, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__MESSAGE_COMPOSER));
        WritableValue contextMapperSOAPHeaders = new WritableValue(realm, null, SoapHeadersType.class);
        binding = context.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this._soapHeadersTypeCombo), (IObservableValue)contextMapperSOAPHeaders, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        ComputedValue computedContextMapper = new ComputedValue((IObservableValue)contextMapperSOAPHeaders){
            private final /* synthetic */ IObservableValue val$contextMapperSOAPHeaders;
            {
                this.val$contextMapperSOAPHeaders = iObservableValue;
            }

            protected Object calculate() {
                SoapHeadersType soapHeaders = (SoapHeadersType)this.val$contextMapperSOAPHeaders.getValue();
                if (soapHeaders != null) {
                    ContextMapperType ctxMapper = SOAPFactory.eINSTANCE.createContextMapperType();
                    ctxMapper.setSoapHeadersType(soapHeaders);
                    return ctxMapper;
                }
                return null;
            }

            protected void doSetValue(Object value) {
                if (value instanceof ContextMapperType) {
                    ContextMapperType ctxMapper = (ContextMapperType)value;
                    this.val$contextMapperSOAPHeaders.setValue((Object)ctxMapper.getSoapHeadersType());
                } else {
                    this.val$contextMapperSOAPHeaders.setValue(null);
                }
                this.getValue();
            }
        };
        binding = context.bindValue((IObservableValue)computedContextMapper, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__CONTEXT_MAPPER));
        this.bindMtomControls(context, domain, realm);
    }

    private void bindMtomControls(DataBindingContext context, EditingDomain domain, Realm realm) {
        WritableValue mtomEnabled = new WritableValue(realm, null, Boolean.class);
        WritableValue mtomDisabled = new WritableValue(realm, null, Boolean.class);
        WritableValue mtomXopExpand = new WritableValue(realm, null, Boolean.class);
        WritableValue mtomThreshold = new WritableValue(realm, null, BigInteger.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._enableMtomCheckbox), (IObservableValue)mtomEnabled, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._disableMtomCheckbox), (IObservableValue)mtomDisabled, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this._enableXopExpandCheckbox), (IObservableValue)mtomXopExpand, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        ISWTObservableValue delayed1 = this.createDelayedObservableText(this._mtomThresholdText);
        binding = context.bindValue((IObservableValue)delayed1, (IObservableValue)mtomThreshold, (UpdateValueStrategy)new EMFUpdateValueStrategyNullForEmptyString("MTom Threshold must be a valid numeric value.", UpdateValueStrategy.POLICY_CONVERT), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        ComputedValue computedMtom = new ComputedValue((IObservableValue)mtomEnabled, (IObservableValue)mtomDisabled, (IObservableValue)mtomXopExpand, (IObservableValue)mtomThreshold){
            private final /* synthetic */ IObservableValue val$mtomEnabled;
            private final /* synthetic */ IObservableValue val$mtomDisabled;
            private final /* synthetic */ IObservableValue val$mtomXopExpand;
            private final /* synthetic */ IObservableValue val$mtomThreshold;
            {
                this.val$mtomEnabled = iObservableValue;
                this.val$mtomDisabled = iObservableValue2;
                this.val$mtomXopExpand = iObservableValue3;
                this.val$mtomThreshold = iObservableValue4;
            }

            protected Object calculate() {
                Boolean enabled = (Boolean)this.val$mtomEnabled.getValue();
                Boolean disabled = (Boolean)this.val$mtomDisabled.getValue();
                Boolean xopExpand = (Boolean)this.val$mtomXopExpand.getValue();
                BigInteger threshold = (BigInteger)this.val$mtomThreshold.getValue();
                if (enabled != null && enabled.booleanValue()) {
                    MtomType mtom = SOAPFactory.eINSTANCE.createMtomType();
                    mtom.setEnabled((Object)disabled);
                    mtom.setXopExpand((Object)xopExpand);
                    mtom.setThreshold((Object)threshold);
                    return mtom;
                }
                return null;
            }

            protected void doSetValue(Object value) {
                if (value instanceof MtomType) {
                    MtomType mtom = (MtomType)value;
                    this.val$mtomEnabled.setValue((Object)new Boolean(true));
                    this.val$mtomDisabled.setValue(mtom.getEnabled());
                    this.val$mtomXopExpand.setValue(mtom.getXopExpand());
                    this.val$mtomThreshold.setValue(mtom.getThreshold());
                } else {
                    this.val$mtomEnabled.setValue((Object)new Boolean(false));
                    this.val$mtomDisabled.setValue(null);
                    this.val$mtomXopExpand.setValue(null);
                    this.val$mtomThreshold.setValue(null);
                }
                this.getValue();
            }
        };
        mtomEnabled.addChangeListener(new IChangeListener((IObservableValue)mtomEnabled){
            private final /* synthetic */ IObservableValue val$mtomEnabled;
            {
                this.val$mtomEnabled = iObservableValue;
            }

            public void handleChange(ChangeEvent event) {
                Boolean value = (Boolean)this.val$mtomEnabled.getValue();
                SOAPBindingReferenceComposite.this._disableMtomCheckbox.setEnabled(value.booleanValue());
                SOAPBindingReferenceComposite.this._enableXopExpandCheckbox.setEnabled(value.booleanValue());
                SOAPBindingReferenceComposite.this._mtomThresholdText.setEnabled(value.booleanValue());
            }
        });
        binding = context.bindValue((IObservableValue)computedMtom, ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)SOAPPackage.Literals.SOAP_BINDING_TYPE__MTOM));
    }

    @Override
    public void dispose() {
        this._bindingValue.dispose();
        super.dispose();
    }
}

