/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.rules;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentReference;
import org.eclipse.soa.sca.sca1_1.model.sca.ComponentService;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.soa.sca.sca1_1.model.sca.Implementation;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.switchyard.tools.models.switchyard1_0.rules.ManifestType;
import org.switchyard.tools.models.switchyard1_0.rules.ResourceType;
import org.switchyard.tools.models.switchyard1_0.rules.ResourcesType;
import org.switchyard.tools.models.switchyard1_0.rules.RulesFactory;
import org.switchyard.tools.models.switchyard1_0.rules.RulesImplementationType;
import org.switchyard.tools.ui.JavaUtil;
import org.switchyard.tools.ui.common.ContractControl;
import org.switchyard.tools.ui.editor.Activator;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.BaseNewServiceFileWizard;

public class NewRulesComponentWizard
extends BaseNewServiceFileWizard
implements INewWizard {
    private static final String TEMPLATE = "RulesTemplate.ftl";
    private static final String PACKAGE_NAME_PARAM = "packageName";
    private static final String COMPONENT_NAME_PARAM = "componentName";
    private static final String SERVICE_NAME_PARAM = "serviceName";
    private RulesImplementationType _implementation;
    private WizardNewFileCreationPage _page;
    private IJavaProject _project;

    public static ResourceType createRulesResource(String location) {
        ResourceType rulesResource = RulesFactory.eINSTANCE.createResourceType();
        rulesResource.setLocation(location);
        rulesResource.setType("DRL");
        return rulesResource;
    }

    public NewRulesComponentWizard(boolean openAfterCreate) {
        super(openAfterCreate, "drl");
    }

    @Override
    public void addPages() {
        this._page = new RulesServiceImplementationFileCreationPage("newFilePage1", this.getSelection());
        this._page.setTitle(Messages.title_newSwitchYardRulesFile);
        this._page.setDescription(Messages.description_newSwitchYardRulesFile);
        if (this.getService() == null) {
            this._page.setFileName("RulesComponent.drl");
        } else {
            this._page.setFileName(this.getService().getName() + "Rules.drl");
        }
        if (this.getCreatedFilePath() != null) {
            this._page.setFileName(this.getCreatedFilePath());
        }
        if (this.getFileExtension() != null) {
            this._page.setFileExtension(this.getFileExtension());
        }
        this.setFileCreationPage(this._page);
        this.addPage((IWizardPage)this._page);
    }

    @Override
    protected WizardNewFileCreationPage getFileCreationPage() {
        return this._page;
    }

    @Override
    public boolean performFinish() {
        this._implementation = RulesFactory.eINSTANCE.createRulesImplementationType();
        this._implementation.setLoggers(null);
        if (!super.performFinish()) {
            return false;
        }
        ManifestType manifest = RulesFactory.eINSTANCE.createManifestType();
        ResourcesType resources = RulesFactory.eINSTANCE.createResourcesType();
        ResourceType resource = NewRulesComponentWizard.createRulesResource(this.getCreatedFilePath());
        manifest.setResources(resources);
        resources.getResource().add((Object)resource);
        this._implementation.setManifest(manifest);
        return true;
    }

    @Override
    protected Implementation createImplementation() {
        return this._implementation;
    }

    @Override
    protected List<ComponentReference> createReferences() {
        return Collections.emptyList();
    }

    public boolean canFinish() {
        ((RulesServiceImplementationFileCreationPage)this._page).update(this.getJavaProject());
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        return nextPage;
    }

    @Override
    protected InputStream getInitialContents() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Configuration config = new Configuration();
            config.setClassForTemplateLoading(this.getClass(), "");
            config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            Template template = config.getTemplate(TEMPLATE);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(PACKAGE_NAME_PARAM, ((RulesServiceImplementationFileCreationPage)this._page).getPackageName());
            parameters.put(COMPONENT_NAME_PARAM, this.getComponentName((IPath)new Path(this.getFileCreationPage().getFileName())));
            parameters.put(SERVICE_NAME_PARAM, this.getService().getName());
            template.process(parameters, (Writer)new PrintWriter(baos));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui.editor", Messages.error_creatingDrlFile, (Throwable)e));
            return null;
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                e.fillInStackTrace();
            }
        }
    }

    @Override
    protected IJavaProject getJavaProject() {
        if (this._page == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(this._page.getContainerFullPath());
        if (resource == null || resource.getProject() == null) {
            this._project = null;
        } else if (this._project == null || !this._project.getProject().equals((Object)resource.getProject())) {
            this._project = JavaCore.create((IProject)resource.getProject());
        }
        return this._project;
    }

    private class RulesServiceImplementationFileCreationPage
    extends WizardNewFileCreationPage {
        private ContractControl _contractControl;
        private String _packageName;
        private Text _packageNameText;
        private String _oldPackageName;

        public RulesServiceImplementationFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
        }

        protected InputStream getInitialContents() {
            return NewRulesComponentWizard.this.getInitialContents();
        }

        protected void createAdvancedControls(Composite parent) {
            Composite contents = new Composite(parent, 0);
            contents.setLayout((Layout)new GridLayout(3, false));
            contents.setLayoutData((Object)new GridData(768));
            this._contractControl = new ContractControl(ScaPackage.eINSTANCE.getComponentService(), NewRulesComponentWizard.this.getJavaProject(), NewRulesComponentWizard.this.getSupportedInterfaceTypes());
            this._contractControl.createControl(contents, 3);
            this._contractControl.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    RulesServiceImplementationFileCreationPage.this.setPageComplete(RulesServiceImplementationFileCreationPage.this.validatePage());
                }
            });
            if (NewRulesComponentWizard.this.getService() != null) {
                this._contractControl.init((Contract)NewRulesComponentWizard.this.getService(), null);
                this._contractControl.setEnabled(false);
            }
            NewRulesComponentWizard.this.setService((ComponentService)this._contractControl.getContract());
            Label separator = new Label(contents, 258);
            GridData lineGD = new GridData(768);
            lineGD.horizontalSpan = 3;
            separator.setLayoutData((Object)lineGD);
            this.createLabel(contents, Messages.label_packageName);
            this._packageNameText = new Text(contents, 2052);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            this._packageNameText.setLayoutData((Object)gd);
            this._packageNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    RulesServiceImplementationFileCreationPage.this._packageName = RulesServiceImplementationFileCreationPage.this._packageNameText.getText();
                }
            });
        }

        private Label createLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            label.setText(text);
            return label;
        }

        private String emptyForNull(String string) {
            return string == null ? "" : string;
        }

        public void update(IJavaProject project) {
            IJavaElement element;
            String newPackageName = project == null ? "" : ((element = JavaUtil.getInitialPackageForProject((IJavaProject)project)).getElementType() == 4 ? ((IPackageFragment)element).getElementName() : "");
            if (this.updateDefault(this._oldPackageName, newPackageName, this._packageNameText.getText())) {
                this.setPackageName(newPackageName);
            }
            this._oldPackageName = newPackageName;
        }

        private boolean updateDefault(String oldValue, String newValue, String currentValue) {
            return !currentValue.equals(newValue) && (oldValue == null || oldValue.length() == 0 || currentValue.length() == 0 || oldValue.equals(currentValue));
        }

        public String getPackageName() {
            return this.emptyForNull(this._packageName);
        }

        public void setPackageName(String packageName) {
            if (this._packageNameText == null) {
                this._packageName = packageName;
            } else {
                this._packageNameText.setText(packageName);
            }
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                this._contractControl.setProject(NewRulesComponentWizard.this.getJavaProject());
                IStatus status = this._contractControl.getStatus();
                if (status.getSeverity() < 4) {
                    if (!status.isOK()) {
                        this.setMessage(status.getMessage(), status.getSeverity() == 2 ? 2 : 1);
                    }
                    return true;
                }
                this.setErrorMessage(status.getMessage());
                return false;
            }
            return false;
        }

        protected IStatus validateLinkedResource() {
            return Status.OK_STATUS;
        }

        protected void createLinkTarget() {
        }
    }
}

