/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.editor.components.jca;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.soa.sca.sca1_1.model.sca.Binding;
import org.eclipse.soa.sca.sca1_1.model.sca.ScaPackage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.switchyard.tools.models.switchyard1_0.jca.ActivationSpec;
import org.switchyard.tools.models.switchyard1_0.jca.Endpoint;
import org.switchyard.tools.models.switchyard1_0.jca.JCABinding;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundConnection;
import org.switchyard.tools.models.switchyard1_0.jca.JCAInboundInteraction;
import org.switchyard.tools.models.switchyard1_0.jca.JcaFactory;
import org.switchyard.tools.models.switchyard1_0.jca.Property;
import org.switchyard.tools.models.switchyard1_0.jca.ResourceAdapter;
import org.switchyard.tools.ui.editor.Messages;
import org.switchyard.tools.ui.editor.components.jca.AbstractJCABindingComposite;
import org.switchyard.tools.ui.editor.components.jca.IJCAResourceAdapterExtension;
import org.switchyard.tools.ui.editor.components.jca.IJCAResourceAdapterExtensionManager;
import org.switchyard.tools.ui.editor.components.jca.JCAActivationSpecPropertyTable;
import org.switchyard.tools.ui.editor.components.jca.JCAPropertyTable;
import org.switchyard.tools.ui.editor.databinding.EMFUpdateValueStrategyNullForEmptyString;
import org.switchyard.tools.ui.editor.databinding.ObservablesUtil;
import org.switchyard.tools.ui.editor.databinding.SWTValueUpdater;
import org.switchyard.tools.ui.editor.databinding.StringEmptyValidator;
import org.switchyard.tools.ui.editor.diagram.binding.AbstractSYBindingComposite;
import org.switchyard.tools.ui.editor.diagram.binding.OperationSelectorComposite;

public class JCABindingInboundComposite
extends AbstractSYBindingComposite {
    private Composite _panel;
    private JCABinding _binding = null;
    private JCAPropertyTable _propsList;
    private Text _nameText;
    private OperationSelectorComposite _opSelectorComposite;
    private HashMap<IJCAResourceAdapterExtension, AbstractJCABindingComposite> _resAdapterMap;
    private ComboViewer _resourceAdapterTypeCombo;
    private Composite _stackComposite;
    private IJCAResourceAdapterExtension _defaultJCAExtension;
    private IJCAResourceAdapterExtension _activeExtension;
    private WritableValue _bindingValue;
    private StackLayout _stackLayout = null;

    JCABindingInboundComposite(FormToolkit toolkit) {
        super(toolkit);
    }

    @Override
    public String getTitle() {
        return Messages.title_jcaBindingDetails;
    }

    @Override
    public String getDescription() {
        return Messages.description_jcaBindingDetails;
    }

    @Override
    public void setBinding(Binding impl) {
        IJCAResourceAdapterExtension newExtension;
        super.setBinding(impl);
        this._binding = impl instanceof JCABinding ? (JCABinding)impl : null;
        this._bindingValue.setValue((Object)this._binding);
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed() && this.getTargetObject() != null) {
            this._opSelectorComposite.setTargetObject(this.getTargetObject());
        }
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setBinding((Binding)this._binding);
        }
        if (this._activeExtension != (newExtension = this.findJCAExtension(this._binding))) {
            this.processJCAExtensionSelection(newExtension, false);
            this._resourceAdapterTypeCombo.setSelection((ISelection)new StructuredSelection((Object)newExtension), true);
        } else {
            this.processJCAExtensionSelection(this._activeExtension, false);
            this._resAdapterMap.get(this._activeExtension).setBinding((Binding)this._binding);
        }
        this._propsList.setTargetObject((EObject)this._binding);
    }

    @Override
    public void setTargetObject(EObject target) {
        super.setTargetObject(target);
        if (this._opSelectorComposite != null && !this._opSelectorComposite.isDisposed()) {
            this._opSelectorComposite.setTargetObject(target);
        }
    }

    @Override
    public void createContents(Composite parent, int style, DataBindingContext context) {
        this._panel = this.getToolkit().createComposite(parent, style);
        this._panel.setLayout((Layout)new GridLayout(1, false));
        this._resAdapterMap = new HashMap();
        this.getJCATabControl(this._panel, context).setLayoutData((Object)new GridData(4, 1, true, false));
        this.getJCAOperationSelectorTabControl(this._panel).setLayoutData((Object)new GridData(4, 1, true, false));
        this.bindControls(context);
    }

    private void processJCAExtensionSelection(final IJCAResourceAdapterExtension newExtension, final boolean processDefaults) {
        if (this._activeExtension == newExtension) {
            return;
        }
        this._propsList.setTargetObject(null);
        TransactionalEditingDomain domain = this.getDomain((EObject)this._binding);
        if (processDefaults && domain != null) {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, "Change JCA connector type"){

                protected void doExecute() {
                    JCABindingInboundComposite.this.deactivateExtension(JCABindingInboundComposite.this._activeExtension, processDefaults);
                    JCABindingInboundComposite.this.activateExtension(newExtension, processDefaults);
                }
            });
        } else {
            this.deactivateExtension(this._activeExtension, processDefaults);
            this.activateExtension(newExtension, processDefaults);
        }
        this._activeExtension = newExtension;
        AbstractJCABindingComposite syComposite = this._resAdapterMap.get(newExtension);
        this._stackLayout.topControl = syComposite.getPanel();
        this._stackComposite.layout();
        this._panel.layout();
        this._propsList.setTargetObject((EObject)this._binding);
    }

    private void activateExtension(IJCAResourceAdapterExtension extension, boolean processDefaults) {
        if (extension == null) {
            return;
        }
        if (processDefaults) {
            this.applyConnectionSettings(extension.getInboundConnectionSettings());
            this.applyInteractionSettings(extension.getInboundInteractionSettings());
        }
        AbstractJCABindingComposite extensionComposite = this._resAdapterMap.get(extension);
        extensionComposite.setBinding((Binding)this._binding);
    }

    private void applyConnectionSettings(IJCAResourceAdapterExtension.IInboundConnectionSettings settings) {
        ResourceAdapter resourceAdapter;
        if (this._binding == null || settings == null) {
            return;
        }
        JCAInboundConnection connection = this._binding.getInboundConnection();
        if (connection == null) {
            connection = JcaFactory.eINSTANCE.createJCAInboundConnection();
            this._binding.setInboundConnection(connection);
        }
        if ((resourceAdapter = connection.getResourceAdapter()) == null) {
            resourceAdapter = JcaFactory.eINSTANCE.createResourceAdapter();
            connection.setResourceAdapter(resourceAdapter);
        }
        resourceAdapter.setName(settings.getResourceAdapterName());
        this.addDefaultProperties((List<Property>)resourceAdapter.getProperty(), settings.getResourceAdapterProperties());
        ActivationSpec activationSpec = connection.getActivationSpec();
        if (activationSpec == null) {
            activationSpec = JcaFactory.eINSTANCE.createActivationSpec();
            connection.setActivationSpec(activationSpec);
        }
        this.addDefaultProperties((List<Property>)activationSpec.getProperty(), settings.getActivationSpecProperties());
    }

    private void applyInteractionSettings(IJCAResourceAdapterExtension.IInboundInteractionSettings settings) {
        Endpoint endpoint;
        if (this._binding == null || settings == null) {
            return;
        }
        JCAInboundInteraction interaction = this._binding.getInboundInteraction();
        if (interaction == null) {
            interaction = JcaFactory.eINSTANCE.createJCAInboundInteraction();
            this._binding.setInboundInteraction(interaction);
        }
        interaction.setListener(settings.getListenerType());
        if (settings.isTransacted() != null) {
            interaction.setTransacted((Object)settings.isTransacted());
        }
        if ((endpoint = interaction.getEndpoint()) == null) {
            endpoint = JcaFactory.eINSTANCE.createEndpoint();
            interaction.setEndpoint(endpoint);
        }
        endpoint.setType(settings.getEndpointType());
        this.addDefaultProperties((List<Property>)endpoint.getProperty(), settings.getEndpointProperties());
    }

    private void addDefaultProperties(List<Property> properties, Map<String, String> defaults) {
        if (defaults == null) {
            return;
        }
        HashMap<String, Property> propertiesMap = new HashMap<String, Property>();
        for (Property property : properties) {
            if (property.getName() == null) continue;
            propertiesMap.put(property.getName(), property);
        }
        for (Map.Entry entry : defaults.entrySet()) {
            Object oldPropValue;
            String name = (String)entry.getKey();
            if (name == null) continue;
            Object value = entry.getValue();
            if (propertiesMap.containsKey(name) && (oldPropValue = ((Property)propertiesMap.get(name)).getValue()) != null && !oldPropValue.equals(value)) {
                for (Property next : properties) {
                    if (!next.getName().equals(name)) continue;
                    properties.remove(next);
                    break;
                }
            }
            Property property = JcaFactory.eINSTANCE.createProperty();
            property.setName(name);
            property.setValue(entry.getValue());
            properties.add(property);
        }
    }

    private void deactivateExtension(IJCAResourceAdapterExtension extension, boolean processDefaults) {
        if (extension == null) {
            return;
        }
        if (processDefaults) {
            this.unapplyConnectionSettings(extension.getInboundConnectionSettings());
        }
        AbstractJCABindingComposite extensionComposite = this._resAdapterMap.get(extension);
        extensionComposite.setBinding(null);
    }

    private void unapplyConnectionSettings(IJCAResourceAdapterExtension.IInboundConnectionSettings settings) {
        ActivationSpec activationSpec;
        if (this._binding == null || settings == null) {
            return;
        }
        JCAInboundConnection connection = this._binding.getInboundConnection();
        if (connection == null) {
            return;
        }
        ResourceAdapter resourceAdapter = connection.getResourceAdapter();
        if (resourceAdapter != null) {
            this.removeDefaultProperties((List<Property>)resourceAdapter.getProperty(), settings.getResourceAdapterProperties());
        }
        if ((activationSpec = connection.getActivationSpec()) != null) {
            this.removeDefaultProperties((List<Property>)activationSpec.getProperty(), settings.getActivationSpecProperties());
        }
    }

    private void removeDefaultProperties(List<Property> properties, Map<String, String> defaults) {
        if (defaults == null) {
            return;
        }
        for (Property property : properties) {
            String name = property.getName();
            if (name != null) continue;
        }
    }

    private IJCAResourceAdapterExtension findJCAExtension(JCABinding binding) {
        IJCAResourceAdapterExtension foundExtension = null;
        int score = -1;
        for (IJCAResourceAdapterExtension extension : IJCAResourceAdapterExtensionManager.instance().getExtensions()) {
            int newScore = extension.score(binding);
            if (newScore <= score) continue;
            foundExtension = extension;
            score = newScore;
        }
        if (foundExtension == null) {
            foundExtension = this._defaultJCAExtension;
        }
        return foundExtension;
    }

    private Control getJCATabControl(Composite tabFolder, DataBindingContext context) {
        Composite composite = this.getToolkit().createComposite(tabFolder, 0);
        GridLayout gl = new GridLayout(2, false);
        composite.setLayout((Layout)gl);
        this._nameText = this.createLabelAndText(composite, Messages.label_name);
        Collection<IJCAResourceAdapterExtension> extensions = IJCAResourceAdapterExtensionManager.instance().getExtensions();
        this._resourceAdapterTypeCombo = new ComboViewer(this.createLabelAndCombo(composite, Messages.label_resourceAdapterType, true));
        this._resourceAdapterTypeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this._resourceAdapterTypeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IJCAResourceAdapterExtension)element).getDisplayName();
            }
        });
        this._resourceAdapterTypeCombo.setInput(extensions);
        this._resourceAdapterTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JCABindingInboundComposite.this.processJCAExtensionSelection((IJCAResourceAdapterExtension)((IStructuredSelection)event.getSelection()).getFirstElement(), true);
            }
        });
        this._stackComposite = new Composite(composite, 0);
        GridData gd = new GridData(4, 1, true, false, 2, 1);
        this._stackComposite.setLayoutData((Object)gd);
        this._stackLayout = new StackLayout();
        this._stackComposite.setLayout((Layout)this._stackLayout);
        Composite dummy = this.getToolkit().createComposite(this._stackComposite, 0);
        this._stackLayout.topControl = dummy;
        this._defaultJCAExtension = null;
        for (IJCAResourceAdapterExtension extension : extensions) {
            if (extension.isDefault() || this._defaultJCAExtension == null) {
                this._defaultJCAExtension = extension;
            }
            AbstractJCABindingComposite extensionComposite = extension.createComposite(this.getToolkit());
            extensionComposite.setTargetObject(this.getTargetObject());
            extensionComposite.createContents(this._stackComposite, 0, context);
            extensionComposite.setBinding(null);
            this._resAdapterMap.put(extension, extensionComposite);
        }
        Group activationPropsGroup = new Group(composite, 0);
        activationPropsGroup.setText(Messages.label_activationProperties);
        activationPropsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        activationPropsGroup.setLayout((Layout)new GridLayout(1, false));
        this.getToolkit().adapt((Composite)activationPropsGroup);
        this._propsList = new JCAActivationSpecPropertyTable((Composite)activationPropsGroup, 0, this.getToolkit(), context, (EditingDomain)this.getDomain(this.getTargetObject()));
        this._propsList.setLayoutData(new GridData(4, 4, true, true));
        this._propsList.getTableViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (JCABindingInboundComposite.this._activeExtension == null || JCABindingInboundComposite.this._activeExtension.getInboundConnectionSettings() == null || JCABindingInboundComposite.this._activeExtension.getInboundConnectionSettings().getActivationSpecProperties() == null) {
                    return true;
                }
                String name = ((Property)element).getName();
                return name == null || !JCABindingInboundComposite.this._activeExtension.getInboundConnectionSettings().getActivationSpecProperties().containsKey(name);
            }
        });
        return composite;
    }

    private Control getJCAOperationSelectorTabControl(Composite tabFolder) {
        Composite composite = this.getToolkit().createComposite(tabFolder, 0);
        GridLayout gl = new GridLayout(1, false);
        composite.setLayout((Layout)gl);
        this._opSelectorComposite = new OperationSelectorComposite(composite, 0, this);
        this._opSelectorComposite.setLayoutData(new GridData(4, 1, true, false));
        this._opSelectorComposite.setLayout((Layout)new GridLayout(2, false));
        this._opSelectorComposite.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JCABindingInboundComposite.this.handleModify((Control)JCABindingInboundComposite.this._opSelectorComposite);
            }
        });
        return composite;
    }

    @Override
    public Composite getPanel() {
        return this._panel;
    }

    private void bindControls(DataBindingContext context) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.getTargetObject());
        Realm realm = SWTObservables.getRealm((Display)this._nameText.getDisplay());
        this._bindingValue = new WritableValue(realm, null, JCABinding.class);
        org.eclipse.core.databinding.Binding binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("JCA binding name should not be empty", 2)), null);
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        binding = context.bindValue((IObservableValue)SWTObservables.observeText((Control)this._nameText, (int[])new int[]{24}), ObservablesUtil.observeDetailValue(domain, (IObservableValue)this._bindingValue, (EStructuralFeature)ScaPackage.eINSTANCE.getBinding_Name()), new EMFUpdateValueStrategyNullForEmptyString(null, UpdateValueStrategy.POLICY_CONVERT).setAfterConvertValidator(new StringEmptyValidator("JCA binding name should not be empty", 2)), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        ControlDecorationSupport.create((ValidationStatusProvider)SWTValueUpdater.attach(binding), (int)16512);
        this._opSelectorComposite.bindControls(domain, context);
    }
}

