/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.bpmn2.component;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMFactory;
import org.switchyard.tools.models.switchyard1_0.bpm.BPMImplementationType;
import org.switchyard.tools.models.switchyard1_0.bpm.ListenerType;
import org.switchyard.tools.ui.bpmn2.Messages;
import org.switchyard.tools.ui.editor.diagram.shared.ClassDialogCellEditor;
import org.switchyard.tools.ui.editor.diagram.shared.TableColumnLayout;
import org.switchyard.tools.ui.editor.impl.SwitchyardSCAEditor;

public class BPMEventListenerTable
extends Composite
implements ICellModifier {
    private TableViewer _propertyTreeTable;
    public static final String NAME_COLUMN = "name";
    private static final String[] TREE_COLUMNS = new String[]{"name"};
    private Button _mAddButton;
    private Button _mRemoveButton;
    private boolean _isReadOnly = false;
    private EObject _targetObj = null;
    private String _mWarning = null;
    private ListenerList _changeListeners;

    public BPMEventListenerTable(Composite parent, int style) {
        this(parent, style, false);
    }

    public BPMEventListenerTable(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        this._isReadOnly = isReadOnly;
        this._changeListeners = new ListenerList();
        int additionalStyles = 0;
        if (isReadOnly) {
            additionalStyles = 8;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Composite tableComposite = new Composite((Composite)this, additionalStyles);
        GridData gd11 = new GridData(4, 4, true, false, 1, 2);
        gd11.heightHint = 100;
        tableComposite.setLayoutData((Object)gd11);
        this._propertyTreeTable = new TableViewer(tableComposite, 0x10A40 | additionalStyles);
        this._propertyTreeTable.getTable().setHeaderVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableLayout);
        TableColumn nameColumn = new TableColumn(this._propertyTreeTable.getTable(), 16384);
        nameColumn.setText(Messages.label_class);
        tableLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(100, 300, true));
        this._propertyTreeTable.setColumnProperties(TREE_COLUMNS);
        this._propertyTreeTable.setLabelProvider((IBaseLabelProvider)new PropertyTreeLabelProvider());
        this._propertyTreeTable.setContentProvider((IContentProvider)new PropertyTreeContentProvider());
        this._propertyTreeTable.setCellModifier((ICellModifier)this);
        this._propertyTreeTable.setCellEditors(new CellEditor[]{new ClassDialogCellEditor((Composite)this._propertyTreeTable.getTable(), "java.util.EventListener", Messages.title_eventListener, Messages.description_eventListener){

            protected Resource getResource() {
                return BPMEventListenerTable.this._targetObj == null ? null : BPMEventListenerTable.this._targetObj.eResource();
            }
        }});
        this._mAddButton = new Button((Composite)this, 0);
        this._mAddButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mAddButton.setText(Messages.button_add);
        this._mAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BPMEventListenerTable.this.addPropertyToList();
                if (BPMEventListenerTable.this._propertyTreeTable.getInput() == null) {
                    BPMEventListenerTable.this._propertyTreeTable.setInput((Object)BPMEventListenerTable.this._targetObj);
                }
                BPMEventListenerTable.this._propertyTreeTable.refresh();
                BPMEventListenerTable.this.fireChangedEvent(e.getSource());
            }
        });
        this._mAddButton.setEnabled(false);
        this._propertyTreeTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BPMEventListenerTable.this.updatePropertyButtons();
            }
        });
        this._mRemoveButton = new Button((Composite)this, 0);
        this._mRemoveButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this._mRemoveButton.setText(Messages.button_remove);
        this._mRemoveButton.setEnabled(false);
        this._mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BPMEventListenerTable.this.removeFromList();
                BPMEventListenerTable.this._propertyTreeTable.refresh();
                BPMEventListenerTable.this.fireChangedEvent(e.getSource());
            }
        });
        this.updatePropertyButtons();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected void addPropertyToList() {
        if (this.getTargetObject() instanceof BPMImplementationType) {
            final BPMImplementationType impl = (BPMImplementationType)this.getTargetObject();
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        ListenerType newAction = BPMFactory.eINSTANCE.createListenerType();
                        newAction.setClass("classname");
                        if (impl.getListeners() == null) {
                            impl.setListeners(BPMFactory.eINSTANCE.createListenersType());
                        }
                        impl.getListeners().getListener().add((Object)newAction);
                        BPMEventListenerTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                ListenerType newAction = BPMFactory.eINSTANCE.createListenerType();
                if (impl.getListeners() == null) {
                    impl.setListeners(BPMFactory.eINSTANCE.createListenersType());
                }
                impl.getListeners().getListener().add((Object)newAction);
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected void removeFromList() {
        if (this.getTargetObject() instanceof BPMImplementationType) {
            final BPMImplementationType impl = (BPMImplementationType)this.getTargetObject();
            final ListenerType actionToRemove = this.getTableSelection();
            if (impl.eContainer() != null) {
                TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        impl.getListeners().getListener().remove((Object)actionToRemove);
                        if (impl.getListeners().getListener().isEmpty()) {
                            impl.setListeners(null);
                        }
                        BPMEventListenerTable.this.getTableViewer().refresh(true);
                    }
                });
            } else {
                impl.getListeners().getListener().remove((Object)actionToRemove);
                if (impl.getListeners().getListener().isEmpty()) {
                    impl.setListeners(null);
                }
                this.getTableViewer().refresh(true);
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected ListenerType getTableSelection() {
        IStructuredSelection ssel;
        if (this._propertyTreeTable != null && !this._propertyTreeTable.getSelection().isEmpty() && (ssel = (IStructuredSelection)this._propertyTreeTable.getSelection()).getFirstElement() instanceof ListenerType) {
            return (ListenerType)ssel.getFirstElement();
        }
        return null;
    }

    public void updatePropertyButtons() {
        if (this._isReadOnly) {
            this._mAddButton.setEnabled(false);
            this._mRemoveButton.setEnabled(false);
        } else {
            this._mAddButton.setEnabled(true);
            if (this.getTableSelection() != null) {
                this._mRemoveButton.setEnabled(true);
            }
        }
    }

    public String getWarning() {
        return this._mWarning;
    }

    protected void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = this._changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._changeListeners.remove((Object)listener);
    }

    public void setTargetObject(EObject target) {
        this._targetObj = target;
        this._propertyTreeTable.setInput((Object)this._targetObj);
        this.updatePropertyButtons();
    }

    protected EObject getTargetObject() {
        return this._targetObj;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        if (element instanceof ListenerType && property.equalsIgnoreCase(NAME_COLUMN)) {
            if (((ListenerType)element).getClass_() != null) {
                return ((ListenerType)element).getClass_();
            }
            return "";
        }
        return null;
    }

    public void modify(Object element, String property, final Object value) {
        if (element instanceof TableItem && property.equalsIgnoreCase(NAME_COLUMN)) {
            TableItem ti = (TableItem)element;
            if (this.getTargetObject() instanceof BPMImplementationType) {
                BPMImplementationType impl = (BPMImplementationType)this.getTargetObject();
                final ListenerType parm = (ListenerType)ti.getData();
                if (value == null && parm.getClass_() == null || value != null && value.equals(parm.getClass_())) {
                    return;
                }
                if (impl.eContainer() != null) {
                    TransactionalEditingDomain domain = SwitchyardSCAEditor.getActiveEditor().getEditingDomain();
                    domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                        protected void doExecute() {
                            parm.setClass((String)value);
                            BPMEventListenerTable.this.getTableViewer().refresh(true);
                        }
                    });
                } else {
                    parm.setClass((String)value);
                    this.getTableViewer().refresh(true);
                }
            }
            this.fireChangedEvent((Object)this);
        }
    }

    protected TableViewer getTableViewer() {
        return this._propertyTreeTable;
    }

    private class PropertyTreeContentProvider
    implements IStructuredContentProvider {
        private PropertyTreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            BPMImplementationType bpmImpl;
            if (inputElement instanceof BPMImplementationType && (bpmImpl = (BPMImplementationType)inputElement).getListeners() != null) {
                return bpmImpl.getListeners().getListener().toArray();
            }
            return new Object[0];
        }
    }

    private class PropertyTreeLabelProvider
    implements ITableLabelProvider {
        private PropertyTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return element instanceof ListenerType && property.equalsIgnoreCase(BPMEventListenerTable.NAME_COLUMN);
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ListenerType && columnIndex == 0) {
                return ((ListenerType)element).getClass_();
            }
            return null;
        }
    }
}

