/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.CreateSwitchYardProjectOperation;
import org.switchyard.tools.ui.wizards.ProjectConfigurationWizardPage;

public class NewSwitchYardProjectWizard
extends Wizard
implements INewWizard {
    public static final String DEFAULT_RUNTIME_VERSION = "2.0.0.Beta1";
    private static final String DEFAULT_PROJECT_NAME = "switchyard-example";
    private static final String DEFAULT_PROJECT_VERSION = "0.0.1-SNAPSHOT";
    private WizardNewProjectCreationPage _newProjectPage;
    private ProjectConfigurationWizardPage _configurationPage;
    private IStructuredSelection _selection;
    private IWorkbench _workbench;

    public NewSwitchYardProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.NewSwitchYardProjectWizard_windowTitle);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._selection = selection;
        this._workbench = workbench;
    }

    public String getProjectName() {
        return this._newProjectPage.getProjectName();
    }

    public void addPages() {
        this._newProjectPage = new WizardNewProjectCreationPage("NewProjectPage"){

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.createWorkingSetGroup((Composite)this.getControl(), NewSwitchYardProjectWizard.this._selection, new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"});
                Dialog.applyDialogFont((Control)this.getControl());
            }
        };
        this._newProjectPage.setTitle(Messages.NewSwitchYardProjectWizard_projectPageTitle);
        this._newProjectPage.setDescription(Messages.NewSwitchYardProjectWizard_projectPageDescription);
        this._newProjectPage.setInitialProjectName(this.getInitialProjectName());
        this.addPage((IWizardPage)this._newProjectPage);
        this._configurationPage = new ProjectConfigurationWizardPage();
        this.addPage((IWizardPage)this._configurationPage);
    }

    public boolean performFinish() {
        ArtifactVersion runtimeVersion = this._configurationPage.getRuntimeVersion();
        if (!this.validateVersion(runtimeVersion)) {
            return false;
        }
        CreateSwitchYardProjectOperation.NewSwitchYardProjectMetaData projectMetaData = new CreateSwitchYardProjectOperation.NewSwitchYardProjectMetaData();
        projectMetaData.setNewProjectHandle(this._newProjectPage.getProjectHandle());
        if (!this._newProjectPage.useDefaults()) {
            projectMetaData.setProjectLocation(this._newProjectPage.getLocationURI());
        }
        projectMetaData.setPackageName(this._configurationPage.getPackageName());
        projectMetaData.setNamespace(this._configurationPage.getNamespace());
        projectMetaData.setGroupId(this._configurationPage.getGroupId());
        projectMetaData.setProjectVersion(DEFAULT_PROJECT_VERSION);
        projectMetaData.setRuntimeVersion(runtimeVersion == null ? DEFAULT_RUNTIME_VERSION : runtimeVersion.toString());
        projectMetaData.setComponents(this._configurationPage.getSelectedComponents());
        projectMetaData.setTargetRuntime(this._configurationPage.getTargetRuntime());
        projectMetaData.setConfigurationVersion(this._configurationPage.getConfigurationVersion());
        projectMetaData.setIsOSGIEnabled(this._configurationPage.isBundled());
        projectMetaData.setIsSwitchYardDependencyBOMEnabled(this._configurationPage.isSwitchYardBOMEnabled());
        final CreateSwitchYardProjectOperation op = new CreateSwitchYardProjectOperation(projectMetaData, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        try {
            final Display display = this._workbench.getDisplay();
            final IWorkbenchPage activePage = this._workbench.getActiveWorkbenchWindow().getActivePage();
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    if (activePage != null) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    IDE.openEditor((IWorkbenchPage)activePage, (IFile)op.getSwitchYardFile(), (boolean)true);
                                }
                                catch (PartInitException e) {
                                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.NewSwitchYardProjectWizard_logError_errorOpeningSYXML, (Throwable)e));
                                }
                            }
                        });
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException instanceof CoreException) {
                Activator.getDefault().getLog().log(((CoreException)realException).getStatus());
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.NewSwitchYardProjectWizard_logError_errorCreatingSYProject, realException));
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewSwitchYardProjectWizard_errorMessage_errorCreatingProject, (String)realException.getMessage());
            return projectMetaData.getNewProjectHandle().exists();
        }
        return true;
    }

    private String getInitialProjectName() {
        String initialProjectName = DEFAULT_PROJECT_NAME;
        int i = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().getProject(initialProjectName).exists()) {
            initialProjectName = DEFAULT_PROJECT_NAME + i++;
        }
        return initialProjectName;
    }

    public boolean canFinish() {
        return super.canFinish() && this.getContainer().getCurrentPage() != this._newProjectPage;
    }

    private boolean validateVersion(final ArtifactVersion version) {
        if (version == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewSwitchYardProjectWizard_errorTitle_noVersionSpecified, (String)Messages.NewSwitchYardProjectWizard_errorMessage_noSwitchYardVersionSpecified);
            return false;
        }
        final boolean[] retVal = new boolean[1];
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.setTaskName(Messages.NewSwitchYardProjectWizard_taskLabel_resolvingSwitchYardArtifacts);
                        if (MavenPlugin.getMaven().resolve("org.switchyard", "switchyard-api", version.toString(), "jar", null, MavenPlugin.getMaven().getArtifactRepositories(), (IProgressMonitor)new NullProgressMonitor()).isResolved()) {
                            retVal[0] = true;
                            return;
                        }
                    }
                    catch (CoreException e) {
                        e.fillInStackTrace();
                    }
                    retVal[0] = MessageDialog.openConfirm((Shell)NewSwitchYardProjectWizard.this.getShell(), (String)Messages.NewSwitchYardProjectWizard_confirmTitle_cannotResolveSwitchYardDependencies, (String)Messages.NewSwitchYardProjectWizard_confirmText_cannotResolveSwitchYardDependencies);
                }
            });
        }
        catch (Exception exception) {
            retVal[0] = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.NewSwitchYardProjectWizard_confirmTitle_cannotResolveSwitchYardDependencies, (String)Messages.NewSwitchYardProjectWizard_confirmText_cannotResolveSwitchYardDependencies);
        }
        return retVal[0];
    }
}

