/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.soa.sca.sca1_1.model.sca.Contract;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.CreateServiceTestOperation;
import org.switchyard.tools.ui.wizards.NewServiceTestClassWizardPage;

public class NewServiceTestClassWizard
extends BasicNewResourceWizard {
    private NewServiceTestClassWizardPage _newClassPage = new NewServiceTestClassWizardPage();

    public NewServiceTestClassWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setWindowTitle(Messages.NewServiceTestClassWizard_wizardTitle);
        this._newClassPage.init(this.selection);
        this.addPage((IWizardPage)this._newClassPage);
    }

    public void forceServiceContract(Contract contract) {
        this._newClassPage.setServiceContract(contract, false);
    }

    public boolean performFinish() {
        final CreateServiceTestOperation op = new CreateServiceTestOperation(this._newClassPage, WorkspaceUndoUtil.getUIInfoAdapter((Shell)this.getShell()));
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)op, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            if (realException instanceof CoreException) {
                Activator.getDefault().getLog().log(((CoreException)realException).getStatus());
            } else {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.NewServiceTestClassWizard_logMessage_errorCreatingTestClass, realException));
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewServiceTestClassWizard_errorMessage_errorCreatingTestClass, (String)realException.getMessage());
            if (!this._newClassPage.getModifiedResource().exists()) {
                return false;
            }
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        final IResource resource = this._newClassPage.getModifiedResource();
        if (resource instanceof IFile && resource.exists()) {
            this.selectAndReveal(resource);
            final IWorkbenchPage activePage = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                        }
                        catch (PartInitException e) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.switchyard.tools.ui", Messages.NewServiceTestClassWizard_logMessage_errorOpeningBeanServiceSource, (Throwable)e));
                        }
                    }
                });
            }
        }
        return true;
    }
}

