/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.validation;

import org.switchyard.tools.ui.i18n.Messages;

public enum ValidationProblem {
    OK(Messages.ValidationProblem_NoProblem, 0, false),
    DuplicateName(Messages.ValidationProblem_DuplicateName, false),
    PromotedReferenceNameMismatch(Messages.ValidationProblem_PromotedReferenceNameMismatch, true),
    AmbiguousReference(Messages.ValidationProblem_AmbiguousReference, false),
    UnresolvedReference(Messages.ValidationProblem_UnresolvedReference, true),
    UnusedReference(Messages.ValidationProblem_UnusedReference, 2, false),
    UnboundService(Messages.ValidationProblem_UnboundService, 2, false),
    UnboundOperation(Messages.ValidationProblem_UnboundOperation, true),
    UnusedReturnValue(Messages.ValidationProblem_UnusedReturnValue, 2, true),
    IncomptaibleMEP(Messages.ValidationProblem_IncompatibleMessageExchangePattern, true),
    UnhandledFault(Messages.ValidationProblem_UnhandledFault, true),
    MissingTransformation(Messages.ValidationProblem_RequiredTransformMissing, true),
    UnresolvableServiceInterface(Messages.ValidationProblem_UnresolvableServiceInterface, false),
    UnableToValidateTransformers(Messages.ValidationProblem_UnableToValidateTransformers, 2, false),
    RequiredCapabilityMissing(Messages.ValidationProblem_RequiredCapabilityMissing, 4, false),
    UnusedCapability(Messages.ValidationProblem_UnusedCapability, 2, false),
    IncompatibleInterfaceType(Messages.ValidationProblem_IncompatibleInterfaceType, 4, false),
    BeanUnspecifiedClass(Messages.ValidationProblem_UnspecifiedBeanClass, 4, false),
    BeanUnresolvableClass(Messages.ValidationProblem_UnresolvableBeanClass, 4, false),
    MissingServiceDeclaration(Messages.ValidationProblem_MissingComponentService, 4, false),
    ServiceInterfaceMismatch(Messages.ValidationProblem_ServiceInterfaceMismatch, 4, false),
    UnusedServiceDeclaration(Messages.ValidationProblem_UnimplementedServiceDeclaration, 4, false),
    MissingReferenceDeclaration(Messages.ValidationProblem_MissingComponentReference, 4, false),
    ReferenceInterfaceMismatch(Messages.ValidationProblem_ReferenceInterfaceMismatch, 4, false),
    UnusedReferenceDeclaration(Messages.ValidationProblem_UnusedComponentReference, 2, false),
    CamelJavaUnspecifiedClass(Messages.ValidationProblem_UnspecifiedCamelRouteClass, 4, false),
    CamelJavaUnresolvableClass(Messages.ValidationProblem_UnresolvableCamelRouteClass, 4, false),
    CamelJavaWrongSuperclass(Messages.ValidationProblem_CamelJavaClassDoesNotExtendRouteBuilder, 4, false),
    CamelXMLUnspecified(Messages.ValidationProblem_NoCamelXMLSpecified, 4, false),
    CamelImplementationIncomplete(Messages.ValidationProblem_CamelImplementationTypeMissing, 4, false),
    InvalidCamelRouteOperationReference(Messages.ValidationProblem_InvalidCamelRouteOperationReference, 4, false),
    CamelRouteOperationNotFoundAsReference(Messages.ValidationProblem_CamelRouteOperationNotFoundAsReference, 4, false),
    CamelRouteOperationNotFoundAsService(Messages.ValidationProblem_CamelRouteOperationNotFoundAsService, 4, false),
    CamelRouteOperationRequiredNotSpecified(Messages.ValidationProblem_CamelRouteOperationRequiredNotSpecified, 2, false),
    CamelXMLNotFound(Messages.ValidationProblem_CamelXMLNotFound, 4, false),
    CamelRouteMoreThanOneFromFound(Messages.ValidationProblem_CamelRouteMoreThanOneFromFound, 4, false),
    CamelRouteURIInvalid(Messages.ValidationProblem_CamelRouteURIInvalid, 4, false),
    DuplicateServiceName(Messages.ValidationProblem_DuplicateServiceName, false),
    ServiceInterfaceHasMultipleParameters(Messages.ValidationProblem_ServiceInterfaceHasMethodWithMultipleParameters, false);

    public static final String PROBLEM_CODE;
    private String _message;
    private int _severity;
    private boolean _connectionProblem;

    static {
        PROBLEM_CODE = Messages.ValidationProblem_ValidateProblem;
    }

    public static boolean isConnectionProblem(int statusCode) {
        if (statusCode > 0 && statusCode < ValidationProblem.values().length) {
            return ValidationProblem.values()[statusCode].isConnectionProblem();
        }
        return false;
    }

    private ValidationProblem(String message, int severity, boolean connectionProblem) {
        this._message = message;
        this._severity = severity;
        this._connectionProblem = connectionProblem;
    }

    private ValidationProblem(String message, boolean connectionProblem) {
        this(message, 4, connectionProblem);
    }

    public boolean isConnectionProblem() {
        return this._connectionProblem;
    }

    public String getMessage() {
        return this._message;
    }

    public int getSeverity() {
        return this._severity;
    }
}

