/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.properties;

import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.ui.internal.SharedWorkingCopyManager;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.common.ILayoutUtilities;
import org.switchyard.tools.ui.common.ISwitchYardComponentExtension;
import org.switchyard.tools.ui.common.ISwitchYardProjectWorkingCopy;
import org.switchyard.tools.ui.common.SwitchYardComponentExtensionManager;
import org.switchyard.tools.ui.common.SwitchYardSettingsGroup;
import org.switchyard.tools.ui.common.impl.SwitchYardProjectManager;
import org.switchyard.tools.ui.i18n.Messages;
import org.switchyard.tools.ui.operations.UpdateProjectPomOperation;

public class SwitchYardSettingsPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage,
ILayoutUtilities {
    private SwitchYardSettingsGroup _settingsGroup;
    private ISwitchYardProjectWorkingCopy _switchYardProject;
    private IFacetedProject _ifp;
    private IFacetedProjectWorkingCopy _ifpwc;
    private Set<IRuntime> _configuredRuntimes;
    private Button _useSwitchYardDependencyBOMCheckbox;

    public SwitchYardSettingsPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout());
        content.setLayoutData((Object)new GridData(4, 4, true, true));
        this._settingsGroup = new SwitchYardSettingsGroup(content, this, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        this._settingsGroup.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                String errmsg = null;
                if (SwitchYardSettingsPropertyPage.this.pomUsesSwitchYardBOM() && !SwitchYardSettingsPropertyPage.this.isSelectedRuntimeVersion2OrHigher()) {
                    errmsg = "SwitchYard projects using BOM dependencies must use Runtime Version 2.0 or higher.";
                }
                if (!SwitchYardSettingsPropertyPage.this.isSelectedConfigurationVersionOkForRuntime()) {
                    String configVersion = SwitchYardSettingsPropertyPage.this.getMajorMinorFromVersion(SwitchYardSettingsPropertyPage.this.getRuntimeVersion().toString());
                    errmsg = "The Configuration Version must be " + configVersion + " or lower to work with Library Version " + SwitchYardSettingsPropertyPage.this.getRuntimeVersion().toString() + ".";
                }
                SwitchYardSettingsPropertyPage.this.setErrorMessage(errmsg);
                SwitchYardSettingsPropertyPage.this.getContainer().updateMessage();
            }
        });
        Label label = new Label(content, 131072);
        this._useSwitchYardDependencyBOMCheckbox = new Button(content, 32);
        this._useSwitchYardDependencyBOMCheckbox.setText("Uses SwitchYard BOM for dependency management");
        GridData cb2GD = new GridData(768);
        this._useSwitchYardDependencyBOMCheckbox.setLayoutData((Object)cb2GD);
        label.setEnabled(false);
        this._useSwitchYardDependencyBOMCheckbox.setEnabled(false);
        this.initControls();
        return content;
    }

    public void dispose() {
        if (this._switchYardProject != null) {
            this._switchYardProject.dispose();
        }
        if (this._ifpwc != null) {
            SharedWorkingCopyManager.releaseWorkingCopy((IFacetedProject)this._ifp);
        }
        super.dispose();
    }

    public boolean performOk() {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    new UpdateProjectPomOperation(SwitchYardSettingsPropertyPage.this._switchYardProject).run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
                if (SwitchYardSettingsPropertyPage.this._ifpwc != null && SwitchYardSettingsPropertyPage.this._ifpwc.isDirty()) {
                    try {
                        SwitchYardSettingsPropertyPage.this._ifpwc.commitChanges((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            }
        });
        return true;
    }

    private void initControls() {
        this._switchYardProject = SwitchYardProjectManager.instance().getSwitchYardProject(this.getProject()).createWorkingCopy();
        if (this._switchYardProject.needsLoading()) {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    SwitchYardSettingsPropertyPage.this._switchYardProject.load((IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
        try {
            this._ifp = ProjectFacetsManager.create((IProject)this._switchYardProject.getProject());
            this._ifpwc = SharedWorkingCopyManager.getWorkingCopy((IFacetedProject)this._ifp);
            this._configuredRuntimes = this._ifpwc.getTargetedRuntimes();
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        this._settingsGroup.setProject(this._ifpwc);
        this.initTargetRuntime();
        this.initRuntimeVersion();
        this.initComponentsTable();
        this._useSwitchYardDependencyBOMCheckbox.setSelection(this.pomUsesSwitchYardBOM());
        String errmsg = null;
        if (!this.pomDefinesSwitchYardVersion()) {
            this._settingsGroup.setRuntimeControlEnablement(false);
        } else if (this.pomUsesSwitchYardBOM()) {
            if (!this.isSelectedRuntimeVersion2OrHigher()) {
                errmsg = Messages.ProjectConfigurationWizardPage_errorMessage_bomRequiresVersion2;
            }
        } else if (!this.isSelectedConfigurationVersionOkForRuntime()) {
            String configVersion = this.getMajorMinorFromVersion(this.getRuntimeVersion().toString());
            errmsg = "The Configuration Version must be " + configVersion + " or lower to work with Library Version " + this.getRuntimeVersion().toString() + ".";
        }
        this.setErrorMessage(errmsg);
        this.getContainer().updateMessage();
    }

    private ArtifactVersion getRuntimeVersion() {
        ISelection runtimeVersionListSelection = this._settingsGroup.getRuntimeVersionsList().getSelection();
        if (runtimeVersionListSelection.isEmpty()) {
            return null;
        }
        return (ArtifactVersion)((IStructuredSelection)runtimeVersionListSelection).getFirstElement();
    }

    private IProjectFacetVersion getConfigurationVersion() {
        return this._settingsGroup.getSelectedConfigurationVersion();
    }

    private boolean isSelectedConfigurationVersionOkForRuntime() {
        float runtimeVersion;
        String runtimeVersionStr;
        String majorMinorRuntime;
        float configVersion;
        String configVersionStr = this.getConfigurationVersion().getVersionString();
        String majorMinorConfig = this.getMajorMinorFromVersion(configVersionStr);
        return majorMinorConfig != null && (configVersion = this.convertVersionStringToLong(configVersionStr)) > -1.0f && (majorMinorRuntime = this.getMajorMinorFromVersion(runtimeVersionStr = this.getRuntimeVersion().toString())) != null && (runtimeVersion = this.convertVersionStringToLong(majorMinorRuntime)) > -1.0f && configVersion <= runtimeVersion;
    }

    private void initTargetRuntime() {
        if (this._ifpwc == null) {
            this._settingsGroup.getTargetRuntimesList().setSelection((ISelection)new StructuredSelection(SwitchYardSettingsGroup.NULL_RUNTIME));
            this._settingsGroup.getTargetRuntimesList().getControl().setEnabled(false);
            return;
        }
        IRuntime runtime = this._ifpwc.getPrimaryRuntime();
        if (runtime == null) {
            this._settingsGroup.getTargetRuntimesList().setSelection((ISelection)new StructuredSelection(SwitchYardSettingsGroup.NULL_RUNTIME));
        } else {
            for (IRuntimeComponent component : runtime.getRuntimeComponents()) {
                if (!"switchyard.runtime".equals(component.getRuntimeComponentType().getId()) && !"fuseServiceWorks.runtime".equals(component.getRuntimeComponentType().getId())) continue;
                this._settingsGroup.getTargetRuntimesList().setSelection((ISelection)new StructuredSelection((Object)component), true);
            }
        }
        this._settingsGroup.getTargetRuntimesList().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty() || selection.getFirstElement() == SwitchYardSettingsGroup.NULL_RUNTIME) {
                    IRuntime primaryRuntime = SwitchYardSettingsPropertyPage.this._ifpwc.getPrimaryRuntime();
                    if (primaryRuntime != null && !SwitchYardSettingsPropertyPage.this._configuredRuntimes.contains(primaryRuntime)) {
                        SwitchYardSettingsPropertyPage.this._ifpwc.removeTargetedRuntime(primaryRuntime);
                    }
                } else {
                    IRuntime runtime = ((IRuntimeComponent)selection.getFirstElement()).getRuntime();
                    SwitchYardSettingsPropertyPage.this._ifpwc.addTargetedRuntime(runtime);
                    SwitchYardSettingsPropertyPage.this._ifpwc.setPrimaryRuntime(runtime);
                }
            }
        });
    }

    private void initRuntimeVersion() {
        DefaultArtifactVersion version = null;
        String versionString = this._switchYardProject.getVersion();
        if (versionString != null && versionString.length() > 0) {
            version = new DefaultArtifactVersion(versionString);
        }
        if (version != null) {
            this._settingsGroup.getRuntimeVersionsList().setSelection((ISelection)new StructuredSelection((Object)version), true);
        }
        this._settingsGroup.getRuntimeVersionsList().getControl().setEnabled(!this._switchYardProject.isUsingDependencyManagement());
        this._settingsGroup.getRuntimeVersionsList().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                    return;
                }
                SwitchYardSettingsPropertyPage.this._switchYardProject.setRuntimeVersion(((IStructuredSelection)selection).getFirstElement().toString());
            }
        });
    }

    private void initComponentsTable() {
        this._settingsGroup.setCheckedComponents(this._switchYardProject.getComponents(), true);
        this._settingsGroup.getComponentsTable().addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getElement() instanceof ISwitchYardComponentExtension) {
                    if (event.getChecked()) {
                        SwitchYardSettingsPropertyPage.this._switchYardProject.addComponent((ISwitchYardComponentExtension)event.getElement());
                    } else {
                        SwitchYardSettingsPropertyPage.this._switchYardProject.removeComponent((ISwitchYardComponentExtension)event.getElement());
                    }
                } else if (event.getElement() instanceof ISwitchYardComponentExtension.Category) {
                    if (event.getChecked()) {
                        SwitchYardSettingsPropertyPage.this._switchYardProject.addComponents(SwitchYardComponentExtensionManager.instance().getComponentExtensions((ISwitchYardComponentExtension.Category)((Object)event.getElement())));
                    } else {
                        SwitchYardSettingsPropertyPage.this._switchYardProject.removeComponents(SwitchYardComponentExtensionManager.instance().getComponentExtensions((ISwitchYardComponentExtension.Category)((Object)event.getElement())));
                    }
                }
            }
        });
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    @Override
    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private boolean pomDefinesSwitchYardVersion() {
        return this._switchYardProject.getMavenProject().getProperties().containsKey("switchyard.version");
    }

    private boolean pomUsesSwitchYardBOM() {
        MavenProject project = this._switchYardProject.getMavenProject();
        Model originalModel = project.getOriginalModel();
        DependencyManagement depMgmt = originalModel.getDependencyManagement();
        if (depMgmt != null && !depMgmt.getDependencies().isEmpty()) {
            for (Dependency tempDep : depMgmt.getDependencies()) {
                if (!tempDep.getArtifactId().equals("switchyard-bom")) continue;
                return true;
            }
        }
        return false;
    }

    private String getMajorMinorFromVersion(String inString) {
        try {
            String[] versionSplit = inString.split("\\.");
            if (versionSplit.length > 1) {
                return String.valueOf(versionSplit[0]) + "." + versionSplit[1];
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private boolean isSelectedRuntimeVersion2OrHigher() {
        float runtimeVersion;
        String runtimeVersionStr = this.getRuntimeVersion().toString();
        String majorMinorConfig = this.getMajorMinorFromVersion(runtimeVersionStr);
        return majorMinorConfig != null && (runtimeVersion = this.convertVersionStringToLong(majorMinorConfig)) > -1.0f && (double)runtimeVersion >= 2.0;
    }

    private float convertVersionStringToLong(String strVersion) {
        float version;
        try {
            version = Float.parseFloat(strVersion);
        }
        catch (NumberFormatException numberFormatException) {
            version = -1.0f;
        }
        return version;
    }

    public void setErrorMessage(String newMessage) {
        this.setValid(newMessage == null);
        super.setErrorMessage(newMessage);
    }
}

