/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;
import org.switchyard.tools.ui.explorer.AbstractSwitchYardNode;
import org.switchyard.tools.ui.explorer.IComponentNode;
import org.switchyard.tools.ui.explorer.IComponentsNode;
import org.switchyard.tools.ui.explorer.impl.ComponentNode;
import org.switchyard.tools.ui.explorer.impl.SwitchYardRootNode;
import org.switchyard.tools.ui.i18n.Messages;

public class ComponentsNode
extends AbstractSwitchYardNode
implements IComponentsNode {
    private List<IComponentNode> _components;

    public ComponentsNode(SwitchYardRootNode root, SwitchYardModel configuration) {
        super(root);
        if (configuration == null) {
            this._components = Collections.emptyList();
            return;
        }
        CompositeModel composite = configuration.getComposite();
        if (composite == null) {
            this._components = Collections.emptyList();
            return;
        }
        List components = composite.getComponents();
        this._components = new ArrayList<IComponentNode>(components.size());
        for (ComponentModel component : components) {
            this._components.add(new ComponentNode(this, component));
        }
    }

    @Override
    public String getName() {
        return Messages.ComponentsNode_labelComponents;
    }

    @Override
    public List<IComponentNode> getComponents() {
        return this._components;
    }

    public int hashCode() {
        return this.getRoot().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentsNode) {
            return ((ComponentsNode)obj).getRoot() == this.getRoot();
        }
        return false;
    }
}

