/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.explorer;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.explorer.IArtifactNode;
import org.switchyard.tools.ui.explorer.IArtifactsNode;
import org.switchyard.tools.ui.explorer.IComponentNode;
import org.switchyard.tools.ui.explorer.IComponentReference;
import org.switchyard.tools.ui.explorer.IComponentService;
import org.switchyard.tools.ui.explorer.IComponentsNode;
import org.switchyard.tools.ui.explorer.IReferenceNode;
import org.switchyard.tools.ui.explorer.IReferencesNode;
import org.switchyard.tools.ui.explorer.IServiceGateway;
import org.switchyard.tools.ui.explorer.IServiceNode;
import org.switchyard.tools.ui.explorer.IServicesNode;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.explorer.ISwitchYardRootNode;
import org.switchyard.tools.ui.i18n.Messages;

public class SwitchYardExplorerLabelProvider
extends LabelProvider
implements ILabelProvider,
IDescriptionProvider {
    public Image getImage(Object element) {
        if (element instanceof ISwitchYardRootNode) {
            return Activator.getDefault().getImageRegistry().get("icons/switchyard_icon_16px.png");
        }
        if (element instanceof IServicesNode || element instanceof IReferencesNode || element instanceof IComponentsNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof IServiceNode || element instanceof IComponentService) {
            return Activator.getDefault().getImageRegistry().get("icons/service_16px.gif");
        }
        if (element instanceof IReferenceNode || element instanceof IComponentReference) {
            return Activator.getDefault().getImageRegistry().get("icons/reference_16px.gif");
        }
        if (element instanceof IComponentNode) {
            return Activator.getDefault().getImageRegistry().get("icons/component_16px.gif");
        }
        if (element instanceof IArtifactsNode) {
            return Activator.getDefault().getImageRegistry().get("icons/artifact_16px.gif");
        }
        if (element instanceof IServiceGateway || element instanceof IArtifactNode) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ISwitchYardRootNode) {
            return Messages.SwitchYardExplorerLabelProvider_SwitchYardRootNode;
        }
        if (element instanceof ISwitchYardNode) {
            return this.named(((ISwitchYardNode)element).getName());
        }
        return super.getText(element);
    }

    public String getDescription(Object element) {
        if (element instanceof ISwitchYardRootNode) {
            ISwitchYardRootNode root = (ISwitchYardRootNode)element;
            return String.valueOf(this.named(root.getName())) + Messages.SwitchYardExplorerLabelProvider_ApplicationNode + root.getProject().getName();
        }
        if (element instanceof IServicesNode) {
            ISwitchYardRootNode root = ((IServicesNode)element).getRoot();
            return String.valueOf(this.named(root.getName())) + Messages.SwitchYardExplorerLabelProvider_AppServicesNode + root.getProject().getName();
        }
        if (element instanceof IReferencesNode) {
            ISwitchYardRootNode root = ((IReferencesNode)element).getRoot();
            return String.valueOf(this.named(root.getName())) + Messages.SwitchYardExplorerLabelProvider_AppReferencesNode + root.getProject().getName();
        }
        if (element instanceof IComponentsNode) {
            ISwitchYardRootNode root = ((IComponentsNode)element).getRoot();
            return String.valueOf(this.named(root.getName())) + Messages.SwitchYardExplorerLabelProvider_AppComponentsNode + root.getProject().getName();
        }
        if (element instanceof IArtifactsNode) {
            ISwitchYardRootNode root = ((IArtifactsNode)element).getRoot();
            return String.valueOf(this.named(root.getName())) + Messages.SwitchYardExplorerLabelProvider_AppArtifactsNode + root.getProject().getName();
        }
        if (element instanceof IServiceNode) {
            return String.valueOf(this.getText(element)) + Messages.SwitchYardExplorerLabelProvider_ServiceNode;
        }
        if (element instanceof IReferenceNode) {
            return String.valueOf(this.getText(element)) + Messages.SwitchYardExplorerLabelProvider_ReferenceNode;
        }
        if (element instanceof IComponentNode) {
            return String.valueOf(this.getText(element)) + Messages.SwitchYardExplorerLabelProvider_ComponentNode;
        }
        if (element instanceof IComponentService) {
            return String.valueOf(this.getText(element)) + Messages.SwitchYardExplorerLabelProvider_ComponentServiceNode;
        }
        if (element instanceof IComponentReference) {
            return String.valueOf(this.getText(element)) + Messages.SwitchYardExplorerLabelProvider_ComponentReferenceNode;
        }
        if (element instanceof IArtifactNode) {
            return String.valueOf(this.getText(element)) + Messages.SwitchYardExplorerLabelProvider_ArtifactReferenceNode;
        }
        if (element instanceof IServiceGateway) {
            return String.valueOf(this.getText(element)) + Messages.SwitchYardExplorerLabelProvider_BindingNode;
        }
        return super.getText(element);
    }

    private String named(String name) {
        if (name == null || name.length() == 0) {
            return Messages.SwitchYardExplorerLabelProvider_UnnamedNode;
        }
        return name;
    }
}

