/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.switchyard.tools.ui.Activator;
import org.switchyard.tools.ui.explorer.ISwitchYardNode;
import org.switchyard.tools.ui.wizards.RepositoryArtifactReferenceWizard;

public class AddArtifactReferenceAction
extends ActionDelegate
implements IObjectActionDelegate {
    private IProject _project;
    private IWorkbenchPart _targetPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this._targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this._project = null;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof IProject) {
            this._project = (IProject)obj;
        } else if (obj instanceof ISwitchYardNode) {
            this._project = ((ISwitchYardNode)obj).getRoot().getProject();
        }
    }

    public void run(IAction action) {
        if (this._project == null || this._targetPart == null) {
            return;
        }
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("AddArtifactReferenceAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("AddArtifactReferenceAction");
        }
        RepositoryArtifactReferenceWizard wizard = new RepositoryArtifactReferenceWizard();
        wizard.setDialogSettings(wizardSettings);
        wizard.init(this._targetPart.getSite().getWorkbenchWindow().getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this._project));
        new WizardDialog(this._targetPart.getSite().getShell(), (IWizard)wizard).open();
    }

    public void dispose() {
        this._project = null;
        this._targetPart = null;
        super.dispose();
    }
}

