/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.wizards;

import java.io.File;
import java.text.StringCharacterIterator;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.dialog.IValidationMessageProvider;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelConfigurationHelper;
import org.jboss.tools.fuse.transformation.editor.internal.util.JavaUtil;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.Model;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.WizardControlDecorationUpdater;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.WizardValidationMessageProvider;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.XformWizardPage;
import org.jboss.tools.fuse.transformation.editor.wizards.NewTransformationWizard;

public class StartPage
extends XformWizardPage {
    private Composite _page;
    private ComboViewer _projectCombo;
    private Text _idText;
    private Text _dozerPathText;
    private Text _camelFilePathText;
    private ComboViewer _sourceCV;
    private ComboViewer _targetCV;

    public StartPage(Model model) {
        super("New Transformation", "New Transformation", Activator.imageDescriptor("transform.png"), model);
        this.observablesManager.addObservablesFromContext(this.context, true, true);
    }

    @Override
    public void createControl(final Composite parent) {
        this.setDescription("Supply the ID, project, and path, as well as the source and target types for the transformation.");
        this.observablesManager.runAndCollect(new Runnable(){

            @Override
            public void run() {
                StartPage.this.createPage(parent);
            }
        });
        WizardPageSupport wps = WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.context);
        wps.setValidationMessageProvider((IValidationMessageProvider)new WizardValidationMessageProvider());
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    private void createPage(Composite parent) {
        this._page = new Composite(parent, 0);
        this.setControl((Control)this._page);
        GridLayout layout = new GridLayout(3, false);
        layout.marginRight = 5;
        layout.horizontalSpacing = 10;
        this._page.setLayout((Layout)layout);
        Label label = this.createLabel(this._page, "Project:", "The project to contain the mapping file.");
        this._projectCombo = new ComboViewer(new Combo(this._page, 8));
        this._projectCombo.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._projectCombo.getCombo().setToolTipText(label.getToolTipText());
        this._projectCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((IProject)element).getName();
            }
        });
        label = this.createLabel(this._page, "Transformation ID:", "The transformation ID that will be shown in the Fuse editor.");
        this._idText = new Text(this._page, 2048);
        this._idText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this._idText.setToolTipText(label.getToolTipText());
        label = this.createLabel(this._page, "Dozer File Path:", "The path to the Dozer transformation file.");
        this._dozerPathText = new Text(this._page, 2048);
        this._dozerPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._dozerPathText.setToolTipText(label.getToolTipText());
        Button dozerPathButton = new Button(this._page, 0);
        dozerPathButton.setLayoutData((Object)new GridData());
        dozerPathButton.setText("...");
        dozerPathButton.setToolTipText("Browse to select an available Dozer file to overwrite.");
        dozerPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IResource res = Util.selectResourceFromWorkspace(StartPage.this.getShell(), ".xml", StartPage.this.model.getProject());
                if (res != null) {
                    IPath respath = JavaUtil.getJavaPathForResource(res);
                    String path = respath.makeRelative().toString();
                    StartPage.this.model.setFilePath(path);
                    StartPage.this._dozerPathText.setText(path);
                    StartPage.this._dozerPathText.notifyListeners(24, new Event());
                }
            }
        });
        label = this.createLabel(this._page, "Camel File Path:", "The path to the Camel configuration file.");
        this._camelFilePathText = new Text(this._page, 2048);
        this._camelFilePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this._camelFilePathText.setToolTipText(label.getToolTipText());
        Button camelPathButton = new Button(this._page, 0);
        camelPathButton.setText("...");
        camelPathButton.setToolTipText("Browse to select an available Camel file.");
        camelPathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IResource res = Util.selectCamelResourceFromWorkspace(StartPage.this.getShell(), StartPage.this.model.getProject());
                if (res != null) {
                    IPath respath = JavaUtil.getJavaPathForResource(res);
                    String path = respath.makeRelative().toString();
                    StartPage.this.model.setCamelFilePath(path);
                    StartPage.this._camelFilePathText.setText(path);
                    if (StartPage.this.model.getProject() == null) {
                        StartPage.this.model.setProject(res.getProject());
                        StartPage.this._projectCombo.getCombo().notifyListeners(24, new Event());
                    }
                    StartPage.this._camelFilePathText.notifyListeners(24, new Event());
                }
            }
        });
        label = this.createLabel(this._page, "", "");
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        Group group = new Group(this._page, 16);
        group.setText("Types Transformed");
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 2));
        this.createLabel((Composite)group, "Source Type", "Data type for the source being transformed.");
        this.createLabel((Composite)group, "", "");
        this.createLabel((Composite)group, "Target Type", "Data type for the target of the transformation.");
        this._sourceCV = new ComboViewer(new Combo((Composite)group, 8));
        this._sourceCV.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)group, 0).setImage(Activator.imageDescriptor("mapped16.gif").createImage());
        this._targetCV = new ComboViewer(new Combo((Composite)group, 8));
        this._targetCV.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.bindControls();
        this.initialize();
        this.validatePage();
    }

    private void initialize() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.model.projects.clear();
        this.model.projects.addAll(Arrays.asList(projects));
        Iterator<IProject> iter = this.model.projects.iterator();
        while (iter.hasNext()) {
            IProject toTest = iter.next();
            if (toTest.isOpen() && Util.projectHasCamelResource(toTest)) continue;
            iter.remove();
        }
        this._projectCombo.setInput((Object)Properties.selfList(IProject.class).observe(this.model.projects));
        if (this.model.getProject() == null) {
            this._projectCombo.getCombo().setFocus();
        } else {
            this._idText.setFocus();
        }
        this._page.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (StartPage.this.model.getProject() == null) {
                    StartPage.this._projectCombo.getCombo().setFocus();
                } else {
                    StartPage.this._idText.setFocus();
                }
                StartPage.this._page.removePaintListener((PaintListener)this);
            }
        });
        for (Object observable : this.context.getValidationStatusProviders()) {
            ((Binding)observable).getTarget().addChangeListener(new IChangeListener(){

                public void handleChange(ChangeEvent event) {
                    StartPage.this.validatePage();
                }
            });
        }
        if (this.model.getProject() != null) {
            this._projectCombo.setSelection((ISelection)new StructuredSelection((Object)this.model.getProject()));
        }
        if (this.model.getCamelFilePath() != null) {
            this._camelFilePathText.setText(this.model.getCamelFilePath());
            this._camelFilePathText.notifyListeners(24, new Event());
        }
        if (this.model.getFilePath() != null) {
            this._dozerPathText.setText(this.model.getFilePath());
            this._dozerPathText.notifyListeners(24, new Event());
        }
        if (this.model.getId() != null) {
            this._idText.setText(this.model.getId());
            this._idText.notifyListeners(24, new Event());
        }
    }

    private void bindControls() {
        this._projectCombo.setContentProvider((IContentProvider)new ObservableListContentProvider());
        IViewerObservableValue widgetValue = ViewerProperties.singleSelection().observe((Viewer)this._projectCombo);
        IObservableValue modelValue = BeanProperties.value(Model.class, (String)"project").observe((Object)this.model);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (value == null) {
                    return ValidationStatus.error((String)"A project must be selected");
                }
                return ValidationStatus.ok();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null), (int)this.decoratorPosition, (Composite)this._projectCombo.getControl().getParent(), (ControlDecorationUpdater)new WizardControlDecorationUpdater());
        widgetValue = WidgetProperties.text((int)24).observe((Widget)this._idText);
        modelValue = BeanProperties.value(Model.class, (String)"id").observe((Object)this.model);
        strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || value.toString().trim().isEmpty()) {
                    return ValidationStatus.error((String)"A transformation ID must be supplied");
                }
                String id = value.toString().trim();
                StringCharacterIterator iter = new StringCharacterIterator(id);
                char chr = iter.first();
                while (chr != '\uffff') {
                    if (!Character.isJavaIdentifierPart(chr)) {
                        return ValidationStatus.error((String)"The transformation ID may only contain letters, digits, currency symbols, or underscores");
                    }
                    chr = iter.next();
                }
                if (StartPage.this.model.camelConfig != null && StartPage.this.model.camelConfig.getConfigBuilder() != null) {
                    for (String endpointId : StartPage.this.model.camelConfig.getConfigBuilder().getTransformEndpointIds()) {
                        if (!id.equalsIgnoreCase(endpointId)) continue;
                        return ValidationStatus.error((String)"A transformation with the supplied ID already exists");
                    }
                }
                return ValidationStatus.ok();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null), (int)this.decoratorPosition, (Composite)this._idText.getParent(), (ControlDecorationUpdater)new WizardControlDecorationUpdater());
        widgetValue = WidgetProperties.text((int)24).observe((Widget)this._dozerPathText);
        modelValue = BeanProperties.value(Model.class, (String)"filePath").observe((Object)this.model);
        strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                IFile file;
                if (value == null || value.toString().trim().isEmpty()) {
                    return ValidationStatus.error((String)"The transformation file path must be supplied");
                }
                if (!value.toString().trim().isEmpty() && StartPage.this.model.getProject() != null && (file = StartPage.this.model.getProject().getFile("src/main/resources/" + (String)value)) != null && file.exists()) {
                    return ValidationStatus.warning((String)"A transformation file with that name already exists.");
                }
                return ValidationStatus.ok();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null), (int)this.decoratorPosition, null, (ControlDecorationUpdater)new WizardControlDecorationUpdater());
        widgetValue = WidgetProperties.text((int)24).observe((Widget)this._camelFilePathText);
        modelValue = BeanProperties.value(Model.class, (String)"camelFilePath").observe((Object)this.model);
        strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || value.toString().trim().isEmpty()) {
                    return ValidationStatus.error((String)"The Camel file path must be supplied");
                }
                if (!value.toString().trim().isEmpty()) {
                    File testFile = null;
                    String path = (String)value;
                    testFile = new File(StartPage.this.model.getProject().getFile(path).getLocationURI());
                    if (!testFile.exists() && !(testFile = new File(StartPage.this.model.getProject().getFile("src/main/resources/" + path).getLocationURI())).exists()) {
                        return ValidationStatus.error((String)"The Camel file path must be a valid file location");
                    }
                    try {
                        CamelConfigurationHelper.load(testFile).getConfigBuilder();
                    }
                    catch (Exception exception) {
                        return ValidationStatus.error((String)"The Camel file path must refer to a valid Camel file");
                    }
                }
                return ValidationStatus.ok();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null), (int)this.decoratorPosition, null, (ControlDecorationUpdater)new WizardControlDecorationUpdater());
        this._sourceCV.setContentProvider((IContentProvider)new ObservableListContentProvider());
        widgetValue = ViewerProperties.singleSelection().observe((Viewer)this._sourceCV);
        modelValue = BeanProperties.value(Model.class, (String)"sourceTypeStr").observe((Object)this.model);
        strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                StartPage.this.getModel().setSourceFilePath(new String());
                ((NewTransformationWizard)StartPage.this.getWizard()).resetSourceAndTargetPages();
                if (StartPage.this.getSourcePage() != null) {
                    ((XformWizardPage)StartPage.this.getSourcePage()).clearControls();
                }
                UIJob uiJob = new UIJob("open error"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (StartPage.this.getTargetPage() != null) {
                            ((XformWizardPage)StartPage.this.getTargetPage()).pingBinding();
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.setSystem(true);
                uiJob.schedule();
                if (value == null || ((String)value).trim().isEmpty()) {
                    return ValidationStatus.error((String)"A source type must be selected");
                }
                return ValidationStatus.ok();
            }
        });
        WritableList sourceList = new WritableList();
        sourceList.add((Object)"Java");
        sourceList.add((Object)"XML");
        sourceList.add((Object)"JSON");
        sourceList.add((Object)"Other");
        sourceList.add((Object)"");
        this._sourceCV.setInput((Object)sourceList);
        ControlDecorationSupport.create((ValidationStatusProvider)this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null), (int)this.decoratorPosition, null, (ControlDecorationUpdater)new WizardControlDecorationUpdater());
        this._targetCV.setContentProvider((IContentProvider)new ObservableListContentProvider());
        widgetValue = ViewerProperties.singleSelection().observe((Viewer)this._targetCV);
        modelValue = BeanProperties.value(Model.class, (String)"targetTypeStr").observe((Object)this.model);
        strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                StartPage.this.getModel().setTargetFilePath(new String());
                ((NewTransformationWizard)StartPage.this.getWizard()).resetSourceAndTargetPages();
                if (StartPage.this.getTargetPage() != null) {
                    ((XformWizardPage)StartPage.this.getTargetPage()).clearControls();
                }
                UIJob uiJob = new UIJob("open error"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (StartPage.this.getSourcePage() != null) {
                            ((XformWizardPage)StartPage.this.getSourcePage()).pingBinding();
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.setSystem(true);
                uiJob.schedule();
                if (value == null || ((String)value).trim().isEmpty()) {
                    return ValidationStatus.error((String)"A target type must be selected");
                }
                return ValidationStatus.ok();
            }
        });
        WritableList targetList = new WritableList();
        targetList.add((Object)"Java");
        targetList.add((Object)"XML");
        targetList.add((Object)"JSON");
        targetList.add((Object)"Other");
        targetList.add((Object)"");
        this._targetCV.setInput((Object)targetList);
        ControlDecorationSupport.create((ValidationStatusProvider)this.context.bindValue((IObservableValue)widgetValue, modelValue, strategy, null), (int)this.decoratorPosition, null, (ControlDecorationUpdater)new WizardControlDecorationUpdater());
        this.listenForValidationChanges();
    }
}

