/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.tools.fuse.transformation.editor.internal.util.CamelConfigurationHelper;
import org.jboss.tools.fuse.transformation.editor.internal.wizards.ModelType;

public class Model
implements PropertyChangeListener {
    private static final String DEFAULT_FILE_PATH = "transformation.xml";
    public final List<IProject> projects = new ArrayList<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
    public CamelConfigurationHelper camelConfig;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private IProject project;
    private String id;
    private String filePath = "transformation.xml";
    private String sourceFilePath;
    private String targetFilePath;
    private ModelType sourceType;
    private ModelType targetType;
    private String camelFilePath;
    private String sourceTypeStr;
    private String targetTypeStr;
    private String sourceDataFormatid;
    private String targetDataFormatid;
    private String sourceClassName;
    private String targetClassName;

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public String getCamelFilePath() {
        return this.camelFilePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getId() {
        return this.id;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getSourceFilePath() {
        return this.sourceFilePath;
    }

    public ModelType getSourceType() {
        return this.sourceType;
    }

    public String getTargetFilePath() {
        return this.targetFilePath;
    }

    public ModelType getTargetType() {
        return this.targetType;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.changeSupport.firePropertyChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void setCamelFilePath(String filePath) {
        this.camelFilePath = filePath.trim();
        this.changeSupport.firePropertyChange("camelFilePath", this.camelFilePath, this.camelFilePath);
        this.setProject(this.project);
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath.trim();
        this.changeSupport.firePropertyChange("filePath", this.filePath, this.filePath);
    }

    public void setId(String id) {
        this.id = id.trim();
        this.changeSupport.firePropertyChange("id", this.id, this.id);
    }

    public void setProject(IProject project) {
        this.project = project;
        this.changeSupport.firePropertyChange("project", this.project, this.project);
        if (this.camelFilePath != null && !this.camelFilePath.trim().isEmpty()) {
            try {
                IFile test = project.getFile(this.camelFilePath);
                if (!test.exists()) {
                    test = project.getFile("src/main/resources/" + this.camelFilePath);
                }
                if (test != null && test.exists()) {
                    File camelFile = new File(test.getLocationURI());
                    this.camelConfig = CamelConfigurationHelper.load(camelFile);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setSourceFilePath(String sourceFilePath) {
        this.sourceFilePath = sourceFilePath.trim();
        this.changeSupport.firePropertyChange("sourceFilePath", this.sourceFilePath, this.sourceFilePath);
    }

    public void setSourceType(ModelType sourceType) {
        this.sourceType = sourceType;
        this.changeSupport.firePropertyChange("sourceType", (Object)this.sourceType, (Object)this.sourceType);
    }

    public void setTargetFilePath(String targetFilePath) {
        this.targetFilePath = targetFilePath.trim();
        this.changeSupport.firePropertyChange("targetFilePath", this.targetFilePath, this.targetFilePath);
    }

    public void setTargetType(ModelType targetType) {
        this.targetType = targetType;
        this.changeSupport.firePropertyChange("targetType", (Object)this.targetType, (Object)this.targetType);
    }

    public String getSourceTypeStr() {
        return this.sourceTypeStr;
    }

    public void setSourceTypeStr(String sourceTypeStr) {
        this.sourceTypeStr = sourceTypeStr;
        this.changeSupport.firePropertyChange("sourceTypeStr", this.sourceTypeStr, this.sourceTypeStr);
    }

    public String getTargetTypeStr() {
        return this.targetTypeStr;
    }

    public void setTargetTypeStr(String targetTypeStr) {
        this.targetTypeStr = targetTypeStr;
        this.changeSupport.firePropertyChange("targetTypeStr", this.targetTypeStr, this.targetTypeStr);
    }

    public String getSourceDataFormatid() {
        return this.sourceDataFormatid;
    }

    public void setSourceDataFormatid(String sourceDataFormatid) {
        this.sourceDataFormatid = sourceDataFormatid.trim();
        this.changeSupport.firePropertyChange("sourceDataFormatid", this.sourceDataFormatid, this.sourceDataFormatid);
    }

    public String getTargetDataFormatid() {
        return this.targetDataFormatid;
    }

    public void setTargetDataFormatid(String targetDataFormatid) {
        this.targetDataFormatid = targetDataFormatid.trim();
        this.changeSupport.firePropertyChange("targetDataFormatid", this.targetDataFormatid, this.targetDataFormatid);
    }

    public String getSourceClassName() {
        return this.sourceClassName;
    }

    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
    }

    public String getTargetClassName() {
        return this.targetClassName;
    }

    public void setTargetClassName(String targetClassName) {
        this.targetClassName = targetClassName;
    }
}

