/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.fuse.transformation.editor.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.fuse.transformation.editor.Activator;
import org.jboss.tools.fuse.transformation.editor.internal.MappingsViewer;
import org.jboss.tools.fuse.transformation.editor.internal.util.BaseDialog;
import org.jboss.tools.fuse.transformation.editor.internal.util.Util;

final class AddCustomFunctionDialog
extends BaseDialog {
    IProject project;
    String sourceType;
    IType type;
    IMethod method;

    AddCustomFunctionDialog(Shell shell, IProject project, String sourceType) {
        super(shell);
        this.project = project;
        this.sourceType = "java.lang.String".equals(sourceType) ? "String" : sourceType;
    }

    @Override
    protected void constructContents(Composite parent) {
        parent.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        Label label = new Label(parent, 0);
        label.setText("Class:");
        final Button classButton = new Button(parent, 0);
        classButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        classButton.setAlignment(16384);
        classButton.setText("< Click to select an existing class >");
        Button newClassButton = new Button(parent, 0);
        newClassButton.setImage(new DecorationOverlayIcon(JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif"), Util.Decorations.ADD, 1).createImage());
        label = new Label(parent, 0);
        label.setText("Method:");
        final ComboViewer methodComboViewer = new ComboViewer(parent, 8);
        methodComboViewer.getCombo().setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).create());
        methodComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        methodComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IMethod method = (IMethod)element;
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append(Signature.getSignatureSimpleName((String)method.getReturnType()));
                    builder.append(" ");
                    builder.append(method.getElementName());
                    builder.append("(");
                    String[] types = method.getParameterTypes();
                    String[] names = method.getParameterNames();
                    boolean hasPrm = false;
                    int ndx = 0;
                    while (ndx < types.length) {
                        if (hasPrm) {
                            builder.append(", ");
                        } else {
                            builder.append(" ");
                            hasPrm = true;
                        }
                        builder.append(Signature.getSignatureSimpleName((String)types[ndx]));
                        builder.append(" ");
                        builder.append(names[ndx]);
                        ++ndx;
                    }
                    if (hasPrm) {
                        builder.append(" ");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                catch (JavaModelException javaModelException) {
                    return "";
                }
            }
        });
        methodComboViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                String[] types2;
                IMethod method1 = (IMethod)object1;
                IMethod method2 = (IMethod)object2;
                int comparison = method1.getElementName().compareTo(method2.getElementName());
                if (comparison != 0) {
                    return comparison;
                }
                String[] types1 = method1.getParameterTypes();
                comparison = types1.length - (types2 = method2.getParameterTypes()).length;
                if (comparison != 0) {
                    return comparison;
                }
                int ndx = 0;
                while (ndx < types1.length) {
                    comparison = Signature.getSignatureSimpleName((String)types1[ndx]).compareTo(Signature.getSignatureSimpleName((String)types2[ndx]));
                    if (comparison != 0) {
                        return comparison;
                    }
                    ++ndx;
                }
                return 0;
            }
        });
        methodComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddCustomFunctionDialog.this.methodSelected(methodComboViewer);
            }
        });
        classButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddCustomFunctionDialog.this.selectClass(classButton, methodComboViewer);
            }
        });
        newClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AddCustomFunctionDialog.this.createNewClass(classButton, methodComboViewer);
            }
        });
    }

    void createNewClass(Button classButton, ComboViewer methodComboViewer) {
        OpenNewClassWizardAction action = new OpenNewClassWizardAction();
        action.setSelection((IStructuredSelection)new StructuredSelection((Object)this.project));
        Page page = new Page(this.sourceType);
        page.init((IStructuredSelection)new StructuredSelection((Object)this.project));
        action.setConfiguredWizardPage((NewClassWizardPage)page);
        action.run();
        IType type = (IType)action.getCreatedElement();
        if (type != null) {
            try {
                type.createMethod("public " + page.returnType + " " + page.methodName + "(" + page.prmType + " input) {\n" + "\treturn null;\n" + "}", null, false, null);
                if (type.getCompilationUnit().isWorkingCopy()) {
                    type.getCompilationUnit().commitWorkingCopy(true, null);
                }
                this.setClass(type, classButton, methodComboViewer);
            }
            catch (JavaModelException e) {
                Activator.error(e);
            }
        }
    }

    @Override
    protected String message() {
        return "Select or create the Java class and method that implements the custom operation";
    }

    void methodSelected(ComboViewer methodComboViewer) {
        IStructuredSelection selection = (IStructuredSelection)methodComboViewer.getSelection();
        this.method = (IMethod)selection.getFirstElement();
    }

    void selectClass(Button classButton, ComboViewer methodComboViewer) {
        Util.Filter filter = new Util.Filter(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean accept(IType type) {
                try {
                    IMethod[] iMethodArray = type.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IMethod method = iMethodArray[n2];
                        if (AddCustomFunctionDialog.this.valid(method)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
                return false;
            }
        };
        IType type = Util.selectClass(this.getShell(), this.project, filter);
        if (type != null) {
            this.setClass(type, classButton, methodComboViewer);
        }
    }

    void setClass(IType type, Button classButton, ComboViewer methodComboViewer) {
        try {
            classButton.setText(type.getFullyQualifiedName());
            ArrayList<IMethod> methods = new ArrayList<IMethod>(Arrays.asList(type.getMethods()));
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                if (this.valid((IMethod)iter.next())) continue;
                iter.remove();
            }
            methodComboViewer.setInput((Object)methods.toArray());
            if (!methods.isEmpty()) {
                methodComboViewer.setSelection((ISelection)new StructuredSelection(methods.get(0)));
            }
            this.type = type;
            this.getButton(0).setEnabled(true);
        }
        catch (JavaModelException e) {
            Activator.error(e);
        }
    }

    @Override
    protected String title() {
        return "Add Custom Operation";
    }

    boolean valid(IMethod method) {
        try {
            return !Signature.getSignatureSimpleName((String)method.getReturnType()).equals("void") && method.getParameters().length == 1;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private class Page
    extends NewClassWizardPage {
        String sourceType;
        String returnType;
        String methodName;
        String prmType;
        IStatus returnTypeStatus = this.typeStatus(null, "return");
        IStatus methodNameStatus = this.nameStatus(null, "method");
        IStatus prmTypeStatus = this.typeStatus(null, "parameter");
        Control pkgText;

        Page(String sourceType) {
            this.sourceType = sourceType;
        }

        private void createComboPane(Composite parent, String initialText, String labelText, final MappingsViewer.CustomFunctionListener listener) {
            final Combo combo = new Combo(parent, 8);
            combo.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
            combo.setItems(new String[]{"boolean", "byte", "char", "double", "float", "int", "java.util.List< ? >", "long", "Object", "short", "String"});
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    listener.functionChanged(combo.getText());
                }
            });
            combo.select(combo.indexOf(initialText));
            listener.functionChanged(initialText);
            Label label = new Label(parent, 0);
            label.setText(labelText);
        }

        protected void createEnclosingTypeControls(Composite composite, int columns) {
        }

        private void createLabelPane(Composite parent, String text) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
            label.setText(text);
        }

        protected void createModifierControls(Composite composite, int columns) {
        }

        protected void createPackageControls(Composite composite, int nColumns) {
            super.createPackageControls(composite, nColumns);
            this.pkgText = composite.getChildren()[4];
        }

        protected void createSuperInterfacesControls(Composite composite, int columns) {
            super.createSuperInterfacesControls(composite, columns);
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)GridDataFactory.fillDefaults().span(columns, 1).grab(true, false).create());
            group.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(6).create());
            group.setText("Custom Function");
            this.createLabelPane((Composite)group, "Return Type");
            this.createLabelPane((Composite)group, "Method Name");
            this.createLabelPane((Composite)group, "Parameter Type");
            this.createComboPane((Composite)group, this.sourceType, " ", new MappingsViewer.CustomFunctionListener(){

                @Override
                public void functionChanged(String text) {
                    Page.this.returnType = text;
                    Page.this.returnTypeStatus = Page.this.typeStatus(Page.this.returnType, "return");
                    Page.this.updateStatus();
                }
            });
            this.createTextPane((Composite)group, "map", "(", new MappingsViewer.CustomFunctionListener(){

                @Override
                public void functionChanged(String text) {
                    Page.this.methodName = text.trim();
                    Page.this.methodNameStatus = Page.this.nameStatus(Page.this.methodName, "method");
                    Page.this.updateStatus();
                }
            });
            this.createComboPane((Composite)group, this.sourceType, " input)", new MappingsViewer.CustomFunctionListener(){

                @Override
                public void functionChanged(String text) {
                    Page.this.prmType = text;
                    Page.this.prmTypeStatus = Page.this.typeStatus(Page.this.prmType, "parameter");
                    Page.this.updateStatus();
                }
            });
        }

        private Text createTextPane(Composite parent, String initialText, String labelText, final MappingsViewer.CustomFunctionListener listener) {
            final Text text = new Text(parent, 2048);
            text.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    listener.functionChanged(text.getText());
                }
            });
            text.setText(initialText);
            Label label = new Label(parent, 0);
            label.setText(labelText);
            return text;
        }

        IStatus nameStatus(String name, String nameName) {
            if (name == null || name.isEmpty()) {
                return new Status(4, Activator.plugin().getBundle().getSymbolicName(), "A " + nameName + " name for the custom operation must be provided");
            }
            char[] chars = name.toCharArray();
            char firstChar = chars[0];
            if (!Character.isJavaIdentifierStart(firstChar)) {
                return new Status(4, Activator.plugin().getBundle().getSymbolicName(), "The " + nameName + " name for the custom operation begins with an invalid character");
            }
            int ndx = 1;
            while (ndx < chars.length) {
                if (!Character.isJavaIdentifierPart(chars[ndx])) {
                    return new Status(4, Activator.plugin().getBundle().getSymbolicName(), "The " + nameName + " name for the custom operation contains at least one invalid character");
                }
                ++ndx;
            }
            if (Character.isUpperCase(firstChar)) {
                return new Status(2, Activator.plugin().getBundle().getSymbolicName(), "The " + nameName + " name for the custom operation begins with an uppercase letter");
            }
            return Status.OK_STATUS;
        }

        protected void setFocus() {
            this.pkgText.setFocus();
        }

        IStatus typeStatus(String type, String typeName) {
            if (type == null) {
                return new Status(4, Activator.plugin().getBundle().getSymbolicName(), "A " + typeName + " type for the custom operation must be selected");
            }
            return Status.OK_STATUS;
        }

        void updateStatus() {
            this.updateStatus(new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus});
        }

        protected void updateStatus(IStatus[] status) {
            ArrayList<IStatus> list = new ArrayList<IStatus>(Arrays.asList(status));
            list.add(this.returnTypeStatus);
            list.add(this.methodNameStatus);
            list.add(this.prmTypeStatus);
            super.updateStatus(list.toArray(new IStatus[list.size()]));
        }
    }
}

