/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.tools.ui.debug;

import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.tools.ui.debug.IConditionBuilder;
import org.switchyard.tools.ui.debug.IInteractionConfiguration;

public class CamelExchangeConditionBuilder
implements IConditionBuilder {
    private final String _exchangeVariable;

    public CamelExchangeConditionBuilder(String exchangeVariable) {
        this._exchangeVariable = exchangeVariable;
    }

    @Override
    public String provider(QName name) {
        if (name == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String serviceReferenceString = String.valueOf(this._exchangeVariable) + ".getProperty(\"org.switchyard.bus.camel.consumer\", org.switchyard.ServiceReference.class)";
        buffer.append(serviceReferenceString).append(" != null && ");
        buffer.append(serviceReferenceString).append(".getTargetServiceName() != null && ");
        buffer.append('\"').append(name.toString()).append('\"').append(".equals(").append(serviceReferenceString).append(".getTargetServiceName().toString())");
        return buffer.toString();
    }

    @Override
    public String consumer(QName name) {
        if (name == null) {
            return null;
        }
        String serviceReferenceString = String.valueOf(this._exchangeVariable) + ".getProperty(\"org.switchyard.bus.camel.consumer\", org.switchyard.ServiceReference.class)";
        StringBuffer buffer = new StringBuffer();
        buffer.append(serviceReferenceString).append(" != null && ");
        buffer.append('\"').append(name.toString()).append('\"').append(".equals(").append(serviceReferenceString).append(".getName().toString())");
        return buffer.toString();
    }

    @Override
    public String exchangePhase(Set<IInteractionConfiguration.TriggerType> triggers) {
        StringBuffer buffer = new StringBuffer();
        boolean addOr = false;
        buffer.append("(");
        if (triggers.contains((Object)IInteractionConfiguration.TriggerType.IN)) {
            if (triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT)) {
                return null;
            }
            buffer.append("org.switchyard.ExchangePhase.IN == ").append(this._exchangeVariable).append(".getProperty(\"org.switchyard.bus.camel.phase\", org.switchyard.ExchangePhase.class)");
            addOr = true;
        }
        if (triggers.contains((Object)IInteractionConfiguration.TriggerType.OUT)) {
            if (addOr) {
                buffer.append("\n            || ");
            }
            buffer.append("org.switchyard.ExchangePhase.OUT == ").append(this._exchangeVariable).append(".getProperty(\"org.switchyard.bus.camel.phase\", org.switchyard.ExchangePhase.class)");
        } else if (triggers.contains((Object)IInteractionConfiguration.TriggerType.FAULT)) {
            if (addOr) {
                buffer.append("\n            || ");
            }
            buffer.append(this.exchangeState(true));
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public String exchangeState(boolean fault) {
        StringBuffer buffer = new StringBuffer();
        if (!fault) {
            buffer.append('!');
        }
        buffer.append(this._exchangeVariable).append(".getProperty(\"org.switchyard.bus.camel.fault\", false, Boolean.class)");
        return buffer.toString();
    }
}

