/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.core.utils.JavaProjectClassLoader;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.Messages;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.FileSelectionGroup;
import org.eclipse.bpmn2.modeler.ui.property.providers.BPMN2DefinitionsTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.JavaTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.ModelTreeLabelProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.ServiceTreeContentProvider;
import org.eclipse.bpmn2.modeler.ui.property.providers.TreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.VariableTypeTreeContentProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.xsd.XSDSchema;

public class DefaultSchemaImportDialog
extends SelectionStatusDialog {
    protected static final int BID_BROWSE_WORKSPACE = 1025;
    protected static final int BID_BROWSE_URL = 1026;
    protected static final int BID_BROWSE_FILE = 1027;
    protected static final int BID_BROWSE = 1028;
    protected static final int BID_IMPORT_XML = 1030;
    protected static final int BID_IMPORT_XSD = 1031;
    protected static final int BID_IMPORT_WSDL = 1032;
    protected static final int BID_IMPORT_BPMN2 = 1033;
    protected static final int BID_IMPORT_JAVA = 1034;
    protected int fImportType = 1031;
    protected int fImportSource = 1025;
    protected static final String IMPORT_TYPE = "ImportType";
    protected static final String IMPORT_SOURCE = "ImportSource";
    protected static final String EMPTY = "";
    protected String[] FILTER_EXTENSIONS;
    protected String[] FILTER_NAMES;
    protected String resourceFilter;
    protected String fResourceKind;
    protected BPMN2Editor bpmn2Editor;
    protected EObject modelObject;
    protected int allowedResourceTypes;
    protected Tree fTree;
    protected TreeViewer fTreeViewer;
    protected Text fLocation;
    protected String fLocationText;
    protected Label fLocationLabel;
    protected Label fStructureLabel;
    protected Composite fLocationComposite;
    protected FileSelectionGroup fResourceComposite;
    protected Text filterText;
    protected String fFilter = "";
    protected Button fBrowseButton;
    protected Group fTypeGroup;
    protected Group fKindGroup;
    protected Composite fKindButtonComposite;
    protected IDialogSettings fSettings;
    protected String fStructureTitle;
    protected ITreeContentProvider fTreeContentProvider;
    protected Object fInput;
    protected Bpmn2ModelerResourceSetImpl fHackedResourceSet;
    long fRunnableStart;
    protected URI fRunnableLoadURI;
    protected Job fLoaderJob;
    protected IPreferenceStore fPrefStore = Activator.getDefault().getPreferenceStore();
    protected Button fBtnResource;

    public DefaultSchemaImportDialog(Shell parent, int allowedResourceTypes) {
        super(parent);
        this.setStatusLineAboveButtons(true);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.fSettings = Activator.getDefault().getDialogSettingsFor((Object)this);
        try {
            this.fImportSource = this.fSettings.getInt(IMPORT_SOURCE);
            this.fImportType = this.fSettings.getInt(IMPORT_TYPE);
        }
        catch (NumberFormatException numberFormatException) {
            this.fImportSource = 1025;
            this.fImportType = 1031;
        }
        this.setDialogBoundsSettings(this.fSettings, this.getDialogBoundsStrategy());
        this.allowedResourceTypes = allowedResourceTypes;
        if ((allowedResourceTypes & 1) == 0 && (this.fImportType == 1030 || this.fImportType == 1031)) {
            this.fImportType = 0;
        }
        if ((allowedResourceTypes & 2) == 0 && this.fImportType == 1032) {
            this.fImportType = 0;
        }
        if ((allowedResourceTypes & 4) == 0 && this.fImportType == 1033) {
            this.fImportType = 0;
        }
        if ((allowedResourceTypes & 8) == 0 && this.fImportType == 1034) {
            this.fImportType = 0;
        }
        if (this.fImportType == 0) {
            if ((allowedResourceTypes & 1) != 0) {
                this.fImportType = 1031;
            }
            if ((allowedResourceTypes & 2) != 0) {
                this.fImportType = 1032;
            }
            if ((allowedResourceTypes & 4) != 0) {
                this.fImportType = 1033;
            }
            if ((allowedResourceTypes & 8) != 0) {
                this.fImportType = 1034;
            }
        }
        if (this.fImportType == 1030) {
            this.configureAsXMLImport();
        } else if (this.fImportType == 1031) {
            this.configureAsSchemaImport();
        } else if (this.fImportType == 1032) {
            this.configureAsWSDLImport();
        } else if (this.fImportType == 1033) {
            this.configureAsBPMN2Import();
        } else if (this.fImportType == 1034) {
            this.configureAsJavaImport();
        }
        this.bpmn2Editor = BPMN2Editor.getActiveEditor();
        ResourceSet rs = this.bpmn2Editor.getResourceSet();
        this.fHackedResourceSet = ModelUtil.slightlyHackedResourceSet((ResourceSet)rs);
    }

    public DefaultSchemaImportDialog(Shell parent) {
        this(parent, -1);
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createImportType(contents);
        this.createImportLocation(contents);
        this.createImportStructure(contents);
        this.buttonPressed(this.fImportSource, true);
        return contents;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1028: {
                if (this.fImportSource == 1026) {
                    String loc = this.fLocation.getText();
                    if (loc.length() <= 0) break;
                    this.attemptLoad(loc);
                    break;
                }
                FileDialog fileDialog = new FileDialog(this.getShell());
                fileDialog.setFilterExtensions(this.FILTER_EXTENSIONS);
                fileDialog.setFilterNames(this.FILTER_NAMES);
                String path = fileDialog.open();
                if (path == null) {
                    return;
                }
                this.fLocation.setText(path);
                this.attemptLoad(path);
                break;
            }
            case 1: {
                if (this.fLoaderJob != null && this.fLoaderJob.getState() == 4) {
                    this.fLoaderJob.cancel();
                }
                this.setSelectionResult(null);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void buttonPressed(int id, boolean checked) {
        if (id == 1027 || id == 1025 || id == 1026) {
            if (!checked) {
                return;
            }
            this.fImportSource = id;
            this.fSettings.put(IMPORT_SOURCE, this.fImportSource);
        } else if (id == 1030 || id == 1031 || id == 1032 || id == 1033 || id == 1034) {
            if (!checked) {
                return;
            }
            if (id == 1030) {
                this.configureAsXMLImport();
                this.setVisibleControl((Control)this.fKindButtonComposite, true);
            } else if (id == 1031) {
                this.configureAsSchemaImport();
                this.setVisibleControl((Control)this.fKindButtonComposite, true);
            } else if (id == 1032) {
                this.configureAsWSDLImport();
                this.setVisibleControl((Control)this.fKindButtonComposite, true);
            } else if (id == 1033) {
                this.configureAsBPMN2Import();
                this.setVisibleControl((Control)this.fKindButtonComposite, true);
            } else if (id == 1034) {
                this.configureAsJavaImport();
                this.setVisibleControl((Control)this.fKindButtonComposite, false);
            }
            this.fImportType = id;
            this.fSettings.put(IMPORT_TYPE, this.fImportType);
        }
        this.setVisibleControl((Control)this.fResourceComposite, this.fImportSource == 1025 && this.fImportType != 1034);
        this.setVisibleControl((Control)this.fLocationComposite, this.fImportSource == 1026 || this.fImportSource == 1027 || this.fImportType == 1034);
        if (this.fImportType == 1034) {
            this.setVisibleControl((Control)this.fKindButtonComposite, false);
            this.setVisibleControl((Control)this.fBrowseButton, false);
            this.fLocationLabel.setText(Messages.SchemaImportDialog_Type_Label);
        } else {
            this.setVisibleControl((Control)this.fKindButtonComposite, true);
            this.setVisibleControl((Control)this.fBrowseButton, true);
            this.fLocationLabel.setText(Messages.SchemaImportDialog_Location_Label);
            this.fBrowseButton.setText(this.fImportSource == 1027 ? Messages.SchemaImportDialog_Browse_Button : Messages.SchemaImportDialog_Load_Button);
        }
        this.fLocation.setText(EMPTY);
        this.fTypeGroup.getParent().layout(true);
        this.fKindGroup.getParent().layout(true);
        this.markEmptySelection();
    }

    protected void setVisibleControl(Control c, boolean b) {
        Object layoutData = c.getLayoutData();
        if (layoutData instanceof GridData) {
            GridData data = (GridData)layoutData;
            data.exclude = !b;
        }
        c.setVisible(b);
    }

    public void create() {
        super.create();
        this.buttonPressed(this.fImportSource, true);
    }

    protected Button createRadioButton(Composite parent, String label, int id, boolean checked) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                int bid = (Integer)b.getData();
                DefaultSchemaImportDialog.this.buttonPressed(bid, b.getSelection());
            }
        });
        return button;
    }

    protected void createImportType(Composite parent) {
        Button button;
        this.fTypeGroup = new Group(parent, 16);
        this.fTypeGroup.setText(Messages.SchemaImportDialog_Import_Type_Title);
        GridLayout layout = new GridLayout(1, true);
        GridData typeGroupGridData = new GridData();
        typeGroupGridData.grabExcessVerticalSpace = false;
        typeGroupGridData.grabExcessHorizontalSpace = true;
        typeGroupGridData.horizontalAlignment = 4;
        typeGroupGridData.verticalAlignment = 4;
        this.fTypeGroup.setLayout((Layout)layout);
        this.fTypeGroup.setLayoutData((Object)typeGroupGridData);
        Composite container = new Composite((Composite)this.fTypeGroup, 0);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = false;
        layout.numColumns = 4;
        container.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        container.setLayoutData((Object)data);
        int buttonCount = 0;
        if ((this.allowedResourceTypes & 1) != 0) {
            button = this.createRadioButton(container, Messages.SchemaImportDialog_XSD_Button, 1031, this.fImportType == 1031);
            button.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            ++buttonCount;
        }
        if ((this.allowedResourceTypes & 2) != 0) {
            button = this.createRadioButton(container, Messages.SchemaImportDialog_WSDL_Button, 1032, this.fImportType == 1032);
            button.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            ++buttonCount;
        }
        if ((this.allowedResourceTypes & 4) != 0) {
            button = this.createRadioButton(container, Messages.SchemaImportDialog_BPMN2_Button, 1033, this.fImportType == 1033);
            button.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            ++buttonCount;
        }
        if ((this.allowedResourceTypes & 8) != 0) {
            button = this.createRadioButton(container, Messages.SchemaImportDialog_Java_Button, 1034, this.fImportType == 1034);
            button.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            ++buttonCount;
        }
        if (buttonCount == 1) {
            this.fTypeGroup.setVisible(false);
            typeGroupGridData.exclude = true;
        }
    }

    protected void createImportLocation(Composite parent) {
        this.fKindGroup = new Group(parent, 16);
        this.fKindGroup.setText(Messages.SchemaImportDialog_Import_Source_Title);
        GridLayout layout = new GridLayout(1, true);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fKindGroup.setLayout((Layout)layout);
        this.fKindGroup.setLayoutData((Object)data);
        this.fKindButtonComposite = new Composite((Composite)this.fKindGroup, 0);
        layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 4;
        this.fKindButtonComposite.setLayout((Layout)layout);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fKindButtonComposite.setLayoutData((Object)data);
        this.fBtnResource = this.createRadioButton(this.fKindButtonComposite, Messages.SchemaImportDialog_Workspace_Button, 1025, this.fImportSource == 1025);
        this.createRadioButton(this.fKindButtonComposite, Messages.SchemaImportDialog_File_System_Button, 1027, this.fImportSource == 1027);
        this.createRadioButton(this.fKindButtonComposite, Messages.SchemaImportDialog_URL_Button, 1026, this.fImportSource == 1026);
        this.fLocationComposite = new Composite((Composite)this.fKindGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.fLocationComposite.setLayout((Layout)layout);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fLocationComposite.setLayoutData((Object)data);
        this.fLocationLabel = new Label(this.fLocationComposite, 0);
        this.fLocationLabel.setText(Messages.SchemaImportDialog_Location_Label);
        this.fLocation = new Text(this.fLocationComposite, 2048);
        this.fLocation.setText(EMPTY);
        data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.fLocation.setLayoutData((Object)data);
        this.fLocation.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                if (DefaultSchemaImportDialog.this.fImportType != 1034 && event.keyCode == 13) {
                    DefaultSchemaImportDialog.this.attemptLoad(DefaultSchemaImportDialog.this.fLocation.getText());
                    event.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
                String s;
                if (DefaultSchemaImportDialog.this.fImportType == 1034 && (s = DefaultSchemaImportDialog.this.fLocation.getText()) != null && s.length() > 1 && !s.equals(DefaultSchemaImportDialog.this.fLocationText)) {
                    DefaultSchemaImportDialog.this.fLocationText = s;
                    DefaultSchemaImportDialog.this.attemptLoad(s);
                }
            }
        });
        this.fBrowseButton = this.createButton(this.fLocationComposite, 1028, Messages.SchemaImportDialog_Browse_Button, false);
        this.fResourceComposite = new FileSelectionGroup((Composite)this.fKindGroup, new Listener(){

            public void handleEvent(Event event) {
                IResource resource = DefaultSchemaImportDialog.this.fResourceComposite.getSelectedResource();
                if (resource != null && resource.getType() == 1) {
                    DefaultSchemaImportDialog.this.attemptLoad((IFile)resource);
                    return;
                }
                DefaultSchemaImportDialog.this.markEmptySelection();
            }
        }, Messages.SchemaImportDialog_Select_Resource_Title, this.resourceFilter);
        TreeViewer viewer = this.fResourceComposite.getTreeViewer();
        viewer.setAutoExpandLevel(2);
    }

    protected Object createImportStructure(Composite parent) {
        this.fStructureLabel = new Label(parent, 0);
        this.fStructureLabel.setText(this.fStructureTitle);
        this.fTree = new Tree(parent, 2048);
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.fTreeViewer.setInput(null);
        this.fTreeViewer.setAutoExpandLevel(3);
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    DefaultSchemaImportDialog.this.computeResult();
                    if (DefaultSchemaImportDialog.this.getResult() != null) {
                        DefaultSchemaImportDialog.this.updateStatus(Status.OK_STATUS);
                    } else {
                        DefaultSchemaImportDialog.this.updateStatus((IStatus)new Status(4, Activator.getDefault().getID(), 0, Messages.SchemaImportDialog_Select_Java_Message, null));
                    }
                } else {
                    DefaultSchemaImportDialog.this.markEmptySelection();
                }
            }
        });
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.minimumHeight = 200;
        this.fTree.setLayoutData((Object)data);
        return this.fTree;
    }

    protected Object attemptLoad(URI uri, String kind) {
        Resource resource = null;
        if ("java".equals(kind)) {
            String fileName = uri.lastSegment();
            ArrayList results = new ArrayList();
            try {
                IProject p = this.bpmn2Editor.getProject();
                if (p.isOpen() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = JavaCore.create((IProject)p);
                    JavaProjectClassLoader cl = new JavaProjectClassLoader(javaProject);
                    results.addAll(cl.findClasses(fileName));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return results;
        }
        try {
            resource = this.fHackedResourceSet.getResource(uri, true, kind);
        }
        catch (Exception e) {
            Activator.logError(e);
            return e;
        }
        if (resource != null && resource.getErrors().isEmpty() && resource.isLoaded()) {
            return resource.getContents().get(0);
        }
        return null;
    }

    Object attemptLoad(URI uri) {
        return this.attemptLoad(uri, this.fResourceKind);
    }

    void attemptLoad(IFile file) {
        this.attemptLoad(file.getFullPath().toString());
    }

    protected void attemptLoad(String path) {
        if (this.fLoaderJob != null && this.fLoaderJob.getState() == 4) {
            this.fLoaderJob.cancel();
        }
        this.updateStatus(Status.OK_STATUS);
        path = path.trim();
        if (path.length() == 0) {
            return;
        }
        URI uri = this.convertToURI(path);
        if (uri == null) {
            return;
        }
        this.fRunnableLoadURI = uri;
        final String msg = MessageFormat.format(Messages.SchemaImportDialog_Loading_Message, this.fRunnableLoadURI);
        this.fLoaderJob = new Job(msg){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(msg, 1);
                monitor.worked(1);
                if (DefaultSchemaImportDialog.this.fBrowseButton != null && !DefaultSchemaImportDialog.this.fBrowseButton.isDisposed()) {
                    DefaultSchemaImportDialog.this.fBrowseButton.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).DefaultSchemaImportDialog.this.fInput = DefaultSchemaImportDialog.this.attemptLoad((this).DefaultSchemaImportDialog.this.fRunnableLoadURI);
                            DefaultSchemaImportDialog.this.loadDone();
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        this.fLoaderJob.schedule();
        this.fRunnableStart = System.currentTimeMillis();
        this.updateStatus((IStatus)new Status(1, Activator.getDefault().getID(), 0, msg, null));
    }

    protected void loadDone() {
        long elapsed = System.currentTimeMillis() - this.fRunnableStart;
        if (this.fInput == null || this.fInput instanceof Throwable) {
            this.markEmptySelection();
            this.updateStatus((IStatus)new Status(4, Activator.getDefault().getID(), 0, MessageFormat.format(Messages.SchemaImportDialog_Load_Failed_Message, this.fRunnableLoadURI, elapsed), (Throwable)this.fInput));
            this.fInput = null;
        } else {
            this.updateStatus((IStatus)new Status(1, Activator.getDefault().getID(), 0, MessageFormat.format(Messages.SchemaImportDialog_Loaded_Message, this.fRunnableLoadURI, elapsed), null));
            String type = null;
            String ns = null;
            String loc = null;
            if (this.fInput instanceof XSDSchema) {
                XSDSchema schema = (XSDSchema)this.fInput;
                ns = schema.getTargetNamespace();
                loc = schema.getSchemaLocation();
                type = Messages.DefaultSchemaImportDialog_XSD_Type;
            } else if (this.fInput instanceof Definition) {
                Definition definition = (Definition)this.fInput;
                ns = definition.getTargetNamespace();
                loc = definition.getLocation();
                type = Messages.DefaultSchemaImportDialog_WSDL_Type;
            } else if (this.fInput instanceof DocumentRoot) {
                DocumentRoot root = (DocumentRoot)this.fInput;
                Definitions definitions = root.getDefinitions();
                ns = definitions.getTargetNamespace();
                loc = root.eResource().getURI().toString();
                type = Messages.DefaultSchemaImportDialog_BPMN2_Type;
                this.fInput = definitions;
            } else if (this.fInput instanceof List) {
                this.markEmptySelection();
            }
            if (type != null) {
                if (ns == null || ns.isEmpty()) {
                    this.updateStatus((IStatus)new Status(2, Activator.getDefault().getID(), 0, MessageFormat.format(Messages.DefaultSchemaImportDialog_Missing_Namespace_Message, type), null));
                }
                if (loc == null || loc.isEmpty()) {
                    this.updateStatus((IStatus)new Status(4, Activator.getDefault().getID(), 0, MessageFormat.format(Messages.SchemaImportDialog_Load_Failed_Message, this.fRunnableLoadURI, elapsed), null));
                    this.fInput = null;
                }
            }
            this.fTreeViewer.setInput(this.fInput);
            this.fTree.getVerticalBar().setSelection(0);
        }
    }

    protected void markEmptySelection() {
        this.updateStatus(Status.OK_STATUS);
        this.updateOK(false);
        this.fTreeViewer.setInput(null);
    }

    protected URI convertToURI(String path) {
        try {
            switch (this.fImportSource) {
                case 1027: {
                    return URI.createFileURI((String)path);
                }
                case 1025: {
                    return URI.createPlatformResourceURI((String)path, (boolean)true);
                }
                case 1026: {
                    return URI.createURI((String)path);
                }
            }
            return null;
        }
        catch (Exception ex) {
            this.updateStatus((IStatus)new Status(4, Activator.getDefault().getID(), 0, Messages.SchemaImportDialog_Invalid_Location, (Throwable)ex));
            return null;
        }
    }

    public void updateOK(boolean state) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(state);
        }
    }

    protected void computeResult() {
        Object object = this.fTreeViewer.getInput();
        if (object == null) {
            return;
        }
        if (this.fImportType == 1034) {
            IStructuredSelection sel = (IStructuredSelection)this.fTreeViewer.getSelection();
            if (!sel.isEmpty()) {
                TreeNode treeNode = (TreeNode)sel.getFirstElement();
                if (treeNode.getModelObject() instanceof IType) {
                    this.setSelectionResult(new Object[]{treeNode.getModelObject()});
                } else {
                    this.setSelectionResult(null);
                }
            }
        } else {
            this.setSelectionResult(new Object[]{object});
        }
    }

    public void configureAsXMLImport() {
        this.setTitle(Messages.SchemaImportDialog_Browse_XML_Title);
        this.fStructureTitle = Messages.SchemaImportDialog_Structure_Label;
        if (this.fStructureLabel != null) {
            this.fStructureLabel.setText(this.fStructureTitle);
        }
        this.fTreeContentProvider = new VariableTypeTreeContentProvider(true, true);
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        }
        this.fResourceKind = "xml";
        String[] xml_FILTER_EXTENSIONS = new String[]{"*.xml", "*.xsd", "*.wsdl", "*.*"};
        this.FILTER_EXTENSIONS = xml_FILTER_EXTENSIONS;
        String[] xml_FILTER_NAMES = new String[]{Messages.DefaultSchemaImportDialog_XML_Filter, Messages.DefaultSchemaImportDialog_XSD_Filter, Messages.DefaultSchemaImportDialog_WSDL_Filter, Messages.DefaultSchemaImportDialog_All};
        this.FILTER_NAMES = xml_FILTER_NAMES;
        this.resourceFilter = ".xml";
        if (this.fResourceComposite != null) {
            this.fResourceComposite.setFileFilter(this.resourceFilter);
        }
    }

    public void configureAsSchemaImport() {
        this.setTitle(Messages.SchemaImportDialog_Browse_XSD_Title);
        this.fStructureTitle = Messages.SchemaImportDialog_Types_Label;
        if (this.fStructureLabel != null) {
            this.fStructureLabel.setText(this.fStructureTitle);
        }
        this.fTreeContentProvider = new VariableTypeTreeContentProvider(true, true);
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        }
        this.fResourceKind = "xsd";
        String[] wsdl_FILTER_EXTENSIONS = new String[]{"*.xml", "*.xsd", "*.wsdl", "*.*"};
        this.FILTER_EXTENSIONS = wsdl_FILTER_EXTENSIONS;
        String[] wsdl_FILTER_NAMES = new String[]{Messages.DefaultSchemaImportDialog_XML_Filter, Messages.DefaultSchemaImportDialog_XSD_Filter, Messages.DefaultSchemaImportDialog_WSDL_Filter, Messages.DefaultSchemaImportDialog_All};
        this.FILTER_NAMES = wsdl_FILTER_NAMES;
        this.resourceFilter = ".xsd";
        if (this.fResourceComposite != null) {
            this.fResourceComposite.setFileFilter(this.resourceFilter);
        }
    }

    public void configureAsWSDLImport() {
        this.setTitle(Messages.SchemaImportDialog_Browse_WSDL_Title);
        this.fStructureTitle = Messages.SchemaImportDialog_Ports_Title;
        if (this.fStructureLabel != null) {
            this.fStructureLabel.setText(this.fStructureTitle);
        }
        this.fTreeContentProvider = new ServiceTreeContentProvider(true);
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        }
        this.fResourceKind = "wsdl";
        String[] wsdl_FILTER_EXTENSIONS = new String[]{"*.wsdl", "*.*"};
        this.FILTER_EXTENSIONS = wsdl_FILTER_EXTENSIONS;
        String[] wsdl_FILTER_NAMES = new String[]{Messages.DefaultSchemaImportDialog_WSDL_Filter, Messages.DefaultSchemaImportDialog_All};
        this.FILTER_NAMES = wsdl_FILTER_NAMES;
        this.resourceFilter = ".wsdl";
        if (this.fResourceComposite != null) {
            this.fResourceComposite.setFileFilter(this.resourceFilter);
        }
    }

    public void configureAsBPMN2Import() {
        this.setTitle(Messages.SchemaImportDialog_Browse_BPMN2_Title);
        this.fStructureTitle = Messages.SchemaImportDialog_Interfaces_Label;
        if (this.fStructureLabel != null) {
            this.fStructureLabel.setText(this.fStructureTitle);
        }
        this.fTreeContentProvider = new BPMN2DefinitionsTreeContentProvider(true);
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        }
        this.fResourceKind = EMPTY;
        String[] wsdl_FILTER_EXTENSIONS = new String[]{"*.bpmn", "*.bpmn2", "*.*"};
        this.FILTER_EXTENSIONS = wsdl_FILTER_EXTENSIONS;
        String[] wsdl_FILTER_NAMES = new String[]{Messages.DefaultSchemaImportDialog_BPMN2_Filter_1, Messages.DefaultSchemaImportDialog_BPMN2_Filter_2, Messages.DefaultSchemaImportDialog_All};
        this.FILTER_NAMES = wsdl_FILTER_NAMES;
        this.resourceFilter = ".bpmn,.bpmn2";
        if (this.fResourceComposite != null) {
            this.fResourceComposite.setFileFilter(this.resourceFilter);
        }
    }

    public void configureAsJavaImport() {
        this.setTitle(Messages.SchemaImportDialog_Browse_Java_Title);
        this.fStructureTitle = Messages.SchemaImportDialog_Java_Types_Label;
        if (this.fStructureLabel != null) {
            this.fStructureLabel.setText(this.fStructureTitle);
        }
        this.fTreeContentProvider = new JavaTreeContentProvider(true);
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        }
        this.fResourceKind = "java";
        String[] java_FILTER_EXTENSIONS = new String[]{"*.java", "*.class", "*.jar", "*.*"};
        this.FILTER_EXTENSIONS = java_FILTER_EXTENSIONS;
        String[] wsdl_FILTER_NAMES = new String[]{Messages.DefaultSchemaImportDialog_Java_Filter_1, Messages.DefaultSchemaImportDialog_Java_Filter_2, Messages.DefaultSchemaImportDialog_Java_Filter_3, Messages.DefaultSchemaImportDialog_All};
        this.FILTER_NAMES = wsdl_FILTER_NAMES;
        this.resourceFilter = ".java";
        if (this.fResourceComposite != null) {
            this.fResourceComposite.setFileFilter(this.resourceFilter);
        }
    }

    public void setTitle(String title) {
        super.setTitle(title);
        if (this.getShell() != null) {
            this.getShell().setText(title);
        }
    }

    public class TreeFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }
}

