/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2SectionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.PropertyTabDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.property.AdvancedPropertySection;
import org.eclipse.bpmn2.modeler.ui.property.TabDescriptorList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;

public class PropertyTabDescriptorProvider
implements ITabDescriptorProvider {
    static Hashtable<EObject, TabDescriptorList> tabDescriptorListMap = new Hashtable();

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        EObject businessObject = BusinessObjectUtil.getBusinessObjectForSelection((ISelection)selection);
        if (businessObject == null || businessObject.eResource() == null) {
            return new ITabDescriptor[0];
        }
        TabDescriptorList tabDescriptorList = tabDescriptorListMap.get(businessObject);
        if (tabDescriptorList != null) {
            return tabDescriptorList.toArray();
        }
        List desc = null;
        TargetRuntime rt = Bpmn2Preferences.getInstance((Resource)businessObject.eResource()).getRuntime();
        if (rt != TargetRuntime.getDefaultRuntime()) {
            desc = TargetRuntime.getDefaultRuntime().buildPropertyTabDescriptors();
            desc.addAll(rt.buildPropertyTabDescriptors());
        } else {
            desc = rt.buildPropertyTabDescriptors();
        }
        ArrayList<PropertyTabDescriptor> replaced = new ArrayList<PropertyTabDescriptor>();
        for (PropertyTabDescriptor d : desc) {
            String[] replacements;
            String replacedId = d.getReplaceTab();
            if (replacedId == null) continue;
            String[] stringArray = replacements = replacedId.split(" ");
            int n = replacements.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                for (Bpmn2SectionDescriptor s : d.getSectionDescriptors()) {
                    PropertyTabDescriptor replacedTab;
                    if (!s.doReplaceTab(id, part, selection) || (replacedTab = TargetRuntime.findPropertyTabDescriptor((String)id)) == null) continue;
                    replaced.add(replacedTab);
                    int i = desc.indexOf(replacedTab);
                    if (i < 0) continue;
                    desc.set(i, d);
                }
                ++n2;
            }
        }
        if (replaced.size() > 0) {
            desc.removeAll(replaced);
        }
        int i = desc.size() - 1;
        while (i >= 0) {
            PropertyTabDescriptor d = (PropertyTabDescriptor)desc.get(i);
            int j = i - 1;
            while (j >= 0) {
                if (desc.get(j) == d) {
                    desc.remove(i);
                    break;
                }
                --j;
            }
            --i;
        }
        ArrayList<PropertyTabDescriptor> emptyTabs = new ArrayList<PropertyTabDescriptor>();
        PropertyTabDescriptor advancedPropertyTab = null;
        for (PropertyTabDescriptor d : desc) {
            boolean empty = true;
            for (Bpmn2SectionDescriptor s : d.getSectionDescriptors()) {
                if (s.appliesTo(part, selection)) {
                    empty = false;
                }
                if (!(s.getSectionClass() instanceof AdvancedPropertySection)) continue;
                advancedPropertyTab = d;
            }
            if (!empty) continue;
            emptyTabs.add(d);
        }
        if (emptyTabs.size() > 0) {
            desc.removeAll(emptyTabs);
        }
        if (advancedPropertyTab != null && desc.remove(advancedPropertyTab)) {
            desc.add(advancedPropertyTab);
        }
        replaced.clear();
        for (PropertyTabDescriptor td : desc) {
            String rtid = td.getRuntimeId();
            if (rtid != null && !rtid.equals("org.eclipse.bpmn2.modeler.runtime.none") && !rt.getId().equals(rtid) || td.getConfigFile() != null && !rt.getId().equals(rtid)) continue;
            replaced.add(td.copy());
        }
        if (businessObject != null) {
            tabDescriptorList = new TabDescriptorList();
            tabDescriptorList.addAll(replaced);
            tabDescriptorListMap.put(businessObject, tabDescriptorList);
            return tabDescriptorList.toArray();
        }
        return replaced.toArray(new ITabDescriptor[replaced.size()]);
    }

    public void disposeTabDescriptors(Resource resource) {
        if (resource != null) {
            TreeIterator iter = resource.getAllContents();
            while (iter.hasNext()) {
                EObject object = (EObject)iter.next();
                tabDescriptorListMap.remove(object);
            }
        }
        ArrayList<EObject> removed = new ArrayList<EObject>();
        for (EObject o : tabDescriptorListMap.keySet()) {
            if (o.eResource() != null) continue;
            removed.add(o);
        }
        for (EObject o : removed) {
            tabDescriptorListMap.remove(o);
        }
    }
}

