/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Group;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.ToolTipProvider;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.DefaultPropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.FeatureListObjectEditor;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.diagram.Bpmn2FeatureMap;
import org.eclipse.bpmn2.modeler.ui.property.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;

public class DescriptionPropertySection
extends DefaultPropertySection
implements ITabbedPropertyConstants {
    protected AbstractDetailComposite createSectionRoot() {
        return new DescriptionDetailComposite((AbstractBpmn2PropertySection)this);
    }

    public AbstractDetailComposite createSectionRoot(Composite parent, int style) {
        return new DescriptionDetailComposite(parent, style);
    }

    public class DescriptionDetailComposite
    extends DefaultDetailComposite {
        public DescriptionDetailComposite(AbstractBpmn2PropertySection section) {
            super(section);
        }

        public DescriptionDetailComposite(Composite parent, int style) {
            super(parent, style);
        }

        protected void cleanBindings() {
            super.cleanBindings();
            this.descriptionText = null;
        }

        public void createBindings(EObject object) {
            EStructuralFeature reference;
            this.bindDescription(object);
            this.bindAttribute(object, "id");
            this.bindAttribute(object, "name");
            this.bindList(object, "documentation");
            this.bindAppearance(object);
            if (!(object instanceof Group) && (reference = object.eClass().getEStructuralFeature("categoryValueRef")) != null && this.isModelObjectEnabled(object.eClass(), reference)) {
                String displayName = this.getBusinessObjectDelegate().getLabel(object, reference);
                FeatureListObjectEditor editor = new FeatureListObjectEditor((AbstractDetailComposite)this, object, reference){

                    protected boolean canEdit() {
                        return !Bpmn2Preferences.getInstance((EObject)this.object).getPropagateGroupCategories();
                    }
                };
                editor.createControl(this.getAttributesParent(), displayName);
            }
        }

        protected boolean isModelObjectEnabled(String className, String featureName) {
            if (featureName != null && "name".equals(featureName)) {
                return true;
            }
            return super.isModelObjectEnabled(className, featureName);
        }

        protected void bindDescription(EObject be) {
            String description;
            if (Bpmn2Preferences.getInstance((EObject)be).getShowDescriptions() && (description = this.getDescription(be)) != null && !description.isEmpty()) {
                this.descriptionText = this.createDescription((Composite)this, description);
            }
        }

        public String getDescription(EObject object) {
            ExtendedPropertiesAdapter adapter;
            String description = null;
            if (object instanceof BPMNDiagram && ((BPMNDiagram)object).getPlane() != null && ((BPMNDiagram)object).getPlane().getBpmnElement() != null) {
                object = ((BPMNDiagram)object).getPlane().getBpmnElement();
            }
            if ((adapter = ExtendedPropertiesAdapter.adapt((Object)object)) != null) {
                description = (String)adapter.getProperty("long.description");
            }
            if (description == null) {
                description = ToolTipProvider.INSTANCE.getLongDescription((Object)this.getDiagramEditor(), object);
            }
            if (!this.isModelObjectEnabled(object.eClass())) {
                if (description == null) {
                    description = "";
                }
                description = "*** The " + ModelUtil.toCanonicalString((String)object.eClass().getName()) + " element is not enabled in this Tool Profile. ***\n" + description;
            }
            return description;
        }

        protected void bindAppearance(EObject be) {
            if (Bpmn2FeatureMap.ALL_SHAPES.contains(be.eClass().getInstanceClass())) {
                PictogramElement[] pes = this.getDiagramEditor().getSelectedPictogramElements();
                if (pes.length == 1 && ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)pes[0])) {
                    return;
                }
                EStructuralFeature feature = this.getFeature(be, "style");
                if (feature == null || !this.isModelObjectEnabled(be.eClass(), feature) || !this.isModelObjectEnabled("ShapeStyle", null)) {
                    return;
                }
                final BaseElement element = (BaseElement)be;
                EObject style = ShapeStyle.getStyleObject((BaseElement)element);
                if (style == null && (style = ShapeStyle.createStyleObject((BaseElement)element)) == null) {
                    return;
                }
                final EObject styleObject = style;
                Composite container = this.createSectionComposite((Composite)this, Messages.DescriptionPropertySection_Appearance_Label);
                if (Bpmn2FeatureMap.CONNECTIONS.contains(be.eClass().getInstanceClass())) {
                    this.bindAttribute(container, style, "shapeForeground");
                    this.bindAttribute(container, style, "labelForeground");
                    this.bindAttribute(container, style, "labelFont");
                    this.bindAttribute(container, style, "labelPosition");
                    this.bindAttribute(container, style, "routingStyle");
                } else if (be instanceof TextAnnotation) {
                    this.bindAttribute(container, style, "shapeForeground");
                    this.bindAttribute(container, style, "labelForeground");
                    this.bindAttribute(container, style, "labelFont");
                } else if (Bpmn2FeatureMap.EVENTS.contains(be.eClass().getInstanceClass()) || Bpmn2FeatureMap.GATEWAYS.contains(be.eClass().getInstanceClass()) || Bpmn2FeatureMap.DATA.contains(be.eClass().getInstanceClass())) {
                    this.bindAttribute(container, style, "shapeBackground");
                    this.bindAttribute(container, style, "shapeForeground");
                    this.bindAttribute(container, style, "labelForeground");
                    this.bindAttribute(container, style, "labelFont");
                    this.bindAttribute(container, style, "labelPosition");
                } else {
                    this.bindAttribute(container, style, "shapeBackground");
                    this.bindAttribute(container, style, "shapeForeground");
                    this.bindAttribute(container, style, "labelForeground");
                    this.bindAttribute(container, style, "labelFont");
                }
                Button reset = new Button(container, 8);
                reset.setText("Restore Defaults");
                reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)element);
                        final ShapeStyle ss = preferences.getShapeStyle((EObject)element);
                        TransactionalEditingDomain domain = DescriptionDetailComposite.this.getDiagramEditor().getEditingDomain();
                        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                            protected void doExecute() {
                                ShapeStyle.setShapeStyle((BaseElement)element, (EObject)styleObject, (ShapeStyle)ss);
                                DescriptionDetailComposite.this.setBusinessObject((EObject)element);
                            }
                        });
                    }
                });
            }
        }
    }
}

