/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.flow;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Artifact;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.BaseElementConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.DefaultDeleteBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractAddFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractReconnectFlowFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AssociationFeatureContainer
extends BaseElementConnectionFeatureContainer {
    public static final String ASSOCIATION_DIRECTION = "association.direction";
    public static final String ARROWHEAD_DECORATOR = "arrowhead.decorator";

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof Association;
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddAssociationFeature(fp);
    }

    public ICreateConnectionFeature getCreateConnectionFeature(IFeatureProvider fp) {
        return new CreateAssociationFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return new UpdateAssociationFeature(fp);
    }

    public IReconnectionFeature getReconnectionFeature(IFeatureProvider fp) {
        return new ReconnectAssociationFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DefaultDeleteBPMNShapeFeature(fp);
    }

    private static void setAssociationDirection(Connection connection, Association businessObject) {
        String oldDirection;
        IPeService peService = Graphiti.getPeService();
        IGaService gaService = Graphiti.getGaService();
        String newDirection = businessObject.getAssociationDirection().toString();
        if (newDirection == null || newDirection.isEmpty()) {
            newDirection = AssociationDirection.NONE.toString();
        }
        if ((oldDirection = peService.getPropertyValue((PropertyContainer)connection, ASSOCIATION_DIRECTION)) == null || oldDirection.isEmpty()) {
            oldDirection = AssociationDirection.NONE.toString();
        }
        if (!oldDirection.equals(newDirection)) {
            Polyline arrowhead;
            ConnectionDecorator sourceDecorator = null;
            ConnectionDecorator targetDecorator = null;
            for (ConnectionDecorator d : connection.getConnectionDecorators()) {
                String s = peService.getPropertyValue((PropertyContainer)d, ARROWHEAD_DECORATOR);
                if (s == null) continue;
                if (s.equals("source")) {
                    sourceDecorator = d;
                    continue;
                }
                if (!s.equals("target")) continue;
                targetDecorator = d;
            }
            boolean needSource = false;
            boolean needTarget = false;
            if (newDirection.equals(AssociationDirection.ONE.toString())) {
                needTarget = true;
            } else if (newDirection.equals(AssociationDirection.BOTH.toString())) {
                needTarget = true;
                needSource = true;
            }
            if (needSource) {
                if (sourceDecorator == null) {
                    sourceDecorator = peService.createConnectionDecorator(connection, false, 0.0, true);
                    int[] nArray = new int[6];
                    nArray[0] = -13;
                    nArray[1] = 7;
                    nArray[4] = -13;
                    nArray[5] = -7;
                    arrowhead = gaService.createPolyline((GraphicsAlgorithmContainer)sourceDecorator, nArray);
                    StyleUtil.applyStyle((GraphicsAlgorithm)arrowhead, (BaseElement)businessObject);
                    peService.setPropertyValue((PropertyContainer)sourceDecorator, ARROWHEAD_DECORATOR, "source");
                }
            } else if (sourceDecorator != null) {
                connection.getConnectionDecorators().remove((Object)sourceDecorator);
            }
            if (needTarget) {
                if (targetDecorator == null) {
                    targetDecorator = peService.createConnectionDecorator(connection, false, 1.0, true);
                    int[] nArray = new int[6];
                    nArray[0] = -13;
                    nArray[1] = 7;
                    nArray[4] = -13;
                    nArray[5] = -7;
                    arrowhead = gaService.createPolyline((GraphicsAlgorithmContainer)targetDecorator, nArray);
                    StyleUtil.applyStyle((GraphicsAlgorithm)arrowhead, (BaseElement)businessObject);
                    peService.setPropertyValue((PropertyContainer)targetDecorator, ARROWHEAD_DECORATOR, "target");
                }
            } else if (targetDecorator != null) {
                connection.getConnectionDecorators().remove((Object)targetDecorator);
            }
            peService.setPropertyValue((PropertyContainer)connection, ASSOCIATION_DIRECTION, newDirection);
        }
    }

    public class AddAssociationFeature
    extends AbstractAddFlowFeature<Association> {
        public AddAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected Polyline createConnectionLine(Connection connection) {
            Polyline connectionLine = super.createConnectionLine(connection);
            connectionLine.setLineWidth(Integer.valueOf(2));
            connectionLine.setLineStyle(LineStyle.DOT);
            return connectionLine;
        }

        protected void decorateConnection(IAddConnectionContext context, Connection connection, Association businessObject) {
            AssociationFeatureContainer.setAssociationDirection(connection, businessObject);
        }

        public Class getBusinessObjectType() {
            return Association.class;
        }
    }

    public class CreateAssociationFeature
    extends AbstractCreateFlowFeature<Association, BaseElement, BaseElement> {
        public CreateAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean isAvailable(IContext context) {
            if (!this.isModelObjectEnabled((EObject)Bpmn2Package.eINSTANCE.getAssociation())) {
                return false;
            }
            return super.isAvailable(context);
        }

        public boolean canCreate(ICreateConnectionContext context) {
            if (!super.canCreate(context)) {
                return false;
            }
            BaseElement source = this.getSourceBo(context);
            BaseElement target = this.getTargetBo(context);
            if (source != null && target != null) {
                if (source instanceof BoundaryEvent && target instanceof Activity) {
                    return true;
                }
                if (source instanceof Artifact || target instanceof Artifact) {
                    return true;
                }
            }
            return false;
        }

        public Connection create(ICreateConnectionContext context) {
            Connection connection = super.create(context);
            Association association = (Association)this.getBusinessObject(context);
            if (association.getSourceRef() instanceof BoundaryEvent && association.getTargetRef() instanceof Activity) {
                association.setAssociationDirection(AssociationDirection.ONE);
            }
            return connection;
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_ASSOCIATION;
        }

        protected Class<BaseElement> getSourceClass() {
            return BaseElement.class;
        }

        protected Class<BaseElement> getTargetClass() {
            return BaseElement.class;
        }

        protected BaseElement getSourceBo(ICreateConnectionContext context) {
            Anchor anchor = this.getSourceAnchor(context);
            if (anchor != null && anchor.getParent() instanceof Shape) {
                Shape shape = (Shape)anchor.getParent();
                return (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, this.getTargetClass());
            }
            if (context.getSourcePictogramElement() instanceof Connection) {
                Connection connection = (Connection)context.getSourcePictogramElement();
                return BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            }
            return null;
        }

        protected BaseElement getTargetBo(ICreateConnectionContext context) {
            Anchor anchor = this.getTargetAnchor(context);
            if (anchor != null && anchor.getParent() instanceof Shape) {
                Shape shape = (Shape)anchor.getParent();
                return (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, this.getTargetClass());
            }
            if (context.getTargetPictogramElement() instanceof Connection) {
                Connection connection = (Connection)context.getTargetPictogramElement();
                return BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            }
            return null;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getAssociation();
        }
    }

    public static class ReconnectAssociationFeature
    extends AbstractReconnectFlowFeature {
        public ReconnectAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canReconnect(IReconnectionContext context) {
            BaseElement targetElement = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetPictogramElement(), BaseElement.class);
            if (targetElement instanceof Association) {
                return false;
            }
            PictogramElement targetPictogramElement = context.getTargetPictogramElement();
            if (targetPictogramElement instanceof FreeFormConnection) {
                AnchorContainer ac = context.getConnection().getEnd().getParent();
                return BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)ac) != targetElement;
            }
            return super.canReconnect(context);
        }

        protected Class<? extends EObject> getTargetClass() {
            return BaseElement.class;
        }

        protected Class<? extends EObject> getSourceClass() {
            return BaseElement.class;
        }

        public void postReconnect(IReconnectionContext context) {
            AnchorUtil.adjustAnchors((AnchorContainer)context.getOldAnchor().getParent());
            super.postReconnect(context);
        }
    }

    public static class UpdateAssociationFeature
    extends AbstractBpmn2UpdateFeature {
        public UpdateAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            if (context.getPictogramElement() instanceof Connection) {
                return BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), Association.class) != null;
            }
            return false;
        }

        public IReason updateNeeded(IUpdateContext context) {
            if (this.canUpdate(context)) {
                String oldDirection;
                Connection connection = (Connection)context.getPictogramElement();
                Association businessObject = (Association)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), Association.class);
                String newDirection = businessObject.getAssociationDirection().toString();
                if (newDirection == null || newDirection.isEmpty()) {
                    newDirection = AssociationDirection.NONE.toString();
                }
                if ((oldDirection = Graphiti.getPeService().getPropertyValue((PropertyContainer)connection, AssociationFeatureContainer.ASSOCIATION_DIRECTION)) == null || oldDirection.isEmpty()) {
                    oldDirection = AssociationDirection.NONE.toString();
                }
                if (!oldDirection.equals(newDirection)) {
                    return Reason.createTrueReason((String)"Association Direction");
                }
            }
            return Reason.createFalseReason();
        }

        public boolean update(IUpdateContext context) {
            Connection connection = (Connection)context.getPictogramElement();
            Association businessObject = (Association)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), Association.class);
            AssociationFeatureContainer.setAssociationDirection(connection, businessObject);
            return true;
        }
    }
}

