/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.di.ParticipantBandKind;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.features.choreography.Messages;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorType;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.IColorConstant;

public class UpdateChoreographyMessageLinkFeature
extends AbstractUpdateBaseElementFeature<BaseElement> {
    private static IGaService gaService = Graphiti.getGaService();
    private static IPeService peService = Graphiti.getPeService();

    public UpdateChoreographyMessageLinkFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        boolean result = false;
        if (super.canUpdate(context)) {
            result = ChoreographyUtil.getChoreographyActivityShape((PictogramElement)context.getPictogramElement()) != null;
        }
        return result;
    }

    public IReason updateNeeded(IUpdateContext context) {
        String activityIds;
        IReason reason = super.updateNeeded(context);
        if (reason.toBoolean()) {
            return reason;
        }
        ContainerShape choreographyActivityShape = ChoreographyUtil.getChoreographyActivityShape((PictogramElement)context.getPictogramElement());
        ChoreographyActivity choreographyActivity = (ChoreographyActivity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyActivityShape, ChoreographyActivity.class);
        String shapeIds = ChoreographyUtil.getParticipantRefIds((ContainerShape)choreographyActivityShape);
        if (!shapeIds.equals(activityIds = ChoreographyUtil.getParticipantRefIds((ChoreographyActivity)choreographyActivity))) {
            reason = Reason.createTrueReason((String)"Participants");
        } else {
            List bandShapes = FeatureSupport.getParticipantBandContainerShapes((ContainerShape)choreographyActivityShape);
            for (ContainerShape bandShape : bandShapes) {
                BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)bandShape, BPMNShape.class);
                boolean visible = new Boolean(Graphiti.getPeService().getPropertyValue((PropertyContainer)bandShape, "choreography.activity.band.message.visible"));
                if (bpmnShape.isIsMessageVisible() == visible) continue;
                reason = Reason.createTrueReason((String)"Message Link Visible");
                break;
            }
        }
        return reason;
    }

    public boolean update(IUpdateContext context) {
        int y;
        String property;
        AnchorContainer container;
        if (!this.canUpdate(context)) {
            return false;
        }
        ContainerShape choreographyTaskShape = ChoreographyUtil.getChoreographyActivityShape((PictogramElement)context.getPictogramElement());
        IFeatureProvider fp = this.getFeatureProvider();
        ArrayList<MessageFlow> messageFlows = new ArrayList<MessageFlow>();
        ChoreographyTask choreography = (ChoreographyTask)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyTaskShape, ChoreographyTask.class);
        if (choreography != null) {
            messageFlows.addAll(choreography.getMessageFlowRef());
        }
        List bandShapes = FeatureSupport.getParticipantBandContainerShapes((ContainerShape)choreographyTaskShape);
        Tuple topAndBottom = FeatureSupport.getTopAndBottomBands((List)bandShapes);
        ArrayList<ContainerShape> shapesWithVisibleMessages = new ArrayList<ContainerShape>();
        FixPointAnchor topAnchor = null;
        FixPointAnchor bottomAnchor = null;
        Connection topConnection = null;
        Connection bottomConnection = null;
        for (Connection connection : AnchorUtil.getConnections((AnchorContainer)choreographyTaskShape, (AnchorSite)AnchorSite.TOP)) {
            container = connection.getEnd().getParent();
            property = peService.getPropertyValue((PropertyContainer)container, "choreography.messageLink");
            if (!Boolean.parseBoolean(property)) continue;
            topConnection = connection;
            topAnchor = (FixPointAnchor)connection.getEnd();
            break;
        }
        if (topAnchor == null) {
            topAnchor = AnchorUtil.createAnchor((AnchorContainer)choreographyTaskShape, (AnchorSite)AnchorSite.TOP);
        }
        AnchorType.setType(topAnchor, (AnchorType)AnchorType.MESSAGELINK);
        for (Connection connection : AnchorUtil.getConnections((AnchorContainer)choreographyTaskShape, (AnchorSite)AnchorSite.BOTTOM)) {
            container = connection.getEnd().getParent();
            property = peService.getPropertyValue((PropertyContainer)container, "choreography.messageLink");
            if (!Boolean.parseBoolean(property)) continue;
            bottomConnection = connection;
            bottomAnchor = (FixPointAnchor)connection.getEnd();
            break;
        }
        if (bottomAnchor == null) {
            bottomAnchor = AnchorUtil.createAnchor((AnchorContainer)choreographyTaskShape, (AnchorSite)AnchorSite.BOTTOM);
        }
        AnchorType.setType(bottomAnchor, (AnchorType)AnchorType.MESSAGELINK);
        for (ContainerShape bandShape : bandShapes) {
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)bandShape, BPMNShape.class);
            if (!bpmnShape.isIsMessageVisible()) continue;
            shapesWithVisibleMessages.add(bandShape);
        }
        boolean shouldDrawTopMessage = !Collections.disjoint((Collection)topAndBottom.getFirst(), shapesWithVisibleMessages);
        boolean shouldDrawBottomMessage = !Collections.disjoint((Collection)topAndBottom.getSecond(), shapesWithVisibleMessages);
        String topMessageName = null;
        String bottomMessageName = null;
        Message topMessage = null;
        Message bottomMessage = null;
        if (shouldDrawTopMessage) {
            topMessage = this.getMessage(messageFlows, (List)topAndBottom.getFirst(), false);
            topMessageName = this.getMessageName(messageFlows, (List)topAndBottom.getFirst());
        }
        if (topMessageName == null) {
            topMessageName = new String();
        }
        if (shouldDrawBottomMessage) {
            bottomMessage = this.getMessage(messageFlows, (List)topAndBottom.getSecond(), false);
            bottomMessageName = this.getMessageName(messageFlows, (List)topAndBottom.getSecond());
        }
        if (bottomMessageName == null) {
            bottomMessageName = new String();
        }
        BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyTaskShape, BPMNShape.class);
        Bounds bounds = bpmnShape.getBounds();
        int x = (int)(bounds.getX() + bounds.getWidth() / 2.0f - 15.0f);
        MessageFlow flow = this.getMessageFlow(messageFlows, (List)topAndBottom.getFirst());
        ContainerShape envelope = null;
        if (topConnection == null && shouldDrawTopMessage && flow != null) {
            y = (int)(bounds.getY() - 30.0f - 18.0f);
            envelope = this.drawMessageLink(topMessage, topMessageName, topAnchor, x, y, this.isFilled((List)topAndBottom.getFirst()));
            peService.setPropertyValue((PropertyContainer)envelope, "choreography.messageName", topMessageName);
        } else if (topConnection != null && !shouldDrawTopMessage) {
            envelope = (ContainerShape)topConnection.getEnd().getParent();
            peService.deletePictogramElement((PictogramElement)topConnection);
            peService.deletePictogramElement((PictogramElement)envelope);
            envelope = null;
        } else if (topConnection != null && shouldDrawTopMessage && flow != null) {
            envelope = (ContainerShape)topConnection.getEnd().getParent();
            this.setMessageLabel(topMessageName, (PictogramElement)envelope);
        }
        if (envelope != null) {
            this.linkMessageFlow(fp, flow, envelope);
        }
        envelope = null;
        flow = this.getMessageFlow(messageFlows, (List)topAndBottom.getSecond());
        if (bottomConnection == null && shouldDrawBottomMessage && flow != null) {
            y = (int)(bounds.getY() + bounds.getHeight() + 30.0f);
            envelope = this.drawMessageLink(bottomMessage, bottomMessageName, bottomAnchor, x, y, this.isFilled((List)topAndBottom.getSecond()));
            peService.setPropertyValue((PropertyContainer)envelope, "choreography.messageName", bottomMessageName);
        } else if (bottomConnection != null && !shouldDrawBottomMessage) {
            envelope = (ContainerShape)bottomConnection.getEnd().getParent();
            peService.deletePictogramElement((PictogramElement)bottomConnection);
            peService.deletePictogramElement((PictogramElement)envelope);
            envelope = null;
        } else if (bottomConnection != null && shouldDrawBottomMessage && flow != null) {
            envelope = (ContainerShape)bottomConnection.getEnd().getParent();
            this.setMessageLabel(bottomMessageName, (PictogramElement)envelope);
        }
        if (envelope != null) {
            this.linkMessageFlow(fp, flow, envelope);
        }
        for (ContainerShape bandShape : bandShapes) {
            bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)bandShape, BPMNShape.class);
            Graphiti.getPeService().setPropertyValue((PropertyContainer)bandShape, "choreography.activity.band.message.visible", Boolean.toString(bpmnShape.isIsMessageVisible()));
        }
        AnchorUtil.adjustAnchors((AnchorContainer)choreographyTaskShape);
        return true;
    }

    private void linkMessageFlow(IFeatureProvider fp, MessageFlow flow, ContainerShape envelope) {
        for (Anchor a : envelope.getAnchors()) {
            for (Connection c : a.getIncomingConnections()) {
                fp.link((PictogramElement)c, (Object)flow);
            }
            for (Connection c : a.getOutgoingConnections()) {
                fp.link((PictogramElement)c, (Object)flow);
            }
        }
    }

    private boolean isFilled(List<ContainerShape> bands) {
        boolean filled = true;
        for (ContainerShape band : bands) {
            ParticipantBandKind bandKind;
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            if (!bpmnShape.isIsMessageVisible() || (bandKind = bpmnShape.getParticipantBandKind()) != ParticipantBandKind.TOP_INITIATING && bandKind != ParticipantBandKind.BOTTOM_INITIATING && bandKind != ParticipantBandKind.MIDDLE_INITIATING) continue;
            filled = false;
            break;
        }
        return filled;
    }

    private void setMessageLabel(String label, PictogramElement message) {
        ContainerShape containerShape = (ContainerShape)message;
        for (Shape shape : peService.getAllContainedShapes(containerShape)) {
            if (!(shape.getGraphicsAlgorithm() instanceof Text)) continue;
            Text text = (Text)shape.getGraphicsAlgorithm();
            text.setValue(label);
            IDimension size = GraphitiUi.getUiLayoutService().calculateTextSize(label, text.getFont());
            gaService.setSize(containerShape.getGraphicsAlgorithm(), 30 + size.getWidth() + 3, 18);
            gaService.setSize((GraphicsAlgorithm)text, size.getWidth(), size.getHeight());
            peService.setPropertyValue((PropertyContainer)containerShape, "choreography.messageName", label);
            break;
        }
    }

    private String getMessageName(List<MessageFlow> messageFlows, List<ContainerShape> bands) {
        for (ContainerShape band : bands) {
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, Participant.class);
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            if (!bpmnShape.isIsMessageVisible()) continue;
            for (MessageFlow flow : messageFlows) {
                if (!flow.getSourceRef().equals(participant)) continue;
                return ChoreographyUtil.getMessageFlowName((MessageFlow)flow);
            }
        }
        return null;
    }

    private MessageFlow getMessageFlow(List<MessageFlow> messageFlows, List<ContainerShape> bands) {
        for (ContainerShape band : bands) {
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, Participant.class);
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            if (!bpmnShape.isIsMessageVisible()) continue;
            for (MessageFlow flow : messageFlows) {
                if (!flow.getSourceRef().equals(participant)) continue;
                return flow;
            }
        }
        return null;
    }

    private Message getMessage(List<MessageFlow> messageFlows, List<ContainerShape> bands, boolean create) {
        MessageFlow flow = this.getMessageFlow(messageFlows, bands);
        if (flow != null) {
            if (flow.getMessageRef() == null && create) {
                Message msg = (Message)Bpmn2ModelerFactory.create(Message.class);
                msg.setName(Messages.ChoreographyUtil_Undefined_Message);
                ModelUtil.getDefinitions((Object)flow).getRootElements().add(msg);
                flow.setMessageRef(msg);
                ModelUtil.setID((EObject)msg);
            }
            return flow.getMessageRef();
        }
        return null;
    }

    private ContainerShape drawMessageLink(Message message, String name, FixPointAnchor choreographyTaskAnchor, int x, int y, boolean filled) {
        FixPointAnchor envelopeAnchor;
        Diagram diagram = peService.getDiagramForAnchor((Anchor)choreographyTaskAnchor);
        FreeFormConnection connection = peService.createFreeFormConnection(diagram);
        Polyline connectionLine = gaService.createPolyline((GraphicsAlgorithmContainer)connection);
        connectionLine.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        connectionLine.setLineStyle(LineStyle.DOT);
        connectionLine.setLineWidth(Integer.valueOf(2));
        peService.setPropertyValue((PropertyContainer)connection, "choreography.messageLink", Boolean.toString(true));
        ContainerShape envelope = peService.createContainerShape((ContainerShape)diagram, true);
        Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)envelope);
        gaService.setLocation((GraphicsAlgorithm)invisibleRectangle, x, y);
        gaService.setSize((GraphicsAlgorithm)invisibleRectangle, 30, 18);
        this.getFeatureProvider().link((PictogramElement)envelope, (Object)message);
        peService.setPropertyValue((PropertyContainer)envelope, "choreography.messageLink", Boolean.toString(true));
        Shape envelopeShape = peService.createShape(envelope, false);
        ShapeDecoratorUtil.Envelope envelopeGa = ShapeDecoratorUtil.createEnvelope((GraphicsAlgorithmContainer)envelopeShape, (int)0, (int)0, (int)30, (int)18);
        IColorConstant color = filled ? IColorConstant.LIGHT_GRAY : IColorConstant.WHITE;
        envelopeGa.rect.setFilled(Boolean.valueOf(true));
        envelopeGa.rect.setBackground(gaService.manageColor(diagram, color));
        envelopeGa.rect.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        envelopeGa.line.setForeground(gaService.manageColor(diagram, StyleUtil.CLASS_FOREGROUND));
        Shape textShape = peService.createShape(envelope, false);
        Text text = gaService.createDefaultText(diagram, (GraphicsAlgorithmContainer)textShape);
        IDimension size = GraphitiUi.getUiLayoutService().calculateTextSize(name, text.getFont());
        gaService.setLocationAndSize((GraphicsAlgorithm)text, 33, 3, size.getWidth(), size.getHeight());
        text.setValue(name);
        gaService.setSize((GraphicsAlgorithm)invisibleRectangle, 30 + size.getWidth() + 3, 18);
        if (AnchorSite.getSite((FixPointAnchor)choreographyTaskAnchor) == AnchorSite.TOP) {
            envelopeAnchor = AnchorUtil.createAnchor((AnchorContainer)envelope, (AnchorSite)AnchorSite.BOTTOM);
            AnchorUtil.moveAnchor((FixPointAnchor)envelopeAnchor, (int)(x + 15), (int)(y + 18));
        } else {
            envelopeAnchor = AnchorUtil.createAnchor((AnchorContainer)envelope, (AnchorSite)AnchorSite.TOP);
            AnchorUtil.moveAnchor((FixPointAnchor)envelopeAnchor, (int)(x + 15), (int)y);
        }
        connection.setStart((Anchor)choreographyTaskAnchor);
        connection.setEnd((Anchor)envelopeAnchor);
        return envelope;
    }
}

