/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.Hashtable;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.ItemKind;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ImportUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.ItemDefinitionPropertiesAdapter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ItemDefinitionRefFeatureDescriptor<T extends BaseElement>
extends FeatureDescriptor<T> {
    protected ImportUtil importer = new ImportUtil();

    public ItemDefinitionRefFeatureDescriptor(ExtendedPropertiesAdapter<T> owner, T object, EStructuralFeature feature) {
        super(owner, object, feature);
        Assert.isTrue((boolean)RootElement.class.isAssignableFrom(feature.getEType().getInstanceClass()));
    }

    public String getLabel() {
        return ItemDefinitionPropertiesAdapter.getLabel();
    }

    public String getTextValue() {
        ItemDefinition itemDefinition = (ItemDefinition)((BaseElement)this.object).eGet(this.feature);
        return ItemDefinitionPropertiesAdapter.getDisplayName(itemDefinition);
    }

    public EObject createFeature(Resource resource, EClass eClass) {
        ItemDefinition itemDefinition = ItemDefinitionPropertiesAdapter.createItemDefinition(((BaseElement)this.object).eResource());
        return itemDefinition;
    }

    public Object getValue() {
        ItemDefinition itemDefinition = (ItemDefinition)((BaseElement)this.object).eGet(this.feature);
        return ItemDefinitionPropertiesAdapter.getStructureRef(itemDefinition);
    }

    protected void internalSet(T object, EStructuralFeature feature, Object value, int index) {
        Definitions definitions = ModelUtil.getDefinitions(object);
        if (value instanceof String) {
            value = this.importer.createItemDefinition(definitions, null, (String)value, ItemKind.INFORMATION);
        }
        if (value == null || value instanceof ItemDefinition) {
            ItemDefinition itemDefinition = (ItemDefinition)value;
            super.internalSet(object, feature, (Object)itemDefinition, index);
            if (definitions != null) {
                TreeIterator iter = definitions.eAllContents();
                while (iter.hasNext()) {
                    ThrowEvent event;
                    Activity activity;
                    InputOutputSpecification ioSpec;
                    EObject o = (EObject)iter.next();
                    if (o instanceof DataInput) {
                        DataInputAssociation dia2;
                        DataInput input = (DataInput)o;
                        if (input.eContainer() instanceof InputOutputSpecification) {
                            ioSpec = (InputOutputSpecification)input.eContainer();
                            if (!(ioSpec.eContainer() instanceof Activity)) continue;
                            activity = (Activity)ioSpec.eContainer();
                            for (DataInputAssociation dia2 : activity.getDataInputAssociations()) {
                                if (dia2.getSourceRef().isEmpty() || dia2.getSourceRef().get(0) != object) continue;
                                input.setItemSubjectRef(itemDefinition);
                            }
                            continue;
                        }
                        if (!(input.eContainer() instanceof ThrowEvent)) continue;
                        event = (ThrowEvent)input.eContainer();
                        dia2 = event.getDataInputAssociation().iterator();
                        while (dia2.hasNext()) {
                            DataInputAssociation dia3 = (DataInputAssociation)dia2.next();
                            if (dia3.getSourceRef().isEmpty() || dia3.getSourceRef().get(0) != object) continue;
                            input.setItemSubjectRef(itemDefinition);
                        }
                        continue;
                    }
                    if (!(o instanceof DataOutput)) continue;
                    DataOutput output = (DataOutput)o;
                    if (output.eContainer() instanceof InputOutputSpecification) {
                        ioSpec = (InputOutputSpecification)output.eContainer();
                        if (!(ioSpec.eContainer() instanceof Activity)) continue;
                        activity = (Activity)ioSpec.eContainer();
                        for (DataOutputAssociation doa : activity.getDataOutputAssociations()) {
                            if (doa.getTargetRef() != object) continue;
                            output.setItemSubjectRef(itemDefinition);
                        }
                        continue;
                    }
                    if (!(output.eContainer() instanceof CatchEvent)) continue;
                    event = (CatchEvent)output.eContainer();
                    for (DataOutputAssociation doa : event.getDataOutputAssociation()) {
                        if (doa.getTargetRef() != object) continue;
                        output.setItemSubjectRef(itemDefinition);
                    }
                }
            }
        }
    }

    public Hashtable<String, Object> getChoiceOfValues() {
        return ItemDefinitionPropertiesAdapter.getChoiceOfValues(this.object);
    }
}

