/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.actions;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepository;
import org.eclipse.datatools.connectivity.internal.repository.IConnectionProfileRepositoryConstants;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.ProfileUIManager;
import org.eclipse.datatools.connectivity.ui.wizards.ConnectionProfileDetailsPage;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.dialogs.PropertyPage;
import org.teiid.designer.ui.actions.IConnectionAction;

public class EditConnectionProfileAction
extends Action
implements IConnectionAction {
    public static final String MEMENTO_ROOT = "Connectivity_Property_Dialog_Root";
    public static final String MEMENTO_DIALOG_SIZE_HEIGHT = "Dialog_Size_Height";
    public static final String MEMENTO_DIALOG_SIZE_WIDTH = "Dialog_Size_Width";
    private int mShellWidth = 0;
    private int mShellHeight = 0;
    private IConnectionProfile profile;
    private Shell mShell;
    private boolean wasFinished = false;

    public EditConnectionProfileAction(Shell shell, IConnectionProfile profile) {
        this.profile = profile;
        this.mShell = shell;
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.showproperties"));
    }

    public static boolean hasContributors(Object selected) {
        return ProfileUIManager.hasContributors((Object)selected);
    }

    public void run() {
        int rtn_val;
        IManagedConnection imc;
        IDialogSettings dSection;
        PreferenceDialog propertyDialog = ProfileUIManager.createPreferenceDialog((Shell)this.mShell, (Object)this.profile);
        if (propertyDialog == null) {
            return;
        }
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        boolean foundSettings = false;
        if (dset != null && (dSection = dset.getSection(MEMENTO_ROOT)) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT).trim().length() > 0) {
            this.mShellHeight = dSection.getInt(MEMENTO_DIALOG_SIZE_HEIGHT);
            this.mShellWidth = dSection.getInt(MEMENTO_DIALOG_SIZE_WIDTH);
            foundSettings = true;
        }
        if (foundSettings) {
            propertyDialog.getShell().setSize(this.mShellWidth, this.mShellHeight);
            propertyDialog.getShell().layout();
        } else {
            this.mShellHeight = propertyDialog.getShell().getSize().y;
            this.mShellWidth = propertyDialog.getShell().getSize().x;
        }
        String title = ConnectivityUIPlugin.getDefault().getResourceString("properties.dialog");
        title = ConnectivityUIPlugin.getDefault().getResourceString("ConnectAction.title", (Object[])new String[]{this.profile.getName()});
        propertyDialog.getShell().setText(title);
        this.mShell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (e.getSource() instanceof Shell) {
                    Shell shell = (Shell)e.getSource();
                    EditConnectionProfileAction.this.mShellHeight = shell.getSize().y;
                    EditConnectionProfileAction.this.mShellWidth = shell.getSize().x;
                }
            }
        });
        boolean inReadOnlyRepository = false;
        if (this.profile.getParentProfile() != null && (imc = this.profile.getParentProfile().getManagedConnection(IConnectionProfileRepositoryConstants.REPOSITORY_CONNECTION_FACTORY_ID)) != null && imc.isConnected()) {
            IConnectionProfileRepository repo = (IConnectionProfileRepository)imc.getConnection().getRawConnection();
            inReadOnlyRepository = repo.isReadOnly();
        }
        propertyDialog.addPageChangedListener((IPageChangedListener)new PropertyPageChangeListener(inReadOnlyRepository));
        if (inReadOnlyRepository && propertyDialog.getSelectedPage() != null) {
            Composite composite;
            PropertyPage page = (PropertyPage)propertyDialog.getSelectedPage();
            if (propertyDialog.getSelectedPage() instanceof ConnectionProfileDetailsPage || propertyDialog.getSelectedPage() instanceof ProfileDetailsPropertyPage) {
                if (page.getControl() instanceof Composite) {
                    composite = (Composite)page.getControl();
                    if (inReadOnlyRepository) {
                        this.disableControls(composite, !inReadOnlyRepository, true);
                    }
                }
            } else if (propertyDialog.getSelectedPage() instanceof PropertyPage && page.getControl() instanceof Composite) {
                composite = (Composite)page.getControl();
                this.disableControls(composite, !inReadOnlyRepository);
            }
        }
        if ((rtn_val = propertyDialog.open()) == 0) {
            this.wasFinished = true;
            this.saveState();
        }
    }

    private void disableControls(Composite parent, boolean enabled) {
        this.disableControls(parent, enabled, false);
    }

    private void disableControls(Composite parent, boolean enabled, boolean checkForPing) {
        int i = 0;
        while (i < parent.getChildren().length) {
            if (parent.getChildren()[i] instanceof TabFolder) {
                Control[] tabList = ((TabFolder)parent.getChildren()[i]).getTabList();
                int j = 0;
                while (j < tabList.length) {
                    if (tabList[j] instanceof Composite) {
                        this.disableControls((Composite)tabList[j], enabled, checkForPing);
                    }
                    tabList[j].setEnabled(false);
                    ++j;
                }
            } else if (parent.getChildren()[i] instanceof Composite) {
                this.disableControls((Composite)parent.getChildren()[i], enabled, checkForPing);
                if (this.parentHasCombo((Composite)parent.getChildren()[i], enabled)) {
                    parent.getChildren()[i].setEnabled(enabled);
                }
            } else if (!(parent.getChildren()[i] instanceof Label)) {
                if (parent.getChildren()[i] instanceof List) {
                    Color bg = Display.getDefault().getSystemColor(22);
                    ((List)parent.getChildren()[i]).setBackground(bg);
                    ((List)parent.getChildren()[i]).setEnabled(enabled);
                } else if (!(parent.getChildren()[i] instanceof TabFolder)) {
                    if (parent.getChildren()[i] instanceof Button) {
                        if (checkForPing) {
                            String pingLabel = ConnectivityUIPlugin.getDefault().getResourceString("ConnectionProfileDetailsPage.Button.TestConnection");
                            Button btn = (Button)parent.getChildren()[i];
                            if (!btn.isDisposed() && btn.getText().equals(pingLabel)) {
                                btn.setEnabled(true);
                            } else {
                                btn.setEnabled(enabled);
                            }
                        } else {
                            parent.getChildren()[i].setEnabled(enabled);
                        }
                    } else {
                        parent.getChildren()[i].setEnabled(enabled);
                    }
                }
            }
            ++i;
        }
    }

    private boolean parentHasCombo(Composite parent, boolean enabled) {
        if (parent.getChildren().length > 0) {
            Control[] controls = parent.getChildren();
            int i = 0;
            while (i < controls.length) {
                if (controls[i] instanceof Combo) {
                    if (!enabled) {
                        Color bg = Display.getDefault().getSystemColor(22);
                        ((Combo)controls[i]).setBackground(bg);
                    }
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void saveState() {
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null && this.mShell != null) {
            IDialogSettings dSection = dset.getSection(MEMENTO_ROOT);
            if (dSection == null) {
                dSection = dset.addNewSection(MEMENTO_ROOT);
            }
            if (dSection != null) {
                dSection.put(MEMENTO_DIALOG_SIZE_HEIGHT, this.mShellHeight);
                dSection.put(MEMENTO_DIALOG_SIZE_WIDTH, this.mShellWidth);
            }
        }
    }

    public boolean wasFinished() {
        return this.wasFinished;
    }

    private class PropertyPageChangeListener
    implements IPageChangedListener {
        private boolean inReadOnlyRepository = false;

        public PropertyPageChangeListener(boolean flag) {
            this.inReadOnlyRepository = flag;
        }

        public void pageChanged(PageChangedEvent event) {
            PropertyPage page;
            if (event.getSelectedPage() instanceof ConnectionProfileDetailsPage || event.getSelectedPage() instanceof ProfileDetailsPropertyPage) {
                PropertyPage page2 = (PropertyPage)event.getSelectedPage();
                if (page2.getControl() instanceof Composite) {
                    Composite composite = (Composite)page2.getControl();
                    if (this.inReadOnlyRepository) {
                        EditConnectionProfileAction.this.disableControls(composite, !this.inReadOnlyRepository, true);
                    }
                }
            } else if (event.getSelectedPage() instanceof PropertyPage && (page = (PropertyPage)event.getSelectedPage()).getControl() instanceof Composite) {
                Composite composite = (Composite)page.getControl();
                if (this.inReadOnlyRepository) {
                    EditConnectionProfileAction.this.disableControls(composite, !this.inReadOnlyRepository);
                }
            }
        }
    }
}

