/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ws;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.translators.SimpleProperty;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class HeaderPropertiesPanel
implements DatatoolsUiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(HeaderPropertiesPanel.class);
    TableViewerBuilder propertiesViewer;
    Button addPropertyButton;
    Button removePropertyButton;
    private Properties profileProperties;
    private int visibleTableRows;

    public HeaderPropertiesPanel(Composite parent, Properties profileProperties, int visibleTableRows) {
        this.profileProperties = profileProperties;
        this.visibleTableRows = visibleTableRows;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        Group panel = WidgetFactory.createGroup((Composite)parent, (String)"", (int)4, (int)2, (int)1);
        GridData gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        panel.setLayoutData((Object)gd);
        this.propertiesViewer = new TableViewerBuilder((Composite)panel, 68352);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.propertiesViewer.getTableComposite());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertiesViewer.getTableViewer());
        this.propertiesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Properties props = HeaderPropertiesPanel.this.profileProperties;
                if (props.isEmpty()) {
                    return new Object[0];
                }
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                for (Object key : props.keySet()) {
                    String keyStr = (String)key;
                    if ("AuthPassword".equalsIgnoreCase(keyStr) || "SecurityType".equalsIgnoreCase(keyStr) || "AuthUserName".equalsIgnoreCase(keyStr) || "EndPoint".equalsIgnoreCase(keyStr) || "Parameter map".equalsIgnoreCase(keyStr) || "URI".equalsIgnoreCase(keyStr) || "Query".equalsIgnoreCase(keyStr) || "responseType".equalsIgnoreCase(keyStr)) continue;
                    properties.add(new SimpleProperty(keyStr, (String)props.get(key)));
                }
                return properties.toArray(new SimpleProperty[0]);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertiesViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                SimpleProperty prop1 = (SimpleProperty)e1;
                SimpleProperty prop2 = (SimpleProperty)e2;
                return super.compare(viewer, (Object)prop1.getName(), (Object)prop2.getName());
            }
        });
        Table table = this.propertiesViewer.getTable();
        ((GridData)table.getLayoutData()).heightHint = table.getItemHeight() * this.visibleTableRows;
        TableViewerColumn column = this.propertiesViewer.createColumn(16384, 50, 50, true);
        column.getColumn().setText(String.valueOf(UTIL.getString("HeaderPropertiesPanel_name", new Object[0])) + "                   ");
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(0));
        column = this.propertiesViewer.createColumn(16384, 50, 50, true);
        column.getColumn().setText(UTIL.getString("HeaderPropertiesPanel_value", new Object[0]));
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(1));
        column.setEditingSupport((EditingSupport)new PropertyNameEditingSupport((ColumnViewer)this.propertiesViewer.getTableViewer(), 1));
        this.propertiesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HeaderPropertiesPanel.this.handlePropertySelected();
            }
        });
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)panel, (int)0, (int)2, (int)1, (int)2);
        this.addPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addPropertyButton.setImage(DatatoolsUiPlugin.getDefault().getImage("icons/full/obj16/add_property.png"));
        this.addPropertyButton.setToolTipText(UTIL.getString("HeaderPropertiesPanel_addNewPropertyButton_tooltip", new Object[0]));
        this.addPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HeaderPropertiesPanel.this.handleAddProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removePropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removePropertyButton.setImage(DatatoolsUiPlugin.getDefault().getImage("icons/full/obj16/remove_property.png"));
        this.removePropertyButton.setToolTipText(UTIL.getString("HeaderPropertiesPanel_removePropertyButton_tooltip", new Object[0]));
        this.removePropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HeaderPropertiesPanel.this.handleRemoveProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removePropertyButton.setEnabled(false);
        this.propertiesViewer.setInput((Object)this);
    }

    void handlePropertySelected() {
        boolean hasSelection = !this.propertiesViewer.getSelection().isEmpty();
        this.removePropertyButton.setEnabled(hasSelection);
    }

    private SimpleProperty getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertiesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (SimpleProperty)selection.getFirstElement();
    }

    void handleAddProperty() {
        assert (!this.propertiesViewer.getSelection().isEmpty());
        HashSet<String> keys = new HashSet<String>();
        for (Object key : this.profileProperties.keySet()) {
            keys.add((String)key);
        }
        AddHeaderPropertyDialog dialog = new AddHeaderPropertyDialog(this.propertiesViewer.getControl().getShell(), keys);
        if (dialog.open() == 0) {
            String name = dialog.getName();
            String value = dialog.getValue();
            this.profileProperties.put(name, value);
            this.propertiesViewer.refresh();
            SimpleProperty prop = null;
            TableItem[] tableItemArray = this.propertiesViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() instanceof SimpleProperty && ((SimpleProperty)item.getData()).getName().equals(name)) {
                    prop = (SimpleProperty)item.getData();
                    break;
                }
                ++n2;
            }
            if (prop != null) {
                this.propertiesViewer.setSelection((ISelection)new StructuredSelection(prop), true);
            }
        }
    }

    void handleRemoveProperty() {
        SimpleProperty selectedProperty = this.getSelectedProperty();
        assert (selectedProperty != null);
        this.profileProperties.remove(selectedProperty.getName());
        this.propertiesViewer.refresh();
    }

    class AddHeaderPropertyDialog
    extends MessageDialog {
        private Button btnOk;
        private final Set<String> existingNames;
        private String name;
        private String value;

        public AddHeaderPropertyDialog(Shell parentShell, Set<String> existingPropertyNames) {
            super(parentShell, UTIL.getString("AddHeaderPropertyDialog_title", new Object[0]), null, UTIL.getString("AddHeaderPropertyDialog_message", new Object[0]), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.existingNames = existingPropertyNames == null ? new HashSet<String>(0) : existingPropertyNames;
        }

        protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
            Button btn = super.createButton(parent, id, label, defaultButton);
            if (id == 0) {
                this.btnOk = btn;
                btn.setEnabled(false);
            }
            return btn;
        }

        protected Control createCustomArea(Composite parent) {
            Composite pnl = new Composite(parent, 0);
            pnl.setLayout((Layout)new GridLayout(2, false));
            pnl.setLayoutData((Object)new GridData(4, 4, true, true));
            Label lblName = new Label(pnl, 0);
            lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblName.setText(UTIL.getString("AddHeaderPropertyDialog_lblName_text", new Object[0]));
            Text txtName = new Text(pnl, 2048);
            txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txtName.setToolTipText(UTIL.getString("AddHeaderPropertyDialog_txtName_toolTip", new Object[0]));
            txtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddHeaderPropertyDialog.this.handleNameChanged(((Text)e.widget).getText());
                }
            });
            Label lblValue = new Label(pnl, 0);
            lblValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            lblValue.setText(UTIL.getString("AddHeaderPropertyDialog_lblValue_text", new Object[0]));
            Text txtValue = new Text(pnl, 2048);
            txtValue.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            txtValue.setToolTipText(UTIL.getString("AddHeaderPropertyDialog_txtValue_toolTip", new Object[0]));
            txtValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AddHeaderPropertyDialog.this.handleValueChanged(((Text)e.widget).getText());
                }
            });
            return pnl;
        }

        public String getName() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.name;
        }

        public String getValue() {
            CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
            return this.value;
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }

        void handleNameChanged(String newName) {
            this.name = newName;
            this.updateState();
        }

        void handleValueChanged(String newValue) {
            this.value = newValue.trim();
            this.updateState();
        }

        private void updateState() {
            String msg = this.validateName();
            if (StringUtilities.isEmpty((String)msg)) {
                msg = this.validateValue();
            }
            if (StringUtilities.isEmpty((String)msg)) {
                if (!this.btnOk.isEnabled()) {
                    this.btnOk.setEnabled(true);
                }
                if (this.imageLabel.getImage() != null) {
                    this.imageLabel.setImage(null);
                }
                this.imageLabel.setImage(this.getInfoImage());
                msg = UTIL.getString("AddHeaderPropertyDialog_message", new Object[0]);
            } else {
                if (this.btnOk.isEnabled()) {
                    this.btnOk.setEnabled(false);
                }
                this.imageLabel.setImage(this.getErrorImage());
            }
            this.messageLabel.setText(msg);
            this.messageLabel.pack();
        }

        private String validateName() {
            String errorMsg = this.validateName(this.name);
            if (errorMsg == null) {
                for (String existingName : this.existingNames) {
                    if (!existingName.equals(this.name)) continue;
                    errorMsg = UTIL.getString("AddHeaderPropertyDialog_customPropertyAlreadyExists", (Object)this.name);
                    break;
                }
            }
            return errorMsg;
        }

        private String validateValue() {
            return this.validateValue(this.value);
        }

        public String validateName(String proposedName) {
            if (StringUtilities.isEmpty((String)proposedName)) {
                return UTIL.getString("AddHeaderPropertyDialog_emptyPropertyName", new Object[0]);
            }
            char[] cArray = proposedName.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!this.isValidChar(c)) {
                    return UTIL.getString("AddHeaderPropertyDialog_invalidPropertyName", new Object[0]);
                }
                ++n2;
            }
            return null;
        }

        private boolean isValidChar(char c) {
            return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_' || c == '.';
        }

        public String validateValue(String proposedValue) {
            if (StringUtilities.isEmpty((String)proposedValue)) {
                return UTIL.getString("AddHeaderPropertyDialog_emptyPropertyValue", new Object[0]);
            }
            return null;
        }
    }

    class PropertyLabelProvider
    extends ColumnLabelProvider {
        private final int columnID;

        public PropertyLabelProvider(int columnID) {
            this.columnID = columnID;
        }

        public String getText(Object element) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    return ((SimpleProperty)element).getName();
                }
                if (this.columnID == 1) {
                    return ((SimpleProperty)element).getValue();
                }
            }
            return super.getText(element);
        }
    }

    class PropertyNameEditingSupport
    extends EditingSupport {
        int columnID;
        private TextCellEditor editor;

        public PropertyNameEditingSupport(ColumnViewer viewer, int columnID) {
            super(viewer);
            this.columnID = columnID;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    return ((SimpleProperty)element).getName();
                }
                if (this.columnID == 1) {
                    return ((SimpleProperty)element).getValue();
                }
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    String oldKey = ((SimpleProperty)element).getName();
                    String oldValue = ((SimpleProperty)element).getValue();
                    String newKey = (String)value;
                    if (newKey != null && newKey.length() > 0 && !newKey.equalsIgnoreCase(oldKey)) {
                        HeaderPropertiesPanel.this.profileProperties.remove(oldKey);
                        HeaderPropertiesPanel.this.profileProperties.put(newKey, oldValue);
                        HeaderPropertiesPanel.this.propertiesViewer.refresh();
                    }
                } else if (this.columnID == 1) {
                    String key = ((SimpleProperty)element).getName();
                    String oldValue = ((SimpleProperty)element).getValue();
                    String newValue = (String)value;
                    if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                        HeaderPropertiesPanel.this.profileProperties.put(key, newValue);
                        HeaderPropertiesPanel.this.propertiesViewer.refresh();
                    }
                }
            }
        }
    }
}

