/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.file;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.UIJob;
import org.teiid.designer.datatools.ui.DatatoolsUiConstants;
import org.teiid.designer.datatools.ui.DatatoolsUiPlugin;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class FlatFileUrlProfilePropertyPage
extends ProfileDetailsPropertyPage
implements IContextProvider,
DatatoolsUiConstants {
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(DatatoolsUiPlugin.getDefault().getBundle().getSymbolicName());
    private Composite scrolled;
    private Label urlLabel;
    private Text urlText;

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.setPingButtonVisible(true);
        return result;
    }

    protected void createCustomContents(Composite parent) {
        Group group = WidgetFactory.createSimpleGroup((Composite)parent, (String)UTIL.getString("Common.Properties.Label", new Object[0]));
        this.scrolled = new Composite((Composite)group, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.scrolled.setLayout((Layout)gridLayout);
        this.urlLabel = new Label(this.scrolled, 0);
        this.urlLabel.setText(UTIL.getString("Common.URL.Label", new Object[0]));
        this.urlLabel.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.urlLabel.setLayoutData((Object)gd);
        this.urlText = new Text(this.scrolled, 2052);
        this.urlText.setToolTipText(UTIL.getString("Common.URL.ToolTip", new Object[0]));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.urlText.setLayoutData((Object)gd);
        this.initControls();
        this.addlisteners();
    }

    private void addlisteners() {
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FlatFileUrlProfilePropertyPage.this.validate();
            }
        });
    }

    protected void validate() {
        String errorMessage = null;
        boolean valid = true;
        if (this.urlText.getText() == null || this.urlText.getText().isEmpty()) {
            errorMessage = UTIL.getString("Common.URL.Error.Message", new Object[0]);
            valid = false;
        }
        this.setErrorMessage(errorMessage);
        this.setPingButtonEnabled(valid);
        this.setValid(valid);
    }

    private void initControls() {
        IConnectionProfile profile = this.getConnectionProfile();
        Properties props = profile.getBaseProperties();
        if (props.get("URL") != null) {
            this.urlText.setText((String)props.get("URL"));
        }
        this.validate();
    }

    protected Properties collectProperties() {
        Properties result = super.collectProperties();
        if (result == null) {
            result = new Properties();
        }
        result.setProperty("URL", this.urlText.getText());
        return result;
    }

    public void testConnection() {
        super.testConnection();
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        final XmlURLPingJob pingJob = new XmlURLPingJob(this.getShell(), profile);
        pingJob.schedule();
        return new Runnable(){

            @Override
            public void run() {
                try {
                    pingJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    public class XmlURLPingJob
    extends Job {
        private IConnectionProfile icp;
        private Shell shell;

        public XmlURLPingJob(Shell shell, IConnectionProfile profile) {
            super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.job"));
            this.setSystem(false);
            this.setUser(true);
            this.shell = shell;
            this.icp = profile;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.title"), -1);
            Exception exception = this.testXmlUrlConnection(this.icp);
            monitor.done();
            new XmlUrlPingUIJob(this.shell, exception).schedule();
            return Status.OK_STATUS;
        }

        public Exception testXmlUrlConnection(IConnectionProfile icp) {
            return null;
        }

        public Throwable getTestConnectionException(IConnection conn) {
            return conn != null ? conn.getConnectException() : new RuntimeException(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"));
        }

        public class XmlUrlPingUIJob
        extends UIJob {
            private Shell shell;
            private Throwable exception;

            public XmlUrlPingUIJob(Shell shell, Throwable exception) {
                super(ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.uijob"));
                this.setSystem(false);
                this.exception = exception;
                this.shell = shell;
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                this.showTestConnectionMessage(this.shell, this.exception);
                return Status.OK_STATUS;
            }

            public void showTestConnectionMessage(Shell shell, Throwable exception) {
                if (exception == null) {
                    MessageDialog.openInformation((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.success"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.success"));
                    FlatFileUrlProfilePropertyPage.this.validate();
                } else {
                    ExceptionHandler.showException((Shell)shell, (String)ConnectivityUIPlugin.getDefault().getResourceString("dialog.title.error"), (String)ConnectivityUIPlugin.getDefault().getResourceString("actions.ping.failure"), (Throwable)exception);
                    FlatFileUrlProfilePropertyPage.this.setErrorMessage(exception.getMessage());
                    FlatFileUrlProfilePropertyPage.this.validate();
                }
            }
        }
    }
}

