/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.EventObject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelProject;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.metamodels.xml.XmlRoot;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.graphics.GlobalUiFontManager;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelResourceSelectionValidator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceTreeProvider;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.wizard.XsdElementChooserPanel;
import org.teiid.designer.webservice.util.WebServiceBuildOptions;
import org.teiid.designer.webservice.util.WebServiceEditObject;
import org.teiid.designer.webservice.util.WebServiceUtil;

public class InterfaceDefinitionPage
extends WizardPage
implements EventObjectListener,
IInternalUiConstants,
IInternalUiConstants.HelpContexts {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(InterfaceDefinitionPage.class);
    private static final String BROWSE_TEXT = InterfaceDefinitionPage.getString("browseButton.text");
    private static final String SELECT_MODEL_TITLE = InterfaceDefinitionPage.getString("selectModelDialog.title");
    private static final String SELECT_MODEL_MSG = InterfaceDefinitionPage.getString("selectModelDialog.msg");
    private static final String SELECT_INTERFACE_TITLE = InterfaceDefinitionPage.getString("selectInterfaceDialog.title");
    private static final String SELECT_INTERFACE_MSG = InterfaceDefinitionPage.getString("selectInterfaceDialog.msg");
    static final String INTERFACE_SELECTION_READ_ONLY_MESSAGE = InterfaceDefinitionPage.getString("selectInterfaceDialog.selectionReadonly.msg");
    static final String INTERFACE_SELECTION_INVALID_MESSAGE = InterfaceDefinitionPage.getString("selectInterfaceDialog.selectionInvalid.msg");
    private WebServiceEditObject webServiceEditObject;
    private StringNameValidator nameValidator = new StringNameValidator();
    private Text modelNameField;
    private Text interfaceNameField;
    private Text operationNameField;
    private Text operationInputElemNameField;
    private Text operationOutputElemNameField;
    private Text locationContainerText;
    private Button selectModelButton;
    private Button selectInterfaceButton;
    private Button browseButton;
    private ModifyListener modelNameChangeListener;
    private ModifyListener interfaceNameChangeListener;
    private ModifyListener operationNameChangeListener;
    private ModifyListener operationInputMessageNameChangeListener;
    private ModifyListener operationOutputMessageNameChangeListener;
    private XsdElementChooserPanel operationInputElemChooser;
    private CLabel operationOutputElemLabel;
    private Font standardFont;
    private Font boldFont;
    private ISelection selection;
    private ViewerFilter wsModelFilter = new ViewerFilter(){

        public boolean select(Viewer theViewer, Object theParent, Object theElement) {
            boolean projectOpen;
            boolean result = false;
            if (theElement instanceof IResource && (projectOpen = ((IResource)theElement).getProject().isOpen())) {
                if (theElement instanceof IProject) {
                    result = true;
                } else if (theElement instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)theElement))) {
                    ModelResource theModel = null;
                    try {
                        theModel = ModelUtil.getModelResource((IFile)((IFile)theElement), (boolean)true);
                    }
                    catch (Exception ex) {
                        ModelerCore.Util.log((Throwable)ex);
                    }
                    if (WebServiceUtil.isWebServiceModelResource((ModelResource)theModel)) {
                        result = true;
                    }
                }
            }
            return result;
        }
    };
    final ViewerFilter interfaceFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        doSelect = true;
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isModelFile((IResource)((IFile)element))) {
                        ModelResource theModel = null;
                        try {
                            theModel = ModelUtil.getModelResource((IFile)((IFile)element), (boolean)true);
                        }
                        catch (Exception ex) {
                            ModelerCore.Util.log((Throwable)ex);
                        }
                        if (WebServiceUtil.isWebServiceModelResource((ModelResource)theModel)) {
                            doSelect = true;
                        }
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            } else if (element instanceof EObject && WebServiceUtil.isWebServiceInterface((Object)element)) {
                doSelect = true;
            }
            return doSelect;
        }
    };
    final ISelectionStatusValidator interfaceValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 1 && selection[0] instanceof EObject && WebServiceUtil.isWebServiceInterface((Object)selection[0])) {
                ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)selection[0]));
                if (mr != null && mr.isReadOnly()) {
                    return new Status(4, "org.teiid.designer.webservice.ui", 0, INTERFACE_SELECTION_READ_ONLY_MESSAGE, null);
                }
                return new Status(0, "org.teiid.designer.webservice.ui", 0, "", null);
            }
            return new Status(4, "org.teiid.designer.webservice.ui", 0, INTERFACE_SELECTION_INVALID_MESSAGE, null);
        }
    };

    public InterfaceDefinitionPage(ISelection selection) {
        super("interfaceDefinitionPage");
        this.setTitle(InterfaceDefinitionPage.getString("title"));
        this.setDescription(InterfaceDefinitionPage.getString("pageDefault.msg"));
        this.webServiceEditObject = new WebServiceEditObject();
        this.selection = selection;
    }

    public WebServiceBuildOptions getWebServiceBuildOptions() {
        return this.webServiceEditObject.getWebServiceBuildOptions();
    }

    public void createControl(Composite theParent) {
        Composite primaryContainer = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        primaryContainer.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)primaryContainer);
        if (!ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            this.addLocationComposite(primaryContainer);
        }
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)primaryContainer, "org.teiid.designer.webservice.ui.interfaceDefinitionPage");
        this.createEditPanel(primaryContainer);
        this.initialize();
        this.updateUi(null);
    }

    private void addLocationComposite(Composite container) {
        Composite locationComposite = new Composite(container, 0);
        GridData locationCompositeGridData = new GridData(1808);
        locationComposite.setLayoutData((Object)locationCompositeGridData);
        GridLayout locationLayout = new GridLayout();
        locationLayout.numColumns = 3;
        locationComposite.setLayout((Layout)locationLayout);
        Label locationMsg = new Label(locationComposite, 0);
        GridData locationMsgGridData = new GridData();
        locationMsgGridData.horizontalSpan = 3;
        locationMsg.setLayoutData((Object)locationMsgGridData);
        locationMsg.setText(InterfaceDefinitionPage.getString("locationMessage"));
        this.locationContainerText = new Text(locationComposite, 2052);
        GridData gd = new GridData(768);
        this.locationContainerText.setLayoutData((Object)gd);
        this.locationContainerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceDefinitionPage.this.setPageStatus();
            }
        });
        this.locationContainerText.setEditable(false);
        this.browseButton = new Button(locationComposite, 8);
        GridData buttonGridData = new GridData();
        this.browseButton.setLayoutData((Object)buttonGridData);
        this.browseButton.setText(InterfaceDefinitionPage.getString("browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InterfaceDefinitionPage.this.handleBrowse();
            }
        });
    }

    private void createEditPanel(Composite parent) {
        Composite panel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808);
        String messageString = InterfaceDefinitionPage.getString("messageLabel.text");
        StyledText messageText = new StyledText(panel, 8);
        messageText.setBackground(panel.getDisplay().getSystemColor(22));
        messageText.setText(messageString);
        this.createTopCreationComposite(panel);
        Composite opDefnPanel = WidgetFactory.createPanel((Composite)panel, (int)0, (int)1808);
        String operationDefnGroupText = InterfaceDefinitionPage.getString("operationDefnGroupText.text");
        Group operationDefnGroup = WidgetFactory.createGroup((Composite)opDefnPanel, (String)operationDefnGroupText, (int)1808);
        this.createOperationPropertiesComposite((Composite)operationDefnGroup);
        messageText.setFont(this.standardFont);
        StyleRange sRange1 = new StyleRange();
        String boldBlueStr = "Bold Blue";
        int startIndex = messageString.indexOf(boldBlueStr);
        int strLength = boldBlueStr.length();
        sRange1.start = startIndex;
        sRange1.length = strLength;
        sRange1.fontStyle = 1;
        sRange1.foreground = messageText.getDisplay().getSystemColor(9);
        messageText.setStyleRange(sRange1);
        StyleRange sRange2 = new StyleRange();
        String boldRedStr = "Bold Red";
        startIndex = messageString.indexOf(boldRedStr);
        strLength = boldRedStr.length();
        sRange2.start = startIndex;
        sRange2.length = strLength;
        sRange2.fontStyle = 1;
        sRange2.foreground = messageText.getDisplay().getSystemColor(3);
        messageText.setStyleRange(sRange2);
        this.operationInputElemNameField.forceFocus();
    }

    private void createTopCreationComposite(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout topCompositeLayout = new GridLayout();
        topComposite.setLayout((Layout)topCompositeLayout);
        topCompositeLayout.numColumns = 3;
        topCompositeLayout.marginWidth = 0;
        GridData topCompositeGridData = new GridData(768);
        topCompositeGridData.horizontalIndent = 20;
        topComposite.setLayoutData((Object)topCompositeGridData);
        String labelText = InterfaceDefinitionPage.getString("modelComposite.titleLabel.text");
        WidgetFactory.createLabel((Composite)topComposite, (int)256, (int)1, (String)labelText);
        this.modelNameField = WidgetFactory.createTextField((Composite)topComposite, (int)768);
        this.standardFont = this.modelNameField.getFont();
        FontData boldData = this.standardFont.getFontData()[0];
        boldData.setStyle(1);
        this.boldFont = GlobalUiFontManager.getFont((FontData)boldData);
        this.modelNameChangeListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceDefinitionPage.this.handleModelNameChanged();
            }
        };
        this.modelNameField.addModifyListener(this.modelNameChangeListener);
        this.selectModelButton = WidgetFactory.createButton((Composite)topComposite, (String)BROWSE_TEXT);
        this.selectModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                InterfaceDefinitionPage.this.selectModelButtonClicked();
            }
        });
        labelText = InterfaceDefinitionPage.getString("interfaceComposite.titleLabel.text");
        WidgetFactory.createLabel((Composite)topComposite, (int)256, (int)1, (String)labelText);
        this.interfaceNameField = WidgetFactory.createTextField((Composite)topComposite, (int)768);
        this.interfaceNameChangeListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceDefinitionPage.this.handleInterfaceNameChanged();
            }
        };
        this.interfaceNameField.addModifyListener(this.interfaceNameChangeListener);
        this.selectInterfaceButton = WidgetFactory.createButton((Composite)topComposite, (String)BROWSE_TEXT);
        this.selectInterfaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                InterfaceDefinitionPage.this.selectInterfaceButtonClicked();
            }
        });
        labelText = InterfaceDefinitionPage.getString("operationComposite.titleLabel.text");
        WidgetFactory.createLabel((Composite)topComposite, (int)256, (int)1, (String)labelText);
        this.operationNameField = WidgetFactory.createTextField((Composite)topComposite, (int)768, (int)2);
        this.operationNameChangeListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceDefinitionPage.this.handleOperationNameChanged();
            }
        };
        this.operationNameField.addModifyListener(this.operationNameChangeListener);
    }

    void handleBrowse() {
        IContainer locationContainer = WidgetUtil.showFolderSelectionDialog((IContainer)((IContainer)this.getTargetContainer()), (ViewerFilter)new ModelingResourceFilter(), (ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        if (locationContainer != null && this.locationContainerText != null) {
            this.locationContainerText.setText(locationContainer.getFullPath().makeRelative().toString());
            this.webServiceEditObject.setLocationContainer(locationContainer);
        }
        this.setPageStatus();
    }

    void handleModelNameChanged() {
        String newModelName = this.modelNameField.getText();
        if (this.webServiceEditObject.modelExistsInCurrentProject(newModelName)) {
            ModelResource model = this.webServiceEditObject.getModelFromCurrentProject(newModelName);
            this.webServiceEditObject.setCurrentWebServiceModel((Object)model);
            this.updateLocationPath(model);
        } else {
            this.webServiceEditObject.setCurrentWebServiceModel((Object)newModelName);
        }
        this.updateUi(this.modelNameField);
    }

    void handleInterfaceNameChanged() {
        String newInterfaceName = this.interfaceNameField.getText();
        this.webServiceEditObject.setCurrentInterfaceName(newInterfaceName);
        this.updateUi(this.interfaceNameField);
    }

    void handleOperationNameChanged() {
        String newOperationName = this.operationNameField.getText();
        this.webServiceEditObject.setCurrentOperationName(newOperationName);
        this.updateUi(this.operationNameField);
    }

    void selectModelButtonClicked() {
        Object[] selection;
        ModelWorkspaceTreeProvider provider = new ModelWorkspaceTreeProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)provider, (ITreeContentProvider)provider);
        dialog.setInput((Object)ModelerCore.getWorkspace().getRoot());
        dialog.setAllowMultiple(false);
        MetamodelDescriptor descriptor = WebServiceUtil.getWebServiceModelDescriptor();
        dialog.setValidator((ISelectionStatusValidator)new ModelResourceSelectionValidator(descriptor, false));
        dialog.addFilter(this.wsModelFilter);
        dialog.setTitle(SELECT_MODEL_TITLE);
        dialog.setMessage(SELECT_MODEL_MSG);
        if (dialog.open() == 0 && (selection = dialog.getResult()).length == 1 && selection[0] instanceof IFile) {
            IFile sourceFile = (IFile)selection[0];
            ModelResource selectedModel = null;
            this.modelNameField.setText("");
            boolean exceptionOccurred = false;
            try {
                selectedModel = ModelUtil.getModelResource((IFile)sourceFile, (boolean)true);
                this.updateLocationPath(selectedModel);
            }
            catch (Exception ex) {
                ModelerCore.Util.log((Throwable)ex);
                exceptionOccurred = true;
            }
            if (!exceptionOccurred) {
                String modelName = ModelerCore.getModelEditor().getModelName(selectedModel);
                this.modelNameField.setText(modelName);
            }
        }
    }

    void selectInterfaceButtonClicked() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)SELECT_INTERFACE_TITLE, (String)SELECT_INTERFACE_MSG, (boolean)true, null, (ViewerFilter)this.interfaceFilter, (ISelectionStatusValidator)this.interfaceValidator, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections.length == 1) {
            Object interfaceObj = selections[0];
            this.webServiceEditObject.setCurrent(interfaceObj);
            this.updateUi(this.interfaceNameField);
        }
    }

    private Composite createOperationPropertiesComposite(Composite parent) {
        Composite operationDefinitionComposite = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1808, (int)1, (int)2);
        GridData operationDefnCompositeGridData = new GridData(1808);
        operationDefnCompositeGridData.horizontalIndent = 20;
        operationDefinitionComposite.setLayoutData((Object)operationDefnCompositeGridData);
        String labelText = InterfaceDefinitionPage.getString("operationInputElemComposite.titleLabel.text");
        WidgetFactory.createLabel((Composite)operationDefinitionComposite, (int)256, (int)1, (String)labelText);
        this.operationInputElemChooser = new XsdElementChooserPanel(operationDefinitionComposite);
        this.operationInputElemChooser.setLayoutData(new GridData(768));
        this.operationInputElemChooser.addEventListener(this);
        labelText = InterfaceDefinitionPage.getString("operationInputElemNameComposite.titleLabel.text");
        WidgetFactory.createLabel((Composite)operationDefinitionComposite, (int)256, (int)1, (String)labelText);
        this.operationInputElemNameField = WidgetFactory.createTextField((Composite)operationDefinitionComposite, (int)256);
        this.operationInputMessageNameChangeListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceDefinitionPage.this.handleOperationInputMessageNameChanged();
            }
        };
        this.operationInputElemNameField.addModifyListener(this.operationInputMessageNameChangeListener);
        labelText = InterfaceDefinitionPage.getString("operationOutputDocComposite.titleLabel.text");
        WidgetFactory.createLabel((Composite)operationDefinitionComposite, (int)256, (int)1, (String)labelText);
        this.operationOutputElemLabel = WidgetFactory.createLabel((Composite)operationDefinitionComposite, (int)256, (int)1);
        labelText = InterfaceDefinitionPage.getString("operationOutputDocNameComposite.titleLabel.text");
        WidgetFactory.createLabel((Composite)operationDefinitionComposite, (int)256, (int)1, (String)labelText);
        this.operationOutputElemNameField = WidgetFactory.createTextField((Composite)operationDefinitionComposite, (int)256);
        this.operationOutputMessageNameChangeListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InterfaceDefinitionPage.this.handleOperationOutputMessageNameChanged();
            }
        };
        this.operationOutputElemNameField.addModifyListener(this.operationOutputMessageNameChangeListener);
        return operationDefinitionComposite;
    }

    void handleOperationInputMessageNameChanged() {
        String newOperationInputElemName = this.operationInputElemNameField.getText();
        this.webServiceEditObject.setOperationInputMessageName(newOperationInputElemName);
        Display display = this.operationInputElemNameField.getDisplay();
        if (!this.isValidName(newOperationInputElemName)) {
            this.operationInputElemNameField.setFont(this.boldFont);
            this.operationInputElemNameField.setForeground(display.getSystemColor(3));
        } else {
            this.operationInputElemNameField.setFont(this.standardFont);
            this.operationInputElemNameField.setForeground(display.getSystemColor(2));
        }
        this.setPageStatus();
    }

    void handleOperationOutputMessageNameChanged() {
        String newOperationOutputElemName = this.operationOutputElemNameField.getText();
        this.webServiceEditObject.setOperationOutputMessageName(newOperationOutputElemName);
        Display display = this.operationOutputElemNameField.getDisplay();
        if (!this.isValidName(newOperationOutputElemName)) {
            this.operationOutputElemNameField.setFont(this.boldFont);
            this.operationOutputElemNameField.setForeground(display.getSystemColor(3));
        } else {
            this.operationOutputElemNameField.setFont(this.standardFont);
            this.operationOutputElemNameField.setForeground(display.getSystemColor(2));
        }
        this.setPageStatus();
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    void setPageStatus() {
        IStatus status = this.webServiceEditObject.validate();
        if (status.getSeverity() == 4) {
            this.setMessage(status.getMessage(), 3);
            this.setPageComplete(false);
        } else if (status.getSeverity() == 1 || status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setPageComplete(true);
        } else {
            this.setMessage(InterfaceDefinitionPage.getString("pageDefault.msg"), 0);
            this.setPageComplete(true);
        }
    }

    public void setInitialSelection(ISelection theSelection) {
        this.selection = theSelection;
    }

    private void updateUi(Object updateSource) {
        this.modelNameField.removeModifyListener(this.modelNameChangeListener);
        this.interfaceNameField.removeModifyListener(this.interfaceNameChangeListener);
        this.operationNameField.removeModifyListener(this.operationNameChangeListener);
        String modelName = this.webServiceEditObject.getCurrentWebServiceModelName();
        String interfaceName = this.webServiceEditObject.getCurrentInterfaceName();
        String operationName = this.webServiceEditObject.getCurrentOperationName();
        if (updateSource != this.modelNameField) {
            this.modelNameField.setText(modelName);
        }
        Display display = this.modelNameField.getDisplay();
        if (this.webServiceEditObject.modelExistsInCurrentProject(modelName)) {
            this.modelNameField.setFont(this.boldFont);
            this.modelNameField.setForeground(display.getSystemColor(9));
            this.browseButton.setEnabled(false);
            this.webServiceEditObject.setUseLocationContainer(false);
        } else if (!this.isValidName(modelName)) {
            this.modelNameField.setFont(this.boldFont);
            this.modelNameField.setForeground(display.getSystemColor(3));
            this.browseButton.setEnabled(true);
            this.webServiceEditObject.setUseLocationContainer(true);
        } else {
            this.modelNameField.setFont(this.standardFont);
            this.modelNameField.setForeground(display.getSystemColor(2));
            this.browseButton.setEnabled(true);
            this.webServiceEditObject.setUseLocationContainer(true);
        }
        if (this.webServiceEditObject.interfaceExistsInCurrentModel(interfaceName)) {
            this.interfaceNameField.setFont(this.boldFont);
            this.interfaceNameField.setForeground(display.getSystemColor(9));
        } else if (!this.isValidName(interfaceName)) {
            this.interfaceNameField.setFont(this.boldFont);
            this.interfaceNameField.setForeground(display.getSystemColor(3));
        } else {
            this.interfaceNameField.setFont(this.standardFont);
            this.interfaceNameField.setForeground(display.getSystemColor(2));
        }
        if (updateSource != this.interfaceNameField) {
            this.interfaceNameField.setText(interfaceName);
        }
        if (updateSource != this.operationNameField) {
            this.operationNameField.setText(operationName);
        }
        if (this.webServiceEditObject.operationExistsInCurrentInterface(operationName)) {
            this.operationNameField.setFont(this.boldFont);
            this.operationNameField.setForeground(display.getSystemColor(3));
        } else if (!this.isValidName(operationName)) {
            this.operationNameField.setFont(this.boldFont);
            this.operationNameField.setForeground(display.getSystemColor(3));
        } else {
            this.operationNameField.setFont(this.standardFont);
            this.operationNameField.setForeground(display.getSystemColor(2));
        }
        this.updateCurrentOperationDetails();
        this.setPageStatus();
        this.modelNameField.addModifyListener(this.modelNameChangeListener);
        this.interfaceNameField.addModifyListener(this.interfaceNameChangeListener);
        this.operationNameField.addModifyListener(this.operationNameChangeListener);
    }

    private void updateCurrentOperationDetails() {
        this.operationInputElemNameField.removeModifyListener(this.operationInputMessageNameChangeListener);
        this.operationOutputElemNameField.removeModifyListener(this.operationOutputMessageNameChangeListener);
        this.operationInputElemChooser.removeEventListener(this);
        String inputName = this.webServiceEditObject.getCurrentOperationInputName();
        String outputName = this.webServiceEditObject.getCurrentOperationOutputName();
        XSDElementDeclaration outputElem = this.webServiceEditObject.getCurrentOperationOutputElem();
        this.operationInputElemNameField.setText(inputName);
        this.operationOutputElemNameField.setText(outputName);
        Display display = this.operationInputElemNameField.getDisplay();
        if (!this.isValidName(inputName)) {
            this.operationInputElemNameField.setFont(this.boldFont);
            this.operationInputElemNameField.setForeground(display.getSystemColor(3));
        } else {
            this.operationInputElemNameField.setFont(this.standardFont);
            this.operationInputElemNameField.setForeground(display.getSystemColor(2));
        }
        if (!this.isValidName(outputName)) {
            this.operationOutputElemNameField.setFont(this.boldFont);
            this.operationOutputElemNameField.setForeground(display.getSystemColor(3));
        } else {
            this.operationOutputElemNameField.setFont(this.standardFont);
            this.operationOutputElemNameField.setForeground(display.getSystemColor(2));
        }
        String text = this.getElementText(outputElem);
        Image image = this.getElementImage(outputElem);
        this.operationOutputElemLabel.setText(text);
        this.operationOutputElemLabel.setImage(image);
        this.operationInputElemNameField.addModifyListener(this.operationInputMessageNameChangeListener);
        this.operationOutputElemNameField.addModifyListener(this.operationOutputMessageNameChangeListener);
        this.operationInputElemChooser.addEventListener(this);
    }

    private String getElementText(Object object) {
        String result = "<No Selection>";
        if (object != null && object instanceof EObject) {
            result = ModelUtilities.getEMFLabelProvider().getText(object);
        }
        return result;
    }

    private Image getElementImage(Object object) {
        Image result = null;
        if (object != null && object instanceof EObject) {
            result = ModelUtilities.getEMFLabelProvider().getImage(object);
        }
        return result;
    }

    private boolean isValidName(String name) {
        boolean isValid = true;
        if (name != null && name.length() > 0) {
            isValid = this.nameValidator.isValidName(name);
        }
        return isValid;
    }

    private void initialize() {
        if (SelectionUtilities.isSingleSelection((ISelection)this.selection)) {
            Object sel = SelectionUtilities.getSelectedObject((ISelection)this.selection);
            if (this.webServiceEditObject.isXmlDocument(sel)) {
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource((EObject)((XmlDocument)sel));
                ModelProject modelProject = modelResource.getModelProject();
                this.webServiceEditObject = new WebServiceEditObject(modelProject);
                XmlRoot xmlRoot = ((XmlDocument)sel).getRoot();
                this.webServiceEditObject.setDefaultsUsingXmlRoot(xmlRoot);
                this.updateLocationPath(modelResource);
            } else if (this.webServiceEditObject.isXmlRoot(sel)) {
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource((EObject)((XmlRoot)sel));
                ModelProject modelProject = modelResource.getModelProject();
                this.webServiceEditObject = new WebServiceEditObject(modelProject);
                XmlRoot xmlRoot = (XmlRoot)sel;
                this.webServiceEditObject.setDefaultsUsingXmlRoot(xmlRoot);
                this.updateLocationPath(modelResource);
            } else if (sel instanceof IFile) {
                ModelResource modelResource = ModelerCore.getModelWorkspace().findModelResource((IResource)((IFile)sel));
                boolean isWebServiceModel = WebServiceUtil.isWebServiceModelResource((ModelResource)modelResource);
                if (isWebServiceModel) {
                    this.webServiceEditObject.setCurrent((Object)modelResource);
                }
                this.updateLocationPath(modelResource);
            }
        }
    }

    public void processEvent(EventObject e) {
        Object source = e.getSource();
        if (source != null && source.equals(this.operationInputElemChooser)) {
            XSDElementDeclaration selectedElem = this.operationInputElemChooser.getSelectedElement();
            this.webServiceEditObject.setOperationInputMessageElem(selectedElem);
            String currentInputMsgName = this.webServiceEditObject.getCurrentOperationInputName();
            if (currentInputMsgName == null || currentInputMsgName.length() == 0) {
                String elemName = selectedElem.getName();
                this.webServiceEditObject.setOperationInputMessageName(elemName);
            }
            this.updateCurrentOperationDetails();
            this.setPageStatus();
        }
    }

    private void updateLocationPath(ModelResource modelResource) {
        try {
            IContainer container = modelResource.getCorrespondingResource().getParent();
            if (this.locationContainerText != null) {
                this.locationContainerText.setText(container.getFullPath().makeRelative().toString());
            }
            this.webServiceEditObject.setLocationContainer(container);
        }
        catch (ModelWorkspaceException theException) {
            UTIL.log((Throwable)theException);
        }
    }

    private IResource getTargetContainer() {
        IWorkspaceRoot root;
        IResource resource;
        IResource result = null;
        String containerName = null;
        if (ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            IProject hiddenProj = ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject(false);
            if (hiddenProj != null) {
                containerName = hiddenProj.getFullPath().makeRelative().toString();
            }
        } else {
            containerName = this.locationContainerText.getText().trim();
        }
        if (containerName != null && !CoreStringUtil.isEmpty((String)containerName) && (resource = (root = ModelerCore.getWorkspace().getRoot()).findMember((IPath)new Path(containerName))).exists()) {
            result = resource;
        }
        return result;
    }
}

