/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.util.FileUrl;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.webservice.Output;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.proc.IAssignmentStatement;
import org.teiid.designer.query.sql.proc.IBlock;
import org.teiid.designer.query.sql.proc.ICreateProcedureCommand;
import org.teiid.designer.query.sql.proc.IDeclareStatement;
import org.teiid.designer.query.sql.proc.IStatement;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.SystemClipboardUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.webservice.IWebServiceResource;
import org.teiid.designer.webservice.procedure.XsdInstanceNode;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.util.WebServiceUtil;

public class WebServiceUiUtil
implements FileUtils.Constants,
IInternalUiConstants {
    public static final String[] FILE_DIALOG_XSD_EXTENSIONS;
    private static final String PREFIX;
    public static final String THIS_CLASS = "WebServiceUiUtil";

    static {
        PREFIX = I18nUtil.getPropertyPrefix(WebServiceUiUtil.class);
        FILE_DIALOG_XSD_EXTENSIONS = new String[]{WebServiceUiUtil.createFileDialogExtension("xsd")};
    }

    private static void addVariableStatements(XsdInstanceNode node, IBlock block, Input input, List nodes, List variables) {
        if (node.isSelectable()) {
            nodes.add(node);
            IDeclareStatement declaration = WebServiceUiUtil.createDeclareStatement(node, input);
            variables.add(declaration.getVariable());
            block.getStatements().add(0, declaration);
        }
        XsdInstanceNode[] children = node.getChildren();
        int ndx = children.length;
        while (--ndx >= 0) {
            WebServiceUiUtil.addVariableStatements(children[ndx], block, input, nodes, variables);
        }
    }

    public static void copyToClipboard(ISelection theSelection) {
        ArrayList<String> objects = new ArrayList<String>(SelectionUtilities.getSelectedObjects((ISelection)theSelection));
        if (!objects.isEmpty()) {
            int size = objects.size();
            int i = 0;
            while (i < size) {
                objects.set(i, WebServiceUiUtil.getText(objects.get(i)));
                ++i;
            }
            SystemClipboardUtilities.copyToClipboard((ISelection)new StructuredSelection(objects));
        }
    }

    public static IDeclareStatement createDeclareStatement(XsdInstanceNode node, Input input) {
        IQueryService service = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = service.createQueryFactory();
        String name = AspectManager.getSqlAspect((EObject)input).getFullName((EObject)input);
        IDeclareStatement statement = factory.createDeclareStatement(factory.createElementSymbol(WebServiceUiUtil.getQualifiedInputVariableName(node.getName())), "string");
        List<IExpression> expressions = Arrays.asList(factory.createElementSymbol(name), factory.createConstant((Object)WebServiceUtil.createXPath((XsdInstanceNode)node)));
        IFunction function = factory.createFunction("xpathvalue", expressions);
        statement.setValue((IExpression)function);
        return statement;
    }

    public static String createFileDialogExtension(String theExtension) {
        return new StringBuffer().append(FILE_NAME_WILDCARD).append('.').append(theExtension).toString();
    }

    public static void ensureVariablesUnique(Map nodesToDeclarations) {
        XsdInstanceNode[] nodes = new XsdInstanceNode[nodesToDeclarations.size()];
        IElementSymbol[] vars = new IElementSymbol[nodes.length];
        Iterator iter = nodesToDeclarations.entrySet().iterator();
        int ndx = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            nodes[ndx] = (XsdInstanceNode)entry.getKey();
            vars[ndx] = ((IDeclareStatement)entry.getValue()).getVariable();
            ++ndx;
        }
        WebServiceUiUtil.ensureVariablesUnique(nodes, vars);
    }

    public static void ensureVariablesUnique(XsdInstanceNode[] nodes, IElementSymbol[] variables) {
        int ndx1 = variables.length;
        while (--ndx1 > 0) {
            IElementSymbol var1 = variables[ndx1];
            String name1 = var1.getShortName();
            int ndx2 = ndx1;
            while (--ndx2 >= 0) {
                IElementSymbol var2 = variables[ndx2];
                if (!name1.equalsIgnoreCase(var2.getShortName())) continue;
                XsdInstanceNode node1 = nodes[ndx1];
                XsdInstanceNode node2 = nodes[ndx2];
                if (!WebServiceUiUtil.prefixAncestorNamesUntilUnique(var1, var2, node1.getParent(), node2.getParent())) {
                    WebServiceUiUtil.prefixNamespaceSegmentsUntilUnique(var1, var2, node1.getTargetNamespace(), node2.getTargetNamespace());
                }
                WebServiceUiUtil.ensureVariablesUnique(nodes, variables);
                return;
            }
        }
    }

    public static Image getImage(String theImageName) {
        return WebServiceUiPlugin.getDefault().getImage(theImageName);
    }

    public static ImageDescriptor getImageDescriptor(String theImageName) {
        return WebServiceUiPlugin.getDefault().getImageDescriptor(theImageName);
    }

    public static Operation getOperation(Object object) {
        if (object instanceof SqlTransformationMappingRoot) {
            object = ((SqlTransformationMappingRoot)object).getTarget();
        } else if (object instanceof Diagram) {
            object = ((Diagram)object).getTarget();
        }
        if (object instanceof Interface) {
            EList ops = ((Interface)object).getOperations();
            return ops.isEmpty() ? null : (Operation)ops.get(0);
        }
        if (object instanceof EObject) {
            EObject eObj = (EObject)object;
            while (eObj != null) {
                if (eObj instanceof Operation) {
                    return (Operation)eObj;
                }
                if (object instanceof ModelAnnotation) {
                    ModelAnnotation annot = (ModelAnnotation)object;
                    EList eObjs = annot.eResource().getContents();
                    for (Object nextObj : eObjs) {
                        if (!(nextObj instanceof Interface)) continue;
                        EList ops = ((Interface)nextObj).getOperations();
                        return ops.isEmpty() ? null : (Operation)ops.get(0);
                    }
                }
                eObj = eObj.eContainer();
            }
        }
        return null;
    }

    public static Interface getFirstInterface(Object object) {
        if (object instanceof Interface) {
            return (Interface)object;
        }
        if (object instanceof EObject) {
            EObject eObj = (EObject)object;
            while (eObj != null) {
                if (object instanceof ModelAnnotation) {
                    ModelAnnotation annot = (ModelAnnotation)object;
                    EList eObjs = annot.eResource().getContents();
                    for (Object nextObj : eObjs) {
                        if (!(nextObj instanceof Interface)) continue;
                        return (Interface)nextObj;
                    }
                }
                eObj = eObj.eContainer();
            }
        }
        return null;
    }

    private static String getQualifiedInputVariableName(String name) {
        return "VARIABLES.IN_" + name;
    }

    public static Image getSharedImage(String theImageName) {
        return PlatformUI.getWorkbench().getSharedImages().getImage(theImageName);
    }

    public static ImageDescriptor getSharedImageDescriptor(String theImageName) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(theImageName);
    }

    public static Image getStatusImage(IStatus theStatus) {
        Image result = null;
        switch (theStatus.getSeverity()) {
            case 4: {
                result = WebServiceUiUtil.getSharedImage("IMG_OBJS_ERROR_TSK");
                break;
            }
            case 2: {
                result = WebServiceUiUtil.getSharedImage("IMG_OBJS_WARN_TSK");
                break;
            }
            case 1: {
                result = WebServiceUiUtil.getSharedImage("IMG_OBJS_INFO_TSK");
            }
        }
        return result;
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    public static String getText(Object theObject) {
        String result = "";
        if (theObject != null) {
            if (theObject instanceof IWebServiceResource) {
                IWebServiceResource resource = (IWebServiceResource)theObject;
                result = new StringBuffer().append(WebServiceUiUtil.getString("property.namespace")).append('=').append(resource.getNamespace()).append(", ").append(WebServiceUiUtil.getString("property.resolvedPath")).append('=').append(resource.getFullPath()).toString();
            } else {
                result = theObject instanceof IFile ? ((IFile)theObject).getFullPath().toOSString() : (theObject instanceof FileUrl ? ((FileUrl)theObject).getOriginalUrlString() : (theObject instanceof File ? theObject.toString() : theObject.toString()));
            }
        }
        return result;
    }

    public static void initializeProcedure(Operation operation, Object transactionSource, boolean replace) {
        XmlDocument doc;
        Output output;
        XSDElementDeclaration elem;
        Input input;
        SqlTransformationMappingRoot root = (SqlTransformationMappingRoot)TransformationHelper.getTransformationMappingRoot((EObject)operation);
        ICreateProcedureCommand proc = null;
        if (!TransformationHelper.isEmptySelect((Object)root)) {
            proc = (ICreateProcedureCommand)TransformationHelper.getCommand((Object)root, (int)0);
        }
        boolean initVar = true;
        boolean initSelect = true;
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        if (proc == null) {
            String sqlString = TransformationHelper.getSelectSqlString((Object)root);
            if (sqlString != null && sqlString.length() > 0) {
                initVar = false;
                initSelect = false;
            } else {
                proc = factory.createCreateProcedureCommand(factory.createBlock());
            }
        } else {
            IBlock block = proc.getBlock();
            if (block == null) {
                proc.setBlock(factory.createBlock());
            } else {
                Iterator statementIter = block.getStatements().iterator();
                while (statementIter.hasNext()) {
                    Object statement = statementIter.next();
                    if (statement instanceof IDeclareStatement) {
                        if (replace && ((IDeclareStatement)statement).getVariable().getName().startsWith("VARIABLES.IN_")) {
                            statementIter.remove();
                            continue;
                        }
                        initVar = false;
                        continue;
                    }
                    if (statement instanceof IAssignmentStatement) {
                        if (replace && ((IAssignmentStatement)statement).getVariable().getName().startsWith("VARIABLES.IN_")) {
                            statementIter.remove();
                            continue;
                        }
                        initVar = false;
                        continue;
                    }
                    if (replace) {
                        statementIter.remove();
                        continue;
                    }
                    initSelect = false;
                }
            }
        }
        if (initVar && replace && (input = operation.getInput()) != null && (elem = input.getContentElement()) != null) {
            ArrayList nodes = new ArrayList();
            ArrayList vars = new ArrayList();
            WebServiceUiUtil.addVariableStatements(new XsdInstanceNode(elem), proc.getBlock(), input, nodes, vars);
            WebServiceUiUtil.ensureVariablesUnique(nodes.toArray(new XsdInstanceNode[nodes.size()]), vars.toArray(new IElementSymbol[vars.size()]));
        }
        if (initSelect && (output = operation.getOutput()) != null && (doc = output.getXmlDocument()) != null) {
            proc.getBlock().addStatement((IStatement)factory.createCommandStatement((ICommand)TransformationSqlHelper.createDefaultQuery((EObject)doc)));
        }
        if (initVar || initSelect) {
            TransformationHelper.setSelectSqlString((Object)root, (String)proc.toString(), (boolean)true, (Object)transactionSource);
        }
    }

    public static void addXmlDocumentAsSource(SqlTransformationMappingRoot transformation, XmlDocument xmlDocument, Object txnSource) {
        block15: {
            EObject target = transformation.getTarget();
            if (!(target instanceof Operation)) {
                return;
            }
            Operation operation = (Operation)target;
            if (xmlDocument != null && operation.getOutput() != null) {
                boolean requiredStart = false;
                boolean succeeded = false;
                try {
                    try {
                        requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Output Property Values", (Object)txnSource);
                        if (operation.getOutput().getXmlDocument() == null) {
                            operation.getOutput().setXmlDocument(xmlDocument);
                        } else if (operation.getOutput().getXmlDocument() != xmlDocument) {
                            operation.getOutput().setXmlDocument(xmlDocument);
                        }
                        XSDElementDeclaration xsdElementDec = (XSDElementDeclaration)xmlDocument.getRoot().getXsdComponent();
                        if (xsdElementDec != null && (operation.getOutput().getContentElement() == null || operation.getOutput().getContentElement() != xsdElementDec)) {
                            operation.getOutput().setContentElement(xsdElementDec);
                        }
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        UTIL.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".addXmlDocumentAsSource()");
                        if (!requiredStart) break block15;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block15;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    public static void clearXmlDocumentAsSource(SqlTransformationMappingRoot transformation, boolean forceClearContentViaElement, Object txnSource) {
        TransformationHelper.clearXmlDocumentAsSource((SqlTransformationMappingRoot)transformation, (boolean)forceClearContentViaElement, (Object)txnSource);
    }

    public static void setXmlDocumentAsSource(SqlTransformationMappingRoot transformation, XmlDocument xmlDocument, Object txnSource) {
        block11: {
            EObject target = transformation.getTarget();
            if (!(target instanceof Operation)) {
                return;
            }
            Operation operation = (Operation)target;
            if (xmlDocument != null && operation.getOutput() != null) {
                boolean requiredStart = false;
                boolean succeeded = false;
                try {
                    try {
                        requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Operation Output Xml Document", (Object)txnSource);
                        operation.getOutput().setXmlDocument(xmlDocument);
                        succeeded = true;
                    }
                    catch (Exception ex) {
                        UTIL.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".addXmlDocumentAsSource()");
                        if (!requiredStart) break block11;
                        if (succeeded) {
                            ModelerCore.commitTxn();
                            break block11;
                        }
                        ModelerCore.rollbackTxn();
                    }
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    public static boolean isXsdFile(File theFile) {
        return ModelFileUtil.isXsdFile((File)theFile);
    }

    public static boolean isXsdFile(IFile theFile) {
        return ModelUtil.isXsdFile((IResource)theFile);
    }

    private static boolean prefixAncestorNamesUntilUnique(IElementSymbol var1, IElementSymbol var2, XsdInstanceNode node1, XsdInstanceNode node2) {
        String name1 = var1.getShortName();
        if (node1 != null) {
            name1 = String.valueOf(node1.getName()) + '_' + name1;
            var1.setShortName("IN_" + name1);
            node1 = node1.getParent();
        }
        String name2 = var2.getShortName();
        if (node2 != null) {
            name2 = String.valueOf(node2.getName()) + '_' + name2;
            var2.setShortName("IN_" + name2);
            node2 = node2.getParent();
        }
        if (!name1.equalsIgnoreCase(name2)) {
            return true;
        }
        if (node1 != null || node2 != null) {
            return WebServiceUiUtil.prefixAncestorNamesUntilUnique(var1, var2, node1, node2);
        }
        return false;
    }

    private static void prefixNamespaceSegmentsUntilUnique(IElementSymbol var1, IElementSymbol var2, String namespace1, String namespace2) {
        String name1 = var1.getShortName();
        if (namespace1 != null) {
            int ndx = namespace1.lastIndexOf(46);
            name1 = String.valueOf(namespace1.substring(ndx + 1)) + '_' + name1;
            var1.setShortName("IN_" + name1);
            namespace1 = ndx >= 0 ? namespace1.substring(0, ndx) : null;
        }
        String name2 = var2.getShortName();
        if (namespace2 != null) {
            int ndx = namespace2.lastIndexOf(46);
            name2 = String.valueOf(namespace2.substring(ndx + 1)) + '_' + name2;
            var2.setShortName("IN_" + name2);
            String string = namespace2 = ndx >= 0 ? namespace2.substring(0, ndx) : null;
        }
        if (!name1.equalsIgnoreCase(name2)) {
            return;
        }
        WebServiceUiUtil.prefixNamespaceSegmentsUntilUnique(var1, var2, namespace1, namespace2);
    }

    public static void viewFile(Shell theShell, ISelection theSelection) {
        boolean result = false;
        Object file = "null";
        if (theSelection != null && !theSelection.isEmpty() && (file = SelectionUtilities.getSelectedObject((ISelection)theSelection)) != null) {
            if (file instanceof IFile) {
                result = UiUtil.openSystemEditor((IFile)((IFile)file));
            } else if (file instanceof File) {
                result = UiUtil.openSystemEditor((File)((File)file));
            } else if (file instanceof IWebServiceResource) {
                WebServiceUiUtil.viewFile(theShell, (ISelection)new StructuredSelection((Object)((IWebServiceResource)file).getFile()));
            }
        }
        if (!result) {
            String txt = file instanceof IFile ? ((IFile)file).getFullPath().toString() : file.toString();
            MessageDialog.openError((Shell)theShell, (String)UTIL.getString(String.valueOf(PREFIX) + "dialog.viewFile.title", new Object[]{txt}), (String)WebServiceUiUtil.getString("dialog.viewFile.msg"));
        }
    }

    private WebServiceUiUtil() {
    }
}

