/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.ItemKind;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerResourceSetImpl;
import org.eclipse.bpmn2.modeler.core.utils.JavaProjectClassLoader;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.NamespaceUtil;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;

public class ImportUtil {
    public static final String IMPORT_TYPE_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String IMPORT_TYPE_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String IMPORT_TYPE_JAVA = "http://www.java.com/javaTypes";
    public static final String IMPORT_TYPE_BPMN2 = "http://www.omg.org/spec/BPMN/20100524/MODEL";
    public static final String IMPORT_KIND_WSDL = "wsdl";
    public static final String IMPORT_KIND_XML_SCHEMA = "xsd";
    public static final String IMPORT_KIND_JAVA = "java";
    public static final String IMPORT_KIND_BPMN2 = "bpmn2";
    protected Bpmn2ModelerResourceSetImpl fHackedResourceSet;

    public Object loadImport(Import imp) {
        if (this.fHackedResourceSet == null) {
            ResourceSet rs = imp.eResource().getResourceSet();
            this.fHackedResourceSet = ModelUtil.slightlyHackedResourceSet(rs);
        }
        String type = imp.getImportType();
        String kind = null;
        if (IMPORT_TYPE_WSDL.equals(type)) {
            kind = IMPORT_KIND_WSDL;
        } else if (IMPORT_TYPE_XML_SCHEMA.equals(type)) {
            kind = IMPORT_KIND_XML_SCHEMA;
        } else if (IMPORT_TYPE_JAVA.equals(type)) {
            kind = IMPORT_KIND_JAVA;
        } else if (IMPORT_TYPE_BPMN2.equals(type)) {
            kind = "bpmn";
        } else {
            throw new IllegalArgumentException("Unsupported Import type: " + type);
        }
        String location = imp.getLocation();
        if (location == null) {
            location = "";
        }
        URI uri = URI.createURI((String)location);
        return this.loadImport(uri, kind);
    }

    public Import findImportForNamespace(Resource resource, String namespace) {
        if (namespace != null && !namespace.isEmpty()) {
            Definitions definitions = ModelUtil.getDefinitions(resource);
            for (Import imp : definitions.getImports()) {
                if (!namespace.equals(imp.getNamespace())) continue;
                return imp;
            }
        }
        return null;
    }

    public Import findImportForObject(Resource resource, Object o) {
        String namespace = null;
        if (o instanceof EObject) {
            EObject object = (EObject)o;
            while (object != null) {
                if (object instanceof Definition) {
                    namespace = ((Definition)object).getTargetNamespace();
                } else if (object instanceof XSDSchema) {
                    namespace = ((XSDSchema)object).getTargetNamespace();
                } else if (object instanceof Definitions) {
                    namespace = ((Definitions)object).getTargetNamespace();
                }
                object = object.eContainer();
            }
        } else {
            boolean cfr_ignored_0 = o instanceof IType;
        }
        return this.findImportForNamespace(resource, namespace);
    }

    private boolean isObjectQName(Resource resource, EObject o, String prefix, String localname) {
        String oprefix;
        String olocalname = this.getLocalnameForObject(o);
        return prefix != null ? prefix.equals(oprefix = NamespaceUtil.getPrefixForObject(resource, o)) && localname.equals(olocalname) : localname.equals(olocalname);
    }

    public Object getObjectForId(Import imp, EObject referencingObject, EReference referencingFeature, String id) {
        Object result = this.loadImport(imp);
        if (result instanceof EObject) {
            Resource resource = imp.eResource();
            String prefix = null;
            String localname = id;
            int i = id.indexOf(58);
            if (i > 0) {
                prefix = id.substring(0, i);
                localname = id.substring(i + 1);
            }
            EObject contents = (EObject)result;
            if (IMPORT_TYPE_WSDL.equals(imp.getImportType())) {
                if (referencingObject instanceof Interface) {
                    if (referencingFeature == Bpmn2Package.eINSTANCE.getInterface_ImplementationRef()) {
                        TreeIterator iter = contents.eAllContents();
                        while (iter.hasNext()) {
                            EObject o = (EObject)iter.next();
                            if (!(o instanceof PortType) || !this.isObjectQName(resource, o, prefix, localname)) continue;
                            return o;
                        }
                    }
                } else if (referencingObject instanceof Operation) {
                    if (referencingFeature == Bpmn2Package.eINSTANCE.getOperation_ImplementationRef()) {
                        TreeIterator iter = contents.eAllContents();
                        while (iter.hasNext()) {
                            EObject o = (EObject)iter.next();
                            if (!(o instanceof org.eclipse.wst.wsdl.Operation) || !this.isObjectQName(resource, o, prefix, localname)) continue;
                            return o;
                        }
                    }
                } else if (referencingObject instanceof Message) {
                    if (referencingFeature == Bpmn2Package.eINSTANCE.getMessage_ItemRef()) {
                        TreeIterator iter = contents.eAllContents();
                        while (iter.hasNext()) {
                            EObject o = (EObject)iter.next();
                            if (!(o instanceof org.eclipse.wst.wsdl.Message) || !this.isObjectQName(resource, o, prefix, localname)) continue;
                            return o;
                        }
                    }
                } else if (referencingObject instanceof Error) {
                    if (referencingFeature == Bpmn2Package.eINSTANCE.getError_StructureRef()) {
                        TreeIterator iter = contents.eAllContents();
                        while (iter.hasNext()) {
                            EObject o = (EObject)iter.next();
                            if (!(o instanceof Fault) || !this.isObjectQName(resource, o, prefix, localname)) continue;
                            return o;
                        }
                    }
                } else if (referencingObject instanceof ItemDefinition && referencingFeature == Bpmn2Package.eINSTANCE.getItemDefinition_StructureRef()) {
                    TreeIterator iter = contents.eAllContents();
                    while (iter.hasNext()) {
                        EObject o = (EObject)iter.next();
                        if (!(o instanceof org.eclipse.wst.wsdl.Message) && !(o instanceof Fault) && !(o instanceof XSDElementDeclaration) || !this.isObjectQName(resource, o, prefix, localname)) continue;
                        return o;
                    }
                }
            } else if (IMPORT_TYPE_XML_SCHEMA.equals(imp.getImportType())) {
                if (referencingObject instanceof ItemDefinition && referencingFeature == Bpmn2Package.eINSTANCE.getItemDefinition_StructureRef()) {
                    TreeIterator iter = contents.eAllContents();
                    while (iter.hasNext()) {
                        EObject o = (EObject)iter.next();
                        if (!(o instanceof XSDElementDeclaration) || !this.isObjectQName(resource, o, prefix, localname)) continue;
                        return o;
                    }
                }
            } else if (IMPORT_TYPE_BPMN2.equals(imp.getImportType())) {
                TreeIterator iter = contents.eAllContents();
                while (iter.hasNext()) {
                    EObject o = (EObject)iter.next();
                    if (!(o instanceof CallableElement) || !this.isObjectQName(resource, o, prefix, localname)) continue;
                    return o;
                }
            }
        } else if (result instanceof List) {
            List cfr_ignored_0 = (List)result;
        }
        return null;
    }

    public String getLocalnameForObject(Object o) {
        if (o instanceof PortType) {
            return ((PortType)o).getQName().getLocalPart();
        }
        if (o instanceof org.eclipse.wst.wsdl.Operation) {
            return ((org.eclipse.wst.wsdl.Operation)o).getName();
        }
        if (o instanceof org.eclipse.wst.wsdl.Message) {
            return ((org.eclipse.wst.wsdl.Message)o).getQName().getLocalPart();
        }
        if (o instanceof Fault) {
            return this.getLocalnameForObject(((Fault)o).getEMessage());
        }
        if (o instanceof XSDElementDeclaration) {
            return ((XSDElementDeclaration)o).getName();
        }
        return null;
    }

    public String getQNameForObject(Resource resource, Object o) {
        String prefix = NamespaceUtil.getPrefixForObject(resource, o);
        String name = this.getLocalnameForObject(o);
        if (prefix != null) {
            return String.valueOf(prefix) + ":" + name;
        }
        return name;
    }

    public static String getImportKind(Object object) {
        String kind = null;
        if (object instanceof IFile) {
            String ext = ((IFile)object).getFileExtension();
            if ("xml".equals(ext) || IMPORT_KIND_XML_SCHEMA.equals(ext)) {
                kind = IMPORT_KIND_XML_SCHEMA;
            } else if ("bpmn".equals(ext) || IMPORT_KIND_BPMN2.equals(ext)) {
                kind = IMPORT_KIND_BPMN2;
            } else if (IMPORT_KIND_WSDL.equals(ext)) {
                kind = IMPORT_KIND_WSDL;
            }
        } else if (object instanceof IType) {
            kind = IMPORT_KIND_JAVA;
        }
        return kind;
    }

    public Object loadImport(URI uri, String kind) {
        return this.loadImport(this.fHackedResourceSet, uri, kind);
    }

    public Object loadImport(Bpmn2ModelerResourceSetImpl resourceSet, URI uri, String kind) {
        Resource resource = null;
        if (IMPORT_KIND_JAVA.equals(kind)) {
            IProject[] projects;
            String fileName = uri.lastSegment();
            ArrayList<IType> results = new ArrayList<IType>();
            IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                try {
                    if (p.isOpen() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject javaProject = JavaCore.create((IProject)p);
                        JavaProjectClassLoader cl = new JavaProjectClassLoader(javaProject);
                        results.addAll(cl.findClasses(fileName));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            return results;
        }
        try {
            resource = resourceSet.getResource(uri, true, kind);
        }
        catch (Throwable t) {
            return t;
        }
        if (resource != null && resource.getErrors().isEmpty() && resource.isLoaded() && resource.getContents().size() > 0) {
            if (!resource.isTrackingModification()) {
                resource.setTrackingModification(true);
            }
            if (kind.equals(IMPORT_KIND_BPMN2)) {
                return ModelUtil.getDefinitions(resource);
            }
            return resource.getContents().get(0);
        }
        return null;
    }

    protected Object loadImport(Bpmn2ModelerResourceSetImpl resourceSet, IFile file, String kind) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        return this.loadImport(resourceSet, uri, kind);
    }

    public EObject resolveExternalReference(EObject object, EStructuralFeature feature, String id) {
        block8: {
            ArrayList<IFile> files;
            IProject container;
            IFile file;
            Bpmn2ModelerResourceSetImpl rs;
            block9: {
                block7: {
                    Resource resource = object.eResource();
                    rs = new Bpmn2ModelerResourceSetImpl();
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    file = workspace.getRoot().getFile((IPath)new Path(resource.getURI().toPlatformString(true)));
                    container = file.getProject();
                    files = new ArrayList<IFile>();
                    if (!(object instanceof CallActivity)) break block7;
                    if (feature != Bpmn2Package.eINSTANCE.getCallActivity_CalledElementRef()) break block8;
                    this.findAllFiles((IContainer)container, new String[]{"bpmn", IMPORT_KIND_BPMN2}, files);
                    for (IFile f : files) {
                        Object root;
                        if (f == file || !((root = this.loadImport(rs, f, IMPORT_KIND_BPMN2)) instanceof Definitions)) continue;
                        TreeIterator iter = ((Definitions)root).eAllContents();
                        while (iter.hasNext()) {
                            EObject o = (EObject)iter.next();
                            if (!(o instanceof CallableElement) || !id.equals(((CallableElement)o).getId())) continue;
                            return o;
                        }
                    }
                    break block8;
                }
                if (!(object instanceof ItemDefinition)) break block9;
                if (feature != Bpmn2Package.eINSTANCE.getItemDefinition_StructureRef()) break block8;
                this.findAllFiles((IContainer)container, new String[]{"xml", IMPORT_KIND_XML_SCHEMA}, files);
                for (IFile f : files) {
                    Object root;
                    if (f == file || !((root = this.loadImport(rs, f, IMPORT_KIND_XML_SCHEMA)) instanceof XSDSchema)) continue;
                    TreeIterator iter = ((XSDSchema)root).eAllContents();
                    while (iter.hasNext()) {
                        String name;
                        EObject o = (EObject)iter.next();
                        if (!(o instanceof XSDElementDeclaration) || !id.equals(name = this.getLocalnameForObject(o))) continue;
                        return o;
                    }
                }
                break block8;
            }
            if (object instanceof Interface && feature == Bpmn2Package.eINSTANCE.getInterface_ImplementationRef()) {
                this.findAllFiles((IContainer)container, new String[]{IMPORT_KIND_WSDL}, files);
                for (IFile f : files) {
                    Object root;
                    if (f == file || !((root = this.loadImport(rs, f, IMPORT_KIND_WSDL)) instanceof Definition)) continue;
                    TreeIterator iter = ((Definition)root).eAllContents();
                    while (iter.hasNext()) {
                        String name;
                        EObject o = (EObject)iter.next();
                        if (!(o instanceof PortType) || !id.equals(name = this.getLocalnameForObject(o))) continue;
                        return o;
                    }
                }
            }
        }
        return null;
    }

    private void findAllFiles(IContainer container, String[] extensions, List<IFile> files) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFile) {
                    String ext = ((IFile)res).getFileExtension();
                    String[] stringArray = extensions;
                    int n3 = extensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        if (s.equals(ext)) {
                            files.add((IFile)res);
                        }
                        ++n4;
                    }
                } else if (res instanceof IContainer) {
                    this.findAllFiles((IContainer)res, extensions, files);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Import addImport(EObject modelObject, Object importObject) {
        Resource resource = modelObject.eResource();
        return this.addImport(resource, importObject);
    }

    public Import addImport(Resource resource, Object importObject) {
        Import imp = null;
        if (resource instanceof Bpmn2Resource) {
            Definitions definitions = ModelUtil.getDefinitions(resource);
            if (importObject instanceof Definition) {
                Definition wsdlDefinition = (Definition)importObject;
                imp = ImportUtil.createBpmn2Object(definitions, Import.class);
                imp.setImportType(IMPORT_TYPE_WSDL);
                imp.setLocation(ImportUtil.makeURIRelative(resource.getURI(), wsdlDefinition.getLocation()));
                imp.setNamespace(wsdlDefinition.getTargetNamespace());
            } else if (importObject instanceof XSDSchema) {
                XSDSchema schema = (XSDSchema)importObject;
                imp = ImportUtil.createBpmn2Object(definitions, Import.class);
                imp.setImportType(IMPORT_TYPE_XML_SCHEMA);
                imp.setLocation(ImportUtil.makeURIRelative(resource.getURI(), schema.getSchemaLocation()));
                imp.setNamespace(schema.getTargetNamespace());
            } else if (importObject instanceof IType) {
                IType clazz = (IType)importObject;
                imp = ImportUtil.createBpmn2Object(definitions, Import.class);
                imp.setImportType(IMPORT_TYPE_JAVA);
                imp.setLocation(clazz.getFullyQualifiedName('.'));
                imp.setNamespace("http://" + clazz.getPackageFragment().getElementName());
            } else if (importObject instanceof Definitions) {
                Definitions defs = (Definitions)importObject;
                imp = ImportUtil.createBpmn2Object(definitions, Import.class);
                imp.setImportType(IMPORT_TYPE_BPMN2);
                imp.setLocation(ImportUtil.makeURIRelative(resource.getURI(), defs.eResource().getURI().toString()));
                imp.setNamespace(defs.getTargetNamespace());
            }
            if (imp != null) {
                for (Import i : definitions.getImports()) {
                    String location = i.getLocation();
                    if (location == null || !location.equals(imp.getLocation())) continue;
                    imp = null;
                    break;
                }
            }
            if (imp != null) {
                definitions.getImports().add(imp);
                NamespaceUtil.addNamespace(imp.eResource(), imp.getNamespace());
                this.addImportObjects(imp, importObject);
            }
        }
        return imp;
    }

    public void addImportObjects(Import imp, Object importObject) {
        Definitions definitions = ModelUtil.getDefinitions(imp);
        if (importObject instanceof Definition) {
            Types t;
            Definition wsdlDefinition = (Definition)importObject;
            String namespace = wsdlDefinition.getTargetNamespace();
            if (namespace != null && !namespace.isEmpty() && !NamespaceUtil.hasNamespace(definitions.eResource(), namespace)) {
                NamespaceUtil.addNamespace(definitions.eResource(), namespace);
            }
            if ((t = wsdlDefinition.getETypes()) != null) {
                for (Object s : t.getSchemas()) {
                    if (!(s instanceof XSDSchema)) continue;
                    XSDSchema schema = (XSDSchema)s;
                    for (XSDElementDeclaration elem : schema.getElementDeclarations()) {
                        this.createItemDefinition(definitions, imp, (EObject)elem, ItemKind.INFORMATION);
                    }
                }
            }
            for (PortType pt : wsdlDefinition.getEPortTypes()) {
                this.createInterface(definitions, imp, pt);
            }
        } else if (importObject instanceof XSDSchema) {
            XSDSchema schema = (XSDSchema)importObject;
            for (XSDElementDeclaration elem : schema.getElementDeclarations()) {
                this.createItemDefinition(definitions, imp, (EObject)elem, ItemKind.INFORMATION);
            }
        } else if (importObject instanceof IType) {
            IType clazz = (IType)importObject;
            this.createItemDefinition(definitions, imp, clazz);
        } else {
            boolean cfr_ignored_0 = importObject instanceof Definitions;
        }
    }

    public static String makeURIRelative(URI baseURI, String s) {
        URI uri = URI.createURI((String)s);
        uri = uri.deresolve(baseURI, false, true, true);
        return uri.toString();
    }

    public static boolean removeImport(Import imp) {
        Definitions definitions = ModelUtil.getDefinitions(imp);
        boolean canRemove = true;
        boolean canRemoveNamespace = true;
        String location = imp.getLocation();
        String namespace = imp.getNamespace();
        for (Import i : definitions.getImports()) {
            if (i == imp) continue;
            String loc1 = i.getLocation();
            String string = i.getNamespace();
            if (loc1 == null || location == null || loc1.equals(location) || string == null || namespace == null || !string.equals(namespace)) continue;
            canRemoveNamespace = false;
            break;
        }
        if (canRemoveNamespace) {
            NamespaceUtil.removeNamespace(imp.eResource(), namespace);
        }
        if (canRemove) {
            URI uri;
            String uriString;
            Object ref;
            List<Interface> list;
            String type = imp.getImportType();
            String loc = imp.getLocation();
            if (IMPORT_TYPE_WSDL.equals(type)) {
                list = ModelUtil.getAllRootElements(definitions, Interface.class);
                for (Interface interface_ : list) {
                    ref = interface_.getImplementationRef();
                    if (!(ref instanceof EObject) || !(uriString = (uri = EcoreUtil.getURI((EObject)((EObject)ref))).trimFragment().toString()).equals(loc)) continue;
                    ImportUtil.deleteInterface(definitions, interface_);
                }
                type = IMPORT_TYPE_XML_SCHEMA;
            }
            if (IMPORT_TYPE_XML_SCHEMA.equals(type)) {
                list = ModelUtil.getAllRootElements(definitions, ItemDefinition.class);
                for (ItemDefinition itemDefinition : list) {
                    ref = itemDefinition.getStructureRef();
                    if (!(ref instanceof EObject) || !(uriString = (uri = EcoreUtil.getURI((EObject)((EObject)ref))).trimFragment().toString()).equals(loc)) continue;
                    EcoreUtil.delete((EObject)itemDefinition);
                }
            }
            if (IMPORT_TYPE_JAVA.equals(type)) {
                IJavaProject project;
                list = ModelUtil.getAllRootElements(definitions, Interface.class);
                for (Interface interface_ : list) {
                    ref = interface_.getImplementationRef();
                    if (!(ref instanceof EObject) || !(uriString = (uri = EcoreUtil.getURI((EObject)((EObject)ref))).trimFragment().toString()).equals(loc)) continue;
                    ImportUtil.deleteInterface(definitions, interface_);
                }
                String string = imp.getLocation();
                boolean deleted = false;
                String filename = definitions.eResource().getURI().trimFragment().toPlatformString(true);
                if (filename != null && (project = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(filename).getProject())) != null) {
                    try {
                        IType clazz = project.findType(string);
                        if (clazz != null) {
                            ImportUtil.deleteItemDefinition(definitions, imp, clazz);
                            deleted = true;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                if (!deleted) {
                    ImportUtil.deleteItemDefinition(definitions, imp, string);
                }
            }
            IMPORT_TYPE_BPMN2.equals(type);
            definitions.getImports().remove(imp);
        }
        return canRemove;
    }

    public Interface createInterface(Definitions definitions, Import imp, PortType portType) {
        Interface intf = ImportUtil.createBpmn2Object(definitions, Interface.class);
        intf.setName(portType.getQName().getLocalPart());
        intf.setImplementationRef((Object)portType);
        this.createOperations(definitions, imp, intf, portType);
        Interface i = ImportUtil.findInterface(definitions, intf);
        if (i != null) {
            return i;
        }
        definitions.getRootElements().add(intf);
        return intf;
    }

    public Interface createInterface(Definitions definitions, Import imp, IType type, IMethod[] methods) {
        Interface intf = ImportUtil.createBpmn2Object(definitions, Interface.class);
        intf.setName(type.getElementName());
        intf.setImplementationRef((Object)ModelUtil.createStringWrapper(type.getFullyQualifiedName('.')));
        this.createOperations(definitions, imp, intf, type, methods);
        Interface i = ImportUtil.findInterface(definitions, intf);
        if (i != null) {
            return i;
        }
        definitions.getRootElements().add(intf);
        return intf;
    }

    public static void deleteInterface(Definitions definitions, Interface intf) {
        ImportUtil.deleteOperations(definitions, intf);
        EcoreUtil.delete((EObject)intf);
    }

    public static Interface findInterface(Definitions definitions, Interface intf) {
        List<Interface> list = ModelUtil.getAllRootElements(definitions, Interface.class);
        for (Interface i : list) {
            if (!ImportUtil.equals(i, intf)) continue;
            return i;
        }
        return null;
    }

    public void createOperations(Definitions definitions, Import imp, Interface intf, PortType portType) {
        for (org.eclipse.wst.wsdl.Operation wsdlop : portType.getEOperations()) {
            Output output;
            Operation bpmn2op = ImportUtil.createBpmn2Object(definitions, Operation.class);
            bpmn2op.setImplementationRef((Object)wsdlop);
            bpmn2op.setName(wsdlop.getName());
            Input input = wsdlop.getEInput();
            if (input != null && input.getEMessage() != null) {
                Message bpmn2msg = this.createMessage(definitions, imp, input.getEMessage());
                bpmn2op.setInMessageRef(bpmn2msg);
            }
            if ((output = wsdlop.getEOutput()) != null && output.getEMessage() != null) {
                Message bpmn2msg = this.createMessage(definitions, imp, output.getEMessage());
                bpmn2op.setOutMessageRef(bpmn2msg);
            }
            for (Fault fault : wsdlop.getEFaults()) {
                bpmn2op.getErrorRefs().add(this.createError(definitions, imp, fault));
            }
            if (ImportUtil.findOperation(definitions, bpmn2op) != null) continue;
            intf.getOperations().add(bpmn2op);
        }
    }

    public void createOperations(Definitions definitions, Import imp, Interface intf, IType type, IMethod[] methods) {
        try {
            if (methods == null) {
                methods = type.getMethods();
            }
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                block25: {
                    IMethod method = iMethodArray[n2];
                    if (!method.isConstructor() && !method.getElementName().contains("<") && (method.getFlags() & 1) != 0 && method.getNumberOfParameters() == 1) {
                        Operation bpmn2op = ImportUtil.createBpmn2Object(definitions, Operation.class);
                        bpmn2op.setImplementationRef((Object)ModelUtil.createStringWrapper(method.getElementName()));
                        bpmn2op.setName(method.getElementName());
                        String[] parameterTypes = method.getParameterTypes();
                        if (parameterTypes.length <= 1) {
                            String boxedType;
                            Message bpmn2msg;
                            String baseName = String.valueOf(intf.getName()) + "_" + bpmn2op.getName() + "_";
                            if (parameterTypes.length == 1) {
                                try {
                                    IType parameterType = ImportUtil.resolveType(type, parameterTypes[0]);
                                    bpmn2msg = this.createMessage(definitions, imp, parameterType, String.valueOf(baseName) + method.getParameterNames()[0]);
                                    if (parameterType == null && (boxedType = ImportUtil.getBoxedType(Signature.toString((String)parameterTypes[0]))) != null && boxedType.length() > 0) {
                                        bpmn2msg.setItemRef(this.createItemDefinition(definitions, null, boxedType, ItemKind.INFORMATION));
                                    }
                                    bpmn2op.setInMessageRef(bpmn2msg);
                                }
                                catch (JavaModelException e) {
                                    Activator.logStatus(e.getStatus());
                                    break block25;
                                }
                                catch (Exception e) {
                                    Activator.logError(e);
                                    break block25;
                                }
                            }
                            try {
                                IType returnType = ImportUtil.resolveType(type, method.getReturnType());
                                bpmn2msg = null;
                                if (returnType != null) {
                                    bpmn2msg = this.createMessage(definitions, imp, returnType, String.valueOf(baseName) + "Result");
                                } else {
                                    boxedType = ImportUtil.getBoxedType(Signature.toString((String)method.getReturnType()));
                                    if (boxedType != null && boxedType.length() > 0) {
                                        bpmn2msg = this.createMessage(definitions, imp, returnType, String.valueOf(baseName) + "Result");
                                        bpmn2msg.setItemRef(this.createItemDefinition(definitions, null, boxedType, ItemKind.INFORMATION));
                                    }
                                }
                                if (bpmn2msg != null) {
                                    bpmn2op.setOutMessageRef(bpmn2msg);
                                }
                            }
                            catch (JavaModelException e) {
                                Activator.logStatus(e.getStatus());
                            }
                            catch (Exception e) {
                                Activator.logError(e);
                            }
                            try {
                                String[] stringArray = method.getExceptionTypes();
                                int n3 = stringArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String exceptionTypeString = stringArray[n4];
                                    try {
                                        IType exceptionType = ImportUtil.resolveType(type, exceptionTypeString);
                                        bpmn2op.getErrorRefs().add(this.createError(definitions, imp, exceptionType));
                                    }
                                    catch (JavaModelException e) {
                                        Activator.logStatus(e.getStatus());
                                    }
                                    catch (Exception e) {
                                        Activator.logError(e);
                                    }
                                    ++n4;
                                }
                            }
                            catch (JavaModelException e) {
                                Activator.logStatus(e.getStatus());
                            }
                            if (ImportUtil.findOperation(definitions, bpmn2op) == null) {
                                intf.getOperations().add(bpmn2op);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Activator.logStatus(e.getStatus());
        }
    }

    private static IType resolveType(IType type, String typeSignature) throws JavaModelException, IllegalArgumentException {
        String typeString = Signature.toString((String)typeSignature);
        String[][] resolvedType = type.resolveType(typeString);
        return resolvedType == null || resolvedType.length == 0 ? null : type.getJavaProject().findType(resolvedType[0][0], resolvedType[0][1]);
    }

    private static String getBoxedType(String primitiveType) {
        if ("boolean".equals(primitiveType)) {
            return Boolean.class.getName();
        }
        if ("byte".equals(primitiveType)) {
            return Byte.class.getName();
        }
        if ("short".equals(primitiveType)) {
            return Short.class.getName();
        }
        if ("int".equals(primitiveType)) {
            return Integer.class.getName();
        }
        if ("long".equals(primitiveType)) {
            return Long.class.getName();
        }
        if ("char".equals(primitiveType)) {
            return Character.class.getName();
        }
        if ("float".equals(primitiveType)) {
            return Float.class.getName();
        }
        if ("double".equals(primitiveType)) {
            return Double.class.getName();
        }
        return null;
    }

    public static void deleteOperations(Definitions definitions, Interface intf) {
        ArrayList<Operation> opList = new ArrayList<Operation>();
        for (Operation bpmn2op : intf.getOperations()) {
            opList.add(bpmn2op);
        }
        for (Operation bpmn2op : opList) {
            Message m = bpmn2op.getInMessageRef();
            if (m != null) {
                ImportUtil.deleteMessage(definitions, m);
            }
            if ((m = bpmn2op.getOutMessageRef()) != null) {
                ImportUtil.deleteMessage(definitions, m);
            }
            ArrayList errorList = new ArrayList();
            errorList.addAll(bpmn2op.getErrorRefs());
            for (Error e : errorList) {
                ItemDefinition itemDef = e.getStructureRef();
                if (itemDef != null) {
                    EcoreUtil.delete((EObject)itemDef);
                }
                EcoreUtil.delete((EObject)e);
            }
            EcoreUtil.delete((EObject)bpmn2op);
        }
    }

    public static Operation findOperation(Definitions definitions, Operation bpmn2op) {
        List<Operation> list = ModelUtil.getAllRootElements(definitions, Operation.class);
        for (Operation o : list) {
            if (!ImportUtil.equals(o, bpmn2op)) continue;
            return o;
        }
        return null;
    }

    public Message createMessage(Definitions definitions, Import imp, org.eclipse.wst.wsdl.Message wsdlmsg) {
        Message bpmn2msg = ImportUtil.createBpmn2Object(definitions, Message.class);
        ItemDefinition itemDef = this.createItemDefinition(definitions, imp, wsdlmsg);
        bpmn2msg.setItemRef(itemDef);
        bpmn2msg.setName(wsdlmsg.getQName().getLocalPart());
        Message m = ImportUtil.findMessage(definitions, bpmn2msg);
        if (m != null) {
            return m;
        }
        definitions.getRootElements().add(bpmn2msg);
        return bpmn2msg;
    }

    public Message createMessage(Definitions definitions, Import imp, IType param, String paramName) {
        Message bpmn2msg = ImportUtil.createBpmn2Object(definitions, Message.class);
        if (param != null) {
            ItemDefinition itemDef = this.createItemDefinition(definitions, imp, param);
            bpmn2msg.setItemRef(itemDef);
        }
        bpmn2msg.setName(paramName);
        Message m = ImportUtil.findMessage(definitions, bpmn2msg);
        if (m != null) {
            return m;
        }
        definitions.getRootElements().add(bpmn2msg);
        return bpmn2msg;
    }

    public static void deleteMessage(Definitions definitions, Message msg) {
        ItemDefinition itemDef = msg.getItemRef();
        if (itemDef != null) {
            EcoreUtil.delete((EObject)itemDef);
        }
        EcoreUtil.delete((EObject)msg);
    }

    public static Message findMessage(Definitions definitions, Message msg) {
        List<Message> list = ModelUtil.getAllRootElements(definitions, Message.class);
        for (Message m : list) {
            if (!ImportUtil.equals(m, msg)) continue;
            return m;
        }
        return null;
    }

    public Error createError(Definitions definitions, Import imp, Fault fault) {
        Error error = ImportUtil.createBpmn2Object(definitions, Error.class);
        ItemDefinition itemDef = this.createItemDefinition(definitions, imp, (EObject)fault, ItemKind.INFORMATION);
        error.setName(fault.getName());
        error.setStructureRef(itemDef);
        Error e = ImportUtil.findError(definitions, error);
        if (e != null) {
            return e;
        }
        definitions.getRootElements().add(error);
        return error;
    }

    public Error createError(Definitions definitions, Import imp, IType exceptionType) {
        Error error = ImportUtil.createBpmn2Object(definitions, Error.class);
        ItemDefinition itemDef = this.createItemDefinition(definitions, imp, exceptionType);
        error.setName(exceptionType.getElementName());
        error.setStructureRef(itemDef);
        Error e = ImportUtil.findError(definitions, error);
        if (e != null) {
            return e;
        }
        definitions.getRootElements().add(error);
        return error;
    }

    public static Error findError(Definitions definitions, Error error) {
        List<Error> list = ModelUtil.getAllRootElements(definitions, Error.class);
        for (Error e : list) {
            if (!ImportUtil.equals(e, error)) continue;
            return e;
        }
        return null;
    }

    public ItemDefinition createItemDefinition(Definitions definitions, Import imp, org.eclipse.wst.wsdl.Message wsdlmsg) {
        return this.createItemDefinition(definitions, imp, (EObject)wsdlmsg, ItemKind.INFORMATION);
    }

    public ItemDefinition createItemDefinition(Definitions definitions, Import imp, IType clazz) {
        try {
            IType[] iTypeArray = clazz.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType c = iTypeArray[n2];
                if (Flags.isPublic((int)c.getFlags())) {
                    this.createItemDefinition(definitions, imp, c);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return this.createItemDefinition(definitions, imp, clazz.getFullyQualifiedName('.'), ItemKind.INFORMATION);
    }

    public ItemDefinition createItemDefinition(Definitions definitions, Import imp, String structName, ItemKind kind) {
        EObject structureRef = ModelUtil.createStringWrapper(structName);
        return this.createItemDefinition(definitions, imp, structureRef, kind);
    }

    public ItemDefinition createItemDefinition(Definitions definitions, Import imp, EObject structureRef, ItemKind kind) {
        String prefix;
        Resource resource = definitions.eResource();
        String namespace = NamespaceUtil.getNamespaceForPrefix(resource, prefix = NamespaceUtil.getPrefixForObject(resource, structureRef));
        if (namespace == null) {
            namespace = NamespaceUtil.addNamespaceForObject(resource, structureRef);
        }
        ItemDefinition itemDef = ImportUtil.createBpmn2Object(definitions, ItemDefinition.class);
        itemDef.setImport(imp);
        if (kind == null) {
            List<Process> processes = ModelUtil.getAllRootElements(definitions, Process.class);
            kind = processes.size() > 0 ? (processes.get(0).isIsExecutable() ? ItemKind.INFORMATION : ItemKind.PHYSICAL) : ItemKind.INFORMATION;
        }
        itemDef.setItemKind(kind);
        if (structureRef instanceof Fault) {
            structureRef = ((Fault)structureRef).getEMessage();
        }
        itemDef.setStructureRef((Object)structureRef);
        ItemDefinition i = ImportUtil.findItemDefinition(definitions, itemDef);
        if (i != null) {
            return i;
        }
        definitions.getRootElements().add(itemDef);
        return itemDef;
    }

    public static ItemDefinition findItemDefinition(Definitions definitions, Import imp, EObject structureRef, ItemKind kind) {
        ItemDefinition itemDef = ImportUtil.createBpmn2Object(definitions, ItemDefinition.class);
        itemDef.setImport(imp);
        itemDef.setItemKind(kind);
        itemDef.setStructureRef((Object)structureRef);
        return ImportUtil.findItemDefinition(definitions, itemDef);
    }

    public static ItemDefinition findItemDefinition(Definitions definitions, ItemDefinition itemDef) {
        List<ItemDefinition> list = ModelUtil.getAllRootElements(definitions, ItemDefinition.class);
        for (ItemDefinition i : list) {
            if (!ImportUtil.equals(i, itemDef)) continue;
            return i;
        }
        return null;
    }

    public static ItemDefinition findItemDefinition(Definitions definitions, Import imp, IType clazz) {
        EObject structureRef = ModelUtil.createStringWrapper(clazz.getFullyQualifiedName('.'));
        return ImportUtil.findItemDefinition(definitions, imp, structureRef, ItemKind.INFORMATION);
    }

    public static void deleteItemDefinition(Definitions definitions, Import imp, IType clazz) {
        try {
            IType[] iTypeArray = clazz.getTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType c = iTypeArray[n2];
                ImportUtil.deleteItemDefinition(definitions, imp, c);
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        EObject structureRef = ModelUtil.createStringWrapper(clazz.getFullyQualifiedName('.'));
        ItemDefinition itemDef = ImportUtil.findItemDefinition(definitions, imp, structureRef, ItemKind.INFORMATION);
        if (itemDef != null) {
            EcoreUtil.delete((EObject)itemDef);
        }
    }

    public static void deleteItemDefinition(Definitions definitions, Import imp, String structName) {
        if (structName != null && !structName.isEmpty()) {
            EObject structureRef = ModelUtil.createStringWrapper(structName);
            ItemDefinition itemDef = ImportUtil.findItemDefinition(definitions, imp, structureRef, ItemKind.INFORMATION);
            if (itemDef == null) {
                itemDef = ImportUtil.findItemDefinition(definitions, imp, structureRef, ItemKind.INFORMATION);
            }
            if (itemDef != null) {
                EcoreUtil.delete((EObject)itemDef);
            }
        }
    }

    private static boolean equals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (object1 instanceof Interface && object2 instanceof Interface) {
            Interface i1 = (Interface)object1;
            Interface i2 = (Interface)object2;
            return ImportUtil.equals(i1.getImplementationRef(), i2.getImplementationRef()) && ImportUtil.equals(i1.getName(), i2.getName()) && ImportUtil.equals(i1.getOperations(), i2.getOperations());
        }
        if (object1 instanceof Operation && object2 instanceof Operation) {
            Operation o1 = (Operation)object1;
            Operation o2 = (Operation)object2;
            return ImportUtil.equals(o1.getName(), o2.getName()) && ImportUtil.equals(o1.getImplementationRef(), o2.getImplementationRef()) && ImportUtil.equals(o1.getErrorRefs(), o2.getErrorRefs()) && ImportUtil.equals(o1.getInMessageRef(), o2.getInMessageRef()) && ImportUtil.equals(o1.getOutMessageRef(), o2.getOutMessageRef());
        }
        if (object1 instanceof Message && object2 instanceof Message) {
            Message m1 = (Message)object1;
            Message m2 = (Message)object2;
            return ImportUtil.equals(m1.getItemRef(), m2.getItemRef()) && ImportUtil.equals(m1.getName(), m2.getName());
        }
        if (object1 instanceof Error && object2 instanceof Error) {
            Error e1 = (Error)object1;
            Error e2 = (Error)object2;
            return ImportUtil.equals(e1.getName(), e2.getName()) && ImportUtil.equals(e1.getStructureRef(), e2.getStructureRef());
        }
        if (object1 instanceof ItemDefinition && object2 instanceof ItemDefinition) {
            ItemDefinition i1 = (ItemDefinition)object1;
            ItemDefinition i2 = (ItemDefinition)object2;
            return ImportUtil.equals(i1.getItemKind(), i2.getItemKind()) && ImportUtil.equals(i1.getStructureRef(), i2.getStructureRef());
        }
        if (object1 instanceof PortType && object2 instanceof PortType) {
            PortType p1 = (PortType)object1;
            PortType p2 = (PortType)object2;
            return ImportUtil.equals(p1.getQName(), p2.getQName()) && ImportUtil.equals(p1.getOperations(), p2.getOperations());
        }
        if (object1 instanceof org.eclipse.wst.wsdl.Operation && object2 instanceof org.eclipse.wst.wsdl.Operation) {
            org.eclipse.wst.wsdl.Operation o1 = (org.eclipse.wst.wsdl.Operation)object1;
            org.eclipse.wst.wsdl.Operation o2 = (org.eclipse.wst.wsdl.Operation)object2;
            return ImportUtil.equals(o1.getName(), o2.getName()) && ImportUtil.equals(o1.getInput(), o2.getInput()) && ImportUtil.equals(o1.getOutput(), o2.getOutput()) && ImportUtil.equals(o1.getFaults(), o2.getFaults()) && ImportUtil.equals(o1.getStyle(), o2.getStyle());
        }
        if (object1 instanceof org.eclipse.wst.wsdl.Message && object2 instanceof org.eclipse.wst.wsdl.Message) {
            org.eclipse.wst.wsdl.Message m1 = (org.eclipse.wst.wsdl.Message)object1;
            org.eclipse.wst.wsdl.Message m2 = (org.eclipse.wst.wsdl.Message)object2;
            return ImportUtil.equals(m1.getQName(), m2.getQName());
        }
        if (object1 instanceof MessageReference && object2 instanceof MessageReference) {
            MessageReference m1 = (MessageReference)object1;
            MessageReference m2 = (MessageReference)object2;
            return ImportUtil.equals(m1.getName(), m2.getName()) && ImportUtil.equals(m1.getEMessage(), m2.getEMessage());
        }
        if (object1 instanceof Fault && object2 instanceof Fault) {
            Fault f1 = (Fault)object1;
            Fault f2 = (Fault)object2;
            return ImportUtil.equals(f1.getEMessage(), f2.getEMessage());
        }
        if (object1 instanceof QName && object2 instanceof QName) {
            QName m1 = (QName)object1;
            QName m2 = (QName)object2;
            return ImportUtil.equals(m1.getNamespaceURI(), m2.getNamespaceURI()) && ImportUtil.equals(m1.getLocalPart(), m2.getLocalPart());
        }
        if (object1 instanceof XSDElementDeclaration && object2 instanceof XSDElementDeclaration) {
            XSDElementDeclaration x1 = (XSDElementDeclaration)object1;
            XSDElementDeclaration x2 = (XSDElementDeclaration)object2;
            return ImportUtil.equals(x1.getQName(), x2.getQName());
        }
        if (object1 instanceof Map && object2 instanceof Map) {
            Map m1 = (Map)object1;
            Map m2 = (Map)object2;
            if (m1.size() != m2.size()) {
                return false;
            }
            for (Object k1 : m1.keySet()) {
                if (ImportUtil.equals(m1.get(k1), m2.get(k1))) continue;
                return false;
            }
            return true;
        }
        if (object1 instanceof List && object2 instanceof List) {
            List l1 = (List)object1;
            List l2 = (List)object2;
            if (l1.size() != l2.size()) {
                return false;
            }
            int i = 0;
            while (i < l1.size()) {
                if (!ImportUtil.equals(l1.get(i), l2.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (object1 instanceof String && object2 instanceof String) {
            return object1.equals(object2);
        }
        return object1.equals(object2);
    }

    private static <T extends EObject> T createBpmn2Object(Definitions definitions, Class<T> clazz) {
        EClassifier eClassifier = Bpmn2Package.eINSTANCE.getEClassifier(clazz.getSimpleName());
        if (eClassifier instanceof EClass) {
            EObject newObject = Bpmn2Factory.eINSTANCE.create((EClass)eClassifier);
            ModelUtil.setID(newObject, definitions.eResource());
            return (T)newObject;
        }
        return null;
    }
}

