/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.utils;

import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public enum AnchorSite {
    TOP("anchor.top"),
    BOTTOM("anchor.bottom"),
    LEFT("anchor.left"),
    RIGHT("anchor.right"),
    CENTER("anchor.center");

    private final String key;

    private AnchorSite(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public static AnchorSite getSite(String key) {
        AnchorSite[] anchorSiteArray = AnchorSite.values();
        int n = anchorSiteArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnchorSite l = anchorSiteArray[n2];
            if (l.getKey().equals(key)) {
                return l;
            }
            ++n2;
        }
        return CENTER;
    }

    public static AnchorSite getSite(FixPointAnchor anchor) {
        return AnchorSite.getSite(Graphiti.getPeService().getPropertyValue((PropertyContainer)anchor, "anchor.location"));
    }

    public static void setSite(FixPointAnchor anchor, AnchorSite site) {
        Graphiti.getPeService().setPropertyValue((PropertyContainer)anchor, "anchor.location", site.getKey());
    }

    public static AnchorSite getNearestEdge(Shape shape, Point p) {
        int x;
        int y;
        GraphicsUtil.LineSegment edge = GraphicsUtil.findNearestEdge(shape, p);
        ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram(shape);
        AnchorSite site = edge.isHorizontal() ? ((y = edge.getStart().getY()) == loc.getY() ? TOP : BOTTOM) : ((x = edge.getStart().getX()) == loc.getX() ? LEFT : RIGHT);
        return site;
    }

    public static AnchorSite getNearestEdge(Shape shape, Point p1, Point p2) {
        int x;
        int y;
        GraphicsUtil.LineSegment edge = GraphicsUtil.findNearestEdge(shape, p1, p2);
        ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram(shape);
        AnchorSite site = edge.isHorizontal() ? ((y = edge.getStart().getY()) == loc.getY() ? TOP : BOTTOM) : ((x = edge.getStart().getX()) == loc.getX() ? LEFT : RIGHT);
        return site;
    }
}

