/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditor;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextObjectEditor
extends ObjectEditor {
    protected Text text;
    protected boolean multiLine = false;
    protected boolean testMultiLine = true;

    public TextObjectEditor(AbstractDetailComposite parent, EObject object, EStructuralFeature feature) {
        super(parent, object, feature);
    }

    @Override
    protected Control createControl(Composite composite, String label, int style) {
        this.createLabel(composite, label);
        if (this.testMultiLine && super.isMultiLineText()) {
            this.multiLine = true;
            style |= 0x202;
        }
        this.text = this.getToolkit().createText(composite, "", style | 0x800);
        GridData data = new GridData(4, 0x1000000, true, false, 2, 1);
        if (this.multiLine) {
            data.heightHint = 100;
        }
        this.text.setLayoutData((Object)data);
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && TextObjectEditor.this.multiLine) {
                    e.doit = false;
                }
            }
        });
        this.setText(this.getText());
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TextObjectEditor.this.isWidgetUpdating) {
                    TextObjectEditor.this.setValue(TextObjectEditor.this.text.getText());
                }
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ErrorUtils.showErrorMessage(null);
            }
        });
        Object result = this.getExtendedProperty("ui.can.edit");
        if (result instanceof Boolean) {
            this.setEditable((Boolean)result);
        }
        return this.text;
    }

    public void setMultiLine(boolean multiLine) {
        this.testMultiLine = false;
        this.multiLine = multiLine;
    }

    @Override
    public void setObject(EObject object) {
        super.setObject(object);
        this.updateText();
    }

    @Override
    public void setObject(EObject object, EStructuralFeature feature) {
        super.setObject(object, feature);
        this.updateText();
    }

    @Override
    protected boolean setValue(Object result) {
        if (super.setValue(result)) {
            this.updateText();
            return true;
        }
        this.text.setText(this.getText());
        return false;
    }

    protected void updateText() {
        try {
            this.isWidgetUpdating = true;
            if (!this.text.getText().equals(this.getText())) {
                int pos = this.text.getCaretPosition();
                this.setText(this.getText());
                this.text.setSelection(pos, pos);
            }
        }
        finally {
            this.isWidgetUpdating = false;
        }
    }

    protected void setText(String value) {
        if (value == null) {
            value = "";
        }
        if (!value.equals(this.text.getText())) {
            this.text.setText(value);
        }
    }

    protected String getText() {
        boolean useActualValue = false;
        Object result = this.getExtendedProperty("ui.can.set.null");
        if (result instanceof Boolean) {
            useActualValue = (Boolean)result;
        }
        if (useActualValue) {
            Object value = this.getBusinessObjectDelegate().getValue(this.object, this.feature);
            return value == null ? "" : value.toString();
        }
        return this.getBusinessObjectDelegate().getTextValue(this.object, this.feature);
    }

    @Override
    public void notifyChanged(Notification notification) {
        EStructuralFeature f;
        if (notification.getEventType() == -1) {
            this.updateText();
            super.notifyChanged(notification);
        } else if (this.object == notification.getNotifier() && notification.getFeature() instanceof EStructuralFeature && (f = (EStructuralFeature)notification.getFeature()) != null && (f.getName().equals(this.feature.getName()) || f.getName().equals("mixed"))) {
            this.updateText();
            super.notifyChanged(notification);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.text.setVisible(visible);
        GridData data = (GridData)this.text.getLayoutData();
        data.exclude = !visible;
        this.text.getParent().redraw();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.text != null && !this.text.isDisposed()) {
            this.text.dispose();
            this.text = null;
        }
    }

    @Override
    public Control getControl() {
        return this.text;
    }

    @Override
    public Object getValue() {
        return this.getText();
    }
}

