/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.flow;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Conversation;
import org.eclipse.bpmn2.ConversationLink;
import org.eclipse.bpmn2.ConversationNode;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SubChoreography;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateConnectionFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;

public abstract class AbstractCreateFlowFeature<CONNECTION extends BaseElement, SOURCE extends EObject, TARGET extends EObject>
extends AbstractBpmn2CreateConnectionFeature<CONNECTION, SOURCE, TARGET> {
    public AbstractCreateFlowFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canCreate(ICreateConnectionContext context) {
        Object source = this.getSourceBo(context);
        Object target = this.getTargetBo(context);
        if (source != null && target != null) {
            AnchorContainer sourceContainer = null;
            AnchorContainer targetContainer = null;
            if (context.getSourceAnchor() != null) {
                sourceContainer = context.getSourceAnchor().getParent();
            } else if (context.getSourcePictogramElement() instanceof FreeFormConnection) {
                return true;
            }
            if (context.getTargetAnchor() != null) {
                targetContainer = context.getTargetAnchor().getParent();
            } else if (context.getTargetPictogramElement() instanceof FreeFormConnection) {
                return true;
            }
            return AbstractCreateFlowFeature.canCreateConnection(sourceContainer, targetContainer, this.getBusinessObjectClass(), null);
        }
        return false;
    }

    public Connection create(ICreateConnectionContext context) {
        Connection connection = null;
        CONNECTION businessObject = this.createBusinessObject(context);
        if (businessObject != null) {
            Point p;
            AnchorContainer source = (AnchorContainer)context.getSourcePictogramElement();
            AnchorContainer target = (AnchorContainer)context.getTargetPictogramElement();
            Anchor sourceAnchor = context.getSourceAnchor();
            Anchor targetAnchor = context.getTargetAnchor();
            ILocation sourceLoc = context.getSourceLocation();
            ILocation targetLoc = context.getTargetLocation();
            if (sourceAnchor == null || sourceAnchor instanceof ChopboxAnchor) {
                p = sourceLoc != null ? GraphicsUtil.createPoint(sourceLoc) : (targetLoc != null ? GraphicsUtil.createPoint(targetLoc) : (targetAnchor != null ? GraphicsUtil.createPoint(targetAnchor) : GraphicsUtil.getShapeCenter(target)));
                sourceAnchor = AnchorUtil.createAnchor(source, p);
            }
            if (targetAnchor == null || targetAnchor instanceof ChopboxAnchor) {
                p = targetLoc != null ? GraphicsUtil.createPoint(targetLoc) : (sourceLoc != null ? GraphicsUtil.createPoint(sourceLoc) : (sourceAnchor != null ? GraphicsUtil.createPoint(sourceAnchor) : GraphicsUtil.getShapeCenter(source)));
                targetAnchor = AnchorUtil.createAnchor(target, p);
            }
            ((CreateConnectionContext)context).setSourceAnchor(sourceAnchor);
            ((CreateConnectionContext)context).setTargetAnchor(targetAnchor);
            AddConnectionContext addContext = this.createAddConnectionContext(context, businessObject);
            addContext.setNewObject(businessObject);
            connection = (Connection)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
            FeatureSupport.updateConnection(this.getFeatureProvider(), connection);
            this.changesDone = true;
        } else {
            this.changesDone = false;
        }
        return connection;
    }

    @Override
    public CONNECTION createBusinessObject(ICreateConnectionContext context) {
        Object businessObject = super.createBusinessObject(context);
        Object source = this.getSourceBo(context);
        Object target = this.getTargetBo(context);
        this.addConnectionToContainer(businessObject, source, target);
        return businessObject;
    }

    protected abstract String getStencilImageId();

    public String getCreateImageId() {
        return this.getStencilImageId();
    }

    public String getCreateLargeImageId() {
        return this.getStencilImageId();
    }

    private boolean addConnectionToContainer(CONNECTION connection, SOURCE source, TARGET target) {
        EObject sourceContainer = source.eContainer();
        EObject targetContainer = target.eContainer();
        if (connection instanceof SequenceFlow) {
            if (source instanceof Participant) {
                if (((Participant)source).getProcessRef() != null) {
                    ((Participant)source).getProcessRef().getFlowElements().add((SequenceFlow)connection);
                    return true;
                }
            } else {
                if (sourceContainer instanceof FlowElementsContainer && sourceContainer == targetContainer) {
                    ((FlowElementsContainer)sourceContainer).getFlowElements().add((SequenceFlow)connection);
                    return true;
                }
                if (source instanceof FlowElementsContainer) {
                    ((FlowElementsContainer)source).getFlowElements().add((SequenceFlow)connection);
                    return true;
                }
            }
        } else if (connection instanceof Association) {
            if (source instanceof Process) {
                ((Process)source).getArtifacts().add((Association)connection);
                return true;
            }
            if (source instanceof SubProcess) {
                while (sourceContainer != null) {
                    if (sourceContainer instanceof Process) {
                        ((Process)sourceContainer).getArtifacts().add((Association)connection);
                        return true;
                    }
                    if (sourceContainer instanceof Collaboration) {
                        ((Collaboration)sourceContainer).getArtifacts().add((Association)connection);
                        return true;
                    }
                    sourceContainer = sourceContainer.eContainer();
                }
                ((SubProcess)source).getArtifacts().add((Association)connection);
                return true;
            }
            if (source instanceof SubChoreography) {
                while (sourceContainer != null) {
                    if (sourceContainer instanceof Process) {
                        ((Process)sourceContainer).getArtifacts().add((Association)connection);
                        return true;
                    }
                    if (sourceContainer instanceof Collaboration) {
                        ((Collaboration)sourceContainer).getArtifacts().add((Association)connection);
                        return true;
                    }
                    sourceContainer = sourceContainer.eContainer();
                }
                ((SubChoreography)source).getArtifacts().add((Association)connection);
                return true;
            }
            if (source instanceof Collaboration) {
                ((Collaboration)source).getArtifacts().add((Association)connection);
                return true;
            }
        } else if (connection instanceof MessageFlow) {
            if (source instanceof Activity) {
                EObject container = source.eContainer();
                while (container != null) {
                    if (container instanceof Process) {
                        source = container;
                        break;
                    }
                    container = container.eContainer();
                }
            }
            if (source instanceof Process) {
                Definitions definitions = ModelUtil.getDefinitions(source);
                block3: for (Collaboration c : ModelUtil.getAllRootElements(definitions, Collaboration.class)) {
                    for (Participant p : c.getParticipants()) {
                        if (p.getProcessRef() != source) continue;
                        source = c;
                        continue block3;
                    }
                }
            }
            if (source instanceof Collaboration) {
                ((Collaboration)source).getMessageFlows().add((MessageFlow)connection);
                return true;
            }
            if (source instanceof ChoreographyTask) {
                ((ChoreographyTask)source).getMessageFlowRef().add((MessageFlow)connection);
            } else if (source instanceof ConversationNode) {
                ((ConversationNode)source).getMessageFlowRefs().add((MessageFlow)connection);
            }
        } else if (connection instanceof ConversationLink) {
            if (source instanceof Process) {
                Definitions definitions = ModelUtil.getDefinitions(source);
                block5: for (Collaboration c : ModelUtil.getAllRootElements(definitions, Collaboration.class)) {
                    for (Participant p : c.getParticipants()) {
                        if (p.getProcessRef() != source) continue;
                        source = c;
                        continue block5;
                    }
                }
            }
            if (source instanceof Collaboration) {
                ((Collaboration)source).getConversationLinks().add((ConversationLink)connection);
                return true;
            }
            if (source instanceof Conversation && target instanceof Participant) {
                ((Conversation)source).getParticipantRefs().add((Participant)target);
            }
            if (target instanceof Conversation && source instanceof Participant) {
                ((Conversation)target).getParticipantRefs().add((Participant)source);
            }
        }
        if (source.eContainer() instanceof EObject) {
            return this.addConnectionToContainer(connection, source.eContainer(), target);
        }
        return false;
    }
}

