/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractUpdateMarkerFeature<T extends FlowElement>
extends AbstractUpdateBaseElementFeature<Activity> {
    public AbstractUpdateMarkerFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public IReason updateNeeded(IUpdateContext context) {
        IReason reason = super.updateNeeded(context);
        if (reason.toBoolean()) {
            return reason;
        }
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape) {
            String property = Graphiti.getPeService().getPropertyValue((PropertyContainer)pe, this.getPropertyKey());
            if (property == null) {
                return reason;
            }
            FlowElement activity = (FlowElement)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
            if (this.isPropertyChanged(activity, property)) {
                reason = Reason.createTrueReason((String)"Marker changed");
            }
        }
        return reason;
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        if (pe instanceof ContainerShape) {
            FlowElement element = (FlowElement)this.getBusinessObjectForPictogramElement(pe);
            this.doUpdate(element, (ContainerShape)pe);
            Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, this.getPropertyKey(), this.convertPropertyToString(element));
            return true;
        }
        return false;
    }

    protected abstract String getPropertyKey();

    protected abstract boolean isPropertyChanged(T var1, String var2);

    protected abstract void doUpdate(T var1, ContainerShape var2);

    protected abstract String convertPropertyToString(T var1);
}

