/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;

public class DefaultDeleteBPMNShapeFeature
extends DefaultDeleteFeature {
    public DefaultDeleteBPMNShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected boolean getUserDecision(IDeleteContext context) {
        return true;
    }

    public boolean canDelete(IDeleteContext context) {
        if (context.getPictogramElement() instanceof Diagram) {
            return false;
        }
        LifecycleEvent event = new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_CAN_DELETE, this.getFeatureProvider(), (IContext)context, context.getPictogramElement());
        TargetRuntime.getCurrentRuntime().notify(event);
        return event.doit;
    }

    public void delete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        ArrayList<AnchorContainer> shapes = new ArrayList<AnchorContainer>();
        ArrayList connections = new ArrayList();
        if (pe instanceof Connection) {
            AnchorContainer ac;
            for (Anchor anchor : AnchorUtil.getAnchors((AnchorContainer)((Connection)pe))) {
                connections.addAll(anchor.getIncomingConnections());
                connections.addAll(anchor.getOutgoingConnections());
            }
            for (Connection connection : connections) {
                DeleteContext dc = new DeleteContext((PictogramElement)connection);
                IDeleteFeature f = this.getFeatureProvider().getDeleteFeature((IDeleteContext)dc);
                f.delete((IDeleteContext)dc);
            }
            Connection connection = (Connection)pe;
            AnchorContainer anchorContainer = ac = connection.getStart() == null ? null : connection.getStart().getParent();
            if (ac != null) {
                shapes.add(ac);
            }
            AnchorContainer anchorContainer2 = ac = connection.getEnd() == null ? null : connection.getEnd().getParent();
            if (ac != null) {
                shapes.add(ac);
            }
        }
        super.delete(context);
        connections.clear();
        for (AnchorContainer anchorContainer : shapes) {
            for (Anchor a : anchorContainer.getAnchors()) {
                connections.addAll(a.getIncomingConnections());
                connections.addAll(a.getOutgoingConnections());
            }
        }
        for (Connection connection : connections) {
            FeatureSupport.updateConnection(this.getFeatureProvider(), connection);
        }
    }

    protected void deleteBusinessObject(Object bo) {
        Object v;
        EStructuralFeature reference = ((EObject)bo).eClass().getEStructuralFeature("categoryValueRef");
        if (reference != null && (v = ((EObject)bo).eGet(reference)) instanceof EList) {
            ((EList)v).clear();
        }
        List pictElements = Graphiti.getLinkService().getPictogramElements(this.getDiagram(), (EObject)bo);
        for (PictogramElement pe : pictElements) {
            this.deletePeEnvironment(pe);
            Graphiti.getPeService().deletePictogramElement(pe);
        }
        TargetRuntime.getCurrentRuntime().notify(new LifecycleEvent(LifecycleEvent.EventType.BUSINESSOBJECT_DELETED, bo));
        super.deleteBusinessObject(bo);
    }

    protected void deletePeEnvironment(PictogramElement pictogramElement) {
        if (pictogramElement instanceof ContainerShape) {
            ContainerShape containerShape = (ContainerShape)pictogramElement;
            ArrayList<Connection> connections = new ArrayList<Connection>();
            for (Anchor anchor : containerShape.getAnchors()) {
                connections.addAll((Collection<Connection>)anchor.getIncomingConnections());
                connections.addAll((Collection<Connection>)anchor.getOutgoingConnections());
            }
            this.deleteConnections(this.getFeatureProvider(), connections);
            this.deleteContainer(this.getFeatureProvider(), containerShape);
        }
    }

    protected void deleteContainer(IFeatureProvider fp, ContainerShape containerShape) {
        Object[] children;
        Object[] objectArray = children = containerShape.getChildren().toArray();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object shape = objectArray[n2];
            if (shape instanceof ContainerShape) {
                DeleteContext context = new DeleteContext((PictogramElement)shape);
                TargetRuntime rt = TargetRuntime.getCurrentRuntime();
                rt.notify(new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_DELETED, fp, (IContext)context, shape));
                fp.getDeleteFeature((IDeleteContext)context).delete((IDeleteContext)context);
            }
            ++n2;
        }
        TargetRuntime rt = TargetRuntime.getCurrentRuntime();
        rt.notify(new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_DELETED, fp, null, containerShape));
    }

    protected void deleteConnections(IFeatureProvider fp, List<Connection> connections) {
        ArrayList<Connection> allConnections = new ArrayList<Connection>();
        allConnections.addAll(connections);
        for (Connection connection : allConnections) {
            DeleteContext context = new DeleteContext((PictogramElement)connection);
            TargetRuntime rt = TargetRuntime.getCurrentRuntime();
            rt.notify(new LifecycleEvent(LifecycleEvent.EventType.PICTOGRAMELEMENT_DELETED, fp, (IContext)context, connection));
            fp.getDeleteFeature((IDeleteContext)context).delete((IDeleteContext)context);
        }
    }
}

