/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.DetourPoints;
import org.eclipse.bpmn2.modeler.core.utils.AnchorSite;
import org.eclipse.bpmn2.modeler.core.utils.AnchorType;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class AutomaticConnectionRouter
extends BendpointConnectionRouter {
    protected static final int margin = 10;

    public AutomaticConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected ConnectionRoute calculateRoute() {
        if (this.isSelfConnection()) {
            return this.calculateSelfConnectionRoute();
        }
        GraphicsUtil.debug = false;
        boolean initialUpdate = peService.getPropertyValue((PropertyContainer)this.ffc, "initial.update") != null;
        Point start = null;
        Point end = null;
        Point middle = null;
        if (this.movedBendpoint != null) {
            middle = this.movedBendpoint;
        }
        ArrayList<ConnectionRoute> allRoutes = new ArrayList<ConnectionRoute>();
        AnchorSite sourceSite = AnchorSite.getSite(this.sourceAnchor);
        AnchorSite targetSite = AnchorSite.getSite(this.targetAnchor);
        AnchorSite initialSourceSite = sourceSite;
        AnchorSite initialTargetSite = targetSite;
        int i = 0;
        while (i < 16) {
            if (this.shouldCalculate(sourceSite, targetSite)) {
                AnchorSite.setSite(this.sourceAnchor, sourceSite);
                AnchorUtil.adjustAnchors((AnchorContainer)this.source);
                AnchorSite.setSite(this.targetAnchor, targetSite);
                AnchorUtil.adjustAnchors((AnchorContainer)this.target);
                ConnectionRoute route = new ConnectionRoute(this, allRoutes.size() + 1, this.source, this.target);
                start = GraphicsUtil.createPoint((Anchor)this.sourceAnchor);
                end = GraphicsUtil.createPoint((Anchor)this.targetAnchor);
                if (initialUpdate || middle != null || sourceSite != initialSourceSite || targetSite != initialTargetSite) {
                    if (AnchorType.getType((Anchor)this.sourceAnchor) == AnchorType.POOL) {
                        if (middle != null) {
                            AnchorUtil.moveAnchor(this.sourceAnchor, middle);
                        } else {
                            AnchorUtil.moveAnchor(this.sourceAnchor, this.targetAnchor);
                        }
                        start = GraphicsUtil.createPoint((Anchor)this.sourceAnchor);
                        route.setRank(sourceSite != initialSourceSite ? 3 : 0);
                    }
                    if (AnchorType.getType((Anchor)this.targetAnchor) == AnchorType.POOL) {
                        if (middle != null) {
                            AnchorUtil.moveAnchor(this.targetAnchor, middle);
                        } else {
                            AnchorUtil.moveAnchor(this.targetAnchor, this.sourceAnchor);
                        }
                        end = GraphicsUtil.createPoint((Anchor)this.targetAnchor);
                        route.setRank(targetSite != initialTargetSite ? 3 : 0);
                    }
                }
                route.setSourceAnchor(this.sourceAnchor);
                route.setTargetAnchor(this.targetAnchor);
                this.calculateRoute(route, start, middle, end);
                allRoutes.add(route);
            }
            if (i % 4 == 0) {
                sourceSite = this.getNextAnchorSite(sourceSite);
            } else {
                targetSite = this.getNextAnchorSite(targetSite);
            }
            ++i;
        }
        ConnectionRoute route = null;
        GraphicsUtil.dump("Optimizing Routes:\n------------------");
        for (ConnectionRoute r : allRoutes) {
            this.optimize(r);
        }
        GraphicsUtil.dump("Calculating Crossings:\n------------------");
        for (ConnectionRoute r : allRoutes) {
            if (r.getPoints().size() > 1) {
                Point p1 = r.getPoints().get(0);
                int i2 = 1;
                while (i2 < r.getPoints().size()) {
                    Point p2 = r.getPoints().get(i2);
                    List<Connection> crossings = this.findCrossings(this.connection, p1, p2);
                    for (Connection c : crossings) {
                        if (c == this.connection) continue;
                        r.addCrossing(c, p1, p2);
                    }
                    ContainerShape shape = this.getCollision(p1, p2);
                    if (shape != null) {
                        r.addCollision((Shape)shape, p1, p2);
                    }
                    p1 = p2;
                    ++i2;
                }
            }
            GraphicsUtil.dump("    " + r.toString());
        }
        GraphicsUtil.dump("Sorting Routes:\n------------------");
        Collections.sort(allRoutes);
        this.drawConnectionRoutes(allRoutes);
        if (allRoutes.size() > 0) {
            route = (ConnectionRoute)allRoutes.get(0);
        }
        return route;
    }

    protected ConnectionRoute calculateRoute(ConnectionRoute route, Point start, Point middle, Point end) {
        if (middle != null) {
            this.calculateRoute(route, start, middle);
            this.calculateRoute(route, middle, end);
        } else {
            this.calculateRoute(route, start, end);
        }
        route.add(end);
        return route;
    }

    protected ConnectionRoute calculateRoute(ConnectionRoute route, Point start, Point end) {
        ContainerShape shape;
        route.add(start);
        Point p1 = start;
        Point p2 = end;
        while ((shape = this.getCollision(p1, p2)) != null && shape != this.target && shape != this.source) {
            DetourPoints detour = new DetourPoints(shape, 10);
            for (Point d : detour.calculateDetour(p1, p2)) {
                if (route.add(d)) continue;
                return route;
            }
            p1 = route.get(route.size() - 1);
        }
        return route;
    }

    protected void optimize(ConnectionRoute route) {
        route.addSpecial(this.movedBendpoint);
        route.optimize();
    }
}

