/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import java.util.Hashtable;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.core.adapters.IPropertyHolder;
import org.eclipse.bpmn2.modeler.core.adapters.IResourceProvider;
import org.eclipse.bpmn2.util.Bpmn2Resource;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ObjectPropertyProvider
extends AdapterImpl
implements IResourceProvider,
IPropertyHolder {
    public static final String RESOURCE = "resource";
    protected Hashtable<String, Object> properties = new Hashtable();

    public static ObjectPropertyProvider adapt(EObject object, Resource resource) {
        ObjectPropertyProvider adapter = ObjectPropertyProvider.getAdapter(object);
        if (adapter != null) {
            adapter.setResource(resource);
        } else {
            adapter = new ObjectPropertyProvider(resource);
            object.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    public static ObjectPropertyProvider getAdapter(EObject object) {
        for (Adapter a : object.eAdapters()) {
            if (!(a instanceof ObjectPropertyProvider)) continue;
            return (ObjectPropertyProvider)a;
        }
        return null;
    }

    protected ObjectPropertyProvider(Resource resource) {
        if (resource != null) {
            this.setResource(resource);
        }
    }

    public EditingDomain getEditingDomain() {
        EditingDomain result;
        Resource resource = this.getResource();
        if (resource != null && (result = AdapterFactoryEditingDomain.getEditingDomainFor((Object)resource)) instanceof TransactionalEditingDomain) {
            return result;
        }
        return null;
    }

    @Override
    public Resource getResource() {
        return (Resource)this.getProperty(RESOURCE);
    }

    @Override
    public void setResource(Resource resource) {
        this.setProperty(RESOURCE, resource);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public static Resource getResource(EObject object) {
        Resource resource = null;
        if (object != null) {
            ResourceSet rs;
            IResourceProvider rp;
            resource = object.eResource();
            if (resource == null && (rp = AdapterRegistry.INSTANCE.adapt((Object)object, IResourceProvider.class)) != null) {
                resource = rp.getResource();
            }
            if (resource == null) {
                for (Adapter a : object.eAdapters()) {
                    if (a instanceof IResourceProvider && (resource = ((IResourceProvider)a).getResource()) != null) break;
                }
            }
            if (resource != null && !(resource instanceof Bpmn2Resource) && (rs = resource.getResourceSet()) != null) {
                for (Resource r : rs.getResources()) {
                    if (!(r instanceof Bpmn2Resource)) continue;
                    resource = r;
                    break;
                }
            }
        }
        return resource;
    }
}

