/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.BPELExtensibleElement;
import org.eclipse.bpel.model.Branches;
import org.eclipse.bpel.model.Catch;
import org.eclipse.bpel.model.CatchAll;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.CompletionCondition;
import org.eclipse.bpel.model.Condition;
import org.eclipse.bpel.model.Copy;
import org.eclipse.bpel.model.Correlation;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.CorrelationSets;
import org.eclipse.bpel.model.Correlations;
import org.eclipse.bpel.model.Documentation;
import org.eclipse.bpel.model.Else;
import org.eclipse.bpel.model.ElseIf;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.Expression;
import org.eclipse.bpel.model.Extension;
import org.eclipse.bpel.model.ExtensionActivity;
import org.eclipse.bpel.model.Extensions;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.ForEach;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.FromPart;
import org.eclipse.bpel.model.FromParts;
import org.eclipse.bpel.model.If;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Links;
import org.eclipse.bpel.model.MessageExchange;
import org.eclipse.bpel.model.MessageExchanges;
import org.eclipse.bpel.model.OnAlarm;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.PartnerActivity;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Pick;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Query;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.RepeatUntil;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.model.Sequence;
import org.eclipse.bpel.model.ServiceRef;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.model.TerminationHandler;
import org.eclipse.bpel.model.Throw;
import org.eclipse.bpel.model.To;
import org.eclipse.bpel.model.ToPart;
import org.eclipse.bpel.model.ToParts;
import org.eclipse.bpel.model.Validate;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.Variables;
import org.eclipse.bpel.model.While;
import org.eclipse.bpel.model.impl.BPELExtensibilityElementImpl;
import org.eclipse.bpel.model.impl.BPELExtensibleElementImpl;
import org.eclipse.bpel.model.impl.CorrelationSetsImpl;
import org.eclipse.bpel.model.impl.MessageExchangesImpl;
import org.eclipse.bpel.model.impl.PartnerLinksImpl;
import org.eclipse.bpel.model.impl.VariablesImpl;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.model.util.ElementFactory;
import org.eclipse.bpel.model.util.ElementPlacer;
import org.eclipse.bpel.model.util.ReconciliationBPELReader;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.wsdl.WSDLElement;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReconciliationHelper {
    private static ReconciliationHelper helper;
    private HashMap<Document, ReconciliationBPELReader> document2reader = new HashMap();

    public static ReconciliationHelper getInstance() {
        if (helper == null) {
            helper = new ReconciliationHelper();
        }
        return helper;
    }

    public void reconcile(WSDLElement element, Element changedElement) {
        ReconciliationBPELReader reader = this.getReader(element, changedElement);
        if (element instanceof Activity) {
            reader.xml2Activity((Activity)element, changedElement);
        } else if (element instanceof Process) {
            reader.xml2Process(changedElement);
        } else if (element instanceof Import) {
            reader.xml2Import((Import)element, changedElement);
        } else if (element instanceof Condition) {
            reader.xml2Condition((Condition)element, changedElement);
        } else if (element instanceof CompletionCondition) {
            reader.xml2CompletionCondition((CompletionCondition)element, changedElement);
        } else if (element instanceof Branches) {
            reader.xml2Branches((Branches)element, changedElement);
        } else if (element instanceof Expression) {
            reader.xml2Expression((Expression)element, changedElement);
        } else if (element instanceof Documentation) {
            reader.xml2Documentation((Documentation)element, changedElement);
        } else if (element instanceof Link) {
            reader.xml2Link((Link)element, changedElement);
        } else if (element instanceof Links) {
            reader.xml2Links((Links)element, changedElement);
        } else if (element instanceof ElseIf) {
            reader.xml2ElseIf((ElseIf)element, changedElement);
        } else if (element instanceof Else) {
            reader.xml2Else((Else)element, changedElement);
        } else if (element instanceof Variable) {
            reader.xml2Variable((Variable)element, changedElement);
        } else if (element instanceof Variables) {
            reader.xml2Variables((Variables)element, changedElement);
        } else if (element instanceof From) {
            reader.xml2From((From)element, changedElement);
        } else if (element instanceof FromPart) {
            reader.xml2FromPart((FromPart)element, changedElement);
        } else if (element instanceof FromParts) {
            reader.xml2FromParts((FromParts)element, changedElement);
        } else if (element instanceof To) {
            reader.xml2To((To)element, changedElement);
        } else if (element instanceof ToPart) {
            reader.xml2ToPart((ToPart)element, changedElement);
        } else if (element instanceof ToParts) {
            reader.xml2ToParts((ToParts)element, changedElement);
        } else if (element instanceof Query) {
            reader.xml2Query((Query)element, changedElement);
        } else if (element instanceof ServiceRef) {
            reader.xml2ServiceRef((ServiceRef)element, changedElement);
        } else if (element instanceof PartnerLinks) {
            reader.xml2PartnerLinks((PartnerLinks)element, changedElement);
        } else if (element instanceof PartnerLink) {
            reader.xml2PartnerLink((PartnerLink)element, changedElement);
        } else if (element instanceof Catch) {
            reader.xml2Catch((Catch)element, changedElement);
        } else if (element instanceof CatchAll) {
            reader.xml2CatchAll((CatchAll)element, changedElement);
        } else if (element instanceof Copy) {
            reader.xml2Copy((Copy)element, changedElement);
        } else if (element instanceof FaultHandler) {
            reader.xml2FaultHandler((FaultHandler)element, changedElement);
        } else if (element instanceof EventHandler) {
            reader.xml2EventHandler((EventHandler)element, changedElement);
        } else if (element instanceof TerminationHandler) {
            reader.xml2TerminationHandler((TerminationHandler)element, changedElement);
        } else if (element instanceof Correlation) {
            reader.xml2Correlation((Correlation)element, changedElement);
        } else if (element instanceof Correlations) {
            reader.xml2Correlations((Correlations)element, changedElement);
        } else if (element instanceof CorrelationSet) {
            reader.xml2CorrelationSet((CorrelationSet)element, changedElement);
        } else if (element instanceof CorrelationSets) {
            reader.xml2CorrelationSets((CorrelationSets)element, changedElement);
        } else if (element instanceof OnAlarm) {
            reader.xml2OnAlarm((OnAlarm)element, changedElement);
        } else if (element instanceof OnMessage) {
            reader.xml2OnMessage((OnMessage)element, changedElement);
        } else if (element instanceof OnEvent) {
            reader.xml2OnEvent((OnEvent)element, changedElement);
        } else if (element instanceof MessageExchanges) {
            reader.xml2MessageExchanges((MessageExchanges)element, changedElement);
        } else if (element instanceof MessageExchange) {
            reader.xml2MessageExchange((MessageExchange)element, changedElement);
        } else if (element instanceof Extension) {
            reader.xml2Extension((Extension)element, changedElement);
        } else if (element instanceof Extensions) {
            reader.xml2Extensions((Extensions)element, changedElement);
        } else if (element instanceof Source) {
            reader.xml2Source((Source)element, changedElement);
        } else if (element instanceof Sources) {
            reader.xml2Sources((Sources)element, changedElement);
        } else if (element instanceof Target) {
            reader.xml2Target((Target)element, changedElement);
        } else if (element instanceof Targets) {
            reader.xml2Targets((Targets)element, changedElement);
        } else if (element instanceof CompensationHandler) {
            reader.xml2CompensationHandler((CompensationHandler)element, changedElement);
        } else if (element instanceof BPELExtensibleElement) {
            reader.xml2ExtensibleElement((BPELExtensibleElement)element, changedElement);
        } else {
            System.err.println("Cannot reconcile: " + element.getClass());
        }
    }

    public static boolean isLoading(WSDLElement element) {
        Process process = BPELUtils.getProcess(element);
        return process == null || process.eResource() == null || !process.eResource().isLoaded();
    }

    public static void replaceChild(WSDLElement parent, WSDLElement oldElement, WSDLElement newElement) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom(parent);
        try {
            ReconciliationHelper.setUpdatingDom(parent, true);
            if (ReconciliationHelper.isLoading(parent)) {
                return;
            }
            Element parseElement = parent.getElement();
            if (parent instanceof ExtensionActivity) {
                parseElement = ReconciliationHelper.getExtensionActivityChildElement(parseElement);
            }
            if (parseElement == null) {
                System.err.println("trying to replace child on null element: " + parent.getClass());
                return;
            }
            if (oldElement == newElement) {
                return;
            }
            if (newElement != null) {
                if (newElement.getElement() == null) {
                    Element newDomElement = ElementFactory.getInstance().createElement(newElement, parent);
                    if (newDomElement == null) {
                        return;
                    }
                    newElement.setElement(newDomElement);
                }
                if (oldElement != null && oldElement.getElement() != null && parseElement == oldElement.getElement().getParentNode()) {
                    parseElement.replaceChild(newElement.getElement(), oldElement.getElement());
                } else {
                    ElementPlacer.placeChild(parent, newElement.getElement());
                }
            } else if (oldElement != null && oldElement.getElement() != null && parseElement == oldElement.getElement().getParentNode()) {
                ElementPlacer.niceRemoveChild(parent, oldElement.getElement());
            }
        }
        finally {
            ReconciliationHelper.setUpdatingDom(parent, oldUpdatingDom);
        }
    }

    protected static List<Element> getChildElements(Element parentElement) {
        ArrayList<Element> list = new ArrayList<Element>();
        if (parentElement != null) {
            NodeList children = parentElement.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getNodeType() == 1) {
                    list.add((Element)children.item(i));
                }
                ++i;
            }
        }
        return list;
    }

    public static Element getExtensionActivityChildElement(Element parentElement) {
        List<Element> nodeList = ReconciliationHelper.getChildElements(parentElement);
        if (nodeList.size() == 1) {
            return nodeList.get(0);
        }
        return null;
    }

    private static void updateLinkNameReferences(Link link, String name) {
        if (link.getSources() != null && !link.getSources().isEmpty()) {
            ((Source)link.getSources().get(0)).getElement().setAttribute("linkName", name);
        }
        if (link.getTargets() != null && !link.getTargets().isEmpty()) {
            ((Target)link.getTargets().get(0)).getElement().setAttribute("linkName", name);
        }
    }

    private static void updateMessageExchangeNameReferences(MessageExchange messExchange, String name) {
        EObject nearestScopeOrProcess = BPELUtils.getNearestScopeOrProcess((EObject)messExchange);
        if (nearestScopeOrProcess == null) {
            return;
        }
        TreeIterator iter = nearestScopeOrProcess.eAllContents();
        while (iter.hasNext()) {
            OnEvent onEvent;
            Object object = iter.next();
            if (object instanceof Receive) {
                Receive receive = (Receive)object;
                if (!messExchange.equals(receive.getMessageExchange())) continue;
                receive.getElement().setAttribute("messageExchange", name);
                continue;
            }
            if (object instanceof Reply) {
                Reply reply = (Reply)object;
                if (!messExchange.equals(reply.getMessageExchange())) continue;
                reply.getElement().setAttribute("messageExchange", name);
                continue;
            }
            if (object instanceof OnMessage) {
                OnMessage onMessage = (OnMessage)object;
                if (!messExchange.equals(onMessage.getMessageExchange())) continue;
                onMessage.getElement().setAttribute("messageExchange", name);
                continue;
            }
            if (!(object instanceof OnEvent) || !messExchange.equals((onEvent = (OnEvent)object).getMessageExchange())) continue;
            onEvent.getElement().setAttribute("messageExchange", name);
        }
    }

    private static void updateCorrelationSetNameReferences(CorrelationSet corrSet, String name) {
        EObject nearestScopeOrProcess = BPELUtils.getNearestScopeOrProcess((EObject)corrSet);
        if (nearestScopeOrProcess == null) {
            return;
        }
        TreeIterator iter = nearestScopeOrProcess.eAllContents();
        while (iter.hasNext()) {
            OnEvent onEvent;
            EList<Correlation> list;
            Correlations correlations;
            Object object = iter.next();
            if (object instanceof PartnerActivity) {
                PartnerActivity partnerAct = (PartnerActivity)object;
                correlations = partnerAct.getCorrelations();
                if (correlations == null) continue;
                list = correlations.getChildren();
                for (Correlation correlation : list) {
                    if (!corrSet.equals(correlation.getSet())) continue;
                    correlation.getElement().setAttribute("set", name);
                }
                continue;
            }
            if (object instanceof OnMessage) {
                OnMessage onMessage = (OnMessage)object;
                correlations = onMessage.getCorrelations();
                if (correlations == null) continue;
                list = correlations.getChildren();
                for (Correlation correlation : list) {
                    if (!corrSet.equals(correlation.getSet())) continue;
                    correlation.getElement().setAttribute("set", name);
                }
                continue;
            }
            if (!(object instanceof OnEvent) || (correlations = (onEvent = (OnEvent)object).getCorrelations()) == null) continue;
            list = correlations.getChildren();
            for (Correlation correlation : list) {
                if (!corrSet.equals(correlation.getSet())) continue;
                correlation.getElement().setAttribute("set", name);
            }
        }
    }

    private static void updatePartnerLinkNameReferences(PartnerLink partnerLink, String name) {
        EObject nearestScopeOrProcess = BPELUtils.getNearestScopeOrProcess((EObject)partnerLink);
        if (nearestScopeOrProcess == null) {
            return;
        }
        TreeIterator iter = nearestScopeOrProcess.eAllContents();
        while (iter.hasNext()) {
            To to;
            Object object = iter.next();
            if (object instanceof PartnerActivity) {
                PartnerActivity partnerAct = (PartnerActivity)object;
                if (!partnerLink.equals(partnerAct.getPartnerLink())) continue;
                partnerAct.getElement().setAttribute("partnerLink", name);
                continue;
            }
            if (object instanceof OnEvent) {
                OnEvent onEvent = (OnEvent)object;
                if (!partnerLink.equals(onEvent.getPartnerLink())) continue;
                onEvent.getElement().setAttribute("partnerLink", name);
                continue;
            }
            if (object instanceof OnMessage) {
                OnMessage onMessage = (OnMessage)object;
                if (!partnerLink.equals(onMessage.getPartnerLink())) continue;
                onMessage.getElement().setAttribute("partnerLink", name);
                continue;
            }
            if (object instanceof From) {
                From from = (From)object;
                if (!partnerLink.equals(from.getPartnerLink())) continue;
                from.getElement().setAttribute("partnerLink", name);
                continue;
            }
            if (!(object instanceof To) || !partnerLink.equals((to = (To)object).getPartnerLink())) continue;
            to.getElement().setAttribute("partnerLink", name);
        }
    }

    private static void updateForeachCounterVariableNameReferences(ForEach forEach, String name) {
        EObject nearestScopeOrProcess = BPELUtils.getNearestScopeOrProcess((EObject)forEach);
        if (nearestScopeOrProcess == null) {
            return;
        }
        ReconciliationHelper.updateVariableNameReferencesOnScope(nearestScopeOrProcess, forEach.getCounterName(), name);
    }

    private static void updateVariableNameReferencesOnScope(EObject scope, Variable variable, String name) {
        TreeIterator iter = scope.eAllContents();
        while (iter.hasNext()) {
            OnEvent onEvent;
            Object object = iter.next();
            if (object instanceof From) {
                From from = (From)object;
                if (!variable.equals(from.getVariable())) continue;
                from.getElement().setAttribute("variable", name);
                continue;
            }
            if (object instanceof To) {
                To to = (To)object;
                if (!variable.equals(to.getVariable())) continue;
                to.getElement().setAttribute("variable", name);
                continue;
            }
            if (object instanceof Receive) {
                Receive receive = (Receive)object;
                if (!variable.equals(receive.getVariable())) continue;
                receive.getElement().setAttribute("variable", name);
                continue;
            }
            if (object instanceof Reply) {
                Reply reply = (Reply)object;
                if (!variable.equals(reply.getVariable())) continue;
                reply.getElement().setAttribute("variable", name);
                continue;
            }
            if (object instanceof Invoke) {
                Object list;
                Invoke invoke = (Invoke)object;
                if (invoke.getFromParts() != null) {
                    FromParts fromParts = invoke.getFromParts();
                    list = fromParts.getChildren();
                    for (FromPart fromPart : list) {
                        if (!variable.equals(fromPart.getToVariable())) continue;
                        fromPart.getElement().setAttribute("toVariable", name);
                    }
                }
                if (invoke.getToParts() != null) {
                    ToParts toParts = invoke.getToParts();
                    list = toParts.getChildren();
                    for (ToPart toPart : list) {
                        if (!variable.equals(toPart.getFromVariable())) continue;
                        toPart.getElement().setAttribute("fromVariable", name);
                    }
                }
                if (variable.equals(invoke.getInputVariable())) {
                    invoke.getElement().setAttribute("inputVariable", name);
                }
                if (!variable.equals(invoke.getOutputVariable())) continue;
                invoke.getElement().setAttribute("outputVariable", name);
                continue;
            }
            if (object instanceof Throw) {
                Throw _throw = (Throw)object;
                if (!variable.equals(_throw.getFaultVariable())) continue;
                _throw.getElement().setAttribute("faultVariable", name);
                continue;
            }
            if (object instanceof Catch) {
                Catch _catch = (Catch)object;
                if (!variable.equals(_catch.getFaultVariable())) continue;
                _catch.getElement().setAttribute("faultVariable", name);
                continue;
            }
            if (object instanceof Validate) {
                Validate validate = (Validate)object;
                EList<Variable> variables = validate.getVariables();
                if (variables == null || variables.size() == 0) {
                    ReconciliationHelper.replaceAttribute((WSDLElement)validate, "variables", null);
                    continue;
                }
                StringBuilder val = new StringBuilder();
                Iterator i = variables.iterator();
                while (i.hasNext()) {
                    Variable var = (Variable)i.next();
                    if (variable.equals(var)) {
                        val.append(name);
                    } else {
                        val.append(var.getName());
                    }
                    if (!i.hasNext()) continue;
                    val.append(" ");
                }
                ReconciliationHelper.replaceAttribute((WSDLElement)validate, "variables", val.toString());
                continue;
            }
            if (object instanceof OnMessage) {
                OnMessage onMessage = (OnMessage)object;
                if (!variable.equals(onMessage.getVariable())) continue;
                onMessage.getElement().setAttribute("variable", name);
                continue;
            }
            if (!(object instanceof OnEvent) || !variable.equals((onEvent = (OnEvent)object).getVariable())) continue;
            onEvent.getElement().setAttribute("variable", name);
        }
    }

    private static void updateVariableNameReferences(Variable variable, String name) {
        EObject nearestScopeOrProcess = BPELUtils.getNearestScopeOrProcess((EObject)variable);
        if (nearestScopeOrProcess == null) {
            return;
        }
        ReconciliationHelper.updateVariableNameReferencesOnScope(nearestScopeOrProcess, variable, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void replaceAttribute(WSDLElement element, String attributeName, String attributeValue) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom(element);
        Element parseElement = element.getElement();
        if (element instanceof ExtensionActivity) {
            parseElement = ReconciliationHelper.getExtensionActivityChildElement(parseElement);
        }
        try {
            block22: {
                block20: {
                    block23: {
                        block21: {
                            ReconciliationHelper.setUpdatingDom(element, true);
                            if (ReconciliationHelper.isLoading(element)) {
                                return;
                            }
                            if (parseElement == null) {
                                EObject parent = element.eContainer();
                                if (parent instanceof OnEvent || parent instanceof Catch) {
                                    for (EStructuralFeature feature : parent.eClass().getEAllStructuralFeatures()) {
                                        if (!feature.getName().equals(attributeName)) continue;
                                        parseElement = ((BPELExtensibleElement)parent).getElement();
                                        break;
                                    }
                                }
                                if (parseElement == null) {
                                    System.err.println("trying to replace attribute \"" + attributeName + "\"" + " on null element " + element.getClass() + " contained in " + (element.eContainer() == null ? null : element.eContainer().getClass()));
                                    return;
                                }
                            }
                            if (parseElement.getAttributes().getNamedItem(attributeName) != null && ReconciliationHelper.isEqual(parseElement.getAttribute(attributeName), attributeValue)) {
                                return;
                            }
                            if (attributeValue != null && !attributeValue.equals("")) {
                                parseElement.setAttribute(attributeName, attributeValue);
                            } else {
                                parseElement.removeAttribute(attributeName);
                            }
                            if (!"name".equals(attributeName)) break block20;
                            if (element instanceof Link) {
                                ReconciliationHelper.updateLinkNameReferences((Link)element, attributeValue);
                            }
                            if (!(element instanceof Variable)) break block21;
                            ReconciliationHelper.updateVariableNameReferences((Variable)element, attributeValue);
                            break block22;
                        }
                        if (!(element instanceof MessageExchange)) break block23;
                        ReconciliationHelper.updateMessageExchangeNameReferences((MessageExchange)element, attributeValue);
                        break block22;
                    }
                    if (element instanceof CorrelationSet) {
                        ReconciliationHelper.updateCorrelationSetNameReferences((CorrelationSet)element, attributeValue);
                        break block22;
                    } else if (element instanceof PartnerLink) {
                        ReconciliationHelper.updatePartnerLinkNameReferences((PartnerLink)element, attributeValue);
                    }
                    break block22;
                }
                if ("counterName".equals(attributeName) && element instanceof ForEach) {
                    ReconciliationHelper.updateForeachCounterVariableNameReferences((ForEach)element, attributeValue);
                }
            }
            if (element instanceof ExtensionActivity) return;
            Process process = BPELUtils.getProcess(element);
            if (process == null) return;
            TreeIterator iter = process.eAllContents();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof ExtensionActivity)) continue;
                ((ExtensionActivity)object).updateElementReferences((EObject)element, attributeName, attributeValue);
            }
            return;
        }
        finally {
            ReconciliationHelper.setUpdatingDom(element, oldUpdatingDom);
        }
    }

    public static void replaceAttribute(WSDLElement element, String attributeName, QName attributeValue) {
        if (ReconciliationHelper.isLoading(element)) {
            return;
        }
        ReconciliationHelper.replaceAttribute(element, attributeName, attributeValue == null ? null : ElementFactory.getInstance().createName(element, attributeValue));
    }

    public static void replaceLiteral(From from, String literal) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom((WSDLElement)from);
        try {
            Node newLiteral;
            ReconciliationHelper.setUpdatingDom((WSDLElement)from, true);
            Element parentElement = from.getElement();
            if (parentElement == null || ReconciliationHelper.isLoading((WSDLElement)from)) {
                return;
            }
            Element oldLiteral = ReconciliationHelper.getBPELChildElementByLocalName(parentElement, "literal");
            Node node = newLiteral = literal == null ? null : ElementFactory.getInstance().createLiteral(from, literal);
            if (oldLiteral == null) {
                if (newLiteral != null) {
                    ElementPlacer.placeChild((WSDLElement)from, newLiteral);
                }
            } else if (newLiteral != null) {
                parentElement.replaceChild(newLiteral, oldLiteral);
            } else {
                parentElement.removeChild(oldLiteral);
            }
        }
        finally {
            ReconciliationHelper.setUpdatingDom((WSDLElement)from, oldUpdatingDom);
        }
    }

    public static void replaceText(WSDLElement parent, Object newText) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom(parent);
        try {
            ReconciliationHelper.setUpdatingDom(parent, true);
            if (ReconciliationHelper.isLoading(parent)) {
                return;
            }
            Element element = parent.getElement();
            if (parent instanceof ExtensionActivity) {
                element = ReconciliationHelper.getExtensionActivityChildElement(element);
            }
            if (element == null) {
                System.err.println("trying to replace text on null element");
                return;
            }
            ArrayList<Node> nodesToRemove = ReconciliationHelper.getTextNodes(element);
            for (Node n : nodesToRemove) {
                element.removeChild(n);
            }
            if (newText != null && !newText.toString().equals("")) {
                CDATASection cdata = BPELUtils.createCDATASection(element.getOwnerDocument(), newText.toString());
                ElementPlacer.placeChild(parent, cdata);
            }
        }
        finally {
            ReconciliationHelper.setUpdatingDom(parent, oldUpdatingDom);
        }
    }

    private static ArrayList<Node> getTextNodes(Element element) {
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        Node node = element.getFirstChild();
        boolean bCData = false;
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: {
                    if (bCData) break;
                    nodesToRemove.add(node);
                    break;
                }
                case 4: {
                    if (!bCData) {
                        nodesToRemove.clear();
                        bCData = true;
                    }
                    nodesToRemove.add(node);
                }
            }
            node = node.getNextSibling();
        }
        return nodesToRemove;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void replaceExpression(WSDLElement parent, Expression newExpression) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom(parent);
        try {
            ReconciliationHelper.setUpdatingDom(parent, true);
            if (ReconciliationHelper.isLoading(parent)) {
                return;
            }
            if (parent.getElement() == null) {
                System.err.println("trying to replace expression on null element:" + parent.getClass());
                return;
            }
            Element element = parent.getElement();
            if (newExpression != null) {
                if (newExpression.getExpressionLanguage() != null) {
                    element.setAttribute("expressionLanguage", newExpression.getExpressionLanguage());
                }
                ReconciliationHelper.replaceText(parent, newExpression.getBody());
                return;
            } else {
                ReconciliationHelper.replaceText(parent, null);
            }
            return;
        }
        finally {
            ReconciliationHelper.setUpdatingDom(parent, oldUpdatingDom);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void replaceFaultHandler(WSDLElement parent, FaultHandler newFaultHandler) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom(parent);
        try {
            ReconciliationHelper.setUpdatingDom(parent, true);
            if (ReconciliationHelper.isLoading(parent)) {
                return;
            }
            if (parent.getElement() == null) {
                System.err.println("trying to replace faultHandler on null element:" + parent.getClass());
                return;
            }
            Element parentElement = parent.getElement();
            if (parent instanceof ExtensionActivity) {
                parentElement = ReconciliationHelper.getExtensionActivityChildElement(parentElement);
            }
            for (Element node : ReconciliationHelper.getBPELChildElementsByLocalName(parentElement, "catch")) {
                parentElement.removeChild(node);
            }
            parentElement.removeChild(ReconciliationHelper.getBPELChildElementByLocalName(parentElement, "catchAll"));
            if (newFaultHandler == null) return;
            ElementFactory.getInstance().writeFaultHandler(newFaultHandler, parent);
            return;
        }
        finally {
            ReconciliationHelper.setUpdatingDom(parent, oldUpdatingDom);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Node replaceValue(ServiceRef serviceRef, Node oldValueNode, Object newValue) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom((WSDLElement)serviceRef);
        try {
            ReconciliationHelper.setUpdatingDom((WSDLElement)serviceRef, true);
            if (ReconciliationHelper.isLoading((WSDLElement)serviceRef)) {
                return null;
            }
            if (serviceRef.getElement() == null) {
                return null;
            }
            Node newValueNode = ElementFactory.getInstance().createValue(serviceRef);
            if (oldValueNode == null && newValueNode != null) {
                ElementPlacer.placeChild((WSDLElement)serviceRef, newValueNode);
            } else if (oldValueNode != null && newValueNode != null) {
                serviceRef.getElement().replaceChild(newValueNode, oldValueNode);
            }
            Node node = newValueNode;
            return node;
        }
        finally {
            ReconciliationHelper.setUpdatingDom((WSDLElement)serviceRef, oldUpdatingDom);
        }
    }

    static boolean isUpdatingDom(WSDLElement element) {
        if (element instanceof BPELExtensibleElementImpl) {
            return ((BPELExtensibleElementImpl)element).isUpdatingDOM();
        }
        if (element instanceof BPELExtensibilityElementImpl) {
            return ((BPELExtensibilityElementImpl)element).isUpdatingDOM();
        }
        return false;
    }

    static void setUpdatingDom(WSDLElement element, boolean updatingDOM) {
        if (element instanceof BPELExtensibleElementImpl) {
            ((BPELExtensibleElementImpl)element).setUpdatingDOM(updatingDOM);
        } else if (element instanceof BPELExtensibilityElementImpl) {
            ((BPELExtensibilityElementImpl)element).setUpdatingDOM(updatingDOM);
        }
    }

    private ReconciliationBPELReader getReader(WSDLElement element, Element changedElement) {
        ReconciliationBPELReader reader = this.document2reader.get(changedElement.getOwnerDocument());
        if (reader == null) {
            reader = new ReconciliationBPELReader(BPELUtils.getProcess(element));
            this.document2reader.put(changedElement.getOwnerDocument(), reader);
        }
        return reader;
    }

    public void patchDom(EObject child, EObject parent, Node parentElement, EObject before, Node beforeElement) {
        Element realParent;
        if (parent instanceof ExtensionActivity && (realParent = ReconciliationHelper.getExtensionActivityChildElement((Element)parentElement)) != null) {
            parentElement = realParent;
        }
        if (child instanceof Variable) {
            parentElement = this.patchParentElement(child, parent, parentElement, "variables", "variable");
        } else if (child instanceof CorrelationSet) {
            parentElement = this.patchParentElement(child, parent, parentElement, "correlationSets", "correlationSet");
        } else if (child instanceof PartnerLink) {
            parentElement = this.patchParentElement(child, parent, parentElement, "partnerLinks", "partnerLink");
        } else if (child instanceof MessageExchange) {
            parentElement = this.patchParentElement(child, parent, parentElement, "messageExchanges", "messageExchange");
        }
        if (!BPELUtils.isTransparent(parent, child)) {
            Element childElement = ((WSDLElement)child).getElement();
            if (childElement == null) {
                childElement = ElementFactory.getInstance().createElement((WSDLElement)((BPELExtensibleElement)child), parent);
                ((BPELExtensibleElement)child).setElement(childElement);
            }
            if (childElement.getParentNode() != parentElement) {
                System.err.println("Non-reconciling element:" + parent.getClass());
                parentElement.insertBefore(childElement, beforeElement);
            }
        } else if (child instanceof FaultHandler) {
            ((FaultHandler)child).setElement((Element)parentElement);
        }
        if (child instanceof ForEach) {
            ForEach forEach = (ForEach)child;
            Variable counter = forEach.getCounterName();
            if (counter.getElement() == null) {
                ReconciliationHelper.replaceAttribute((WSDLElement)forEach, "counterName", counter.getName());
            }
        } else if (!(child instanceof Scope || child instanceof Pick || child instanceof Assign)) {
            BPELExtensibleElement c;
            if (child instanceof Catch) {
                c = (Catch)child;
                this.reconcile((WSDLElement)c, c.getElement());
                System.err.println("Catch patch ok");
            } else if (child instanceof CatchAll) {
                c = (CatchAll)child;
                this.reconcile((WSDLElement)c, c.getElement());
                System.err.println("CatchAll patch ok");
            } else if (child instanceof TerminationHandler) {
                TerminationHandler th = (TerminationHandler)child;
                this.reconcile((WSDLElement)th, th.getElement());
                System.err.println("TerminationHandler patch ok");
            } else if (!(child instanceof OnEvent)) {
                if (child instanceof OnAlarm) {
                    OnAlarm o = (OnAlarm)child;
                    Activity a = o.getActivity();
                    Element s = ReconciliationHelper.getBPELChildElementByLocalName(o.getElement(), "scope");
                    a.setElement(s);
                    this.reconcile((WSDLElement)a, s);
                } else if (child instanceof FaultHandler) {
                    c = (FaultHandler)child;
                    EList<Catch> _catch = c.getCatch();
                    if (_catch.size() == 1 && ((Catch)_catch.get(0)).getElement() == null) {
                        Catch ch = (Catch)_catch.get(0);
                        Element catchElement = ReconciliationHelper.getBPELChildElementByLocalName(c.getElement(), "catch");
                        ch.setElement(catchElement);
                        this.reconcile((WSDLElement)ch, catchElement);
                    }
                    System.err.println("FaultHandler patch ok");
                } else if (child instanceof EventHandler) {
                    EventHandler e = (EventHandler)child;
                    EList<OnEvent> _onEvent = e.getEvents();
                    OnEvent on = (OnEvent)_onEvent.get(0);
                    Element onElement = ReconciliationHelper.getBPELChildElementByLocalName(e.getElement(), "onEvent");
                    on.setElement(onElement);
                    this.reconcile((WSDLElement)on, onElement);
                } else if (child instanceof CompensationHandler) {
                    c = (CompensationHandler)child;
                    Activity a = c.getActivity();
                    Element s = ReconciliationHelper.getBPELChildElementByLocalName(c.getElement(), "sequence");
                    a.setElement(s);
                    this.reconcile((WSDLElement)a, s);
                }
            }
        }
    }

    public Node patchParentElement(EObject child, EObject parent, Node parentElement, String parentNodeName, String nodeName) {
        WSDLElement variables = (WSDLElement)parent;
        WSDLElement var = (WSDLElement)child;
        WSDLElement container = (WSDLElement)variables.eContainer();
        if (variables.getElement() == null && container != null && container.getElement() != null) {
            parentElement = ReconciliationHelper.getBPELChildElementByLocalName(container.getElement(), parentNodeName);
            variables.setElement(parentElement != null ? (Element)parentElement : ElementFactory.getInstance().createElement(variables, container));
            var.setElement(ReconciliationHelper.getBPELChildElementByLocalName(variables.getElement(), nodeName));
            if (parentElement == null) {
                ElementPlacer.placeChild(container, variables.getElement());
                parentElement = variables.getElement();
            }
        }
        return parentElement;
    }

    public static Element getBPELChildElementByLocalName(Element parentElement, String localName) {
        if (parentElement == null) {
            return null;
        }
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (localName.equals(node.getLocalName())) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    public static List<Element> getActivities(Element parentElement) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (BPELUtils.isActivityNode(node)) {
                list.add((Element)node);
            }
            ++i;
        }
        return list;
    }

    public static List<Element> getBPELChildElementsByLocalName(Element parentElement, String localName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (localName.equals(node.getLocalName()) && BPELUtils.isBPELElement(node)) {
                list.add((Element)node);
            }
            ++i;
        }
        return list;
    }

    public static void updateVariableName(WSDLElement parent, String varName) {
        if (parent == null || parent.getElement() == null) {
            return;
        }
        if (parent instanceof Catch) {
            ReconciliationHelper.replaceAttribute(parent, "faultVariable", varName);
        }
    }

    public static void adoptChild(WSDLElement parent, List<? extends WSDLElement> children, WSDLElement newChild, String nodeName) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom(parent);
        try {
            List<Element> domChildren;
            ReconciliationHelper.setUpdatingDom(parent, true);
            if (ReconciliationHelper.isLoading(parent) || parent.getElement() == null) {
                return;
            }
            Element parseElement = parent.getElement();
            if (parent instanceof ExtensionActivity) {
                parseElement = ReconciliationHelper.getExtensionActivityChildElement(parseElement);
            }
            if (newChild.getElement() == null) {
                newChild.setElement(ElementFactory.getInstance().createElement(newChild, parent));
            }
            if (newChild.getElement().getParentNode() == parseElement) {
                return;
            }
            int index = children.indexOf(newChild);
            if (index >= (domChildren = parent instanceof Sequence || parent instanceof Flow ? ReconciliationHelper.getActivities(parseElement) : ReconciliationHelper.getBPELChildElementsByLocalName(parseElement, nodeName)).size()) {
                ElementPlacer.placeChild(parent, newChild.getElement());
            } else {
                ElementPlacer.niceInsertBefore(parent, newChild.getElement(), domChildren.get(index));
            }
        }
        finally {
            ReconciliationHelper.setUpdatingDom(parent, oldUpdatingDom);
        }
    }

    public static void orphanChild(WSDLElement parent, WSDLElement child) {
        boolean oldUpdatingDom = ReconciliationHelper.isUpdatingDom(parent);
        try {
            Invoke invoke;
            FaultHandler faultHandler;
            ReconciliationHelper.setUpdatingDom(parent, true);
            if (ReconciliationHelper.isLoading(parent) || parent.getElement() == null) {
                return;
            }
            if (parent.getElement() != null && child.getElement() != null && child.getElement().getParentNode() == parent.getElement()) {
                parent.getElement().removeChild(child.getElement());
            }
            if (child instanceof Variable && ((Variables)parent).getChildren().size() == 0 && !((VariablesImpl)parent).isReconciling()) {
                if (parent.getContainer() instanceof Process) {
                    ((Process)parent.getContainer()).setVariables(null);
                } else if (parent.getContainer() instanceof Scope) {
                    ((Scope)parent.getContainer()).setVariables(null);
                } else {
                    throw new IllegalStateException();
                }
            }
            if (child instanceof PartnerLink && ((PartnerLinks)parent).getChildren().size() == 0 && !((PartnerLinksImpl)parent).isReconciling()) {
                if (parent.getContainer() instanceof Process) {
                    ((Process)parent.getContainer()).setPartnerLinks(null);
                } else if (parent.getContainer() instanceof Scope) {
                    ((Scope)parent.getContainer()).setPartnerLinks(null);
                } else {
                    throw new IllegalStateException();
                }
            }
            if (child instanceof CorrelationSet && ((CorrelationSets)parent).getChildren().size() == 0 && !((CorrelationSetsImpl)parent).isReconciling()) {
                if (parent.getContainer() instanceof Process) {
                    ((Process)parent.getContainer()).setCorrelationSets(null);
                } else if (parent.getContainer() instanceof Scope) {
                    ((Scope)parent.getContainer()).setCorrelationSets(null);
                } else {
                    throw new IllegalStateException();
                }
            }
            if (child instanceof MessageExchange && ((MessageExchanges)parent).getChildren().size() == 0 && !((MessageExchangesImpl)parent).isReconciling()) {
                if (parent.getContainer() instanceof Process) {
                    ((Process)parent.getContainer()).setMessageExchanges(null);
                } else if (parent.getContainer() instanceof Scope) {
                    ((Scope)parent.getContainer()).setMessageExchanges(null);
                } else {
                    throw new IllegalStateException();
                }
            }
            if (child instanceof Catch && parent instanceof Invoke && (faultHandler = (invoke = (Invoke)parent).getFaultHandler()).getCatch().size() == 0 && faultHandler.getCatchAll() == null) {
                invoke.setFaultHandler(null);
            }
        }
        finally {
            ReconciliationHelper.setUpdatingDom(parent, oldUpdatingDom);
        }
    }

    public static boolean isSingleActivityContainer(Object context) {
        if (context instanceof If) {
            return true;
        }
        if (context instanceof ForEach) {
            return true;
        }
        if (context instanceof ElseIf) {
            return true;
        }
        if (context instanceof Else) {
            return true;
        }
        if (context instanceof Catch) {
            return true;
        }
        if (context instanceof CatchAll) {
            return true;
        }
        if (context instanceof OnAlarm) {
            return true;
        }
        if (context instanceof OnMessage) {
            return true;
        }
        if (context instanceof OnEvent) {
            return true;
        }
        if (context instanceof Process) {
            return true;
        }
        if (context instanceof While) {
            return true;
        }
        if (context instanceof RepeatUntil) {
            return true;
        }
        if (context instanceof CompensationHandler) {
            return true;
        }
        if (context instanceof Scope) {
            return true;
        }
        return context instanceof ExtensionActivity;
    }

    private static boolean isEqual(String s1, String s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public static Activity getActivity(Object context) {
        if (context instanceof ElseIf) {
            return ((ElseIf)context).getActivity();
        }
        if (context instanceof ForEach) {
            return ((ForEach)context).getActivity();
        }
        if (context instanceof Else) {
            return ((Else)context).getActivity();
        }
        if (context instanceof Catch) {
            return ((Catch)context).getActivity();
        }
        if (context instanceof CatchAll) {
            return ((CatchAll)context).getActivity();
        }
        if (context instanceof OnAlarm) {
            return ((OnAlarm)context).getActivity();
        }
        if (context instanceof OnMessage) {
            return ((OnMessage)context).getActivity();
        }
        if (context instanceof OnEvent) {
            return ((OnEvent)context).getActivity();
        }
        if (context instanceof Process) {
            return ((Process)context).getActivity();
        }
        if (context instanceof While) {
            return ((While)context).getActivity();
        }
        if (context instanceof RepeatUntil) {
            return ((RepeatUntil)context).getActivity();
        }
        if (context instanceof Scope) {
            return ((Scope)context).getActivity();
        }
        if (context instanceof FaultHandler) {
            return ReconciliationHelper.getCatchAll((FaultHandler)context);
        }
        if (context instanceof CompensationHandler) {
            return ((CompensationHandler)context).getActivity();
        }
        if (context instanceof TerminationHandler) {
            return ((TerminationHandler)context).getActivity();
        }
        if (context instanceof If) {
            return ((If)context).getActivity();
        }
        if (context instanceof ExtensionActivity) {
            ExtensionActivity ea = (ExtensionActivity)context;
            for (EStructuralFeature sf : ea.eClass().getEAllStructuralFeatures()) {
                if (!sf.getName().equals("activity")) continue;
                return (Activity)ea.eGet(sf);
            }
        }
        System.err.println("Missing getActivity():" + context.getClass());
        throw new IllegalArgumentException();
    }

    private static Activity getCatchAll(FaultHandler faultHandler) {
        CatchAll catchAll = faultHandler.getCatchAll();
        return catchAll == null ? null : catchAll.getActivity();
    }
}

