/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.bpmn2.modeler.core.validation.ValidationStatusAdapter;
import org.eclipse.bpmn2.modeler.core.validation.ValidationStatusAdapterFactory;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintFactory;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class BPMN2ValidationStatusLoader {
    DiagramEditor editor;

    public BPMN2ValidationStatusLoader(DiagramEditor editor) {
        this.editor = editor;
    }

    public Set<EObject> load(List<IMarker> markers) {
        if (markers == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<EObject> touched = new LinkedHashSet<EObject>();
        for (IMarker marker : markers) {
            EObject markedObject = this.getTargetObject(marker);
            if (markedObject == null) continue;
            ValidationStatusAdapter statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)markedObject, ValidationStatusAdapter.class);
            if (statusAdapter == null) {
                ResourceSet resourceSet = this.editor.getEditingDomain().getResourceSet();
                resourceSet.getAdapterFactories().add((Object)new ValidationStatusAdapterFactory());
                statusAdapter = (ValidationStatusAdapter)EcoreUtil.getRegisteredAdapter((EObject)markedObject, ValidationStatusAdapter.class);
            }
            IStatus status = this.convertMarker(marker, markedObject);
            statusAdapter.addValidationStatus(status);
            touched.add(markedObject);
        }
        return touched;
    }

    private EObject getTargetObject(IMarker marker) {
        URI uri;
        String uriString = marker.getAttribute("uri", null);
        URI uRI = uri = uriString == null ? null : URI.createURI((String)uriString);
        if (uri == null) {
            return null;
        }
        return this.editor.getEditingDomain().getResourceSet().getEObject(uri, false);
    }

    private IStatus convertMarker(IMarker marker, EObject target) {
        IModelConstraint imc;
        String message = marker.getAttribute("message", "");
        String constraintId = marker.getAttribute("rule", null);
        IConstraintDescriptor icd = constraintId == null ? null : ConstraintRegistry.getInstance().getDescriptor(constraintId);
        IModelConstraint iModelConstraint = imc = icd == null ? null : ConstraintFactory.getInstance().newConstraint(icd);
        if (imc == null) {
            int severity;
            switch (marker.getAttribute("severity", -1)) {
                case 0: {
                    severity = 1;
                    break;
                }
                case 1: {
                    severity = 2;
                    break;
                }
                case 2: {
                    severity = 4;
                    break;
                }
                default: {
                    severity = 0;
                }
            }
            return new Status(severity, "org.eclipse.bpmn2.modeler.core", message);
        }
        List locus = new EditUIMarkerHelper().getTargetObjects((Object)this.editor.getEditingDomain(), marker);
        Iterator it = locus.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof EObject) continue;
            it.remove();
        }
        return new ConstraintStatus(imc, target, message, (Set)(locus == null ? null : new LinkedHashSet(locus)));
    }
}

