/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation;

import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.ComplexGateway;
import org.eclipse.bpmn2.ConditionalEventDefinition;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Error;
import org.eclipse.bpmn2.ErrorEventDefinition;
import org.eclipse.bpmn2.Escalation;
import org.eclipse.bpmn2.EscalationEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventBasedGateway;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ExclusiveGateway;
import org.eclipse.bpmn2.Expression;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.GatewayDirection;
import org.eclipse.bpmn2.Import;
import org.eclipse.bpmn2.InclusiveGateway;
import org.eclipse.bpmn2.InputOutputSpecification;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.Interface;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.ParallelGateway;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Resource;
import org.eclipse.bpmn2.ScriptTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.Signal;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.TimerEventDefinition;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.osgi.util.NLS;

public class BPMN2ValidationConstraints
extends AbstractModelConstraint {
    public static final String ERROR_ID = "org.eclipse.bpmn2.modeler.core.validation.error";
    public static final String WARNING_ID = "org.eclipse.bpmn2.modeler.core.validation.warning";
    private boolean warnings = false;

    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        Bpmn2Preferences prefs = Bpmn2Preferences.getInstance(eObj);
        if (prefs.getDoCoreValidation()) {
            EMFEventType eType = ctx.getEventType();
            String id = ctx.getCurrentConstraintId();
            this.warnings = WARNING_ID.equals(id);
            if (eType == EMFEventType.NULL) {
                if (eObj instanceof Definitions) {
                    return this.validateDefinitions(ctx, (Definitions)eObj);
                }
                if (eObj instanceof BaseElement) {
                    return this.validateBaseElement(ctx, (BaseElement)eObj);
                }
                this.validateEObject(ctx, eObj);
            } else {
                if (eObj instanceof BaseElement) {
                    return this.validateBaseElementLive(ctx, (BaseElement)eObj);
                }
                this.validateEObject(ctx, eObj);
            }
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateDefinitions(IValidationContext ctx, Definitions def) {
        if ((def.getTargetNamespace() == null || def.getTargetNamespace().isEmpty()) && !this.warnings) {
            ctx.addResult((EObject)def);
            return ctx.createFailureStatus(new Object[]{Messages.BPMN2ValidationConstraints_2});
        }
        for (Import imp : def.getImports()) {
            IStatus status = this.validateEObject(ctx, (EObject)imp);
            if (status.isOK()) continue;
            return status;
        }
        return ctx.createSuccessStatus();
    }

    public IStatus createFailureStatus(IValidationContext ctx, EObject object, String featureName, String message) {
        EStructuralFeature feature;
        ctx.addResult(object);
        if (featureName != null && !featureName.isEmpty() && (feature = object.eClass().getEStructuralFeature(featureName)) != null) {
            ctx.addResult((EObject)feature);
        }
        IStatus status = ctx.createFailureStatus(new Object[]{message});
        return status;
    }

    public IStatus createMissingFeatureStatus(IValidationContext ctx, EObject object, String featureName) {
        EStructuralFeature feature = object.eClass().getEStructuralFeature(featureName);
        ctx.addResult(object);
        ctx.addResult((EObject)feature);
        String message = feature.getEType() == Bpmn2Package.eINSTANCE.getSequenceFlow() ? NLS.bind((String)Messages.BPMN2ValidationConstraints_Missing_Connection, (Object)ExtendedPropertiesProvider.getLabel(object), (Object)ExtendedPropertiesProvider.getLabel(object, feature)) : NLS.bind((String)Messages.BPMN2ValidationConstraints_Missing_Feature, (Object)ExtendedPropertiesProvider.getLabel(object), (Object)ExtendedPropertiesProvider.getLabel(object, feature));
        IStatus status = ctx.createFailureStatus(new Object[]{message});
        return status;
    }

    private IStatus validateBaseElement(IValidationContext ctx, BaseElement be) {
        if (be instanceof Process) {
            Process process = (Process)be;
            if (this.warnings) {
                boolean foundStartEvent = false;
                boolean foundEndEvent = false;
                List flowElements = process.getFlowElements();
                for (FlowElement fe : flowElements) {
                    if (fe instanceof StartEvent) {
                        foundStartEvent = true;
                    }
                    if (!(fe instanceof EndEvent)) continue;
                    foundEndEvent = true;
                }
                if (!foundStartEvent) {
                    return this.createFailureStatus(ctx, (EObject)be, null, Messages.BPMN2ValidationConstraints_6);
                }
                if (!foundEndEvent) {
                    return this.createFailureStatus(ctx, (EObject)be, null, Messages.BPMN2ValidationConstraints_7);
                }
                if (BPMN2ValidationConstraints.isEmpty(process.getName())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "name");
                }
            }
        } else if (be instanceof Error) {
            if (!this.warnings && !this.isValidForExecutableProcess((BaseElement)be.eContainer(), be)) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "structureRef");
            }
        } else if (be instanceof Escalation) {
            if (!this.warnings && !this.isValidForExecutableProcess((BaseElement)be.eContainer(), be)) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "structureRef");
            }
        } else if (be instanceof Message) {
            if (!this.warnings && !this.isValidForExecutableProcess((BaseElement)be.eContainer(), be)) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "itemRef");
            }
        } else if (be instanceof Signal) {
            if (!this.warnings && !this.isValidForExecutableProcess((BaseElement)be.eContainer(), be)) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "structureRef");
            }
        } else if (be instanceof ItemDefinition) {
            if (!this.warnings && !this.isValidForExecutableProcess((BaseElement)be.eContainer(), be)) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "structureRef");
            }
        } else if (be instanceof StartEvent) {
            StartEvent elem = (StartEvent)be;
            if (!(this.warnings || elem.getOutgoing() != null && elem.getOutgoing().size() >= 1)) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "outgoing");
            }
        } else if (be instanceof EndEvent) {
            EndEvent elem = (EndEvent)be;
            if (!(this.warnings || elem.getIncoming() != null && elem.getIncoming().size() >= 1)) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "incoming");
            }
        } else if (be instanceof ScriptTask) {
            ScriptTask elem = (ScriptTask)be;
            if (this.warnings && BPMN2ValidationConstraints.isEmpty(elem.getScript())) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "script");
            }
        } else if (be instanceof SendTask) {
            SendTask elem = (SendTask)be;
            if (!this.warnings) {
                if (elem.getOperationRef() == null) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "operationRef");
                }
                if (elem.getMessageRef() == null) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "messageRef");
                }
            }
        } else if (be instanceof CatchEvent) {
            CatchEvent elem = (CatchEvent)be;
            if (this.warnings) {
                if (elem.getOutgoing() == null || elem.getOutgoing().size() < 1) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "outgoing");
                }
            } else {
                IStatus status = this.validateEvent(ctx, (Event)be);
                if (status != null) {
                    return status;
                }
            }
            be = null;
        } else if (be instanceof ThrowEvent) {
            ThrowEvent elem = (ThrowEvent)be;
            if (this.warnings) {
                if (elem.getOutgoing() == null || elem.getOutgoing().size() < 1) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "outgoing");
                }
            } else {
                IStatus status = this.validateEvent(ctx, (Event)be);
                if (status != null) {
                    return status;
                }
            }
            be = null;
        } else if (be instanceof SequenceFlow) {
            SequenceFlow elem = (SequenceFlow)be;
            if (!this.warnings) {
                if (elem.getSourceRef() == null) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "sourceRef");
                }
                if (elem.getTargetRef() == null) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "targetRef");
                }
            }
        } else if (be instanceof Association) {
            Association elem = (Association)be;
            if (!this.warnings) {
                if (elem.getSourceRef() == null) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "sourceRef");
                }
                if (elem.getTargetRef() == null) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "targetRef");
                }
            }
        } else if (be instanceof Gateway) {
            Gateway elem = (Gateway)be;
            if (!this.warnings) {
                GatewayDirection direction = elem.getGatewayDirection();
                int incoming = elem.getIncoming().size();
                int outgoing = elem.getOutgoing().size();
                if (direction == GatewayDirection.CONVERGING) {
                    if (incoming < 1) {
                        ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                        return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_10);
                    }
                    if (outgoing > 1) {
                        ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                        return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_11);
                    }
                } else if (direction == GatewayDirection.DIVERGING) {
                    if (incoming > 1) {
                        ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                        return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_12);
                    }
                    if (outgoing < 1) {
                        ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                        return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_13);
                    }
                } else if (direction == GatewayDirection.MIXED) {
                    if (incoming < 1) {
                        ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                        return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_14);
                    }
                    if (outgoing < 1) {
                        ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                        return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_15);
                    }
                } else if (outgoing < 1 && incoming < 1) {
                    ctx.addResult((EObject)Bpmn2Package.eINSTANCE.getGateway_GatewayDirection());
                    return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_16);
                }
                if (elem instanceof ExclusiveGateway && direction != GatewayDirection.DIVERGING && direction != GatewayDirection.CONVERGING) {
                    return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_29);
                }
                if (elem instanceof EventBasedGateway && direction != GatewayDirection.DIVERGING) {
                    return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_30);
                }
                if (elem instanceof ParallelGateway && direction != GatewayDirection.DIVERGING && direction != GatewayDirection.CONVERGING) {
                    return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_31);
                }
                if (elem instanceof InclusiveGateway && direction != GatewayDirection.DIVERGING && direction != GatewayDirection.CONVERGING) {
                    return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_32);
                }
                if (elem instanceof ComplexGateway && direction != GatewayDirection.DIVERGING && direction != GatewayDirection.CONVERGING) {
                    return this.createFailureStatus(ctx, (EObject)be, "gatewayDirection", Messages.BPMN2ValidationConstraints_33);
                }
            }
        } else if (be instanceof CallActivity) {
            CallActivity elem = (CallActivity)be;
            if (!this.warnings && elem.getCalledElementRef() == null) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "calledElementRef");
            }
        } else if (be instanceof DataObject) {
            DataObject elem = (DataObject)be;
            if (!(this.warnings || elem.getName() != null && elem.getName().length() >= 1)) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "name");
            }
        } else if (be instanceof Interface) {
            Interface elem = (Interface)be;
            if (!this.warnings) {
                if (BPMN2ValidationConstraints.isEmpty(elem.getOperations())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "operations");
                }
                if (BPMN2ValidationConstraints.isEmpty(elem.getName())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "name");
                }
            }
        } else if (be instanceof Operation) {
            Operation elem = (Operation)be;
            if (!this.warnings) {
                if (BPMN2ValidationConstraints.isEmpty(elem.getInMessageRef())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "inMessageRef");
                }
                if (BPMN2ValidationConstraints.isEmpty(elem.getName())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "name");
                }
            }
        } else if (be instanceof DataAssociation) {
            DataAssociation elem = (DataAssociation)be;
            if (!this.warnings && BPMN2ValidationConstraints.isEmpty(elem.getTargetRef()) && elem.getAssignment().size() == 0 && elem.getTransformation() == null) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "targetRef");
            }
        } else if (be instanceof Assignment) {
            Assignment elem = (Assignment)be;
            if (!this.warnings) {
                if (BPMN2ValidationConstraints.isEmpty(elem.getFrom())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "from");
                }
                if (BPMN2ValidationConstraints.isEmpty(elem.getTo())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "to");
                }
            }
        } else if (be instanceof InputOutputSpecification) {
            InputOutputSpecification elem = (InputOutputSpecification)be;
            if (!this.warnings) {
                if (BPMN2ValidationConstraints.isEmpty(elem.getInputSets())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "inputSets");
                }
                if (BPMN2ValidationConstraints.isEmpty(elem.getOutputSets())) {
                    return this.createMissingFeatureStatus(ctx, (EObject)be, "outputSets");
                }
            }
        } else if (be instanceof ChoreographyActivity) {
            ChoreographyActivity elem = (ChoreographyActivity)be;
            if (elem.getParticipantRefs().size() < 2) {
                return this.createFailureStatus(ctx, (EObject)be, "participantRefs", Messages.BPMN2ValidationConstraints_45);
            }
            if (elem.getInitiatingParticipantRef() == null) {
                return this.createFailureStatus(ctx, (EObject)be, "initiatingParticipantRef", Messages.BPMN2ValidationConstraints_46);
            }
        } else if (be instanceof Resource) {
            Resource elem = (Resource)be;
            if (BPMN2ValidationConstraints.isEmpty(elem.getName())) {
                return this.createMissingFeatureStatus(ctx, (EObject)be, "name");
            }
        } else if (be instanceof ChoreographyTask) {
            ChoreographyTask elem = (ChoreographyTask)be;
            for (MessageFlow mf : elem.getMessageFlowRef()) {
                InteractionNode in = mf.getSourceRef();
                if (!elem.getParticipantRefs().contains(in)) {
                    return this.createFailureStatus(ctx, (EObject)be, "participantRefs", Messages.BPMN2ValidationConstraints_48);
                }
                in = mf.getTargetRef();
                if (elem.getParticipantRefs().contains(in)) continue;
                return this.createFailureStatus(ctx, (EObject)be, "participantRefs", Messages.BPMN2ValidationConstraints_49);
            }
        }
        if (be instanceof ItemAwareElement) {
            return this.validateItemAwareElement(ctx, (ItemAwareElement)be);
        }
        if (be instanceof FlowNode) {
            return this.validateFlowNode(ctx, (FlowNode)be);
        }
        return ctx.createSuccessStatus();
    }

    private Process findProcess(BaseElement be) {
        while (be != null && !(be instanceof Process) && be.eContainer() instanceof BaseElement) {
            be = (BaseElement)be.eContainer();
        }
        if (be instanceof Process) {
            return (Process)be;
        }
        return null;
    }

    private boolean isValidForExecutableProcess(BaseElement be, BaseElement ref) {
        Process process = this.findProcess(be);
        if (!this.warnings && process != null && process.isIsExecutable()) {
            if (ref == null) {
                return false;
            }
            if (ref instanceof Expression) {
                if (!(ref instanceof FormalExpression)) {
                    return false;
                }
                String body = ModelUtil.getExpressionBody((FormalExpression)ref);
                if (BPMN2ValidationConstraints.isEmpty(body)) {
                    return false;
                }
            } else if (ref instanceof Message) {
                Message message = (Message)ref;
                if (!this.isValidForExecutableProcess((BaseElement)message, (BaseElement)message.getItemRef())) {
                    return false;
                }
            } else if (ref instanceof ItemDefinition) {
                ItemDefinition itemDefinition = (ItemDefinition)ref;
                if (BPMN2ValidationConstraints.isEmpty(itemDefinition.getStructureRef())) {
                    return false;
                }
            } else if (ref instanceof Signal) {
                Signal signal = (Signal)ref;
                if (!this.isValidForExecutableProcess((BaseElement)signal, (BaseElement)signal.getStructureRef())) {
                    return false;
                }
            } else if (ref instanceof Error) {
                Error error = (Error)ref;
                if (BPMN2ValidationConstraints.isEmpty(error.getErrorCode())) {
                    return false;
                }
                if (!this.isValidForExecutableProcess((BaseElement)error, (BaseElement)error.getStructureRef())) {
                    return false;
                }
            } else if (ref instanceof Escalation) {
                Escalation escalation = (Escalation)ref;
                if (BPMN2ValidationConstraints.isEmpty(escalation.getEscalationCode())) {
                    return false;
                }
                if (!this.isValidForExecutableProcess((BaseElement)escalation, (BaseElement)escalation.getStructureRef())) {
                    return false;
                }
            } else if (!(ref instanceof Activity)) {
                return false;
            }
        }
        return true;
    }

    private IStatus validateEvent(IValidationContext ctx, Event event) {
        Process process = this.findProcess((BaseElement)event);
        if (process != null && process.isIsExecutable()) {
            EStructuralFeature feature = event.eClass().getEStructuralFeature("eventDefinitions");
            Assert.isNotNull((Object)feature);
            List eventdefs = (List)event.eGet(feature);
            if (eventdefs.size() == 0 && !(event instanceof StartEvent) && !(event instanceof EndEvent)) {
                return this.createMissingFeatureStatus(ctx, (EObject)event, "eventDefinitions");
            }
            for (EventDefinition ed : eventdefs) {
                IStatus status = this.validateEventDefinition(ctx, ed);
                if (status == null) continue;
                return status;
            }
        }
        return null;
    }

    private IStatus validateEventDefinition(IValidationContext ctx, EventDefinition ed) {
        if (ed instanceof TimerEventDefinition) {
            TimerEventDefinition ted = (TimerEventDefinition)ed;
            if (ted.getTimeDate() == null && ted.getTimeDuration() == null && ted.getTimeCycle() == null) {
                return this.createFailureStatus(ctx, (EObject)ed, "timeCycle", Messages.BPMN2ValidationConstraints_52);
            }
        } else if (ed instanceof SignalEventDefinition) {
            if (!this.isValidForExecutableProcess((BaseElement)ed, (BaseElement)((SignalEventDefinition)ed).getSignalRef())) {
                return this.createMissingFeatureStatus(ctx, (EObject)ed, "signalRef");
            }
        } else if (ed instanceof ErrorEventDefinition) {
            if (!this.isValidForExecutableProcess((BaseElement)ed, (BaseElement)((ErrorEventDefinition)ed).getErrorRef())) {
                return this.createMissingFeatureStatus(ctx, (EObject)ed, "errorRef");
            }
        } else if (ed instanceof ConditionalEventDefinition) {
            if (!this.isValidForExecutableProcess((BaseElement)ed, (BaseElement)((ConditionalEventDefinition)ed).getCondition())) {
                return this.createMissingFeatureStatus(ctx, (EObject)ed, "condition");
            }
        } else if (ed instanceof EscalationEventDefinition) {
            if (!this.isValidForExecutableProcess((BaseElement)ed, (BaseElement)((EscalationEventDefinition)ed).getEscalationRef())) {
                return this.createMissingFeatureStatus(ctx, (EObject)ed, "escalationRef");
            }
        } else if (ed instanceof MessageEventDefinition) {
            if (!this.isValidForExecutableProcess((BaseElement)ed, (BaseElement)((MessageEventDefinition)ed).getMessageRef())) {
                return this.createMissingFeatureStatus(ctx, (EObject)ed, "messageRef");
            }
        } else if (ed instanceof CompensateEventDefinition && !this.isValidForExecutableProcess((BaseElement)ed, (BaseElement)((CompensateEventDefinition)ed).getActivityRef())) {
            return this.createMissingFeatureStatus(ctx, (EObject)ed, "activityRef");
        }
        return null;
    }

    private IStatus validateFlowNode(IValidationContext ctx, FlowNode fn) {
        if (!this.warnings) {
            boolean needIncoming = true;
            boolean needOutgoing = true;
            if (fn instanceof ThrowEvent) {
                needOutgoing = false;
            }
            if (fn instanceof CatchEvent) {
                needIncoming = false;
            }
            if (fn.eContainer() instanceof AdHocSubProcess) {
                needIncoming = false;
                needOutgoing = false;
            }
            if (needOutgoing && (fn.getOutgoing() == null || fn.getOutgoing().size() < 1)) {
                return this.createMissingFeatureStatus(ctx, (EObject)fn, "outgoing");
            }
            if (needIncoming && (fn.getIncoming() == null || fn.getIncoming().size() < 1)) {
                return this.createMissingFeatureStatus(ctx, (EObject)fn, "incoming");
            }
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateItemAwareElement(IValidationContext ctx, ItemAwareElement elem) {
        if (!this.isValidForExecutableProcess((BaseElement)elem, (BaseElement)elem.getItemSubjectRef())) {
            return this.createMissingFeatureStatus(ctx, (EObject)elem, "itemSubjectRef");
        }
        return ctx.createSuccessStatus();
    }

    private IStatus validateEObject(IValidationContext ctx, EObject be) {
        if (be instanceof Import) {
            Import elem = (Import)be;
            if (!this.warnings) {
                if (BPMN2ValidationConstraints.isEmpty(elem.getLocation())) {
                    return this.createMissingFeatureStatus(ctx, be, "location");
                }
                if (BPMN2ValidationConstraints.isEmpty(elem.getNamespace())) {
                    return this.createMissingFeatureStatus(ctx, be, "namespace");
                }
                if (BPMN2ValidationConstraints.isEmpty(elem.getImportType())) {
                    return this.createMissingFeatureStatus(ctx, be, "importType");
                }
            }
        }
        return ctx.createSuccessStatus();
    }

    private static boolean isEmpty(Object object) {
        String w;
        if (object instanceof String) {
            String str = (String)object;
            return str == null || str.isEmpty();
        }
        if (object instanceof List) {
            return ((List)object).isEmpty();
        }
        return ModelUtil.isStringWrapper(object) ? (w = ModelUtil.getStringWrapperValue(object)) == null || w.isEmpty() : object == null;
    }

    private IStatus validateBaseElementLive(IValidationContext ctx, BaseElement be) {
        block16: {
            block19: {
                block18: {
                    block17: {
                        block15: {
                            Object structureRef;
                            if (!(be instanceof ItemDefinition)) break block15;
                            ItemDefinition itemDefinition = (ItemDefinition)be;
                            Definitions defs = ModelUtil.getDefinitions(itemDefinition);
                            if (defs != null) {
                                List<ItemDefinition> itemDefs = ModelUtil.getAllRootElements(defs, ItemDefinition.class);
                                for (ItemDefinition id : itemDefs) {
                                    Object structureRef2;
                                    if (id == itemDefinition || !ExtendedPropertiesProvider.compare((EObject)id, (EObject)itemDefinition, true) || (structureRef2 = itemDefinition.getStructureRef()) == null || ModelUtil.isStringWrapper(structureRef2) && ModelUtil.getStringWrapperValue(structureRef2).isEmpty()) continue;
                                    return this.createFailureStatus(ctx, (EObject)be, "structureRef", NLS.bind((String)Messages.BPMN2ValidationConstraints_Duplicate_Data_Type, (Object[])new Object[]{id.getItemKind(), id.isIsCollection() ? "[]" : "", ExtendedPropertiesProvider.getTextValue((EObject)id)}));
                                }
                            }
                            if ((structureRef = itemDefinition.getStructureRef()) == null || ModelUtil.isStringWrapper(structureRef) && ModelUtil.getStringWrapperValue(structureRef).isEmpty()) {
                                return this.createMissingFeatureStatus(ctx, (EObject)be, "structureRef");
                            }
                            break block16;
                        }
                        if (!(be instanceof Event)) break block17;
                        IStatus status = this.validateEvent(ctx, (Event)be);
                        if (status != null) {
                            return status;
                        }
                        break block16;
                    }
                    if (!(be instanceof EventDefinition)) break block18;
                    IStatus status = this.validateEventDefinition(ctx, (EventDefinition)be);
                    if (status != null) {
                        return status;
                    }
                    break block16;
                }
                if (!(be instanceof DataInput)) break block19;
                DataInput param = (DataInput)be;
                List allParams = null;
                if (be.eContainer() instanceof InputOutputSpecification) {
                    allParams = ((InputOutputSpecification)param.eContainer()).getDataInputs();
                } else if (be.eContainer() instanceof ThrowEvent) {
                    allParams = ((ThrowEvent)param.eContainer()).getDataInputs();
                }
                if (allParams == null) break block16;
                for (DataInput i : allParams) {
                    if (i == param) continue;
                    String n1 = param.getName();
                    String n2 = i.getName();
                    if (n1 == null || n2 == null || !n1.equals(n2)) continue;
                    return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.BPMN2ValidationConstraints_Duplicate_Input, (Object)param.getName())});
                }
                break block16;
            }
            if (be instanceof DataOutput) {
                DataOutput param = (DataOutput)be;
                List allParams = null;
                if (be.eContainer() instanceof InputOutputSpecification) {
                    allParams = ((InputOutputSpecification)param.eContainer()).getDataOutputs();
                } else if (be.eContainer() instanceof CatchEvent) {
                    allParams = ((CatchEvent)param.eContainer()).getDataOutputs();
                }
                if (allParams != null) {
                    for (DataOutput i : allParams) {
                        if (i == param) continue;
                        String n1 = param.getName();
                        String n2 = i.getName();
                        if (n1 == null || n2 == null || !n1.equals(n2)) continue;
                        return ctx.createFailureStatus(new Object[]{NLS.bind((String)Messages.BPMN2ValidationConstraints_Duplicate_Output, (Object)param.getName())});
                    }
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

