/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.modeler.core.IBpmn2RuntimeExtension;
import org.eclipse.bpmn2.modeler.core.LifecycleEvent;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskImageProvider;
import org.eclipse.bpmn2.modeler.core.runtime.DataTypeDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ExpressionLanguageDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.FeatureContainerDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.IRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.Messages;
import org.eclipse.bpmn2.modeler.core.runtime.ModelDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelEnablementDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ModelExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.PropertyExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.PropertyTabDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.ServiceImplementationDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntimeConfigurationException;
import org.eclipse.bpmn2.modeler.core.runtime.ToolPaletteDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TypeLanguageDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ErrorDialog;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

public class TargetRuntime
extends BaseRuntimeExtensionDescriptor
implements IRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "runtime";
    public static final String RUNTIME_EXTENSION_ID = "org.eclipse.bpmn2.modeler.runtime";
    public static final String DEFAULT_RUNTIME_ID = "org.eclipse.bpmn2.modeler.runtime.none";
    public static final String BPMN2_MARKER_ID = "org.eclipse.bpmn2.modeler.core.problemMarker";
    private static List<TargetRuntime> targetRuntimes;
    private static TargetRuntime currentRuntime;
    private String name;
    private String[] versions;
    private String description;
    private IBpmn2RuntimeExtension runtimeExtension;
    private String problemMarkerId;
    protected List<ModelDescriptor> modelDescriptors;
    protected List<PropertyTabDescriptor> propertyTabDescriptors;
    protected List<CustomTaskDescriptor> customTaskDescriptors;
    protected List<ModelExtensionDescriptor> modelExtensionDescriptors;
    protected List<ModelEnablementDescriptor> modelEnablementDescriptors;
    protected List<PropertyExtensionDescriptor> propertyExtensionDescriptors;
    protected List<FeatureContainerDescriptor> featureContainerDescriptors;
    protected List<ToolPaletteDescriptor> toolPaletteDescriptors;
    protected List<ShapeStyle> shapeStyles;
    protected List<DataTypeDescriptor> dataTypeDescriptors;
    protected List<TypeLanguageDescriptor> typeLanguageDescriptors;
    protected List<ExpressionLanguageDescriptor> expressionLanguageDescriptors;
    protected List<ServiceImplementationDescriptor> serviceImplementationDescriptors;
    static Class[] extensionDescriptorClasses;

    static {
        extensionDescriptorClasses = new Class[]{TargetRuntime.class, ModelDescriptor.class, DataTypeDescriptor.class, PropertyTabDescriptor.class, ModelExtensionDescriptor.class, CustomTaskDescriptor.class, ModelEnablementDescriptor.class, ToolPaletteDescriptor.class, PropertyExtensionDescriptor.class, FeatureContainerDescriptor.class, TypeLanguageDescriptor.class, ExpressionLanguageDescriptor.class, ServiceImplementationDescriptor.class, ShapeStyle.class};
    }

    public TargetRuntime(IConfigurationElement e) {
        super(e);
        IConfigurationElement[] markers;
        this.name = e.getAttribute("name");
        String s = e.getAttribute("versions");
        if (s != null) {
            this.versions = s.split("[, ]");
        }
        this.description = e.getAttribute("description");
        try {
            this.setRuntimeExtension((IBpmn2RuntimeExtension)e.createExecutableExtension("class"));
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        IContributor contributor = e.getDeclaringExtension().getContributor();
        IConfigurationElement[] iConfigurationElementArray = markers = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.core.resources.markers");
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement m = iConfigurationElementArray[n2];
            if (m.getDeclaringExtension().getContributor() == contributor) {
                this.problemMarkerId = m.getDeclaringExtension().getUniqueIdentifier();
            }
            ++n2;
        }
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Override
    public void setRuntime(TargetRuntime targetRuntime) {
        targetRuntimes.add(this);
    }

    @Override
    public TargetRuntime getRuntime() {
        return this;
    }

    @Override
    public IFile getConfigFile() {
        return null;
    }

    @Override
    public void setConfigFile(IFile configFile) {
    }

    @Override
    public void dispose() {
    }

    public void notify(LifecycleEvent event) {
        for (TargetRuntime rt : targetRuntimes) {
            if (!rt.getId().equals(this.id)) continue;
            rt.getRuntimeExtension().notify(event);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String[] getVersions() {
        return this.versions;
    }

    public String getDescription() {
        return this.description;
    }

    public IBpmn2RuntimeExtension getRuntimeExtension() {
        return this.runtimeExtension;
    }

    public void setRuntimeExtension(IBpmn2RuntimeExtension runtimeExtension) {
        this.runtimeExtension = runtimeExtension;
    }

    public ModelDescriptor getModelDescriptor() {
        if (this.getModelDescriptors().size() == 0) {
            return null;
        }
        return this.getModelDescriptors().get(0);
    }

    public void setModelDescriptor(ModelDescriptor md) {
        this.getModelDescriptors().clear();
        this.getModelDescriptors().add(md);
    }

    public String getProblemMarkerId() {
        if (this.problemMarkerId == null) {
            return BPMN2_MARKER_ID;
        }
        return this.problemMarkerId;
    }

    public static TargetRuntime getRuntime(String id) {
        if (targetRuntimes == null) {
            return null;
        }
        for (TargetRuntime rt : targetRuntimes) {
            if (!rt.id.equals(id)) continue;
            return rt;
        }
        return null;
    }

    public static void setCurrentRuntime(TargetRuntime rt) {
        currentRuntime = rt;
    }

    public static TargetRuntime getCurrentRuntime() {
        if (currentRuntime == null) {
            return TargetRuntime.getDefaultRuntime();
        }
        return currentRuntime;
    }

    public static TargetRuntime getDefaultRuntime() {
        return TargetRuntime.getRuntime(DEFAULT_RUNTIME_ID);
    }

    public static String getFirstNonDefaultId() {
        String runtimeId = null;
        int nonDefaultRuntimeCount = 0;
        if (TargetRuntime.createTargetRuntimes() == null) {
            return DEFAULT_RUNTIME_ID;
        }
        for (TargetRuntime rt : TargetRuntime.createTargetRuntimes()) {
            if (rt.getId().equals(DEFAULT_RUNTIME_ID)) continue;
            ++nonDefaultRuntimeCount;
            runtimeId = rt.getId();
        }
        if (nonDefaultRuntimeCount == 1 && runtimeId != null) {
            return runtimeId;
        }
        return DEFAULT_RUNTIME_ID;
    }

    public void registerExtensionResourceFactory(ResourceSet resourceSet) {
        resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.bpmn2.content-type.xml", this.getModelDescriptor().getResourceFactory());
    }

    public static List<TargetRuntime> createTargetRuntimes() {
        if (targetRuntimes == null) {
            targetRuntimes = new ArrayList<TargetRuntime>();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(RUNTIME_EXTENSION_ID);
            try {
                TargetRuntime.loadExtensions(null, elements, null);
            }
            catch (Exception e) {
                ErrorDialog dlg = new ErrorDialog(Messages.TargetRuntime_Config_Error, e);
                dlg.show();
            }
            for (TargetRuntime rt : targetRuntimes) {
                if (rt.getModelDescriptor() == null) {
                    rt.setModelDescriptor(TargetRuntime.getDefaultRuntime().getModelDescriptor());
                }
                for (ToolPaletteDescriptor tp : rt.getToolPaletteDescriptors()) {
                    tp.sortCategories();
                }
            }
            CustomTaskImageProvider.registerAvailableImages();
        }
        return targetRuntimes;
    }

    static TargetRuntime getRuntime(IConfigurationElement e) {
        TargetRuntime rt = TargetRuntime.getRuntime(TargetRuntime.getRuntimeId(e));
        if (rt == null) {
            rt = currentRuntime != null ? currentRuntime : TargetRuntime.getDefaultRuntime();
        }
        return rt;
    }

    static String getRuntimeId(IConfigurationElement e) {
        String id = null;
        if (EXTENSION_NAME.equals(e.getName())) {
            id = e.getAttribute("id");
        } else {
            id = e.getAttribute("runtimeId");
            if (id == null) {
                IConfigurationElement[] iConfigurationElementArray = e.getDeclaringExtension().getConfigurationElements();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ep = iConfigurationElementArray[n2];
                    if (EXTENSION_NAME.equals(ep.getName())) {
                        id = ep.getAttribute("id");
                        break;
                    }
                    ++n2;
                }
            }
        }
        return id;
    }

    public List<TargetRuntime> getTargetRuntimes() {
        return TargetRuntime.createTargetRuntimes();
    }

    public CustomTaskDescriptor getCustomTask(String id) {
        for (CustomTaskDescriptor ctd : this.customTaskDescriptors) {
            if (!ctd.getId().equalsIgnoreCase(id)) continue;
            return ctd;
        }
        return null;
    }

    public boolean customTaskExists(String id) {
        for (CustomTaskDescriptor ctd : this.customTaskDescriptors) {
            if (!ctd.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    public void addCustomTask(CustomTaskDescriptor ct) {
        this.getCustomTaskDescriptors().add(ct);
        ct.targetRuntime = this;
    }

    public String getCustomTaskId(EObject object) {
        for (CustomTaskDescriptor ctd : this.getCustomTaskDescriptors()) {
            String id = ctd.getFeatureContainer().getId(object);
            if (!ctd.getId().equals(id)) continue;
            return id;
        }
        return null;
    }

    public void addModelExtension(ModelExtensionDescriptor me) {
        this.getModelExtensionDescriptors().add(me);
    }

    public void addPropertyExtension(PropertyExtensionDescriptor me) {
        this.getPropertyExtensionDescriptors().add(me);
    }

    public PropertyExtensionDescriptor getPropertyExtension(Class clazz) {
        for (PropertyExtensionDescriptor ped : this.getPropertyExtensionDescriptors()) {
            String className = clazz.getName();
            if (className.equals(ped.type)) {
                return ped;
            }
            className = className.replaceFirst("\\.impl\\.", ".");
            if (!(className = className.replaceFirst("Impl$", "")).equals(ped.type)) continue;
            return ped;
        }
        return null;
    }

    public void addFeatureContainer(FeatureContainerDescriptor me) {
        this.getFeatureContainerDescriptors().add(me);
    }

    public FeatureContainerDescriptor getFeatureContainer(EClass clazz) {
        for (FeatureContainerDescriptor fcd : this.getFeatureContainerDescriptors()) {
            String className = clazz.getInstanceClassName();
            if (className.equals(fcd.type)) {
                return fcd;
            }
            className = className.replaceFirst("\\.impl\\.", ".");
            if (!(className = className.replaceFirst("Impl$", "")).equals(fcd.type)) continue;
            return fcd;
        }
        return null;
    }

    public ModelEnablementDescriptor getModelEnablements(EObject object) {
        List<ModelEnablementDescriptor> meds;
        TargetRuntime rt = this;
        DiagramEditor diagramEditor = ModelUtil.getEditor(object);
        if (diagramEditor != null) {
            rt = (TargetRuntime)diagramEditor.getAdapter(TargetRuntime.class);
        }
        if ((meds = rt.getModelEnablementDescriptors()).size() > 0) {
            return meds.get(0);
        }
        return null;
    }

    public List<ModelEnablementDescriptor> getModelEnablements() {
        ArrayList<ModelEnablementDescriptor> list = new ArrayList<ModelEnablementDescriptor>();
        for (ModelEnablementDescriptor me : this.getModelEnablementDescriptors()) {
            list.add(me);
        }
        return list;
    }

    public ModelEnablementDescriptor getModelEnablements(String profileId) {
        if (profileId != null && profileId.isEmpty()) {
            profileId = null;
        }
        for (ModelEnablementDescriptor me : this.getModelEnablementDescriptors()) {
            if (profileId != null && !profileId.equalsIgnoreCase(me.getId())) continue;
            return me;
        }
        if (this != TargetRuntime.getDefaultRuntime()) {
            return TargetRuntime.getDefaultRuntime().getModelEnablements(profileId);
        }
        return null;
    }

    public void addModelEnablements(ModelEnablementDescriptor me) {
        this.getModelEnablementDescriptors().add(me);
    }

    public ToolPaletteDescriptor getToolPalette(EObject object) {
        DiagramEditor diagramEditor = ModelUtil.getEditor(object);
        return (ToolPaletteDescriptor)diagramEditor.getAdapter(ToolPaletteDescriptor.class);
    }

    public ToolPaletteDescriptor getToolPalette(String profileId) {
        ToolPaletteDescriptor defaultToolPalette = null;
        List<ToolPaletteDescriptor> allToolPalettes = this.getToolPaletteDescriptors();
        int i = allToolPalettes.size() - 1;
        while (i >= 0) {
            ToolPaletteDescriptor tp = allToolPalettes.get(i);
            if (profileId == null) {
                return tp;
            }
            for (String p : tp.getProfileIds()) {
                if (!profileId.equalsIgnoreCase(p)) continue;
                return tp;
            }
            if (defaultToolPalette == null) {
                defaultToolPalette = tp;
            }
            --i;
        }
        if (defaultToolPalette != null) {
            return defaultToolPalette;
        }
        if (this != TargetRuntime.getDefaultRuntime()) {
            return TargetRuntime.getDefaultRuntime().getToolPalette(profileId);
        }
        return null;
    }

    public void addToolPalette(ToolPaletteDescriptor tp) {
        this.getToolPaletteDescriptors().add(tp);
    }

    private void addAfterTab(ArrayList<PropertyTabDescriptor> list, PropertyTabDescriptor tab) {
        TargetRuntime.createTargetRuntimes();
        String afterTab = tab.getAfterTab();
        if (afterTab != null && !afterTab.isEmpty() && !afterTab.equals("top")) {
            tab.getId();
            for (TargetRuntime rt : targetRuntimes) {
                for (PropertyTabDescriptor td : rt.getPropertyTabDescriptors()) {
                    if (tab == td || !td.getId().equals(afterTab) && !td.isReplacementForTab(afterTab)) continue;
                    this.addAfterTab(list, td);
                    if (rt != this && rt != TargetRuntime.getDefaultRuntime() || list.contains(td)) continue;
                    list.add(td);
                }
            }
        }
    }

    public void addPropertyTabDescriptor(PropertyTabDescriptor td) {
        this.getPropertyTabDescriptors().add(td);
    }

    public static PropertyTabDescriptor findPropertyTabDescriptor(String id) {
        for (TargetRuntime rt : TargetRuntime.createTargetRuntimes()) {
            PropertyTabDescriptor tab = rt.getPropertyTabDescriptor(id);
            if (tab == null) continue;
            return tab;
        }
        return null;
    }

    public PropertyTabDescriptor getPropertyTabDescriptor(String id) {
        for (PropertyTabDescriptor tab : this.getPropertyTabDescriptors()) {
            if (!tab.getId().equals(id)) continue;
            return tab;
        }
        return null;
    }

    public List<PropertyTabDescriptor> buildPropertyTabDescriptors() {
        ArrayList<PropertyTabDescriptor> list = new ArrayList<PropertyTabDescriptor>();
        for (PropertyTabDescriptor tab : this.getPropertyTabDescriptors()) {
            this.addAfterTab(list, tab);
            if (list.contains(tab)) continue;
            list.add(tab);
        }
        return list;
    }

    public String getTypeLanguage() {
        if (this.getTypeLanguageDescriptors().size() > 0) {
            return this.getTypeLanguageDescriptors().get(0).getUri();
        }
        return TargetRuntime.getDefaultRuntime().getTypeLanguage();
    }

    public TypeLanguageDescriptor getTypeLanguageDescriptor(String uri) {
        if (uri != null) {
            for (TypeLanguageDescriptor tld : this.getTypeLanguageDescriptors()) {
                if (!uri.equals(tld.getUri())) continue;
                return tld;
            }
        }
        return null;
    }

    public String getExpressionLanguage() {
        if (this.getExpressionLanguageDescriptors().size() > 0) {
            return this.getExpressionLanguageDescriptors().get(0).getUri();
        }
        return TargetRuntime.getDefaultRuntime().getExpressionLanguage();
    }

    public ExpressionLanguageDescriptor getExpressionLanguageDescriptor(String uri) {
        if (uri != null) {
            for (ExpressionLanguageDescriptor tld : this.getExpressionLanguageDescriptors()) {
                if (!uri.equals(tld.getUri())) continue;
                return tld;
            }
        }
        return null;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof TargetRuntime) {
            if (this.id != null && this.id.equals(((TargetRuntime)arg0).getId())) {
                return true;
            }
        } else if (arg0 instanceof String) {
            return ((String)arg0).equals(this.id);
        }
        return super.equals(arg0);
    }

    public static void loadExtensions(TargetRuntime targetRuntime, IConfigurationElement[] elements, IFile file) throws TargetRuntimeConfigurationException {
        TargetRuntime oldCurrentRuntime = currentRuntime;
        currentRuntime = targetRuntime;
        try {
            ConfigurationElementSorter.sort(elements);
            TargetRuntime.unloadExtensions(file);
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                currentRuntime = TargetRuntime.getRuntime(e);
                TargetRuntime.createRuntimeExtensionDescriptor(currentRuntime, e, file);
                ++n2;
            }
        }
        finally {
            currentRuntime = oldCurrentRuntime;
        }
    }

    public static void unloadExtensions(IFile file) {
        if (file != null) {
            ArrayList<IRuntimeExtensionDescriptor> disposed = new ArrayList<IRuntimeExtensionDescriptor>();
            for (TargetRuntime rt : targetRuntimes) {
                Class[] classArray = extensionDescriptorClasses;
                int n = extensionDescriptorClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class c = classArray[n2];
                    String name = TargetRuntime.getExtensionNameForClass(c);
                    for (IRuntimeExtensionDescriptor d : rt.getRuntimeExtensionDescriptors(name)) {
                        if (!file.equals((Object)d.getConfigFile())) continue;
                        disposed.add(d);
                    }
                    ++n2;
                }
            }
            for (IRuntimeExtensionDescriptor d : disposed) {
                d.dispose();
            }
        }
    }

    public static IRuntimeExtensionDescriptor createRuntimeExtensionDescriptor(TargetRuntime rt, IConfigurationElement e, IFile file) throws TargetRuntimeConfigurationException {
        IRuntimeExtensionDescriptor d = null;
        try {
            Class c = TargetRuntime.getClassForExtensionName(e.getName());
            Constructor ctor = c.getConstructor(IConfigurationElement.class);
            d = (IRuntimeExtensionDescriptor)ctor.newInstance(e);
            d.setRuntime(rt);
            d.setConfigFile(file);
        }
        catch (Exception ex) {
            throw new TargetRuntimeConfigurationException(rt, ex);
        }
        return d;
    }

    public List<IRuntimeExtensionDescriptor> getRuntimeExtensionDescriptors(String name) {
        ArrayList<IRuntimeExtensionDescriptor> result = new ArrayList();
        try {
            Class c = TargetRuntime.getClassForExtensionName(name);
            Method m = TargetRuntime.class.getMethod("get" + c.getSimpleName() + "s", new Class[0]);
            result = (List)m.invoke((Object)this, new Object[0]);
        }
        catch (Exception ex) {
            throw new TargetRuntimeConfigurationException(this, ex);
        }
        return result;
    }

    public static Class getClassForExtensionName(String name) {
        try {
            int i = 0;
            while (i < extensionDescriptorClasses.length) {
                Class c = extensionDescriptorClasses[i];
                Field field = c.getField("EXTENSION_NAME");
                String n = (String)field.get(null);
                if (name.equals(n)) {
                    return c;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            throw new TargetRuntimeConfigurationException(null, ex);
        }
        return null;
    }

    public static String getExtensionNameForClass(Class clazz) {
        try {
            Field field = clazz.getField("EXTENSION_NAME");
            return (String)field.get(null);
        }
        catch (Exception ex) {
            throw new TargetRuntimeConfigurationException(null, ex);
        }
    }

    public List<CustomTaskDescriptor> getCustomTaskDescriptors() {
        if (this.customTaskDescriptors == null) {
            this.customTaskDescriptors = new ArrayList<CustomTaskDescriptor>();
        }
        return this.customTaskDescriptors;
    }

    public List<ModelExtensionDescriptor> getModelExtensionDescriptors() {
        if (this.modelExtensionDescriptors == null) {
            this.modelExtensionDescriptors = new ArrayList<ModelExtensionDescriptor>();
        }
        return this.modelExtensionDescriptors;
    }

    public List<ModelExtensionDescriptor> getAllModelExtensionDescriptors() {
        ArrayList<ModelExtensionDescriptor> list = new ArrayList<ModelExtensionDescriptor>();
        list.addAll(this.getCustomTaskDescriptors());
        list.addAll(this.getModelExtensionDescriptors());
        return list;
    }

    public ModelExtensionDescriptor getModelExtensionDescriptor(EObject object) {
        EClass eClass = (EClass)(object instanceof EClass ? object : object.eClass());
        for (ModelExtensionDescriptor md : this.getModelExtensionDescriptors()) {
            String type = eClass.getName();
            if (md.getType().equals(type)) {
                return md;
            }
            for (EClass ec : eClass.getESuperTypes()) {
                type = ec.getName();
                if (md.getType().equals(type)) {
                    return md;
                }
                ModelExtensionDescriptor md2 = this.getModelExtensionDescriptor((EObject)ec);
                if (md2 == null) continue;
                return md2;
            }
        }
        return null;
    }

    public Hashtable<EClass, List<EStructuralFeature>> getModelExtensions(int filter) {
        ModelDescriptor md;
        Hashtable<EClass, List<EStructuralFeature>> list = new Hashtable<EClass, List<EStructuralFeature>>();
        for (CustomTaskDescriptor ctd : this.getCustomTaskDescriptors()) {
            this.getModelExtensions(filter, ctd, list);
        }
        for (ModelExtensionDescriptor med : this.getModelExtensionDescriptors()) {
            this.getModelExtensions(filter, med, list);
        }
        if (filter == 2 && (md = this.getModelDescriptor()).getEPackage() != Bpmn2Package.eINSTANCE) {
            for (EClassifier ec : md.getEPackage().getEClassifiers()) {
                if (ec.getName().equals("DocumentRoot") || !(ec instanceof EClass)) continue;
                EClass eClass = (EClass)ec;
                List<EStructuralFeature> features = list.get(eClass);
                if (features == null) {
                    features = new ArrayList<EStructuralFeature>();
                    list.put(eClass, features);
                }
                for (EStructuralFeature f : eClass.getEStructuralFeatures()) {
                    features.add(f);
                }
            }
        }
        return list;
    }

    private void getModelExtensions(int filter, ModelExtensionDescriptor med, Hashtable<EClass, List<EStructuralFeature>> list) {
        String type = med.getType();
        EClassifier bpmn2type = Bpmn2Package.eINSTANCE.getEClassifier(type);
        if (filter == 1 && bpmn2type == null) {
            return;
        }
        if (filter == 2 && bpmn2type != null) {
            return;
        }
        EClass eClass = med.createEClass(type);
        List<EStructuralFeature> features = list.get(eClass);
        if (features == null) {
            features = new ArrayList<EStructuralFeature>();
            list.put(eClass, features);
        }
        for (ModelExtensionDescriptor.Property p : med.getProperties()) {
            EStructuralFeature feature = med.createEFeature(eClass, p);
            if (bpmn2type instanceof EClass && ((EClass)bpmn2type).getEStructuralFeature(p.name) != null) continue;
            if (feature != null && !features.contains(feature)) {
                features.add(feature);
            }
            for (Object v : p.getValues()) {
                if (!(v instanceof ModelExtensionDescriptor.Property)) continue;
                this.getModelExtensions(med, (ModelExtensionDescriptor.Property)v, list);
            }
        }
        if (features.isEmpty()) {
            list.remove(eClass);
        }
    }

    private void getModelExtensions(ModelExtensionDescriptor med, ModelExtensionDescriptor.Property p, Hashtable<EClass, List<EStructuralFeature>> list) {
        EClass eClass;
        if (p.parent != null && (eClass = med.getModelDecorator().getEClass(p.parent.type)) != null) {
            EStructuralFeature feature;
            List<EStructuralFeature> features = list.get(eClass);
            if (features == null) {
                features = new ArrayList<EStructuralFeature>();
                list.put(eClass, features);
            }
            if ((feature = med.createEFeature(eClass, p)) != null && !features.contains(feature)) {
                features.add(feature);
            }
            for (Object v : p.getValues()) {
                if (!(v instanceof ModelExtensionDescriptor.Property)) continue;
                this.getModelExtensions(med, (ModelExtensionDescriptor.Property)v, list);
            }
        }
    }

    public List<PropertyExtensionDescriptor> getPropertyExtensionDescriptors() {
        if (this.propertyExtensionDescriptors == null) {
            this.propertyExtensionDescriptors = new ArrayList<PropertyExtensionDescriptor>();
        }
        return this.propertyExtensionDescriptors;
    }

    public List<FeatureContainerDescriptor> getFeatureContainerDescriptors() {
        if (this.featureContainerDescriptors == null) {
            this.featureContainerDescriptors = new ArrayList<FeatureContainerDescriptor>();
        }
        return this.featureContainerDescriptors;
    }

    public List<ModelEnablementDescriptor> getModelEnablementDescriptors() {
        if (this.modelEnablementDescriptors == null) {
            this.modelEnablementDescriptors = new ArrayList<ModelEnablementDescriptor>();
        }
        return this.modelEnablementDescriptors;
    }

    public List<ToolPaletteDescriptor> getToolPaletteDescriptors() {
        if (this.toolPaletteDescriptors == null) {
            this.toolPaletteDescriptors = new ArrayList<ToolPaletteDescriptor>();
        }
        return this.toolPaletteDescriptors;
    }

    public List<ShapeStyle> getShapeStyles() {
        if (this.shapeStyles == null) {
            this.shapeStyles = new ArrayList<ShapeStyle>();
        }
        return this.shapeStyles;
    }

    public List<PropertyTabDescriptor> getPropertyTabDescriptors() {
        if (this.propertyTabDescriptors == null) {
            this.propertyTabDescriptors = new ArrayList<PropertyTabDescriptor>();
        }
        return this.propertyTabDescriptors;
    }

    public List<ModelDescriptor> getModelDescriptors() {
        if (this.modelDescriptors == null) {
            this.modelDescriptors = new ArrayList<ModelDescriptor>();
        }
        return this.modelDescriptors;
    }

    public List<DataTypeDescriptor> getDataTypeDescriptors() {
        if (this.dataTypeDescriptors == null) {
            this.dataTypeDescriptors = new ArrayList<DataTypeDescriptor>();
        }
        return this.dataTypeDescriptors;
    }

    public List<TypeLanguageDescriptor> getTypeLanguageDescriptors() {
        if (this.typeLanguageDescriptors == null) {
            this.typeLanguageDescriptors = new ArrayList<TypeLanguageDescriptor>();
        }
        return this.typeLanguageDescriptors;
    }

    public List<ExpressionLanguageDescriptor> getExpressionLanguageDescriptors() {
        if (this.expressionLanguageDescriptors == null) {
            this.expressionLanguageDescriptors = new ArrayList<ExpressionLanguageDescriptor>();
        }
        return this.expressionLanguageDescriptors;
    }

    public List<ServiceImplementationDescriptor> getServiceImplementationDescriptors() {
        if (this.serviceImplementationDescriptors == null) {
            this.serviceImplementationDescriptors = new ArrayList<ServiceImplementationDescriptor>();
        }
        return this.serviceImplementationDescriptors;
    }

    public static class ConfigurationElementSorter {
        public static void sort(IConfigurationElement[] elements) {
            Arrays.sort(elements, new Comparator<IConfigurationElement>(){

                @Override
                public int compare(IConfigurationElement e0, IConfigurationElement e1) {
                    return this.rank(e1) - this.rank(e0);
                }

                int rank(IConfigurationElement e) {
                    int rank = 0;
                    try {
                        String name = e.getName();
                        int i = 0;
                        while (i < extensionDescriptorClasses.length) {
                            Class c = extensionDescriptorClasses[i];
                            Field field = c.getField("EXTENSION_NAME");
                            String n = (String)field.get(null);
                            if (name.equals(n)) {
                                rank = extensionDescriptorClasses.length - i;
                                break;
                            }
                            ++i;
                        }
                        rank *= 2;
                        String id = TargetRuntime.getRuntimeId(e);
                        if (TargetRuntime.DEFAULT_RUNTIME_ID.equals(id)) {
                            ++rank;
                        }
                    }
                    catch (Exception ex) {
                        throw new TargetRuntimeConfigurationException(null, ex);
                    }
                    return rank;
                }
            });
        }
    }
}

