/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectPropertyProvider;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.IObjectDecorator;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.SimpleTreeIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelExtensionDescriptor
extends BaseRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "modelExtension";
    protected String name;
    protected String uri;
    protected String type;
    protected String description;
    protected IObjectDecorator objectDecorator;
    protected List<Property> properties = new ArrayList<Property>();
    protected ModelDecorator modelDecorator;
    private Resource containingResource;
    private EObject modelObject;
    private InitializerList initializers = new InitializerList();
    private int recursionCounter;

    public ModelExtensionDescriptor(IConfigurationElement e) {
        super(e);
        this.name = e.getAttribute("name");
        this.uri = e.getAttribute("uri");
        this.type = e.getAttribute("type");
        this.description = e.getAttribute("description");
        if (e.getAttribute("decorator") != null) {
            try {
                this.objectDecorator = (IObjectDecorator)e.createExecutableExtension("decorator");
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
        }
        this.getModelExtensionProperties(null, this, e);
    }

    @Override
    public void setConfigFile(IFile configFile) {
        super.setConfigFile(configFile);
        if (configFile != null) {
            Bpmn2Preferences prefs = Bpmn2Preferences.getInstance(configFile.getProject());
            prefs.loadDefaults(this.targetRuntime, "model.enablement");
        }
    }

    @Override
    public void dispose() {
        Bpmn2Preferences prefs;
        if (this.configFile != null) {
            prefs = Bpmn2Preferences.getInstance(this.configFile.getProject());
            prefs.unloadDefaults(this.targetRuntime, "model.enablement");
        }
        super.dispose();
        if (this.configFile != null) {
            prefs = Bpmn2Preferences.getInstance(this.configFile.getProject());
            prefs.loadDefaults(this.targetRuntime, "model.enablement");
        }
        this.getModelDecorator().dispose();
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    @Deprecated
    public ModelExtensionDescriptor(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    protected Object getModelExtensionProperties(Property parent, ModelExtensionDescriptor ct, IConfigurationElement e) {
        String elem = e.getName();
        if ("value".equals(elem)) {
            String id = e.getAttribute("id");
            Value val = new Value(id);
            IConfigurationElement[] iConfigurationElementArray = e.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement c = iConfigurationElementArray[n2];
                Object propValue = this.getModelExtensionProperties(parent, null, c);
                val.getValues().add(propValue);
                ++n2;
            }
            return val;
        }
        if ("property".equals(elem)) {
            Object o;
            String name = e.getAttribute("name");
            String label = e.getAttribute("label");
            String value = e.getAttribute("value");
            String ref = e.getAttribute("ref");
            String type = e.getAttribute("type");
            String description = e.getAttribute("description");
            Property prop = new Property(parent, name, description);
            prop.label = label;
            prop.setType(type);
            if (value != null) {
                prop.getValues().add(value);
            } else if (ref != null) {
                prop.ref = ref;
            } else if (e.getChildren().length > 0 && (o = this.getModelExtensionProperties(prop, null, e.getChildren()[0])) instanceof Value) {
                prop.getValues().addAll(((Value)o).getValues());
            }
            return prop;
        }
        IConfigurationElement[] iConfigurationElementArray = e.getChildren();
        int n = iConfigurationElementArray.length;
        int n3 = 0;
        while (n3 < n) {
            IConfigurationElement c = iConfigurationElementArray[n3];
            Object o = this.getModelExtensionProperties(parent, null, c);
            if (o instanceof Property && ct != null) {
                ct.getProperties().add((Property)o);
            }
            ++n3;
        }
        return null;
    }

    public EObject createObject(EClass eClass) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(eClass);
        if (adapter != null) {
            adapter.setResource(this.containingResource);
            return adapter.getObjectDescriptor().createObject(eClass);
        }
        EPackage pkg = eClass.getEPackage();
        return pkg.getEFactoryInstance().create(eClass);
    }

    public ModelDecorator getModelDecorator() {
        if (this.modelDecorator == null) {
            String name = null;
            String nsPrefix = null;
            String nsURI = null;
            EPackage pkg = this.getEPackage();
            if (this.uri == null && pkg == Bpmn2Package.eINSTANCE) {
                nsURI = String.valueOf(this.getRuntime().getRuntimeExtension().getTargetNamespace(ModelUtil.Bpmn2DiagramType.NONE)) + "/ext";
            } else if (!(this.uri == null || pkg != null && this.uri.equals(pkg.getNsURI()))) {
                nsURI = this.uri;
            }
            if (nsURI != null) {
                nsPrefix = name = URI.createURI(nsURI).lastSegment();
                this.modelDecorator = new ModelDecorator(name, nsPrefix, nsURI);
            } else {
                this.modelDecorator = new ModelDecorator(pkg);
            }
        }
        return this.modelDecorator;
    }

    public EObject populateObject(EObject object, Resource resource, boolean initialize) {
        try {
            this.containingResource = resource;
            this.modelObject = object;
            if (this.containingResource == null) {
                this.containingResource = ObjectPropertyProvider.getResource(object);
            }
            this.getModelDecorator();
            if (this.objectDecorator != null) {
                if (this.objectDecorator.canApply(this.id, this.containingResource, this.modelObject)) {
                    this.populateObject(this.modelObject, initialize);
                    this.objectDecorator.apply(this.id, this.containingResource, this.modelObject);
                }
            } else {
                this.populateObject(this.modelObject, initialize);
            }
        }
        finally {
            this.containingResource = null;
            object = this.modelObject;
        }
        return object;
    }

    public void populateObject(EObject object, boolean initialize) {
        try {
            try {
                this.modelObject = object;
                this.initializers.clear();
                this.initializers.initialize = initialize;
                this.populateObject(object, this.getProperties());
                this.adaptObject(object);
                if (initialize) {
                    this.initializers.execute();
                }
            }
            catch (Exception e) {
                Activator.logError(e);
                this.initializers.clear();
            }
        }
        finally {
            this.initializers.clear();
        }
    }

    private void populateObject(EObject object, List<Property> properties) {
        for (Property prop : properties) {
            this.populateObject(object, prop);
        }
    }

    private Object getValue(EObject object, EStructuralFeature feature, int index) {
        if (feature.isMany()) {
            return ((EList)object.eGet(feature)).get(index < 0 ? 0 : index);
        }
        return object.eGet(feature);
    }

    public EClass createEClass(String type) {
        EClass eClass = this.getModelDecorator().getEClass(type);
        if (eClass == null) {
            eClass = this.getModelDecorator().createEClass(type);
        }
        return eClass;
    }

    public EStructuralFeature createEFeature(EClass eClass, Property property) {
        boolean isContainment;
        EStructuralFeature feature = eClass.getEStructuralFeature(property.name);
        boolean isAttribute = true;
        EClassifier eClassifier = this.getModelDecorator().findEClassifier(property.type);
        if (eClassifier != null && !(eClassifier instanceof EDataType) && !(eClassifier instanceof EEnum)) {
            isAttribute = false;
        }
        if (!property.getValues().isEmpty() && property.getValues().get(0) instanceof Property) {
            isAttribute = false;
        }
        if (property.ref != null) {
            isAttribute = false;
        }
        boolean isMany = property.isMany;
        boolean bl = isContainment = property.ref == null;
        if (isAttribute) {
            if (feature == null) {
                feature = this.getModelDecorator().createEAttribute(property.name, property.type, eClass.getName(), property.getFirstStringValue());
            }
        } else if (feature == null) {
            feature = this.getModelDecorator().createEReference(property.name, property.type, eClass.getName(), isContainment, isMany);
        }
        ModelDecorator.setLabel((EModelElement)feature, property.label);
        return feature;
    }

    private EStructuralFeature getFeature(EObject object, Property property) {
        return this.createEFeature(object.eClass(), property);
    }

    private EStructuralFeature populateObject(EObject object, Property property) {
        Object firstValue;
        EObject childObject = null;
        EStructuralFeature childFeature = null;
        EStructuralFeature feature = this.getFeature(object, property);
        Object object2 = firstValue = property.getValues().isEmpty() ? null : property.getValues().get(0);
        if (feature instanceof EAttribute) {
            this.adaptFeature(object, feature, firstValue, property);
        } else if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            if (property.ref != null) {
                String[] segments;
                childObject = this.modelObject;
                String[] stringArray = segments = property.ref.split("/");
                int n = segments.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    int index = s.indexOf(35);
                    if (index > 0) {
                        index = Integer.parseInt(s.substring(index + 1));
                        s = s.split("#")[0];
                    }
                    if (this.initializers.execute(childObject)) {
                        childFeature = childObject.eClass().getEStructuralFeature(s);
                        childObject = (EObject)this.getValue(childObject, childFeature, index);
                    }
                    ++n2;
                }
                this.adaptFeature(object, feature, childObject, property);
            } else if (firstValue instanceof Property) {
                ExtendedPropertiesAdapter adapter;
                EClassifier reftype = null;
                reftype = property.type == null || property.type.length() == 0 ? this.getModelDecorator().findEClassifier(property.name) : this.getModelDecorator().findEClassifier(property.type);
                if (reftype == null || !(reftype instanceof EClass)) {
                    reftype = ref.getEReferenceType();
                }
                childObject = this.createObject((EClass)reftype);
                if (property.label != null && (adapter = ExtendedPropertiesAdapter.adapt(childObject)) != null) {
                    adapter.getObjectDescriptor().setLabel(property.label);
                }
                this.adaptFeature(object, feature, childObject, property);
                this.populateObjectFromValues(childObject, property.getValues());
            }
        }
        return feature;
    }

    private void populateObjectFromValues(EObject object, List<Object> values) {
        for (Object value : values) {
            if (!(value instanceof Property)) continue;
            this.populateObject(object, (Property)value);
        }
    }

    public Object getPropertyValue(String name) {
        for (Property prop : this.getProperties()) {
            if (!prop.name.equals(name) || prop.getValues().isEmpty()) continue;
            return prop.getValues().get(0);
        }
        return null;
    }

    public List<Property> getProperties(String path) {
        ArrayList<Property> result = new ArrayList<Property>();
        ArrayList<Property> props = new ArrayList<Property>();
        props.addAll(this.getProperties());
        String[] names = path.split("/");
        this.getProperties(props, names, 0, result);
        return result;
    }

    private void getProperties(List<Property> props, String[] names, int index, List<Property> result) {
        String name = names[index];
        for (Property p : props) {
            if (!p.name.equals(name)) continue;
            if (index == names.length - 1) {
                result.add(p);
                continue;
            }
            ArrayList<Property> childProps = new ArrayList<Property>();
            for (Object v : p.values) {
                if (!(v instanceof Property)) continue;
                childProps.add((Property)v);
            }
            this.getProperties(childProps, names, index + 1, result);
        }
    }

    public Property getProperty(String name) {
        for (Property prop : this.getProperties()) {
            if (!prop.name.equals(name)) continue;
            return prop;
        }
        return null;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public ExtendedPropertiesAdapter adaptObject(EObject object) {
        this.addModelExtensionAdapter(object);
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        if (adapter != null) {
            adapter.setProperty(this.getClass().getName(), this);
            if (this.description != null) {
                adapter.setProperty("long.description", this.description);
            }
        }
        return adapter;
    }

    private void addModelExtensionAdapter(EObject object) {
        if (!object.eAdapters().contains((Object)this)) {
            object.eAdapters().add((Object)new ModelExtensionAdapter(this));
        }
    }

    public static ModelExtensionAdapter getModelExtensionAdapter(EObject object) {
        for (Adapter a : object.eAdapters()) {
            if (!(a instanceof ModelExtensionAdapter)) continue;
            return (ModelExtensionAdapter)a;
        }
        return null;
    }

    private void adaptFeature(EObject object, EStructuralFeature feature, Object value, Property property) {
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(object);
        if (adapter != null) {
            FeatureDescriptor fd = adapter.getFeatureDescriptor(feature);
            if (object.eClass().getEStructuralFeature(feature.getName()) == null) {
                fd.setProperty("is.extension.feature", Boolean.TRUE);
            }
            if (property.description != null) {
                adapter.setProperty(feature, "long.description", property.description);
            }
            if (!(feature.getEType() instanceof EEnum)) {
                this.initializers.add(adapter, feature, value);
            }
        }
    }

    public boolean isDefined(String className, String featureName) {
        if (className == null || featureName == null) {
            return false;
        }
        if (++this.recursionCounter > 100) {
            Activator.logError(new Exception("Possible infinite recursion in " + this.getClass().getName() + "#isDefined()"));
            --this.recursionCounter;
            return false;
        }
        if (className.equals(this.getType())) {
            if (featureName != null) {
                for (Property p : this.getProperties()) {
                    if (!featureName.equals(p.name)) continue;
                    --this.recursionCounter;
                    return true;
                }
            }
            --this.recursionCounter;
            return false;
        }
        EClass eClass = this.getEClass(className);
        if (eClass != null) {
            for (EClass st : eClass.getEAllSuperTypes()) {
                if (st.getName().equals(className) || !this.isDefined(st.getName(), featureName)) continue;
                --this.recursionCounter;
                return true;
            }
        }
        for (Property property : this.getProperties()) {
            if (className.equals(property.type)) {
                if (featureName != null && property.values != null) {
                    for (Object p : property.values) {
                        if (!(p instanceof Property) || !featureName.equals(((Property)p).name)) continue;
                        --this.recursionCounter;
                        return true;
                    }
                }
                --this.recursionCounter;
                return false;
            }
            for (Property p : property) {
                if (!className.equals(p.type) || featureName == null || p.values == null) continue;
                for (Object child : p.values) {
                    if (!(child instanceof Property) || !((Property)child).name.equals(featureName)) continue;
                    --this.recursionCounter;
                    return true;
                }
            }
        }
        --this.recursionCounter;
        return false;
    }

    public EClass getEClass(String className) {
        EClass eClass = this.getModelDecorator().getEClass(className);
        if (eClass == null) {
            eClass = (EClass)Bpmn2Package.eINSTANCE.getEClassifier(className);
        }
        if (eClass == null) {
            eClass = (EClass)BpmnDiPackage.eINSTANCE.getEClassifier(className);
        }
        return eClass;
    }

    public EStructuralFeature getEStructuralFeature(String className, String featureName) {
        EClass eClass = this.getEClass(className);
        if (eClass != null) {
            return eClass.getEStructuralFeature(featureName);
        }
        return null;
    }

    private class Initializer {
        public ExtendedPropertiesAdapter adapter;
        public EStructuralFeature feature;
        public Object value;

        public Initializer(ExtendedPropertiesAdapter adapter, EStructuralFeature feature, Object value) {
            this.adapter = adapter;
            this.feature = feature;
            this.value = value;
        }
    }

    private class InitializerList
    extends ArrayList<Initializer> {
        public boolean initialize;

        private InitializerList() {
        }

        public void add(ExtendedPropertiesAdapter adapter, EStructuralFeature feature, Object value) {
            super.add(new Initializer(adapter, feature, value));
        }

        public void execute() {
            for (Initializer item : this) {
                if (item.feature.getEType() instanceof EEnum || !this.initialize) continue;
                item.adapter.getFeatureDescriptor(item.feature).setValue(item.value);
            }
            this.clear();
        }

        public boolean execute(EObject object) {
            int last = -1;
            int i = this.size() - 1;
            while (i >= 0) {
                Initializer item = (Initializer)this.get(i);
                if (item.adapter.getTarget() == object) {
                    last = i;
                    break;
                }
                --i;
            }
            while (last >= 0) {
                Initializer item = (Initializer)this.get(0);
                this.remove(0);
                if (item.feature.getEType() instanceof EEnum) continue;
                if (this.initialize) {
                    item.adapter.getFeatureDescriptor(item.feature).setValue(item.value);
                }
                --last;
            }
            return this.initialize;
        }
    }

    public class ModelExtensionAdapter
    extends AdapterImpl {
        ModelExtensionDescriptor descriptor;

        public ModelExtensionAdapter(ModelExtensionDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public Property getProperty(String name) {
            return this.descriptor.getProperty(name);
        }

        public List<Property> getProperties(String path) {
            return this.descriptor.getProperties(path);
        }

        public ModelExtensionDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    public static class Property
    extends SimpleTreeIterator<Property> {
        public Property parent;
        public String name;
        public String label;
        public String description;
        public List<Object> values;
        public String ref;
        public String type;
        boolean isMany;

        public Property() {
            this.name = "unknown";
        }

        public Property(Property parent, String name, String description) {
            this.parent = parent;
            this.name = name;
            this.description = description;
        }

        public void setType(String t) {
            if (t != null && t.contains("*")) {
                this.isMany = true;
                t = t.replaceAll("\\*", "");
            }
            this.type = t;
        }

        public List<Object> getValues() {
            if (this.values == null) {
                this.values = new ArrayList<Object>();
            }
            return this.values;
        }

        public String getFirstStringValue() {
            if (!this.getValues().isEmpty()) {
                for (Object propValue : this.getValues()) {
                    String s;
                    if (propValue instanceof String) {
                        return (String)propValue;
                    }
                    if (!(propValue instanceof Property) || (s = ((Property)propValue).getFirstStringValue()) == null) continue;
                    return s;
                }
            }
            return null;
        }

        protected List<Property> getChildren() {
            ArrayList<Property> children = new ArrayList<Property>();
            if (this.values != null) {
                for (Object child : this.values) {
                    if (!(child instanceof Property)) continue;
                    children.add((Property)child);
                }
            }
            return children;
        }

        @Override
        public Iterator<Property> iterator() {
            return new SimpleTreeIterator.TreeIterator(this, this.getChildren());
        }
    }

    public static class Value {
        static int ID = 0;
        String id;
        public List<Object> values;

        public Value() {
            this.setDefaultId();
        }

        public Value(String id) {
            if (id == null || id.isEmpty()) {
                this.setDefaultId();
            } else {
                this.id = id;
            }
        }

        public List<Object> getValues() {
            if (this.values == null) {
                this.values = new ArrayList<Object>();
            }
            return this.values;
        }

        private void setDefaultId() {
            this.id = "V-" + ID++;
        }
    }
}

