/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.ExtensionAttributeValue;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BpmnDiPackage;
import org.eclipse.bpmn2.modeler.core.EDataTypeConversionFactory;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterRegistry;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterUtil;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.model.AnyTypeAdaptorFactory;
import org.eclipse.bpmn2.modeler.core.model.AnyTypeObjectFactory;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.ModelDecoratorAdapter;
import org.eclipse.bpmn2.modeler.core.utils.Messages;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dd.dc.DcPackage;
import org.eclipse.dd.di.DiPackage;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EAttributeImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;

public class ModelDecorator {
    static final EcoreFactory theCoreFactory = EcoreFactory.eINSTANCE;
    public static final String DECORATOR_URI = "http://org.eclipse.bpmn2.modeler.core.decorator";
    protected EPackage ePackage;
    protected static ResourceSet resourceSet;
    protected List<EPackage> relatedEPackages;

    public ModelDecorator(EPackage pkg) {
        Assert.isTrue((boolean)ModelDecorator.isValid(pkg));
        String name = String.valueOf(pkg.getName()) + " Dynamic Extensions";
        String nsPrefix = pkg.getNsPrefix();
        String nsURI = pkg.getNsURI();
        this.addRelatedEPackage(pkg);
        ModelDecorator.getResourceSet();
        this.ePackage = (EPackage)resourceSet.getPackageRegistry().get((Object)nsURI);
        if (this.ePackage == null) {
            this.ePackage = this.createEPackage(name, nsPrefix, nsURI);
            this.initPackage();
        }
    }

    public ModelDecorator(String name, String nsPrefix, String nsURI) {
        this.ePackage = (EPackage)ModelDecorator.getResourceSet().getPackageRegistry().get((Object)nsURI);
        if (this.ePackage == null) {
            this.ePackage = this.createEPackage(name, nsPrefix, nsURI);
        }
        this.initPackage();
    }

    public void dispose() {
        if (resourceSet != null && this.ePackage != null) {
            ModelDecoratorAdapter mda = ModelDecoratorAdapter.getAdapter(this.ePackage);
            if (mda != null) {
                mda.dispose();
            }
            resourceSet.getPackageRegistry().remove((Object)this.ePackage.getNsURI());
            EcoreUtil.delete((EObject)this.ePackage);
        }
    }

    private static ResourceSet getResourceSet() {
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        return resourceSet;
    }

    private void initPackage() {
        this.ePackage.setEFactoryInstance((EFactory)new AnyTypeObjectFactory(this));
        ModelDecoratorAdapter.adapt(this);
        ArrayList<String> delegates = new ArrayList<String>();
        delegates.add("http://org.eclipse.bpmn2.modeler.EDataTypeConversionFactory");
        EcoreUtil.setConversionDelegates((EPackage)this.ePackage, delegates);
        AdapterRegistry.INSTANCE.registerFactory(this.ePackage, (AdapterFactory)AnyTypeAdaptorFactory.INSTANCE);
    }

    public EPackage getEPackage() {
        Assert.isNotNull((Object)this.ePackage);
        return this.ePackage;
    }

    public static EPackage getEPackage(String nsURI) {
        EPackage pkg = (EPackage)ModelDecorator.getResourceSet().getPackageRegistry().get((Object)nsURI);
        if (pkg != null) {
            return pkg;
        }
        for (Map.Entry entry : ModelDecorator.getResourceSet().getPackageRegistry().entrySet()) {
            ModelDecorator md = ModelDecoratorAdapter.getModelDecorator((EPackage)entry.getValue());
            for (EPackage p : md.getRelatedEPackages()) {
                if (!p.getNsURI().equals(nsURI)) continue;
                return p;
            }
        }
        return null;
    }

    public static ModelDecorator getModelDecorator(String nsURI) {
        ModelDecoratorAdapter mda;
        EPackage pkg = ModelDecorator.getEPackage(nsURI);
        if (pkg != null && (mda = AdapterUtil.adapt((Object)pkg, ModelDecoratorAdapter.class)) != null) {
            return mda.getModelDecorator();
        }
        return null;
    }

    public static ModelDecorator getModelDecorator(EStructuralFeature feature) {
        String nsURI = ExtendedMetaData.INSTANCE.getNamespace(feature);
        return ModelDecorator.getModelDecorator(nsURI);
    }

    public void addRelatedEPackage(EPackage pkg) {
        if (pkg != this.ePackage && !this.getRelatedEPackages().contains(pkg)) {
            this.getRelatedEPackages().add(pkg);
        }
    }

    public List<EPackage> getRelatedEPackages() {
        if (this.relatedEPackages == null) {
            this.relatedEPackages = new ArrayList<EPackage>();
        }
        return this.relatedEPackages;
    }

    private EPackage createEPackage(String name, String nsPrefix, String nsURI) {
        this.ePackage = theCoreFactory.createEPackage();
        this.ePackage.setName(name);
        this.ePackage.setNsPrefix(nsPrefix);
        this.ePackage.setNsURI(nsURI);
        ModelDecorator.getResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMLResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)nsURI, (Object)this.ePackage);
        return this.ePackage;
    }

    private List<String> getSuperTypes(String type) {
        ArrayList<String> supertypes = new ArrayList<String>();
        if (type != null && type.contains(":")) {
            String[] a = type.split(":");
            a = a.length > 1 ? a[1].split(",") : a[0].split(",");
            int i = 0;
            while (i < a.length) {
                supertypes.add(a[i]);
                ++i;
            }
        }
        return supertypes;
    }

    private String getType(String type) {
        if (type != null && type.contains(":")) {
            return type.split(":")[0];
        }
        return type;
    }

    public EClassifier getEClassifier(String type) {
        EClassifier eClassifier = this.ePackage.getEClassifier(type = this.getType(type));
        if (eClassifier != null) {
            return eClassifier;
        }
        for (EPackage p : this.getRelatedEPackages()) {
            eClassifier = p.getEClassifier(this.getType(type));
            if (eClassifier == null) continue;
            return eClassifier;
        }
        Assert.isTrue((eClassifier == null ? 1 : 0) != 0);
        return null;
    }

    public EClassifier createEClassifier(String type) {
        Object eClassifier = this.getEClassifier(type);
        if (eClassifier != null) {
            return eClassifier;
        }
        EClassifier eDataType = null;
        for (String st : this.getSuperTypes(type)) {
            EClassifier ec = this.findEClassifier(st);
            if (!EDataType.class.isAssignableFrom(ec.getInstanceClass())) continue;
            eDataType = ec;
            break;
        }
        if (eDataType == null) {
            if (EDataTypeConversionFactory.isFactoryFor(this.getType(type))) {
                return this.createEDataType(type);
            }
            return this.createEClass(type);
        }
        eClassifier = EEnum.class.isAssignableFrom(eDataType.getInstanceClass()) ? theCoreFactory.createEEnum() : theCoreFactory.createEDataType();
        eClassifier.setName(this.getType(type));
        this.ePackage.getEClassifiers().add(eClassifier);
        return eClassifier;
    }

    public EEnumLiteral createEEnumLiteral(String name, String owningtype) {
        EClassifier eClassifier = this.getEClassifier(owningtype);
        if (eClassifier == null) {
            eClassifier = this.createEClassifier(String.valueOf(owningtype) + ":EEnum");
        }
        if (!(eClassifier instanceof EEnum)) {
            return null;
        }
        return this.createEEnumLiteral(name, (EEnum)eClassifier);
    }

    public EEnumLiteral createEEnumLiteral(String name, EEnum eEnum) {
        EEnumLiteral literal = theCoreFactory.createEEnumLiteral();
        literal.setLiteral(name);
        literal.setName(name.toUpperCase());
        literal.setValue(eEnum.getELiterals().size());
        eEnum.getELiterals().add((Object)literal);
        return literal;
    }

    public EDataType getEDataType(String type) {
        EClassifier eClassifier = this.getEClassifier(type);
        if (eClassifier instanceof EDataType) {
            return (EDataType)eClassifier;
        }
        Assert.isTrue((eClassifier == null ? 1 : 0) != 0);
        return null;
    }

    public EDataType createEDataType(String type) {
        EDataType eDataType = this.getEDataType(type = this.getType(type));
        if (eDataType != null) {
            return eDataType;
        }
        eDataType = theCoreFactory.createEDataType();
        eDataType.setName(type);
        this.ePackage.getEClassifiers().add((Object)eDataType);
        ExtendedMetaData.INSTANCE.setName((EClassifier)eDataType, "");
        EAnnotation ea = theCoreFactory.createEAnnotation();
        ea.setEModelElement((EModelElement)eDataType);
        ea.setSource("http://org.eclipse.bpmn2.modeler.EDataTypeConversionFactory");
        EDataType.Internal.ConversionDelegate cd = EDataTypeConversionFactory.INSTANCE.createConversionDelegate(eDataType);
        if (cd != null) {
            Object value = cd.createFromString("");
            eDataType.setInstanceClass(value.getClass());
        }
        eDataType.getEAnnotations().add((Object)ea);
        return eDataType;
    }

    public EClass getEClass(String type) {
        EClassifier eClassifier = this.getEClassifier(type);
        if (eClassifier instanceof EClass) {
            return (EClass)eClassifier;
        }
        Assert.isTrue((eClassifier == null ? 1 : 0) != 0);
        return null;
    }

    public EClass createEClass(String type) {
        EClass eClass = this.getEClass(type);
        if (eClass != null) {
            return eClass;
        }
        eClass = theCoreFactory.createEClass();
        eClass.setName(this.getType(type));
        eClass.getESuperTypes().add((Object)XMLTypePackage.eINSTANCE.getAnyType());
        this.ePackage.getEClassifiers().add((Object)eClass);
        for (String st : this.getSuperTypes(type)) {
            EClassifier eClassifier = this.findEClassifier(st);
            if (!(eClassifier instanceof EClass)) continue;
            eClass.getESuperTypes().add((Object)((EClass)eClassifier));
        }
        ExtendedMetaData.INSTANCE.setName((EClassifier)eClass, "");
        eClass.setInstanceClass(AnyType.class);
        return eClass;
    }

    public EStructuralFeature getEStructuralFeature(EObject object, String name) {
        String type;
        EStructuralFeature feature;
        EClass eClass = object.eClass();
        if (eClass != null && (feature = eClass.getEStructuralFeature(name)) != null) {
            return feature;
        }
        if (object instanceof ExtensionAttributeValue) {
            object = object.eContainer();
        }
        if ((eClass = this.getEClass(type = object.eClass().getName())) != null) {
            for (EStructuralFeature feature2 : eClass.getEAllStructuralFeatures()) {
                if (name.equals(feature2.getName())) {
                    return feature2;
                }
                if (!name.equals(ExtendedMetaData.INSTANCE.getName(feature2))) continue;
                return feature2;
            }
        }
        return this.findEStructuralFeatureInDocumentRoot(name);
    }

    public EAttribute getEAttribute(String name, String type, String owningtype) {
        EStructuralFeature feature = this.findEStructuralFeatureInDocumentRoot(name);
        if (feature instanceof EAttribute) {
            return (EAttribute)feature;
        }
        EClass eClass = this.getEClass(owningtype);
        if (eClass != null) {
            feature = eClass.getEStructuralFeature(name);
            if (feature instanceof EAttribute) {
                if (type != null) {
                    Assert.isTrue((boolean)type.equals(((EAttribute)feature).getEType().getName()));
                }
                return (EAttribute)feature;
            }
            Assert.isTrue((feature == null ? 1 : 0) != 0);
            return null;
        }
        EClassifier ec = this.findEClassifier(owningtype);
        if (!this.isValid(ec) && ec instanceof EClass && (feature = ((EClass)ec).getEStructuralFeature(name)) instanceof EAttribute) {
            return (EAttribute)feature;
        }
        Assert.isTrue((eClass == null ? 1 : 0) != 0);
        return null;
    }

    public EAttribute createEAttribute(String name, String type, String owningtype, String defaultValue) {
        EClass eClass;
        EClassifier eClassifier;
        EAttribute eAttribute = this.getEAttribute(name, type, owningtype);
        if (eAttribute != null) {
            return eAttribute;
        }
        if (type == null) {
            type = "EString";
        }
        if ((eClassifier = this.findEClassifier(type)) == null) {
            eClassifier = this.createEClassifier(type);
        }
        if ((eClass = this.getEClass(owningtype)) == null) {
            EClassifier ec = this.findEClassifier(owningtype);
            if (!this.isValid(ec)) {
                ec = this.createEClass(owningtype);
            }
            if (ec instanceof EClass) {
                eClass = (EClass)ec;
            }
        }
        Assert.isNotNull((Object)eClass);
        eAttribute = theCoreFactory.createEAttribute();
        eAttribute.setName(name);
        eAttribute.setChangeable(true);
        eAttribute.setUnsettable(true);
        eAttribute.setEType(eClassifier);
        eClass.getEStructuralFeatures().add((Object)eAttribute);
        ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)eAttribute, this.ePackage.getNsURI());
        ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eAttribute, 2);
        ExtendedMetaData.INSTANCE.setName((EStructuralFeature)eAttribute, name);
        if (eClassifier instanceof EEnum) {
            if (defaultValue != null) {
                boolean setDefault = true;
                String[] values = defaultValue.contains(",") ? defaultValue.split(",") : defaultValue.split(" ");
                String[] stringArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    String v = stringArray[n2];
                    if (setDefault) {
                        eAttribute.setDefaultValue((Object)v);
                        setDefault = false;
                    }
                    this.createEEnumLiteral(v, (EEnum)eClassifier);
                    ++n2;
                }
            }
        } else if (eClassifier instanceof EDataType && defaultValue != null) {
            eAttribute.setDefaultValue((Object)defaultValue);
        }
        return eAttribute;
    }

    public EReference getEReference(String name, String type, String owningtype, boolean containment, boolean many) {
        EStructuralFeature feature = this.findEStructuralFeatureInDocumentRoot(name);
        if (feature instanceof EReference) {
            if (type != null) {
                Assert.isTrue((boolean)type.equals(((EReference)feature).getEType().getName()));
            }
            Assert.isTrue((containment == ((EReference)feature).isContainment() ? 1 : 0) != 0);
            Assert.isTrue((many == ((EReference)feature).isMany() ? 1 : 0) != 0);
            return (EReference)feature;
        }
        EClass eClass = this.getEClass(owningtype);
        if (eClass != null) {
            feature = eClass.getEStructuralFeature(name);
            if (feature instanceof EReference) {
                EClassifier eClassifier = this.findEClassifier(type);
                Assert.isTrue((eClassifier == feature.getEType() ? 1 : 0) != 0);
                Assert.isTrue((containment == ((EReference)feature).isContainment() ? 1 : 0) != 0);
                Assert.isTrue((boolean)(many ? ((EReference)feature).getUpperBound() == -1 : true));
                return (EReference)feature;
            }
            Assert.isTrue((feature == null ? 1 : 0) != 0);
            return null;
        }
        EClassifier ec = this.findEClassifier(owningtype);
        if (!this.isValid(ec) && ec instanceof EClass && (feature = ((EClass)ec).getEStructuralFeature(name)) instanceof EReference) {
            return (EReference)feature;
        }
        Assert.isTrue((eClass == null ? 1 : 0) != 0);
        return null;
    }

    public EReference createEReference(String name, String type, String owningtype, boolean containment, boolean many) {
        EReference eReference = this.getEReference(name, type, owningtype, containment, many);
        if (eReference != null) {
            return eReference;
        }
        EClassifier eClassifier = this.findEClassifier(type);
        if (eClassifier == null) {
            eClassifier = this.createEClass(type);
        }
        eReference = theCoreFactory.createEReference();
        eReference.setName(name);
        eReference.setChangeable(true);
        eReference.setUnsettable(true);
        eReference.setUnique(true);
        eReference.setContainment(containment);
        if (many) {
            eReference.setUpperBound(-1);
        }
        eReference.setEType(eClassifier);
        EClass eClass = this.getEClass(owningtype);
        if (eClass == null) {
            EClassifier ec = this.findEClassifier(owningtype);
            if (!this.isValid(ec)) {
                ec = this.createEClass(owningtype);
            }
            if (ec instanceof EClass) {
                eClass = (EClass)ec;
            }
        }
        Assert.isNotNull((Object)eClass);
        eClass.getEStructuralFeatures().add((Object)eReference);
        ExtendedMetaData.INSTANCE.setNamespace((EStructuralFeature)eReference, this.ePackage.getNsURI());
        ExtendedMetaData.INSTANCE.setFeatureKind((EStructuralFeature)eReference, 4);
        ExtendedMetaData.INSTANCE.setName((EStructuralFeature)eReference, name);
        return eReference;
    }

    public static void setLabel(EModelElement element, String label) {
        EReference ref;
        EClassifier ec;
        if (element instanceof EReference && ModelDecorator.isValid((ec = (ref = (EReference)element).getEType()).getEPackage())) {
            element = ec;
        }
        EAnnotation ea = element.getEAnnotation(DECORATOR_URI);
        if (label != null && !label.isEmpty()) {
            if (ea == null) {
                ea = theCoreFactory.createEAnnotation();
                ea.setEModelElement(element);
                ea.setSource(DECORATOR_URI);
            }
            ea.getDetails().put((Object)"label", (Object)label);
        } else if (ea != null) {
            element.getEAnnotations().remove((Object)ea);
            EcoreUtil.delete((EObject)ea);
        }
    }

    public static String getLabel(EModelElement element) {
        EAnnotation ea = element.getEAnnotation(DECORATOR_URI);
        if (ea != null) {
            String label = (String)ea.getDetails().get((Object)"label");
            return label;
        }
        return null;
    }

    public boolean isValid(EClassifier eClassifier) {
        EPackage p;
        EPackage ePackage = p = eClassifier == null ? null : eClassifier.getEPackage();
        return eClassifier != null && (p == this.ePackage || this.getRelatedEPackages().contains(p));
    }

    public static boolean isValid(EPackage pkg) {
        return pkg != null && pkg != EcorePackage.eINSTANCE && pkg != Bpmn2Package.eINSTANCE && pkg != BpmnDiPackage.eINSTANCE && pkg != DcPackage.eINSTANCE && pkg != DiPackage.eINSTANCE;
    }

    public EClassifier findEClassifier(String type) {
        if (type == null) {
            return null;
        }
        type = this.getType(type);
        EClassifier eClassifier = null;
        if (this.ePackage != null) {
            eClassifier = this.ePackage.getEClassifier(type);
            if (eClassifier != null) {
                return eClassifier;
            }
            eClassifier = ModelDecorator.findEClassifierInDocumentRoot(this.ePackage, type);
            if (eClassifier != null) {
                return eClassifier;
            }
        }
        for (EPackage pkg : this.getRelatedEPackages()) {
            eClassifier = pkg.getEClassifier(type);
            if (eClassifier != null) {
                return eClassifier;
            }
            eClassifier = ModelDecorator.findEClassifierInDocumentRoot(pkg, type);
            if (eClassifier == null) continue;
            return eClassifier;
        }
        return ModelDecorator.findEClassifier(null, type);
    }

    public EStructuralFeature findEStructuralFeatureInDocumentRoot(String name) {
        if (name == null) {
            return null;
        }
        EStructuralFeature feature = null;
        if (this.ePackage != null && (feature = ModelDecorator.findEStructuralFeatureInDocumentRoot(this.ePackage, name)) != null) {
            return feature;
        }
        for (EPackage pkg : this.getRelatedEPackages()) {
            feature = ModelDecorator.findEStructuralFeatureInDocumentRoot(pkg, name);
            if (feature == null) continue;
            return feature;
        }
        feature = ModelDecorator.findEStructuralFeatureInDocumentRoot((EPackage)Bpmn2Package.eINSTANCE, name);
        if (feature != null) {
            return feature;
        }
        return null;
    }

    public static EClassifier findEClassifier(EPackage pkg, String type) {
        if (type == null) {
            return null;
        }
        EClassifier eClassifier = null;
        if (pkg != null) {
            eClassifier = pkg.getEClassifier(type);
            if (eClassifier != null) {
                return eClassifier;
            }
            eClassifier = ModelDecorator.findEClassifierInDocumentRoot(pkg, type);
            if (eClassifier != null) {
                return eClassifier;
            }
        }
        if ((eClassifier = EcorePackage.eINSTANCE.getEClassifier(type)) != null) {
            return eClassifier;
        }
        eClassifier = Bpmn2Package.eINSTANCE.getEClassifier(type);
        if (eClassifier != null) {
            return eClassifier;
        }
        eClassifier = ModelDecorator.findEClassifierInDocumentRoot((EPackage)Bpmn2Package.eINSTANCE, type);
        if (eClassifier != null) {
            return eClassifier;
        }
        eClassifier = BpmnDiPackage.eINSTANCE.getEClassifier(type);
        if (eClassifier != null) {
            return eClassifier;
        }
        eClassifier = ModelDecorator.findEClassifierInDocumentRoot((EPackage)BpmnDiPackage.eINSTANCE, type);
        if (eClassifier != null) {
            return eClassifier;
        }
        eClassifier = DiPackage.eINSTANCE.getEClassifier(type);
        if (eClassifier != null) {
            return eClassifier;
        }
        eClassifier = DcPackage.eINSTANCE.getEClassifier(type);
        if (eClassifier != null) {
            return eClassifier;
        }
        return null;
    }

    private static EClassifier findEClassifierInDocumentRoot(EPackage pkg, String name) {
        EStructuralFeature feature = ModelDecorator.findEStructuralFeatureInDocumentRoot(pkg, name);
        if (feature != null) {
            return feature.getEType();
        }
        return null;
    }

    private static EStructuralFeature findEStructuralFeatureInDocumentRoot(EPackage pkg, String name) {
        try {
            EClass docRoot = (EClass)pkg.getEClassifier("DocumentRoot");
            if (docRoot == null) {
                docRoot = ExtendedMetaData.INSTANCE.getDocumentRoot(pkg);
            }
            if (docRoot != null) {
                for (EStructuralFeature feature : docRoot.getEAllStructuralFeatures()) {
                    if (feature.getEContainingClass().getEPackage() != pkg) continue;
                    if (name.equals(feature.getName())) {
                        return feature;
                    }
                    if (!name.equals(ExtendedMetaData.INSTANCE.getName(feature))) continue;
                    return feature;
                }
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private static EStructuralFeature getAnyAttributeFeature(EObject object) {
        EStructuralFeature anyAttribute = null;
        if (object != null) {
            EClass eclass = null;
            eclass = object instanceof EClass ? (EClass)object : object.eClass();
            anyAttribute = eclass.getEStructuralFeature("anyAttribute");
        }
        return anyAttribute;
    }

    public static EStructuralFeature getAnyAttribute(EObject object, String name) {
        EStructuralFeature anyAttribute = ModelDecorator.getAnyAttributeFeature(object);
        if (anyAttribute != null && object.eGet(anyAttribute) instanceof BasicFeatureMap) {
            BasicFeatureMap map = (BasicFeatureMap)object.eGet(anyAttribute);
            for (FeatureMap.Entry entry : map) {
                EStructuralFeature feature = entry.getEStructuralFeature();
                if (!feature.getName().equals(name)) continue;
                return feature;
            }
        }
        return null;
    }

    public static List<EStructuralFeature> getAnyAttributes(EObject object) {
        ArrayList<EStructuralFeature> list = new ArrayList<EStructuralFeature>();
        EStructuralFeature anyAttribute = ModelDecorator.getAnyAttributeFeature(object);
        if (anyAttribute != null && object.eGet(anyAttribute) instanceof BasicFeatureMap) {
            BasicFeatureMap map = (BasicFeatureMap)object.eGet(anyAttribute);
            for (FeatureMap.Entry entry : map) {
                EStructuralFeature feature = entry.getEStructuralFeature();
                list.add(feature);
            }
        }
        return list;
    }

    public EStructuralFeature addAnyAttribute(EObject object, String namespace, String name, String type, Object value) {
        EPackage pkg;
        EDataType eDataType;
        EClass eclass;
        EAttribute attr = null;
        if (object instanceof EClass) {
            eclass = (EClass)object;
            object = ExtendedPropertiesAdapter.getDummyObject(eclass);
        } else {
            eclass = object.eClass();
        }
        EStructuralFeature anyAttribute = ModelDecorator.getAnyAttributeFeature(object);
        List anyMap = (List)object.eGet(anyAttribute);
        if (anyMap == null) {
            return null;
        }
        for (FeatureMap.Entry fe : anyMap) {
            EAttributeImpl a;
            if (!(fe.getEStructuralFeature() instanceof EAttributeImpl) || !namespace.equals((a = (EAttributeImpl)fe.getEStructuralFeature()).getExtendedMetaData().getNamespace()) || !name.equals(a.getName())) continue;
            attr = a;
            break;
        }
        if (type == null) {
            type = "E" + value.getClass().getSimpleName();
        }
        if ((eDataType = (EDataType)ModelDecorator.findEClassifier(pkg = ModelDecorator.getEPackage(namespace), type)) != null) {
            if (value == null) {
                try {
                    value = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, "");
                }
                catch (Exception exception) {
                    try {
                        value = eDataType.getInstanceClass().newInstance();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            if (attr == null) {
                attr = this.createEAttribute(name, type, eclass.getName(), null);
                anyMap.add(FeatureMapUtil.createEntry((EStructuralFeature)attr, (Object)value));
            } else {
                EClassifier dt = attr.getEType();
                if (dt == null || !eDataType.getInstanceClass().isAssignableFrom(dt.getInstanceClass())) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.ModelUtil_Illegal_Value, (Object[])new Object[]{object.eClass().getName(), attr.getName(), attr.getEType().getName(), value.toString()}));
                }
                anyMap.add(FeatureMapUtil.createEntry((EStructuralFeature)attr, (Object)value));
            }
        } else {
            if (attr == null) {
                attr = this.createEAttribute(name, type, eclass.getName(), null);
            }
            if (value == null && attr.getEType() instanceof EDataType) {
                eDataType = (EDataType)attr.getEType();
                value = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, "");
            }
            anyMap.add(FeatureMapUtil.createEntry(attr, (Object)value));
        }
        return attr;
    }

    public EStructuralFeature addAnyAttribute(EObject object, String name, String type, Object value) {
        EPackage pkg = object.eClass().getEPackage();
        String nsURI = pkg.getNsURI();
        return this.addAnyAttribute(object, nsURI, name, type, value);
    }

    public static void addExtensionAttributeValue(EObject object, EStructuralFeature feature, Object value) {
        ModelDecorator.addExtensionAttributeValue(object, feature, value, -1, false);
    }

    public static void addExtensionAttributeValue(EObject object, EStructuralFeature feature, Object value, boolean delay) {
        ModelDecorator.addExtensionAttributeValue(object, feature, value, -1, delay);
    }

    public static void addExtensionAttributeValue(EObject object, EStructuralFeature feature, Object value, int index, boolean delay) {
        EStructuralFeature evf;
        EList list;
        if (object instanceof ExtensionAttributeValue) {
            object = object.eContainer();
        }
        if ((list = (EList)object.eGet(evf = object.eClass().getEStructuralFeature("extensionValues"))).size() == 0) {
            ExtensionAttributeValue newItem = Bpmn2ModelerFactory.create(ExtensionAttributeValue.class);
            ModelUtil.setID((EObject)newItem);
            FeatureMap map = newItem.getValue();
            map.add(feature, value);
            if (delay) {
                InsertionAdapter.add(object, feature, (EObject)value);
            } else {
                list.add((Object)newItem);
            }
        } else {
            ExtensionAttributeValue oldItem = (ExtensionAttributeValue)list.get(0);
            if (delay) {
                InsertionAdapter.add(object, feature, (EObject)value);
            } else {
                FeatureMap map = oldItem.getValue();
                if (!feature.isMany()) {
                    int i = 0;
                    while (i < map.size()) {
                        FeatureMap.Entry entry = (FeatureMap.Entry)map.get(i);
                        if (entry.getEStructuralFeature().getName().equals(feature.getName())) {
                            map.remove(i--);
                        }
                        ++i;
                    }
                    map.add(feature, value);
                } else if (index < 0) {
                    map.add(feature, value);
                }
            }
        }
    }

    public static List<ExtensionAttributeValue> getExtensionAttributeValues(EObject be) {
        BPMNDiagram diagram;
        BaseElement bpmnElement;
        if (be instanceof Participant) {
            Collaboration collab;
            final Participant participant = (Participant)be;
            if (participant.getProcessRef() == null && participant.eContainer() instanceof Collaboration && (collab = (Collaboration)participant.eContainer()).eContainer() instanceof Definitions) {
                final Definitions definitions = ModelUtil.getDefinitions(collab);
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Resource)definitions.eResource());
                domain.getCommandStack().execute((Command)new RecordingCommand(domain){

                    protected void doExecute() {
                        Process process = Bpmn2ModelerFactory.create(Process.class);
                        participant.setProcessRef(process);
                        definitions.getRootElements().add(process);
                        ModelUtil.setID((EObject)process);
                    }
                });
            }
            return participant.getProcessRef().getExtensionValues();
        }
        if (be instanceof BPMNDiagram && (bpmnElement = (diagram = (BPMNDiagram)be).getPlane().getBpmnElement()) instanceof Process) {
            return bpmnElement.getExtensionValues();
        }
        if (be instanceof BaseElement) {
            return ((BaseElement)be).getExtensionValues();
        }
        return new ArrayList<ExtensionAttributeValue>();
    }

    public static <T> List<T> getAllExtensionAttributeValues(EObject object, Class<T> clazz) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (object != null) {
            EStructuralFeature evf = object.eClass().getEStructuralFeature("extensionValues");
            EList list = (EList)object.eGet(evf);
            for (ExtensionAttributeValue eav : list) {
                FeatureMap fm = eav.getValue();
                for (FeatureMap.Entry e : fm) {
                    if (!clazz.isInstance(e.getValue())) continue;
                    results.add(e.getValue());
                }
            }
        }
        return results;
    }

    public static List<Object> getAllExtensionAttributeValues(EObject object, EStructuralFeature feature) {
        ArrayList<Object> results = new ArrayList<Object>();
        if (object != null) {
            String name = feature.getName();
            EStructuralFeature evf = object.eClass().getEStructuralFeature("extensionValues");
            EList list = (EList)object.eGet(evf);
            for (ExtensionAttributeValue eav : list) {
                FeatureMap fm = eav.getValue();
                for (FeatureMap.Entry e : fm) {
                    if (!e.getEStructuralFeature().getName().equals(name)) continue;
                    results.add(e.getValue());
                }
            }
        }
        return results;
    }

    public static EStructuralFeature getExtensionAttribute(EObject object, String name) {
        if (object != null) {
            EStructuralFeature evf = object.eClass().getEStructuralFeature("extensionValues");
            EList list = (EList)object.eGet(evf);
            for (ExtensionAttributeValue eav : list) {
                FeatureMap fm = eav.getValue();
                for (FeatureMap.Entry e : fm) {
                    if (!e.getEStructuralFeature().getName().equals(name)) continue;
                    return e.getEStructuralFeature();
                }
            }
        }
        return null;
    }

    public EStructuralFeature getFeature(EObject object, String prefix, String name, boolean isElement) {
        EStructuralFeature feature;
        EClass eClass = this.getEClass(object.eClass().getName());
        if (eClass != null && (feature = eClass.getEStructuralFeature(name)) != null && (isElement ? feature instanceof EReference : feature instanceof EAttribute)) {
            return feature;
        }
        object = object.eContainer();
        return null;
    }

    public EStructuralFeature getFeature(EObject object, String name) {
        EStructuralFeature feature = ModelDecorator.getAnyAttribute(object, name);
        if (feature != null) {
            return feature;
        }
        feature = ModelDecorator.getExtensionAttribute(object, name);
        if (feature != null) {
            return feature;
        }
        return null;
    }
}

